/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.util.zzbo;
import com.google.android.gms.ads.internal.util.zzbp;
import com.google.android.gms.ads.internal.util.zzbr;
import com.google.android.gms.ads.internal.util.zzby;
import com.google.android.gms.ads.internal.util.zzcb;
import com.google.android.gms.ads.internal.util.zzcc;
import com.google.android.gms.ads.internal.util.zzcd;
import com.google.android.gms.ads.internal.util.zzce;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzf;
import com.google.android.gms.ads.internal.util.zzl;
import com.google.android.gms.ads.internal.util.zzn;
import com.google.android.gms.ads.internal.util.zzp;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzbar;
import com.google.android.gms.internal.ads.zzbbs;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzbub;
import com.google.android.gms.internal.ads.zzbyz;
import com.google.android.gms.internal.ads.zzbza;
import com.google.android.gms.internal.ads.zzbzn;
import com.google.android.gms.internal.ads.zzcdz;
import com.google.android.gms.internal.ads.zzcff;
import com.google.android.gms.internal.ads.zzdmt;
import com.google.android.gms.internal.ads.zzeyc;
import com.google.android.gms.internal.ads.zzeyf;
import com.google.android.gms.internal.ads.zzfkr;
import com.google.android.gms.internal.ads.zzfuj;
import com.google.android.gms.internal.ads.zzfut;
import com.google.android.gms.internal.ads.zzgxm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;

public final class zzs {
    public static final zzfkr zza = new zzf(Looper.getMainLooper());
    private final AtomicReference zzb = new AtomicReference<Object>(null);
    private final AtomicReference zzc = new AtomicReference<Object>(null);
    private boolean zzd = true;
    private final Object zze = new Object();
    @GuardedBy(value="userAgentLock")
    private String zzf;
    private boolean zzg = false;
    private boolean zzh = false;
    private final Executor zzi = Executors.newSingleThreadExecutor();

    public static int zza(int n) {
        if (n >= 5000) {
            return n;
        }
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HTTP timeout too low: ");
            stringBuilder.append(n);
            stringBuilder.append(" milliseconds. Reverting to default timeout: 60000 milliseconds.");
            zzbza.zzj((String)stringBuilder.toString());
        }
        return 60000;
    }

    @Nullable
    private static KeyguardManager zzU(Context object) {
        if ((object = object.getSystemService("keyguard")) != null && object instanceof KeyguardManager) {
            return (KeyguardManager)object;
        }
        return null;
    }

    @Nullable
    private static Bundle zzV(Context context) {
        try {
            context = Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            return context;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            com.google.android.gms.ads.internal.util.zze.zzb("Error getting metadata", throwable);
            return null;
        }
    }

    public final zzfut zzb(Uri uri) {
        return zzfuj.zzj(new zzl(uri), this.zzi);
    }

    private static String zzW(Bundle object) {
        if (object == null) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getString("com.google.android.gms.ads.APPLICATION_ID")))) {
            return "";
        }
        if (((String)object).matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$") || ((String)object).matches("^/\\d+~.+$")) {
            return object;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzc(Context context, String string2) {
        Object object = ((zzs)this).zze;
        synchronized (object) {
            boolean bl;
            String string3 = ((zzs)this).zzf;
            if (string3 != null) {
                return string3;
            }
            if (string2 == null) {
                return zzs.zzo();
            }
            try {
                zzce zzce2 = zzce.zza();
                boolean bl2 = TextUtils.isEmpty((CharSequence)zzce2.zza);
                if (bl2) {
                    Object object2;
                    bl2 = ClientLibraryUtils.isPackageSide();
                    if (bl2) {
                        Context context2 = context;
                        object2 = (String)zzcb.zza((Context)context2, (Callable)new zzcc(context2));
                    } else {
                        object2 = GooglePlayServicesUtilLight.getRemoteContext((Context)context);
                        object2 = (String)zzcb.zza((Context)context, (Callable)new zzcd((Context)object2, context));
                    }
                    zzce2.zza = object2;
                }
                ((zzs)this).zzf = string3 = zzce2.zza;
            }
            catch (Exception exception) {}
            if (bl = TextUtils.isEmpty((CharSequence)((zzs)this).zzf)) {
                ((zzs)this).zzf = WebSettings.getDefaultUserAgent((Context)context);
            }
            if (bl = TextUtils.isEmpty((CharSequence)((zzs)this).zzf)) {
                ((zzs)this).zzf = zzs.zzo();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((zzs)this).zzf);
            stringBuilder.append(" (Mobile; ");
            stringBuilder.append(string2);
            ((zzs)this).zzf = stringBuilder.toString();
            try {
                boolean bl3 = Wrappers.packageManager((Context)context).isCallerInstantApp();
                if (bl3) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(((zzs)this).zzf);
                    stringBuilder2.append(";aia");
                    ((zzs)this).zzf = stringBuilder2.toString();
                }
            }
            catch (Exception exception) {
                zzt.zzo().zzu(exception, "AdUtil.getUserAgent");
            }
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append(((zzs)this).zzf);
            stringBuilder3.append(")");
            ((zzs)this).zzf = stringBuilder3.toString();
            return ((zzs)this).zzf;
        }
    }

    static /* bridge */ /* synthetic */ void zzd(zzs zzs2, boolean bl) {
        zzs2.zzd = bl;
    }

    public final void zze(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = zzs.zza(n);
        stringBuilder.append("HTTP timeout: ");
        stringBuilder.append(n2);
        stringBuilder.append(" milliseconds.");
        zzbza.zzi((String)stringBuilder.toString());
        httpURLConnection.setConnectTimeout(n2);
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(n2);
        if (TextUtils.isEmpty((CharSequence)httpURLConnection.getRequestProperty("User-Agent"))) {
            String string3 = ((zzs)((Object)string3)).zzc(context, string2);
            httpURLConnection.setRequestProperty("User-Agent", string3);
        }
        httpURLConnection.setUseCaches(false);
    }

    public static void zzf(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzbzn.zza.execute(runnable);
    }

    public final boolean zzg(String string2) {
        zzs zzs2 = zzbar.zzZ;
        return zzs.zzX(string2, zzs2.zzb, (String)zzba.zzc().zzb((zzbaj)zzs2));
    }

    public final boolean zzh(String string2) {
        zzs zzs2 = zzbar.zzaa;
        return zzs.zzX(string2, zzs2.zzc, (String)zzba.zzc().zzb((zzbaj)zzs2));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzX(String string2, AtomicReference serializable, String string3) {
        void var1_4;
        Pattern pattern;
        block7: {
            void var2_6;
            block6: {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return false;
                }
                try {
                    pattern = (Pattern)((AtomicReference)serializable).get();
                    if (pattern == null) break block6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
                boolean bl = var2_6.equals(pattern.pattern());
                if (bl) break block7;
            }
            Pattern pattern2 = Pattern.compile((String)var2_6);
            ((AtomicReference)serializable).set(pattern2);
            Pattern pattern3 = pattern2;
            return var1_4.matcher(string2).matches();
        }
        Pattern pattern4 = pattern;
        return var1_4.matcher(string2).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"UnprotectedReceiver"})
    public final boolean zzi(Context context) {
        if (this.zzh) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        zzbar.zzc((Context)context);
        zzbaj zzbaj2 = zzbar.zzjn;
        if (((Boolean)zzba.zzc().zzb(zzbaj2)).booleanValue() && Build.VERSION.SDK_INT >= 33) {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzp(this, null), intentFilter, 4);
        } else {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzp(this, null), intentFilter);
        }
        this.zzh = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"UnprotectedReceiver"})
    public final boolean zzj(Context context) {
        if (this.zzg) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        zzbar.zzc((Context)context);
        zzbaj zzbaj2 = zzbar.zzjn;
        if (((Boolean)zzba.zzc().zzb(zzbaj2)).booleanValue() && Build.VERSION.SDK_INT >= 33) {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzr(this, null), intentFilter, 4);
        } else {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzr(this, null), intentFilter);
        }
        this.zzg = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int zzk(Context context, Uri uri) {
        int n;
        if (context == null) {
            com.google.android.gms.ads.internal.util.zze.zza("Trying to open chrome custom tab on a null context");
            return 3;
        }
        if (!(context instanceof Activity)) {
            com.google.android.gms.ads.internal.util.zze.zza("Chrome Custom Tabs can only work with Activity context.");
            n = 2;
        } else {
            n = 0;
        }
        zzbaj zzbaj2 = zzbar.zzee;
        Boolean bl = (Boolean)zzba.zzc().zzb(zzbaj2);
        zzbaj2 = zzbar.zzef;
        if (bl.equals(zzba.zzc().zzb(zzbaj2))) {
            n = 9;
        }
        if (n != 0) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(uri);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return n;
        }
        Object object = zzbar.zzee;
        if (((Boolean)zzba.zzc().zzb((zzbaj)object)).booleanValue()) {
            object = new zzbbs();
            ((zzbbs)object).zze(new zzn(zzs2, (zzbbs)object, context, uri));
            ((zzbbs)object).zzb((Activity)context);
        }
        zzs zzs2 = zzbar.zzef;
        if (((Boolean)zzba.zzc().zzb((zzbaj)zzs2)).booleanValue()) {
            CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
            customTabsIntent.intent.setPackage(zzgxm.zza(context));
            customTabsIntent.launchUrl(context, uri);
        }
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzl(View view) {
        if ((view = view.getRootView()) == null) {
            return false;
        }
        if (!((view = view.getContext()) instanceof Activity)) return false;
        view = (Activity)view;
        if (view == null) {
            return false;
        }
        if ((view = view.getWindow()) == null) {
            return false;
        }
        view = view.getAttributes();
        if (view == null) return false;
        if ((view.flags & 0x80000) == 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final void zzm(Context object, Intent intent) {
        void var1_2;
        if (var1_2 == null) {
            return;
        }
        Bundle bundle = var1_2.getExtras() != null ? var1_2.getExtras() : new Bundle();
        bundle.putBinder("android.support.customtabs.extra.SESSION", null);
        String string2 = object.getPackageName();
        bundle.putString("com.android.browser.application_id", string2);
        var1_2.putExtras(bundle);
    }

    public static final String zzn(Context context) {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        return zzs.zzW(zzs.zzV(context));
    }

    static final String zzo() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ");
        stringBuilder.append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ");
            stringBuilder.append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/");
                stringBuilder.append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    public static final String zzp() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static final DisplayMetrics zzq(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    protected static final int[] zzr() {
        return new int[]{0, 0};
    }

    public static final long zzs(View view) {
        float f = Float.MAX_VALUE;
        while (view instanceof View) {
            View view2 = view;
            f = Math.min(f, view2.getAlpha());
            view = view2.getParent();
            if (!(f <= 0.0f)) continue;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return Math.round(f * 100.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final WebResourceResponse zzt(Context object, String object2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzt.zzp().zzc((Context)object, (String)object2));
        hashMap.put("Cache-Control", "max-stale=3600");
        object2 = new zzbo((Context)object);
        object = ((zzbo)object2).zzb(0, string2, hashMap, null);
        object = (String)object.get(60L, TimeUnit.SECONDS);
        if (object == null) return null;
        try {
            return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)new ByteArrayInputStream(((String)object).getBytes("UTF-8")));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            zzbza.zzk((String)"Could not fetch MRAID JS.", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String zzu() {
        void var0_2;
        Resources resources = zzt.zzo().zzd();
        if (resources == null) return var0_2;
        String string2 = resources.getString(R.string.s7);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final zzbr zzv(Context object) {
        void var0_4;
        Object obj;
        try {
            obj = object.getClassLoader().loadClass("com.google.android.gms.ads.internal.util.WorkManagerUtil").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            String string2 = "Failed to instantiate WorkManagerUtil";
            zzt.zzo().zzu(exception, string2);
            return null;
        }
        if (!(obj instanceof IBinder)) {
            zzbza.zzg((String)"Instantiated WorkManagerUtil not instance of IBinder.");
            return null;
        }
        IBinder iBinder = (IBinder)obj;
        if (iBinder == null) {
            return var0_4;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.ads.internal.util.IWorkManagerUtil");
        if (iInterface instanceof zzbr) {
            zzbr zzbr2 = (zzbr)iInterface;
            return var0_4;
        }
        zzbp zzbp2 = new zzbp(iBinder);
        return var0_4;
    }

    public static final boolean zzw(Context object, String string2) {
        Context context = zzbub.zza(object);
        object = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string2, (String)object) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzx(Context context) {
        try {
            return DeviceProperties.isBstar((Context)context);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    public static final boolean zzy(String string2) {
        int n;
        String[] stringArray;
        if (!zzbyz.zzl()) {
            return false;
        }
        Object object = zzbar.zzey;
        if (!((Boolean)zzba.zzc().zzb((zzbaj)object)).booleanValue()) {
            return false;
        }
        object = zzbar.zzeA;
        object = (String)zzba.zzc().zzb((zzbaj)object);
        if (!((String)object).isEmpty()) {
            stringArray = ((String)object).split(";");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return false;
            }
        }
        Object object2 = zzbar.zzez;
        object2 = (String)zzba.zzc().zzb((zzbaj)object2);
        if (((String)object2).isEmpty()) {
            return true;
        }
        stringArray = ((String)object2).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean zzz(Context context) {
        if (context == null) {
            return false;
        }
        return (context = zzs.zzU(context)) != null && context.isKeyguardLocked();
    }

    public static final boolean zzA(Context object) {
        try {
            object = object.getClassLoader();
            String string2 = "com.google.android.gms.ads.internal.ClientApi";
            ((ClassLoader)object).loadClass(string2);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzbza.zzh((String)"Error loading class.", (Throwable)throwable);
            String string3 = "AdUtil.isLiteSdk";
            zzt.zzo().zzu(throwable, string3);
            return false;
        }
    }

    public static final boolean zzB() {
        int n = Process.myUid();
        return n == 0 || n == 1000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzC(Context context) {
        try {
            block5: {
                boolean bl;
                Object object = (ActivityManager)context.getSystemService("activity");
                KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
                if (object == null || keyguardManager == null) {
                    return false;
                }
                if ((object = object.getRunningAppProcesses()) == null) {
                    return false;
                }
                object = object.iterator();
                while (bl = object.hasNext()) {
                    boolean bl2;
                    int n;
                    ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                    int n2 = Process.myPid();
                    if (n2 != (n = runningAppProcessInfo.pid)) continue;
                    int n3 = runningAppProcessInfo.importance;
                    if (n3 == 100 && (n3 = (int)(keyguardManager.inKeyguardRestrictedInputMode() ? 1 : 0)) == 0 && (context = (PowerManager)context.getSystemService("power")) != null && (bl2 = context.isScreenOn())) break block5;
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final boolean zzD(Context object) {
        Bundle bundle = zzs.zzV(object);
        object = bundle.getString("com.google.android.gms.ads.INTEGRATION_MANAGER");
        return TextUtils.isEmpty((CharSequence)zzs.zzW(bundle)) && !TextUtils.isEmpty((CharSequence)object);
    }

    public static final boolean zzE(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        if ((context = ((Activity)context).getWindow()) == null || context.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        context.getDecorView().getGlobalVisibleRect(rect, null);
        context.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzF(View object, int n, MotionEvent motionEvent) {
        int[] nArray = new int[2];
        Rect rect = new Rect();
        try {
            Object object2;
            Object object3;
            int n2;
            int n3;
            int n4;
            String string2;
            String string3 = object.getContext().getPackageName();
            boolean bl = object instanceof zzdmt;
            if (bl) {
                object = ((zzdmt)((Object)object)).getChildAt(0);
            }
            if ((bl = object instanceof zzg) || (bl = object instanceof NativeAdView)) {
                string2 = "NATIVE";
                n4 = 1;
            } else {
                string2 = "UNKNOWN";
                n4 = 0;
            }
            if ((n3 = object.getLocalVisibleRect(rect)) != 0) {
                n3 = rect.width();
                n2 = rect.height();
            } else {
                n3 = 0;
                n2 = 0;
            }
            zzt.zzp();
            long l = zzs.zzs((View)object);
            object.getLocationOnScreen(nArray);
            int n5 = nArray[0];
            int n6 = nArray[1];
            boolean bl2 = object instanceof zzcff;
            String string4 = "none";
            if (bl2) {
                object3 = ((zzcff)object).zzP();
                if (object3 != null) {
                    object3 = ((zzeyf)object3).zzb;
                    Object object4 = object;
                    int n7 = object4.hashCode();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object3);
                    stringBuilder.append(":");
                    stringBuilder.append(n7);
                    object4.setContentDescription((CharSequence)stringBuilder.toString());
                } else {
                    object3 = string4;
                }
            } else {
                object3 = string4;
            }
            boolean bl3 = object instanceof zzcdz;
            String string5 = "none";
            if (bl3) {
                object2 = ((zzcdz)object).zzD();
                if (object2 != null) {
                    string2 = zzeyc.zza(((zzeyc)object2).zzb);
                    n4 = ((zzeyc)object2).zzf;
                    object2 = ((zzeyc)object2).zzF;
                } else {
                    object2 = string5;
                }
            } else {
                object2 = string5;
            }
            object = String.format(Locale.US, "<Ad hashCode=%d, package=%s, adNetCls=%s, gwsQueryId=%s, format=%s, impType=%d, class=%s, x=%d, y=%d, width=%d, height=%d, vWidth=%d, vHeight=%d, alpha=%d, state=%s>", object.hashCode(), string3, object2, object3, string2, n4, object.getClass().getName(), n5, n6, object.getWidth(), object.getHeight(), n3, n2, l, Integer.toString(n, 2));
            zzbza.zzi((String)object);
            return;
        }
        catch (Exception exception) {
            zzbza.zzh((String)"Failure getting view location.", (Throwable)exception);
            return;
        }
    }

    public static final AlertDialog.Builder zzG(Context context) {
        return new AlertDialog.Builder(context, zzt.zzq().zza());
    }

    public static final void zzH(Context context, String string2, String object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        for (String string3 : arrayList) {
            new zzby(context, string2, string3).zzb();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void zzI(Context context, Throwable throwable) {
        if (context == null) return;
        try {
            boolean bl = (Boolean)zzbct.zzb.zze();
            if (!bl) return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable);
    }

    private static final void zzY(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static final String zzJ(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static final int zzK(String string2) {
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            zzbza.zzj((String)"Could not parse value:".concat(((Object)numberFormatException).toString()));
            return 0;
        }
    }

    @Nullable
    public static final Map zzL(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : uri.getQueryParameterNames()) {
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            String string3 = string2;
            hashMap.put(string3, uri.getQueryParameter(string3));
        }
        return hashMap;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static final WebResourceResponse zzM(HttpURLConnection var0) throws IOException {
        block5: {
            zzt.zzp();
            var1_1 = var0.getContentType();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block5;
            var1_1 = "";
lbl6:
            // 2 sources

            while (true) {
                block6: {
                    zzt.zzp();
                    var2_2 = var0.getContentType();
                    if (TextUtils.isEmpty((CharSequence)var2_2)) {
                        var2_2 = "";
lbl12:
                        // 4 sources

                        while (true) {
                            var3_4 = var0.getHeaderFields();
                            var4_5 = new HashMap(var3_4.size());
                            for (Map.Entry var5_6 : var3_4.entrySet()) {
                                if (var5_6.getKey() == null || var5_6.getValue() == null || ((List)var5_6.getValue()).isEmpty()) continue;
                                var4_5.put((String)var5_6.getKey(), (String)((List)var5_6.getValue()).get(0));
                            }
                            return zzt.zzq().zzc(var1_1, var2_2, var0.getResponseCode(), var0.getResponseMessage(), (Map)var4_5, var0.getInputStream());
                        }
                    }
                    var3_4 = var2_2.split(";");
                    if (((String[])var3_4).length != 1) break block6;
                    var2_2 = "";
                    ** GOTO lbl12
                }
                for (var2_3 = 1; var2_3 < ((Object)var3_4).length; ++var2_3) {
                    if (!var3_4[var2_3].trim().startsWith("charset") || (var4_5 = var3_4[var2_3].trim().split("=")).length <= 1) continue;
                    var2_2 = var4_5[1].trim();
                    ** GOTO lbl12
                }
                var2_2 = "";
                ** continue;
                break;
            }
        }
        var1_1 = var1_1.split(";")[0].trim();
        ** while (true)
    }

    public static final int[] zzN(Activity activity) {
        if ((activity = activity.getWindow()) != null && (activity = activity.findViewById(0x1020002)) != null) {
            return new int[]{activity.getWidth(), activity.getHeight()};
        }
        return zzs.zzr();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int[] zzO(Activity activity) {
        void var1_4;
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray = new int[]{view.getTop(), view.getBottom()};
            return new int[]{zzay.zzb().zzb((Context)activity, (int)var1_4[0]), zzay.zzb().zzb((Context)activity, (int)var1_4[1])};
        }
        int[] nArray = zzs.zzr();
        return new int[]{zzay.zzb().zzb((Context)activity, (int)var1_4[0]), zzay.zzb().zzb((Context)activity, (int)var1_4[1])};
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzP(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = !zzt.zzp().zzd ? (keyguardManager == null ? true : (keyguardManager.inKeyguardRestrictedInputMode() ? zzs.zzl(view) : true)) : true;
        long l = zzs.zzs(view);
        if (view.getVisibility() != 0) {
            return false;
        }
        if (!view.isShown()) {
            return false;
        }
        if (powerManager != null && !powerManager.isScreenOn()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        powerManager = zzbar.zzbe;
        if (((Boolean)zzba.zzc().zzb((zzbaj)powerManager)).booleanValue() && !view.getLocalVisibleRect(new Rect()) && !view.getGlobalVisibleRect(new Rect())) {
            return false;
        }
        view = zzbar.zziW;
        if ((Boolean)zzba.zzc().zzb((zzbaj)view) == false) return true;
        view = zzbar.zziY;
        if (l >= (long)((Integer)zzba.zzc().zzb((zzbaj)view)).intValue()) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzQ(Context context, Intent object) {
        zzbaj zzbaj2 = zzbar.zzjo;
        if (!((Boolean)zzba.zzc().zzb(zzbaj2)).booleanValue()) {
            zzs.zzY(context, (Intent)object);
            return;
        }
        try {
            zzs.zzY(context, (Intent)object);
            return;
        }
        catch (SecurityException securityException) {
            zzbza.zzk((String)"", (Throwable)securityException);
            object = "AdUtil.startActivityWithUnknownContext";
            zzt.zzo().zzu(securityException, (String)object);
            return;
        }
    }

    public static final void zzR(Context object, Uri uri) {
        try {
            Context context = object;
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzs.zzm(context, intent);
            bundle.putString("com.android.browser.application_id", object.getPackageName());
            context.startActivity(intent);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Opening ");
            stringBuilder.append(uri.toString());
            stringBuilder.append(" in a new browser.");
            object = stringBuilder.toString();
            zzbza.zze((String)object);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzbza.zzh((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    public static final int[] zzS(Activity activity) {
        int[] nArray = zzs.zzN(activity);
        return new int[]{zzay.zzb().zzb((Context)activity, nArray[0]), zzay.zzb().zzb((Context)activity, nArray[1])};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzT(View view, Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            context2 = (PowerManager)context2.getSystemService("power");
            return zzs.zzP(view, (PowerManager)context2, zzs.zzU(context));
        }
        context2 = null;
        return zzs.zzP(view, (PowerManager)context2, zzs.zzU(context));
    }
}

