/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.util.zzbr;
import com.google.android.gms.ads.internal.util.zzbs;
import com.google.android.gms.ads.internal.util.zzbu;
import com.google.android.gms.ads.internal.util.zzcb;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzf;
import com.google.android.gms.ads.internal.util.zzk;
import com.google.android.gms.ads.internal.util.zzl;
import com.google.android.gms.ads.internal.util.zzm;
import com.google.android.gms.ads.internal.util.zzn;
import com.google.android.gms.ads.internal.util.zzo;
import com.google.android.gms.ads.internal.util.zzp;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzber;
import com.google.android.gms.internal.ads.zzbet;
import com.google.android.gms.internal.ads.zzbjd;
import com.google.android.gms.internal.ads.zzbjj;
import com.google.android.gms.internal.ads.zzbjl;
import com.google.android.gms.internal.ads.zzbkh;
import com.google.android.gms.internal.ads.zzbkj;
import com.google.android.gms.internal.ads.zzblf;
import com.google.android.gms.internal.ads.zzcbx;
import com.google.android.gms.internal.ads.zzcgl;
import com.google.android.gms.internal.ads.zzcgm;
import com.google.android.gms.internal.ads.zzcgs;
import com.google.android.gms.internal.ads.zzchg;
import com.google.android.gms.internal.ads.zzcmc;
import com.google.android.gms.internal.ads.zzcni;
import com.google.android.gms.internal.ads.zzdsv;
import com.google.android.gms.internal.ads.zzezz;
import com.google.android.gms.internal.ads.zzfac;
import com.google.android.gms.internal.ads.zzfla;
import com.google.android.gms.internal.ads.zzfsd;
import com.google.android.gms.internal.ads.zzfsm;
import com.google.android.gms.internal.ads.zzglo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzs {
    private final AtomicReference<Pattern> zzb;
    private final AtomicReference<Pattern> zzc;
    public static final zzfla zza;
    @GuardedBy(value="AdUtil.class")
    private static boolean zzd;
    private boolean zze;
    private final Object zzf;
    @GuardedBy(value="userAgentLock")
    private String zzg;
    private boolean zzh;
    private boolean zzi;
    private final Executor zzj;

    static /* synthetic */ boolean zza(boolean bl) {
        zzd = bl;
        return bl;
    }

    static /* synthetic */ boolean zzb(zzs zzs2, boolean bl) {
        zzs2.zze = bl;
        return bl;
    }

    static /* synthetic */ Object zzc(zzs zzs2) {
        return zzs2.zzf;
    }

    static /* synthetic */ String zzd(zzs zzs2, String string2) {
        zzs2.zzg = string2;
        return string2;
    }

    public zzs() {
        Object object = new AtomicReference(null);
        this.zzb = object;
        object = new AtomicReference(null);
        this.zzc = object;
        this.zze = true;
        this.zzf = object = new Object();
        this.zzh = false;
        this.zzi = false;
        this.zzj = Executors.newSingleThreadExecutor();
    }

    public static int zze(int n) {
        if (n >= 5000) {
            return n;
        }
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder(97);
            stringBuilder.append("HTTP timeout too low: ");
            stringBuilder.append(n);
            stringBuilder.append(" milliseconds. Reverting to default timeout: 60000 milliseconds.");
            com.google.android.gms.ads.internal.util.zze.zzi((String)stringBuilder.toString());
        }
        return 60000;
    }

    /*
     * WARNING - void declaration
     */
    public final void zzf(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2, int n) {
        void var4_5;
        void var6_8;
        int n2 = zzs.zze((int)var6_8);
        StringBuilder stringBuilder = new StringBuilder(39);
        stringBuilder.append("HTTP timeout: ");
        stringBuilder.append(n2);
        stringBuilder.append(" milliseconds.");
        com.google.android.gms.ads.internal.util.zze.zzh((String)stringBuilder.toString());
        var4_5.setConnectTimeout(n2);
        var4_5.setInstanceFollowRedirects(false);
        var4_5.setReadTimeout(n2);
        var4_5.setRequestProperty("User-Agent", this.zzi(context, string2));
        var4_5.setUseCaches(false);
    }

    public final boolean zzg(Context context) {
        if (this.zzh) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context = context.getApplicationContext();
        zzr zzr2 = new zzr(this, null);
        context.registerReceiver((BroadcastReceiver)zzr2, intentFilter);
        this.zzh = true;
        return true;
    }

    public final boolean zzh(Context context) {
        if (this.zzi) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context = context.getApplicationContext();
        zzp zzp2 = new zzp(this, null);
        context.registerReceiver((BroadcastReceiver)zzp2, intentFilter);
        this.zzi = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzi(Context context, String string2) {
        Object object = ((zzs)this).zzf;
        synchronized (object) {
            int n;
            boolean bl;
            String string3 = ((zzs)this).zzg;
            if (string3 != null) {
                return string3;
            }
            if (string2 == null) {
                return zzs.zzw();
            }
            try {
                ((zzs)this).zzg = zzt.zze().zzb(context);
            }
            catch (Exception exception) {}
            if (bl = TextUtils.isEmpty((CharSequence)((zzs)this).zzg)) {
                zzber.zza();
                bl = zzcgm.zzp();
                if (bl) {
                    ((zzs)this).zzg = zzs.zzU(context);
                } else {
                    ((zzs)this).zzg = null;
                    Object object2 = zza;
                    Object object3 = new zzm((zzs)this, context);
                    object2.post((Runnable)object3);
                    while ((object2 = ((zzs)this).zzg) == null) {
                        try {
                            ((zzs)this).zzf.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            ((zzs)this).zzg = zzs.zzw();
                            object2 = "Interrupted, use default user agent: ";
                            object3 = String.valueOf(((zzs)this).zzg);
                            n = ((String)object3).length();
                            object2 = n != 0 ? ((String)object2).concat((String)object3) : (object3 = new String((String)object2));
                            com.google.android.gms.ads.internal.util.zze.zzi((String)object2);
                        }
                    }
                }
            }
            String string4 = String.valueOf(((zzs)this).zzg);
            int n2 = String.valueOf(string4).length();
            n2 += 10;
            n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n2 += n);
            stringBuilder.append(string4);
            stringBuilder.append(" (Mobile; ");
            stringBuilder.append(string2);
            ((zzs)this).zzg = stringBuilder.toString();
            try {
                boolean bl2 = Wrappers.packageManager((Context)context).isCallerInstantApp();
                if (bl2) {
                    ((zzs)this).zzg = String.valueOf(((zzs)this).zzg).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzt.zzg().zzk(exception, "AdUtil.getUserAgent");
            }
            ((zzs)this).zzg = String.valueOf(((zzs)this).zzg).concat(")");
            return ((zzs)this).zzg;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JSONObject zzj(Map<String, ?> object) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            Iterator iterator = object.keySet().iterator();
            while (true) {
                boolean bl;
                if (!(bl = iterator.hasNext())) {
                    return jSONObject;
                }
                String string2 = (String)iterator.next();
                this.zzac(jSONObject, string2, object.get(string2));
            }
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            String string4 = "Could not convert map to JSON: ";
            string3 = string3.length() != 0 ? string4.concat(string3) : new String(string4);
            object = new JSONException(string3);
            throw object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final JSONObject zzk(@Nullable Bundle bundle, JSONObject jSONObject) {
        if (bundle == null) return null;
        try {
            return this.zzl(bundle);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    public final JSONObject zzl(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zzac(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zzaa(Collection<?> object) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        object = object.iterator();
        while (object.hasNext()) {
            this.zzab(jSONArray, object.next());
        }
        return jSONArray;
    }

    private final void zzab(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzl((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONArray.put((Object)this.zzj((Map)object));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zzaa((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            JSONArray jSONArray2 = new JSONArray();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzab(jSONArray2, objectArray[i]);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zzac(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzl((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONObject.put(string2, (Object)this.zzj((Map)object));
            return;
        }
        if (object instanceof Collection) {
            if (string2 == null) {
                string2 = "null";
            }
            jSONObject.put(string2, (Object)this.zzaa((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zzaa(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    public final zzfsm<Map<String, String>> zzm(Uri uri) {
        zzk zzk2 = new zzk(uri);
        return zzfsd.zzd(zzk2, this.zzj);
    }

    public final void zzn(Context context, @Nullable String string2, String object, Bundle bundle, boolean bl) {
        zzt.zzc();
        bundle.putString("device", zzs.zzx());
        bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zzbjl.zzc()));
        zzber.zza();
        object = new zzn(this, context, string2);
        zzcgm.zzr((Context)context, (String)string2, (String)"gmob-apps", (Bundle)bundle, (boolean)true, (zzcgl)object);
    }

    public static void zzo(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzchg.zza.execute(runnable);
    }

    @Nullable
    private static KeyguardManager zzad(Context object) {
        if ((object = object.getSystemService("keyguard")) != null && object instanceof KeyguardManager) {
            return (KeyguardManager)object;
        }
        return null;
    }

    public final boolean zzp(String string2) {
        AtomicReference<Pattern> atomicReference = ((zzs)((Object)atomicReference)).zzb;
        zzbjd zzbjd2 = zzbjl.zzW;
        return zzs.zzae(string2, atomicReference, (String)zzbet.zzc().zzc(zzbjd2));
    }

    public final boolean zzq(String string2) {
        AtomicReference<Pattern> atomicReference = ((zzs)((Object)atomicReference)).zzc;
        zzbjd zzbjd2 = zzbjl.zzX;
        return zzs.zzae(string2, atomicReference, (String)zzbet.zzc().zzc(zzbjd2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzae(String string2, AtomicReference<Pattern> object, String object2) {
        Pattern pattern;
        block7: {
            block6: {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return false;
                }
                try {
                    pattern = (Pattern)((AtomicReference)object).get();
                    if (pattern == null) break block6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
                boolean bl = ((String)object2).equals(pattern.pattern());
                if (bl) break block7;
            }
            object2 = Pattern.compile((String)object2);
            ((AtomicReference)object).set(object2);
            object = object2;
            return ((Pattern)object).matcher(string2).matches();
        }
        object = pattern;
        return ((Pattern)object).matcher(string2).matches();
    }

    private static String zzaf(Bundle object) {
        if (object == null) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getString("com.google.android.gms.ads.APPLICATION_ID")))) {
            return "";
        }
        if (((String)object).matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$") || ((String)object).matches("^/\\d+~.+$")) {
            return object;
        }
        return "";
    }

    private static Bundle zzag(Context context) {
        try {
            context = Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            return context;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            com.google.android.gms.ads.internal.util.zze.zzb("Error getting metadata", throwable);
            return null;
        }
    }

    @TargetApi(value=26)
    public final void zzr(Context object) {
        if (!PlatformVersion.isAtLeastO()) {
            return;
        }
        Object object2 = zzbjl.zzgb;
        if (!((Boolean)zzbet.zzc().zzc(object2)).booleanValue()) {
            return;
        }
        object = object.getSystemService("connectivity");
        object = (ConnectivityManager)object;
        object2 = new zzo(this);
        object.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)object2);
    }

    static {
        zzf zzf2 = new zzf(Looper.getMainLooper());
        zza = zzf2;
        zzd = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=18)
    public final int zzs(Context context, Uri uri) {
        zzs zzs2;
        int n;
        if (context == null) {
            com.google.android.gms.ads.internal.util.zze.zza("Trying to open chrome custom tab on a null context");
            return 3;
        }
        if (!PlatformVersion.isAtLeastJellyBeanMR2()) {
            com.google.android.gms.ads.internal.util.zze.zza("Chrome Custom Tabs can only work with version Jellybean onwards.");
            n = 1;
        } else if (!(context instanceof Activity)) {
            com.google.android.gms.ads.internal.util.zze.zza("Chrome Custom Tabs can only work with Activity context.");
            n = 2;
        } else {
            n = 0;
        }
        Object object = zzbjl.zzcW;
        zzbjj zzbjj2 = zzbet.zzc();
        object = zzbjj2.zzc((zzbjd)object);
        object = (Boolean)object;
        zzbjj2 = zzbjl.zzcX;
        if (((Boolean)object).equals(zzbet.zzc().zzc((zzbjd)zzbjj2))) {
            n = 9;
        }
        if (n != 0) {
            zzs2 = new Intent("android.intent.action.VIEW");
            zzs2.setData(uri);
            zzs2.addFlags(0x10000000);
            context.startActivity((Intent)zzs2);
            return n;
        }
        Object object2 = zzbjl.zzcW;
        if (((Boolean)zzbet.zzc().zzc((zzbjd)object2)).booleanValue()) {
            object2 = new zzbkj();
            object = new zzl(zzs2, (zzbkj)object2, context, uri);
            ((zzbkj)object2).zzd((zzbkh)object);
            ((zzbkj)object2).zze((Activity)context);
        }
        zzs2 = zzbjl.zzcX;
        if (((Boolean)zzbet.zzc().zzc((zzbjd)zzs2)).booleanValue()) {
            zzs2 = new CustomTabsIntent.Builder();
            zzs2 = zzs2.build();
            ((CustomTabsIntent)zzs2).intent.setPackage(zzglo.zza(context));
            zzs2.launchUrl(context, uri);
        }
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzt(View view) {
        if ((view = view.getRootView()) == null) {
            return false;
        }
        if (!((view = view.getContext()) instanceof Activity)) return false;
        view = (Activity)view;
        if (view == null) {
            return false;
        }
        if ((view = view.getWindow()) == null) {
            return false;
        }
        view = view.getAttributes();
        if (view == null) return false;
        if ((view.flags & 0x80000) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=18)
    public static final void zzu(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (!PlatformVersion.isAtLeastJellyBeanMR2()) {
            return;
        }
        Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
        bundle.putBinder("android.support.customtabs.extra.SESSION", null);
        bundle.putString("com.android.browser.application_id", context.getPackageName());
        intent.putExtras(bundle);
    }

    public static final String zzv(Context context) {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        return zzs.zzaf(zzs.zzag(context));
    }

    static final String zzw() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ");
        stringBuilder.append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ");
            stringBuilder.append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/");
                stringBuilder.append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    public static final String zzx() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        String string4 = String.valueOf(string3);
        int n = string4.length();
        String string5 = String.valueOf(string2);
        int n2 = string5.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static final DisplayMetrics zzy(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    protected static final int[] zzz() {
        int[] nArray = new int[]{0, 0};
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final long zzA(View view) {
        float f;
        block2: {
            float f2 = Float.MAX_VALUE;
            while (view instanceof View) {
                f2 = Math.min(f2, view.getAlpha());
                view = view.getParent();
                if (!(f2 <= 0.0f)) continue;
                f = f2;
                break block2;
            }
            f = f2;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return Math.round(f * 100.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final WebResourceResponse zzB(Context object, String object2, String object3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzt.zzc().zzi((Context)object, (String)object2));
        hashMap.put("Cache-Control", "max-stale=3600");
        object2 = new zzbr((Context)object);
        object = ((zzbr)object2).zzb(0, (String)object3, hashMap, null);
        object = (String)object.get(60L, TimeUnit.SECONDS);
        if (object == null) return null;
        try {
            object3 = new ByteArrayInputStream(((String)object).getBytes("UTF-8"));
            return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)object3);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            com.google.android.gms.ads.internal.util.zze.zzj((String)"Could not fetch MRAID JS.", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String zzC() {
        void var0_2;
        Resources resources = zzt.zzg().zzj();
        if (resources == null) return var0_2;
        String string2 = resources.getString(R.string.s7);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final zzbu zzD(Context object) {
        void var0_4;
        Object obj;
        try {
            obj = object.getClassLoader().loadClass("com.google.android.gms.ads.internal.util.WorkManagerUtil").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            zzt.zzg().zzk(exception, "Failed to instantiate WorkManagerUtil");
            return null;
        }
        if (!(obj instanceof IBinder)) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instantiated WorkManagerUtil not instance of IBinder.");
            return null;
        }
        IBinder iBinder = (IBinder)obj;
        if (iBinder == null) {
            return var0_4;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.ads.internal.util.IWorkManagerUtil");
        if (iInterface instanceof zzbu) {
            zzbu zzbu2 = (zzbu)iInterface;
            return var0_4;
        }
        IInterface iInterface2 = iInterface = new zzbs(iBinder);
        return var0_4;
    }

    public static final boolean zzE(Context context, String string2) {
        context = zzcbx.zza(context);
        String string3 = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string2, string3) == 0;
    }

    public static final boolean zzF(String string2) {
        int n;
        String[] stringArray;
        if (!zzcgs.zzj()) {
            return false;
        }
        Object object = zzbjl.zzdq;
        if (!((Boolean)zzbet.zzc().zzc((zzbjd)object)).booleanValue()) {
            return false;
        }
        object = zzbjl.zzds;
        object = (String)zzbet.zzc().zzc((zzbjd)object);
        if (!((String)object).isEmpty()) {
            stringArray = ((String)object).split(";");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return false;
            }
        }
        Object object2 = zzbjl.zzdr;
        object2 = (String)zzbet.zzc().zzc((zzbjd)object2);
        if (((String)object2).isEmpty()) {
            return true;
        }
        stringArray = ((String)object2).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=16)
    public static final boolean zzG(Context context) {
        if (context == null || !PlatformVersion.isAtLeastJellyBean()) {
            return false;
        }
        return (context = zzs.zzad(context)) != null && context.isKeyguardLocked();
    }

    public static final boolean zzH(Context object) {
        try {
            object = object.getClassLoader();
            String string2 = "com.google.android.gms.ads.internal.ClientApi";
            ((ClassLoader)object).loadClass(string2);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error loading class.", (Throwable)throwable);
            zzt.zzg().zzk(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzI(Context object) {
        if (PlatformVersion.isAtLeastO()) {
            zzbjd zzbjd2 = zzbjl.zzgb;
            if (((Boolean)zzbet.zzc().zzc(zzbjd2)).booleanValue()) {
                object = zzs.class;
                synchronized (object) {
                    return zzd;
                    {
                        catch (Throwable throwable) {}
                        {
                            throw throwable;
                        }
                    }
                }
            }
        }
        if ((object = ((ConnectivityManager)object.getSystemService("connectivity")).getActiveNetworkInfo()) == null) return false;
        if (!object.isConnected()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzJ(Context context) {
        try {
            block5: {
                boolean bl;
                Object object = (ActivityManager)context.getSystemService("activity");
                KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
                if (object == null || keyguardManager == null) {
                    return false;
                }
                if ((object = object.getRunningAppProcesses()) == null) {
                    return false;
                }
                object = object.iterator();
                while (bl = object.hasNext()) {
                    boolean bl2;
                    int n;
                    ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                    int n2 = Process.myPid();
                    if (n2 != (n = runningAppProcessInfo.pid)) continue;
                    int n3 = runningAppProcessInfo.importance;
                    if (n3 == 100 && (n3 = (int)(keyguardManager.inKeyguardRestrictedInputMode() ? 1 : 0)) == 0 && (context = (PowerManager)context.getSystemService("power")) != null && (bl2 = context.isScreenOn())) break block5;
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final boolean zzK(Context context) {
        context = zzs.zzag(context);
        String string2 = context.getString("com.google.android.gms.ads.INTEGRATION_MANAGER");
        return TextUtils.isEmpty((CharSequence)zzs.zzaf((Bundle)context)) && !TextUtils.isEmpty((CharSequence)string2);
    }

    public static final boolean zzL(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        if ((context = ((Activity)context).getWindow()) == null || context.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        context.getDecorView().getGlobalVisibleRect(rect, null);
        context.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzM(View object, int n, MotionEvent motionEvent) {
        int[] nArray = new int[2];
        Rect rect = new Rect();
        try {
            Object object2;
            int n2;
            int n3;
            int n4;
            String string2;
            String string3 = object.getContext().getPackageName();
            boolean bl = object instanceof zzdsv;
            if (bl) {
                object = ((zzdsv)((Object)object)).getChildAt(0);
            }
            if ((bl = object instanceof zzg) || (bl = object instanceof NativeAdView)) {
                string2 = "NATIVE";
                n4 = 1;
            } else {
                string2 = "UNKNOWN";
                n4 = 0;
            }
            if ((n3 = object.getLocalVisibleRect(rect)) != 0) {
                n3 = rect.width();
                int n5 = rect.height();
                n2 = n3;
                n3 = n5;
            } else {
                n2 = 0;
                n3 = 0;
            }
            zzt.zzc();
            long l = zzs.zzA((View)object);
            object.getLocationOnScreen(nArray);
            int n6 = nArray[0];
            int n7 = nArray[1];
            boolean bl2 = object instanceof zzcni;
            String string4 = "none";
            object2 = bl2 ? ((object2 = ((zzcni)object).zzaB()) != null ? ((zzfac)object2).zzb : string4) : string4;
            int n8 = object instanceof zzcmc;
            String string5 = "none";
            if (n8 != 0) {
                zzezz zzezz2 = ((zzcmc)object).zzF();
                if (zzezz2 != null) {
                    string2 = zzezz.zza(zzezz2.zzb);
                    n4 = zzezz2.zzf;
                    string5 = zzezz2.zzE;
                    n8 = n4;
                } else {
                    n8 = n4;
                }
            } else {
                n8 = n4;
            }
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{string3, string5, object2, string2, n8, object.getClass().getName(), n6, n7, object.getWidth(), object.getHeight(), n2, n3, l, Integer.toString(n, 2)};
            object = String.format(locale, "<Ad package=%s, adNetCls=%s, gwsQueryId=%s, format=%s, impType=%d, class=%s, x=%d, y=%d, width=%d, height=%d, vWidth=%d, vHeight=%d, alpha=%d, state=%s>", objectArray);
            com.google.android.gms.ads.internal.util.zze.zzh((String)object);
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Failure getting view location.", (Throwable)exception);
            return;
        }
    }

    public static final void zzN(Context context, String string2, String object) {
        Object object2 = new ArrayList();
        object2.add(object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            object2 = (String)object2;
            zzcb zzcb2 = new zzcb(context, string2, (String)object2);
            zzcb2.zzc();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void zzO(Context context, Throwable throwable) {
        if (context == null) return;
        try {
            boolean bl = (Boolean)zzblf.zzb.zze();
            if (!bl) return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable);
    }

    public static final void zzP(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static final int zzQ(String string2) {
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"Could not parse value:".concat(((Object)numberFormatException).toString()));
            return 0;
        }
    }

    public static final Map<String, String> zzR(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : uri.getQueryParameterNames()) {
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static final WebResourceResponse zzS(HttpURLConnection var0) throws IOException {
        block5: {
            zzt.zzc();
            var1_1 = var0.getContentType();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block5;
            var1_1 = "";
lbl6:
            // 2 sources

            while (true) {
                block6: {
                    zzt.zzc();
                    var2_2 = var0.getContentType();
                    if (TextUtils.isEmpty((CharSequence)var2_2)) {
                        var2_2 = "";
lbl12:
                        // 4 sources

                        while (true) {
                            var3_4 = var0.getHeaderFields();
                            var4_5 = new HashMap(var3_4.size());
                            for (Map.Entry var5_6 : var3_4.entrySet()) {
                                if (var5_6.getKey() == null || var5_6.getValue() == null || ((List)var5_6.getValue()).size() <= 0) continue;
                                var4_5.put((String)var5_6.getKey(), (String)((List)var5_6.getValue()).get(0));
                            }
                            return zzt.zze().zzn(var1_1, var2_2, var0.getResponseCode(), var0.getResponseMessage(), (Map<String, String>)var4_5, var0.getInputStream());
                        }
                    }
                    var3_4 = var2_2.split(";");
                    if (((String[])var3_4).length != 1) break block6;
                    var2_2 = "";
                    ** GOTO lbl12
                }
                for (var2_3 = 1; var2_3 < ((Object)var3_4).length; ++var2_3) {
                    if (!var3_4[var2_3].trim().startsWith("charset") || (var4_5 = var3_4[var2_3].trim().split("=")).length <= 1) continue;
                    var2_2 = var4_5[1].trim();
                    ** GOTO lbl12
                }
                var2_2 = "";
                ** continue;
                break;
            }
        }
        var1_1 = var1_1.split(";")[0].trim();
        ** while (true)
    }

    public static final int[] zzT(Activity activity) {
        if ((activity = activity.getWindow()) != null && (activity = activity.findViewById(0x1020002)) != null) {
            int[] nArray = new int[]{activity.getWidth(), activity.getHeight()};
            return nArray;
        }
        return zzs.zzz();
    }

    @VisibleForTesting
    protected static final String zzU(Context object) {
        try {
            WebView webView = new WebView(object);
            object = webView.getSettings().getUserAgentString();
            return object;
        }
        catch (Throwable throwable) {
            return zzs.zzw();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final int[] zzV(Activity activity) {
        void var1_4;
        int[] nArray;
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            nArray = new int[]{view.getTop(), view.getBottom()};
            int[] nArray2 = nArray;
        } else {
            int[] nArray3 = zzs.zzz();
        }
        nArray = new int[]{zzber.zza().zza((Context)activity, (int)var1_4[0]), zzber.zza().zza((Context)activity, (int)var1_4[1])};
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzW(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = !zzt.zzc().zze ? (keyguardManager == null ? true : (keyguardManager.inKeyguardRestrictedInputMode() ? zzs.zzt(view) : true)) : true;
        long l = zzs.zzA(view);
        if (view.getVisibility() != 0) {
            return false;
        }
        if (!view.isShown()) {
            return false;
        }
        if (powerManager != null && !powerManager.isScreenOn()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        powerManager = zzbjl.zzaQ;
        if (((Boolean)zzbet.zzc().zzc((zzbjd)powerManager)).booleanValue() && !view.getLocalVisibleRect((Rect)(powerManager = new Rect())) && !view.getGlobalVisibleRect((Rect)(powerManager = new Rect()))) {
            return false;
        }
        view = zzbjl.zzgR;
        if ((Boolean)zzbet.zzc().zzc((zzbjd)view) == false) return true;
        view = zzbjl.zzgT;
        if (l >= (long)((Integer)zzbet.zzc().zzc((zzbjd)view)).intValue()) return true;
        return false;
    }

    @TargetApi(value=18)
    public static final void zzX(Context object, Uri uri) {
        int n;
        Object object2;
        try {
            object2 = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            object2.putExtras(bundle);
            zzs.zzu(object, (Intent)object2);
            bundle.putString("com.android.browser.application_id", object.getPackageName());
            object.startActivity((Intent)object2);
            object = uri.toString();
            n = String.valueOf(object).length();
            n += 26;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
        object2 = new StringBuilder(n);
        ((StringBuilder)object2).append("Opening ");
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append(" in a new browser.");
        object = ((StringBuilder)object2).toString();
        com.google.android.gms.ads.internal.util.zze.zzd((String)object);
    }

    public static final int[] zzY(Activity activity) {
        int[] nArray = zzs.zzT(activity);
        int[] nArray2 = new int[]{zzber.zza().zza((Context)activity, nArray[0]), zzber.zza().zza((Context)activity, nArray[1])};
        return nArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzZ(View view, Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            context2 = (PowerManager)context2.getSystemService("power");
            return zzs.zzW(view, (PowerManager)context2, zzs.zzad(context));
        }
        context2 = null;
        return zzs.zzW(view, (PowerManager)context2, zzs.zzad(context));
    }
}

