/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMultivariantPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import java.io.IOException;

public interface HlsPlaylistTracker {
    public void start(Uri var1, MediaSourceEventListener.EventDispatcher var2, PrimaryPlaylistListener var3);

    public void stop();

    public void addListener(PlaylistEventListener var1);

    public void removeListener(PlaylistEventListener var1);

    @Nullable
    public HlsMultivariantPlaylist getMultivariantPlaylist();

    @Nullable
    public HlsMediaPlaylist getPlaylistSnapshot(Uri var1, boolean var2);

    public long getInitialStartTimeUs();

    public boolean isSnapshotValid(Uri var1);

    public void maybeThrowPrimaryPlaylistRefreshError() throws IOException;

    public void maybeThrowPlaylistRefreshError(Uri var1) throws IOException;

    public boolean excludeMediaPlaylist(Uri var1, long var2);

    public void refreshPlaylist(Uri var1);

    public boolean isLive();

    public static final class PlaylistResetException
    extends IOException {
        public final Uri url;

        public PlaylistResetException(Uri url) {
            this.url = url;
        }
    }

    public static final class PlaylistStuckException
    extends IOException {
        public final Uri url;

        public PlaylistStuckException(Uri url) {
            this.url = url;
        }
    }

    public static interface PlaylistEventListener {
        public void onPlaylistChanged();

        public boolean onPlaylistError(Uri var1, LoadErrorHandlingPolicy.LoadErrorInfo var2, boolean var3);
    }

    public static interface PrimaryPlaylistListener {
        public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist var1);
    }

    public static interface Factory {
        public HlsPlaylistTracker createTracker(HlsDataSourceFactory var1, LoadErrorHandlingPolicy var2, HlsPlaylistParserFactory var3);
    }
}

