/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;

public interface TsPayloadReader {
    public static final int FLAG_PAYLOAD_UNIT_START_INDICATOR = 1;
    public static final int FLAG_RANDOM_ACCESS_INDICATOR = 2;
    public static final int FLAG_DATA_ALIGNMENT_INDICATOR = 4;

    public void init(TimestampAdjuster var1, ExtractorOutput var2, TrackIdGenerator var3);

    public void seek();

    public void consume(ParsableByteArray var1, int var2) throws ParserException;

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }

    public static final class TrackIdGenerator {
        private static final int ID_UNSET = Integer.MIN_VALUE;
        private final String formatIdPrefix;
        private final int firstTrackId;
        private final int trackIdIncrement;
        private int trackId;
        private String formatId;

        public TrackIdGenerator(int firstTrackId, int trackIdIncrement) {
            this(Integer.MIN_VALUE, firstTrackId, trackIdIncrement);
        }

        public TrackIdGenerator(int programNumber, int firstTrackId, int trackIdIncrement) {
            this.formatIdPrefix = programNumber != Integer.MIN_VALUE ? programNumber + "/" : "";
            this.firstTrackId = firstTrackId;
            this.trackIdIncrement = trackIdIncrement;
            this.trackId = Integer.MIN_VALUE;
            this.formatId = "";
        }

        public void generateNewId() {
            this.trackId = this.trackId == Integer.MIN_VALUE ? this.firstTrackId : this.trackId + this.trackIdIncrement;
            this.formatId = this.formatIdPrefix + this.trackId;
        }

        public int getTrackId() {
            this.maybeThrowUninitializedError();
            return this.trackId;
        }

        public String getFormatId() {
            this.maybeThrowUninitializedError();
            return this.formatId;
        }

        private void maybeThrowUninitializedError() {
            if (this.trackId == Integer.MIN_VALUE) {
                throw new IllegalStateException("generateNewId() must be called before retrieving ids.");
            }
        }
    }

    public static final class DvbSubtitleInfo {
        public final String language;
        public final int type;
        public final byte[] initializationData;

        public DvbSubtitleInfo(String language, int type, byte[] initializationData) {
            this.language = language;
            this.type = type;
            this.initializationData = initializationData;
        }
    }

    public static final class EsInfo {
        public final int streamType;
        @Nullable
        public final String language;
        public final List<DvbSubtitleInfo> dvbSubtitleInfos;
        public final byte[] descriptorBytes;

        public EsInfo(int streamType, @Nullable String language, @Nullable List<DvbSubtitleInfo> dvbSubtitleInfos, byte[] descriptorBytes) {
            this.streamType = streamType;
            this.language = language;
            this.dvbSubtitleInfos = dvbSubtitleInfos == null ? Collections.emptyList() : Collections.unmodifiableList(dvbSubtitleInfos);
            this.descriptorBytes = descriptorBytes;
        }
    }

    public static interface Factory {
        public SparseArray<TsPayloadReader> createInitialPayloadReaders();

        @Nullable
        public TsPayloadReader createPayloadReader(int var1, EsInfo var2);
    }
}

