/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.jpeg;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.jpeg.MotionPhotoDescription;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.XmlPullParserUtil;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

final class XmpMotionPhotoDescriptionParser {
    private static final String TAG = "MotionPhotoXmpParser";
    private static final String[] MOTION_PHOTO_ATTRIBUTE_NAMES = new String[]{"Camera:MotionPhoto", "GCamera:MotionPhoto", "Camera:MicroVideo", "GCamera:MicroVideo"};
    private static final String[] DESCRIPTION_MOTION_PHOTO_PRESENTATION_TIMESTAMP_ATTRIBUTE_NAMES = new String[]{"Camera:MotionPhotoPresentationTimestampUs", "GCamera:MotionPhotoPresentationTimestampUs", "Camera:MicroVideoPresentationTimestampUs", "GCamera:MicroVideoPresentationTimestampUs"};
    private static final String[] DESCRIPTION_MICRO_VIDEO_OFFSET_ATTRIBUTE_NAMES = new String[]{"Camera:MicroVideoOffset", "GCamera:MicroVideoOffset"};

    @Nullable
    public static MotionPhotoDescription parse(String xmpString) throws IOException {
        try {
            return XmpMotionPhotoDescriptionParser.parseInternal(xmpString);
        }
        catch (ParserException | NumberFormatException | XmlPullParserException e) {
            Log.w((String)TAG, (String)"Ignoring unexpected XMP metadata");
            return null;
        }
    }

    @Nullable
    private static MotionPhotoDescription parseInternal(String xmpString) throws XmlPullParserException, IOException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlPullParser xpp = xmlPullParserFactory.newPullParser();
        xpp.setInput((Reader)new StringReader(xmpString));
        xpp.next();
        if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"x:xmpmeta")) {
            throw new ParserException("Couldn't find xmp metadata");
        }
        long motionPhotoPresentationTimestampUs = -9223372036854775807L;
        ImmutableList<MotionPhotoDescription.ContainerItem> containerItems = ImmutableList.of();
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"rdf:Description")) {
                if (!XmpMotionPhotoDescriptionParser.parseMotionPhotoFlagFromDescription(xpp)) {
                    return null;
                }
                motionPhotoPresentationTimestampUs = XmpMotionPhotoDescriptionParser.parseMotionPhotoPresentationTimestampUsFromDescription(xpp);
                containerItems = XmpMotionPhotoDescriptionParser.parseMicroVideoOffsetFromDescription(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Container:Directory")) {
                containerItems = XmpMotionPhotoDescriptionParser.parseMotionPhotoV1Directory(xpp, "Container", "Item");
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"GContainer:Directory")) continue;
            containerItems = XmpMotionPhotoDescriptionParser.parseMotionPhotoV1Directory(xpp, "GContainer", "GContainerItem");
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"x:xmpmeta"));
        if (containerItems.isEmpty()) {
            return null;
        }
        return new MotionPhotoDescription(motionPhotoPresentationTimestampUs, (List<MotionPhotoDescription.ContainerItem>)containerItems);
    }

    private static boolean parseMotionPhotoFlagFromDescription(XmlPullParser xpp) {
        for (String attributeName : MOTION_PHOTO_ATTRIBUTE_NAMES) {
            String attributeValue = XmlPullParserUtil.getAttributeValue((XmlPullParser)xpp, (String)attributeName);
            if (attributeValue == null) continue;
            int motionPhotoFlag = Integer.parseInt(attributeValue);
            return motionPhotoFlag == 1;
        }
        return false;
    }

    private static long parseMotionPhotoPresentationTimestampUsFromDescription(XmlPullParser xpp) {
        for (String attributeName : DESCRIPTION_MOTION_PHOTO_PRESENTATION_TIMESTAMP_ATTRIBUTE_NAMES) {
            String attributeValue = XmlPullParserUtil.getAttributeValue((XmlPullParser)xpp, (String)attributeName);
            if (attributeValue == null) continue;
            long presentationTimestampUs = Long.parseLong(attributeValue);
            return presentationTimestampUs == -1L ? -9223372036854775807L : presentationTimestampUs;
        }
        return -9223372036854775807L;
    }

    private static ImmutableList<MotionPhotoDescription.ContainerItem> parseMicroVideoOffsetFromDescription(XmlPullParser xpp) {
        for (String attributeName : DESCRIPTION_MICRO_VIDEO_OFFSET_ATTRIBUTE_NAMES) {
            String attributeValue = XmlPullParserUtil.getAttributeValue((XmlPullParser)xpp, (String)attributeName);
            if (attributeValue == null) continue;
            long microVideoOffset = Long.parseLong(attributeValue);
            return ImmutableList.of((Object)new MotionPhotoDescription.ContainerItem("image/jpeg", "Primary", 0L, 0L), (Object)new MotionPhotoDescription.ContainerItem("video/mp4", "MotionPhoto", microVideoOffset, 0L));
        }
        return ImmutableList.of();
    }

    private static ImmutableList<MotionPhotoDescription.ContainerItem> parseMotionPhotoV1Directory(XmlPullParser xpp, String containerNamespacePrefix, String itemNamespacePrefix) throws XmlPullParserException, IOException {
        ImmutableList.Builder containerItems = ImmutableList.builder();
        String itemTagName = containerNamespacePrefix + ":Item";
        String directoryTagName = containerNamespacePrefix + ":Directory";
        do {
            xpp.next();
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)itemTagName)) continue;
            String mimeAttributeName = itemNamespacePrefix + ":Mime";
            String semanticAttributeName = itemNamespacePrefix + ":Semantic";
            String lengthAttributeName = itemNamespacePrefix + ":Length";
            String paddinghAttributeName = itemNamespacePrefix + ":Padding";
            String mime = XmlPullParserUtil.getAttributeValue((XmlPullParser)xpp, (String)mimeAttributeName);
            String semantic = XmlPullParserUtil.getAttributeValue((XmlPullParser)xpp, (String)semanticAttributeName);
            String length = XmlPullParserUtil.getAttributeValue((XmlPullParser)xpp, (String)lengthAttributeName);
            String padding = XmlPullParserUtil.getAttributeValue((XmlPullParser)xpp, (String)paddinghAttributeName);
            if (mime == null || semantic == null) {
                return ImmutableList.of();
            }
            containerItems.add((Object)new MotionPhotoDescription.ContainerItem(mime, semantic, length != null ? Long.parseLong(length) : 0L, padding != null ? Long.parseLong(padding) : 0L));
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)directoryTagName));
        return containerItems.build();
    }

    private XmpMotionPhotoDescriptionParser() {
    }
}

