/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.opengl.Matrix;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;

public final class GlUtil {
    public static final int HOMOGENEOUS_COORDINATE_VECTOR_SIZE = 4;
    public static final float LENGTH_NDC = 2.0f;
    public static final int[] EGL_CONFIG_ATTRIBUTES_RGBA_8888 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12344};
    public static final int[] EGL_CONFIG_ATTRIBUTES_RGBA_1010102 = new int[]{12352, 4, 12324, 10, 12323, 10, 12322, 10, 12321, 2, 12325, 0, 12326, 0, 12344};
    private static final String EXTENSION_PROTECTED_CONTENT = "EGL_EXT_protected_content";
    private static final String EXTENSION_SURFACELESS_CONTEXT = "EGL_KHR_surfaceless_context";
    private static final String EXTENSION_YUV_TARGET = "GL_EXT_YUV_target";
    private static final int[] EGL_WINDOW_SURFACE_ATTRIBUTES_NONE = new int[]{12344};

    private GlUtil() {
    }

    public static float[] getNormalizedCoordinateBounds() {
        return new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    }

    public static float[] getTextureCoordinateBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    }

    public static float[] create4x4IdentityMatrix() {
        float[] matrix = new float[16];
        GlUtil.setToIdentity(matrix);
        return matrix;
    }

    public static void setToIdentity(float[] matrix) {
        Matrix.setIdentityM((float[])matrix, (int)0);
    }

    public static float[] createVertexBuffer(List<float[]> vertexList) {
        float[] vertexBuffer = new float[4 * vertexList.size()];
        for (int i = 0; i < vertexList.size(); ++i) {
            System.arraycopy(vertexList.get(i), 0, vertexBuffer, 4 * i, 4);
        }
        return vertexBuffer;
    }

    public static boolean isProtectedContentExtensionSupported(Context context) {
        if (Util.SDK_INT < 24) {
            return false;
        }
        if (Util.SDK_INT < 26 && ("samsung".equals(Util.MANUFACTURER) || "XT1650".equals(Util.MODEL))) {
            return false;
        }
        if (Util.SDK_INT < 26 && !context.getPackageManager().hasSystemFeature("android.hardware.vr.high_performance")) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_PROTECTED_CONTENT);
    }

    public static boolean isSurfacelessContextExtensionSupported() {
        if (Util.SDK_INT < 17) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_SURFACELESS_CONTEXT);
    }

    public static boolean isYuvTargetExtensionSupported() {
        String glExtensions;
        if (Util.SDK_INT < 17) {
            return false;
        }
        if (Util.areEqual(EGL14.eglGetCurrentContext(), EGL14.EGL_NO_CONTEXT)) {
            try {
                EGLDisplay eglDisplay = GlUtil.createEglDisplay();
                EGLContext eglContext = GlUtil.createEglContext(eglDisplay);
                GlUtil.focusPlaceholderEglSurface(eglContext, eglDisplay);
                glExtensions = GLES20.glGetString((int)7939);
                GlUtil.destroyEglContext(eglDisplay, eglContext);
            }
            catch (GlException e) {
                return false;
            }
        } else {
            glExtensions = GLES20.glGetString((int)7939);
        }
        return glExtensions != null && glExtensions.contains(EXTENSION_YUV_TARGET);
    }

    @RequiresApi(value=17)
    public static EGLDisplay createEglDisplay() throws GlException {
        return Api17.createEglDisplay();
    }

    @RequiresApi(value=17)
    public static EGLContext createEglContext(EGLDisplay eglDisplay) throws GlException {
        return GlUtil.createEglContext(eglDisplay, EGL_CONFIG_ATTRIBUTES_RGBA_8888);
    }

    @RequiresApi(value=17)
    public static EGLContext createEglContext(EGLDisplay eglDisplay, int[] configAttributes) throws GlException {
        Assertions.checkArgument(Arrays.equals(configAttributes, EGL_CONFIG_ATTRIBUTES_RGBA_8888) || Arrays.equals(configAttributes, EGL_CONFIG_ATTRIBUTES_RGBA_1010102));
        return Api17.createEglContext(eglDisplay, Arrays.equals(configAttributes, EGL_CONFIG_ATTRIBUTES_RGBA_1010102) ? 3 : 2, configAttributes);
    }

    @RequiresApi(value=17)
    public static EGLSurface getEglSurface(EGLDisplay eglDisplay, Object surface) throws GlException {
        return Api17.getEglSurface(eglDisplay, surface, EGL_CONFIG_ATTRIBUTES_RGBA_8888, EGL_WINDOW_SURFACE_ATTRIBUTES_NONE);
    }

    @RequiresApi(value=17)
    public static EGLSurface getEglSurface(EGLDisplay eglDisplay, Object surface, int[] configAttributes) throws GlException {
        return Api17.getEglSurface(eglDisplay, surface, configAttributes, EGL_WINDOW_SURFACE_ATTRIBUTES_NONE);
    }

    @RequiresApi(value=17)
    private static EGLSurface createPbufferSurface(EGLDisplay eglDisplay, int width, int height, int[] configAttributes) throws GlException {
        int[] pbufferAttributes = new int[]{12375, width, 12374, height, 12344};
        return Api17.createEglPbufferSurface(eglDisplay, configAttributes, pbufferAttributes);
    }

    @RequiresApi(value=17)
    public static EGLSurface focusPlaceholderEglSurface(EGLContext eglContext, EGLDisplay eglDisplay) throws GlException {
        return GlUtil.createFocusedPlaceholderEglSurface(eglContext, eglDisplay, EGL_CONFIG_ATTRIBUTES_RGBA_8888);
    }

    @RequiresApi(value=17)
    public static EGLSurface createFocusedPlaceholderEglSurface(EGLContext eglContext, EGLDisplay eglDisplay, int[] configAttributes) throws GlException {
        EGLSurface eglSurface = GlUtil.isSurfacelessContextExtensionSupported() ? EGL14.EGL_NO_SURFACE : GlUtil.createPbufferSurface(eglDisplay, 1, 1, configAttributes);
        GlUtil.focusEglSurface(eglDisplay, eglContext, eglSurface, 1, 1);
        return eglSurface;
    }

    public static void checkGlError() throws GlException {
        int error;
        StringBuilder errorMessageBuilder = new StringBuilder();
        boolean foundError = false;
        while ((error = GLES20.glGetError()) != 0) {
            if (foundError) {
                errorMessageBuilder.append('\n');
            }
            errorMessageBuilder.append("glError: ").append(GLU.gluErrorString((int)error));
            foundError = true;
        }
        if (foundError) {
            throw new GlException(errorMessageBuilder.toString());
        }
    }

    private static void assertValidTextureSize(int width, int height) throws GlException {
        int[] maxTextureSizeBuffer = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])maxTextureSizeBuffer, (int)0);
        int maxTextureSize = maxTextureSizeBuffer[0];
        Assertions.checkState(maxTextureSize > 0, "Create a OpenGL context first or run the GL methods on an OpenGL thread.");
        if (width < 0 || height < 0) {
            throw new GlException("width or height is less than 0");
        }
        if (width > maxTextureSize || height > maxTextureSize) {
            throw new GlException("width or height is greater than GL_MAX_TEXTURE_SIZE " + maxTextureSize);
        }
    }

    public static void clearOutputFrame() throws GlException {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        GlUtil.checkGlError();
    }

    @RequiresApi(value=17)
    public static void focusEglSurface(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface eglSurface, int width, int height) throws GlException {
        Api17.focusRenderTarget(eglDisplay, eglContext, eglSurface, 0, width, height);
    }

    @RequiresApi(value=17)
    public static void focusFramebuffer(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface eglSurface, int framebuffer, int width, int height) throws GlException {
        Api17.focusRenderTarget(eglDisplay, eglContext, eglSurface, framebuffer, width, height);
    }

    @RequiresApi(value=17)
    public static void focusFramebufferUsingCurrentContext(int framebuffer, int width, int height) throws GlException {
        Api17.focusFramebufferUsingCurrentContext(framebuffer, width, height);
    }

    public static void deleteTexture(int textureId) throws GlException {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
        GlUtil.checkGlError();
    }

    @RequiresApi(value=17)
    public static void destroyEglContext(@Nullable EGLDisplay eglDisplay, @Nullable EGLContext eglContext) throws GlException {
        Api17.destroyEglContext(eglDisplay, eglContext);
    }

    public static FloatBuffer createBuffer(float[] data) {
        return (FloatBuffer)GlUtil.createBuffer(data.length).put(data).flip();
    }

    private static FloatBuffer createBuffer(int capacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(capacity * 4);
        return byteBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public static int createExternalTexture() throws GlException {
        int texId = GlUtil.generateTexture();
        GlUtil.bindTexture(36197, texId);
        return texId;
    }

    public static int createTexture(int width, int height, boolean useHighPrecisionColorComponents) throws GlException {
        if (useHighPrecisionColorComponents) {
            Assertions.checkState(Util.SDK_INT >= 18, "GLES30 extensions are not supported below API 18.");
            return GlUtil.createTexture(width, height, 34842, 5131);
        }
        return GlUtil.createTexture(width, height, 6408, 5121);
    }

    private static int createTexture(int width, int height, int internalFormat, int type) throws GlException {
        GlUtil.assertValidTextureSize(width, height);
        int texId = GlUtil.generateTexture();
        GlUtil.bindTexture(3553, texId);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        GLES20.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)6408, (int)type, (Buffer)byteBuffer);
        GlUtil.checkGlError();
        return texId;
    }

    private static int generateTexture() throws GlException {
        GlUtil.checkGlException(!Util.areEqual(EGL14.eglGetCurrentContext(), EGL14.EGL_NO_CONTEXT), "No current context");
        int[] texId = new int[1];
        GLES20.glGenTextures((int)1, (int[])texId, (int)0);
        GlUtil.checkGlError();
        return texId[0];
    }

    public static void bindTexture(int textureTarget, int texId) throws GlException {
        GLES20.glBindTexture((int)textureTarget, (int)texId);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10240, (int)9729);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10241, (int)9729);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10242, (int)33071);
        GlUtil.checkGlError();
        GLES20.glTexParameteri((int)textureTarget, (int)10243, (int)33071);
        GlUtil.checkGlError();
    }

    public static int createFboForTexture(int texId) throws GlException {
        GlUtil.checkGlException(!Util.areEqual(EGL14.eglGetCurrentContext(), EGL14.EGL_NO_CONTEXT), "No current context");
        int[] fboId = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])fboId, (int)0);
        GlUtil.checkGlError();
        GLES20.glBindFramebuffer((int)36160, (int)fboId[0]);
        GlUtil.checkGlError();
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texId, (int)0);
        GlUtil.checkGlError();
        return fboId[0];
    }

    public static void checkGlException(boolean expression, String errorMessage) throws GlException {
        if (!expression) {
            throw new GlException(errorMessage);
        }
    }

    private static void checkEglException(String errorMessage) throws GlException {
        int error = EGL14.eglGetError();
        GlUtil.checkGlException(error == 12288, errorMessage + ", error code: " + error);
    }

    @RequiresApi(value=17)
    private static final class Api17 {
        private Api17() {
        }

        @DoNotInline
        public static EGLDisplay createEglDisplay() throws GlException {
            EGLDisplay eglDisplay = EGL14.eglGetDisplay((int)0);
            GlUtil.checkGlException(!eglDisplay.equals((Object)EGL14.EGL_NO_DISPLAY), "No EGL display.");
            GlUtil.checkGlException(EGL14.eglInitialize((EGLDisplay)eglDisplay, (int[])new int[1], (int)0, (int[])new int[1], (int)0), "Error in eglInitialize.");
            GlUtil.checkGlError();
            return eglDisplay;
        }

        @DoNotInline
        public static EGLContext createEglContext(EGLDisplay eglDisplay, int version, int[] configAttributes) throws GlException {
            int[] contextAttributes = new int[]{12440, version, 12344};
            EGLContext eglContext = EGL14.eglCreateContext((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])contextAttributes, (int)0);
            if (eglContext == null) {
                EGL14.eglTerminate((EGLDisplay)eglDisplay);
                throw new GlException("eglCreateContext() failed to create a valid context. The device may not support EGL version " + version);
            }
            GlUtil.checkGlError();
            return eglContext;
        }

        @DoNotInline
        public static EGLSurface getEglSurface(EGLDisplay eglDisplay, Object surface, int[] configAttributes, int[] windowSurfaceAttributes) throws GlException {
            EGLSurface eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (Object)surface, (int[])windowSurfaceAttributes, (int)0);
            GlUtil.checkEglException("Error creating surface");
            return eglSurface;
        }

        @DoNotInline
        public static EGLSurface createEglPbufferSurface(EGLDisplay eglDisplay, int[] configAttributes, int[] pbufferAttributes) throws GlException {
            EGLSurface eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (int[])pbufferAttributes, (int)0);
            GlUtil.checkEglException("Error creating surface");
            return eglSurface;
        }

        @DoNotInline
        public static void focusRenderTarget(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface eglSurface, int framebuffer, int width, int height) throws GlException {
            EGL14.eglMakeCurrent((EGLDisplay)eglDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)eglContext);
            GlUtil.checkEglException("Error making context current");
            Api17.focusFramebufferUsingCurrentContext(framebuffer, width, height);
        }

        @DoNotInline
        public static void focusFramebufferUsingCurrentContext(int framebuffer, int width, int height) throws GlException {
            GlUtil.checkGlException(!Util.areEqual(EGL14.eglGetCurrentContext(), EGL14.EGL_NO_CONTEXT), "No current context");
            int[] boundFramebuffer = new int[1];
            GLES20.glGetIntegerv((int)36006, (int[])boundFramebuffer, (int)0);
            if (boundFramebuffer[0] != framebuffer) {
                GLES20.glBindFramebuffer((int)36160, (int)framebuffer);
            }
            GlUtil.checkGlError();
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            GlUtil.checkGlError();
        }

        @DoNotInline
        public static void destroyEglContext(@Nullable EGLDisplay eglDisplay, @Nullable EGLContext eglContext) throws GlException {
            if (eglDisplay == null) {
                return;
            }
            EGL14.eglMakeCurrent((EGLDisplay)eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            GlUtil.checkEglException("Error releasing context");
            if (eglContext != null) {
                EGL14.eglDestroyContext((EGLDisplay)eglDisplay, (EGLContext)eglContext);
                GlUtil.checkEglException("Error destroying context");
            }
            EGL14.eglReleaseThread();
            GlUtil.checkEglException("Error releasing thread");
            EGL14.eglTerminate((EGLDisplay)eglDisplay);
            GlUtil.checkEglException("Error terminating display");
        }

        @DoNotInline
        private static EGLConfig getEglConfig(EGLDisplay eglDisplay, int[] attributes) throws GlException {
            EGLConfig[] eglConfigs = new EGLConfig[1];
            if (!EGL14.eglChooseConfig((EGLDisplay)eglDisplay, (int[])attributes, (int)0, (EGLConfig[])eglConfigs, (int)0, (int)1, (int[])new int[1], (int)0)) {
                throw new GlException("eglChooseConfig failed.");
            }
            return eglConfigs[0];
        }
    }

    public static final class GlException
    extends Exception {
        public GlException(String message) {
            super(message);
        }
    }
}

