/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Bundle;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.Rating;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Objects;

public final class StarRating
extends Rating {
    @IntRange(from=1L)
    private final int maxStars;
    private final float starRating;
    private static final int TYPE = 2;
    private static final int MAX_STARS_DEFAULT = 5;
    private static final String FIELD_MAX_STARS = Util.intToStringMaxRadix(1);
    private static final String FIELD_STAR_RATING = Util.intToStringMaxRadix(2);
    public static final Bundleable.Creator<StarRating> CREATOR = StarRating::fromBundle;

    public StarRating(@IntRange(from=1L) int maxStars) {
        Assertions.checkArgument(maxStars > 0, "maxStars must be a positive integer");
        this.maxStars = maxStars;
        this.starRating = -1.0f;
    }

    public StarRating(@IntRange(from=1L) int maxStars, @FloatRange(from=0.0) float starRating) {
        Assertions.checkArgument(maxStars > 0, "maxStars must be a positive integer");
        Assertions.checkArgument(starRating >= 0.0f && starRating <= (float)maxStars, "starRating is out of range [0, maxStars]");
        this.maxStars = maxStars;
        this.starRating = starRating;
    }

    @Override
    public boolean isRated() {
        return this.starRating != -1.0f;
    }

    @IntRange(from=1L)
    public int getMaxStars() {
        return this.maxStars;
    }

    public float getStarRating() {
        return this.starRating;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.maxStars, Float.valueOf(this.starRating)});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof StarRating)) {
            return false;
        }
        StarRating other = (StarRating)obj;
        return this.maxStars == other.maxStars && this.starRating == other.starRating;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(FIELD_RATING_TYPE, 2);
        bundle.putInt(FIELD_MAX_STARS, this.maxStars);
        bundle.putFloat(FIELD_STAR_RATING, this.starRating);
        return bundle;
    }

    private static StarRating fromBundle(Bundle bundle) {
        Assertions.checkArgument(bundle.getInt(FIELD_RATING_TYPE, -1) == 2);
        int maxStars = bundle.getInt(FIELD_MAX_STARS, 5);
        float starRating = bundle.getFloat(FIELD_STAR_RATING, -1.0f);
        return starRating == -1.0f ? new StarRating(maxStars) : new StarRating(maxStars, starRating);
    }
}

