/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.types.ResourceCollection;
import shadow.org.apache.tools.ant.types.resources.Appendable;
import shadow.org.apache.tools.ant.types.resources.FileProvider;
import shadow.org.apache.tools.ant.types.resources.ResourceDecorator;
import shadow.org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentTransformingResource
extends ResourceDecorator {
    private static final int BUFFER_SIZE = 8192;

    protected ContentTransformingResource() {
    }

    protected ContentTransformingResource(ResourceCollection other) {
        super(other);
    }

    @Override
    public long getSize() {
        if (this.isExists()) {
            long l;
            InputStream in = null;
            try {
                int readNow;
                in = this.getInputStream();
                byte[] buf = new byte[8192];
                int size = 0;
                while ((readNow = in.read(buf, 0, buf.length)) > 0) {
                    size += readNow;
                }
                l = size;
                Object var8_7 = null;
            }
            catch (IOException ex) {
                try {
                    throw new BuildException("caught exception while reading " + this.getName(), ex);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    FileUtils.close(in);
                    throw throwable;
                }
            }
            FileUtils.close(in);
            return l;
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = this.getResource().getInputStream();
        if (in != null) {
            in = this.wrapStream(in);
        }
        return in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream out = this.getResource().getOutputStream();
        if (out != null) {
            out = this.wrapStream(out);
        }
        return out;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        if (Appendable.class.isAssignableFrom(clazz)) {
            Appendable a;
            if (this.isAppendSupported() && (a = this.getResource().as(Appendable.class)) != null) {
                return clazz.cast(new Appendable(){

                    public OutputStream getAppendOutputStream() throws IOException {
                        OutputStream out = a.getAppendOutputStream();
                        if (out != null) {
                            out = ContentTransformingResource.this.wrapStream(out);
                        }
                        return out;
                    }
                });
            }
            return null;
        }
        return FileProvider.class.isAssignableFrom(clazz) ? null : (T)this.getResource().as(clazz);
    }

    protected boolean isAppendSupported() {
        return false;
    }

    protected abstract InputStream wrapStream(InputStream var1) throws IOException;

    protected abstract OutputStream wrapStream(OutputStream var1) throws IOException;
}

