/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.android.SdkConstants;
import com.android.dexdeps.DexData;
import com.android.dexdeps.DexDataException;
import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;
import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.DexFile;
import com.getkeepsafe.dexcount.DexMethodCountPlugin;
import com.getkeepsafe.dexcount.SourceFile;
import com.getkeepsafe.dexcount.SourceFileKt;
import com.getkeepsafe.dexcount.StreamableZipEntry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/getkeepsafe/dexcount/DexFile;", "Lcom/getkeepsafe/dexcount/SourceFile;", "file", "Ljava/io/File;", "isTemp", "", "isInstantRun", "(Ljava/io/File;ZZ)V", "data", "Lcom/android/dexdeps/DexData;", "fieldRefs", "", "Lcom/android/dexdeps/FieldRef;", "getFieldRefs", "()Ljava/util/List;", "()Z", "methodRefs", "Lcom/android/dexdeps/MethodRef;", "getMethodRefs", "raf", "Ljava/io/RandomAccessFile;", "close", "", "Companion", "dexcount-gradle-plugin"})
public final class DexFile
extends SourceFile {
    private final RandomAccessFile raf;
    private final DexData data;
    private final File file;
    private final boolean isTemp;
    private final boolean isInstantRun;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<MethodRef> getMethodRefs() {
        Object[] objectArray = this.data.getMethodRefs();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"data.methodRefs");
        return ArraysKt.toList((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<FieldRef> getFieldRefs() {
        Object[] objectArray = this.data.getFieldRefs();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"data.fieldRefs");
        return ArraysKt.toList((Object[])objectArray);
    }

    @Override
    public void close() {
        this.raf.close();
        if (this.isTemp) {
            this.file.delete();
        }
    }

    public final boolean isInstantRun() {
        return this.isInstantRun;
    }

    public DexFile(@NotNull File file, boolean isTemp, boolean isInstantRun) {
        DexData dexData;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super(null);
        this.file = file;
        this.isTemp = isTemp;
        this.isInstantRun = isInstantRun;
        this.raf = new RandomAccessFile(this.file, "r");
        DexData dexData2 = new DexData(this.raf);
        DexFile dexFile = this;
        boolean bl = false;
        boolean bl2 = false;
        DexData it = dexData2;
        boolean bl3 = false;
        try {
            it.load();
        }
        catch (IOException e) {
            throw (Throwable)new DexCountException("Error loading dex file", e);
        }
        catch (DexDataException e) {
            throw (Throwable)new DexCountException("Error loading dex file", e);
        }
        dexFile.data = dexData = dexData2;
    }

    public /* synthetic */ DexFile(File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(file, bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final List<DexFile> extractDexData(@Nullable File file, int dxTimeoutSecs) {
        return Companion.extractDexData(file, dxTimeoutSecs);
    }

    @JvmStatic
    private static final List<DexFile> extractDexFromAar(File file, int dxTimeoutSecs) {
        return DexFile.Companion.extractDexFromAar(file, dxTimeoutSecs);
    }

    @JvmStatic
    @NotNull
    public static final List<DexFile> extractDexFromZip(@NotNull File file) {
        return Companion.extractDexFromZip(file);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"Lcom/getkeepsafe/dexcount/DexFile$Companion;", "", "()V", "extractDexData", "", "Lcom/getkeepsafe/dexcount/DexFile;", "file", "Ljava/io/File;", "dxTimeoutSecs", "", "extractDexFromAar", "extractDexFromZip", "dexcount-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final List<DexFile> extractDexData(@Nullable File file, int dxTimeoutSecs) {
            if (file == null || !file.exists()) {
                return CollectionsKt.emptyList();
            }
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            if (StringsKt.endsWith$default((String)string, (String)".aar", (boolean)false, (int)2, null)) {
                return this.extractDexFromAar(file, dxTimeoutSecs);
            }
            try {
                return this.extractDexFromZip(file);
            }
            catch (ZipException zipException) {
                return CollectionsKt.listOf((Object)new DexFile(file, false, false, 4, null));
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmStatic
        private final List<DexFile> extractDexFromAar(File file, int dxTimeoutSecs) {
            var3_3 = new Ref.IntRef();
            var3_3.element = 13;
            tempClasses = (File)SourceFileKt.access$unzip(file, (Function1)new Function1<Sequence<? extends StreamableZipEntry>, File>((Ref.IntRef)minSdk, file){
                final /* synthetic */ Ref.IntRef $minSdk;
                final /* synthetic */ File $file;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                @NotNull
                public final File invoke(@NotNull Sequence<StreamableZipEntry> entries) {
                    void var2_2;
                    Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
                    Object tempFile = null;
                    for (StreamableZipEntry entry : entries) {
                        Object manifestText;
                        if (Intrinsics.areEqual((Object)entry.getName(), (Object)"AndroidManifest.xml")) {
                            Closeable closeable = entry.inputStream();
                            Charset charset = Charsets.UTF_8;
                            boolean bl = false;
                            Closeable closeable2 = closeable;
                            int n = 0;
                            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                            n = 8192;
                            boolean bl2 = false;
                            closeable = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
                            boolean bl3 = false;
                            Throwable throwable = null;
                            try {
                                Object it = (BufferedReader)closeable;
                                boolean bl4 = false;
                                it = TextStreamsKt.readText((Reader)((Reader)it));
                            }
                            catch (Throwable it) {
                                throwable = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            manifestText = it;
                            MatchResult match = Regex.find$default((Regex)new Regex("android:minSdkVersion=\"(\\d+)\""), (CharSequence)((CharSequence)manifestText), (int)0, (int)2, null);
                            if (match != null) {
                                int n2;
                                String string = (String)match.getGroupValues().get(1);
                                Ref.IntRef intRef = this.$minSdk;
                                boolean bl5 = false;
                                intRef.element = n2 = Integer.parseInt(string);
                            }
                        }
                        manifestText = entry.getName();
                        Regex regex = new Regex("classes\\.jar");
                        boolean bl = false;
                        if (!regex.matches((CharSequence)manifestText)) continue;
                        manifestText = SourceFileKt.access$makeTempFile("classes.jar");
                        boolean bl6 = false;
                        bl = false;
                        Object it = manifestText;
                        boolean bl7 = false;
                        entry.writeTo((File)it);
                        tempFile = manifestText;
                    }
                    boolean bl = false;
                    boolean bl8 = false;
                    if (tempFile == null) {
                        boolean bl9 = false;
                        String string = "No classes.jar file found in " + this.$file.getCanonicalPath();
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return var2_2;
                }
                {
                    this.$minSdk = intRef;
                    this.$file = file;
                    super(1);
                }
            });
            v0 = DexMethodCountPlugin.Companion.getSdkLocation();
            if (v0 == null) {
                throw (Throwable)new Exception("Android SDK not found!");
            }
            androidSdkHome = v0;
            buildToolsSubDirs = new File(androidSdkHome, "build-tools");
            v1 /* !! */  = buildToolsSubDirs.listFiles();
            if (v1 /* !! */  == null) ** GOTO lbl-1000
            $this$sortedBy$iv = v1 /* !! */ ;
            $i$f$sortedBy = false;
            var10_11 = $this$sortedBy$iv;
            var11_12 = false;
            var12_14 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    File it = (File)a;
                    boolean bl2 = false;
                    File file = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                    it = (File)b;
                    Comparable comparable = (Comparable)((Object)file.getName());
                    bl2 = false;
                    File file2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                    String string = file2.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            };
            v1 /* !! */  = ArraysKt.sortedWith((Object[])var10_11, (Comparator)var12_14);
            if (v1 /* !! */  != null) {
                v2 = CollectionsKt.asReversed((List)v1 /* !! */ );
            } else lbl-1000:
            // 2 sources

            {
                v2 = dirs = null;
            }
            if (dirs == null || dirs.isEmpty()) {
                throw (Throwable)new Exception("No Build Tools found in " + buildToolsSubDirs.getAbsolutePath());
            }
            isWindows = SdkConstants.currentPlatform() == 2;
            dxExeName = isWindows != false ? "dx.bat" : "dx";
            dxExe = new File((File)dirs.get(0), dxExeName);
            if (!dxExe.exists()) {
                throw (Throwable)new Exception("dx tool not found at " + dxExe.getAbsolutePath());
            }
            dexHelp = SourceFileKt.access$runProcess(dxExe, CollectionsKt.listOf((Object)"--help"), 5000L);
            if (dexHelp.getTimedOut() || dexHelp.getExitCode() != 1) {
                throw (Throwable)new DexCountException("Unable to run dx --help (file: " + dxExe + ')');
            }
            hasMinSdkFlag = StringsKt.contains$default((CharSequence)dexHelp.getStdout(), (CharSequence)"--min-sdk-version", (boolean)false, (int)2, null) != false || StringsKt.contains$default((CharSequence)dexHelp.getStderr(), (CharSequence)"--min-sdk-version", (boolean)false, (int)2, null) != false;
            tempDex = SourceFileKt.access$makeTempFile("classes.dex");
            dexArgs = CollectionsKt.mutableListOf((Object[])new String[]{"--dex", "--output=" + tempDex.getAbsolutePath()});
            if (hasMinSdkFlag) {
                var15_19 = dexArgs;
                var16_20 = "--min-sdk-version=" + minSdk.element;
                var17_21 = false;
                var15_19.add(var16_20);
            }
            var15_19 = dexArgs;
            var16_20 = tempClasses.getAbsolutePath();
            var17_21 = false;
            var15_19.add(var16_20);
            dexRun = SourceFileKt.access$runProcess(dxExe, dexArgs, TimeUnit.SECONDS.toMillis(dxTimeoutSecs));
            if (dexRun.getTimedOut()) {
                throw (Throwable)new DexCountException("dx timed out after " + dxTimeoutSecs + " seconds");
            }
            if (dexRun.getExitCode() != 0) {
                throw (Throwable)new DexCountException("dx exited with exit code " + dexRun.getExitCode() + "\nstderr=" + dexRun.getStderr());
            }
            if (!tempDex.exists()) {
                throw (Throwable)new DexCountException("Error converting classes.jar into classes.dex: " + dexRun.getStderr());
            }
            return CollectionsKt.listOf((Object)new DexFile(tempDex, true, false, 4, null));
        }

        @JvmStatic
        @NotNull
        public final List<DexFile> extractDexFromZip(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return (List)SourceFileKt.access$unzip(file, extractDexFromZip.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

