/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;
import com.getkeepsafe.dexcount.Color;
import com.getkeepsafe.dexcount.ColorConsoleKt;
import com.getkeepsafe.dexcount.Deobfuscator;
import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.DexCountTask;
import com.getkeepsafe.dexcount.DexFile;
import com.getkeepsafe.dexcount.IOUtilKt;
import com.getkeepsafe.dexcount.JarFile;
import com.getkeepsafe.dexcount.OutputFormat;
import com.getkeepsafe.dexcount.PackageTree;
import com.getkeepsafe.dexcount.PrintOptions;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00109\u001a\u00020:H\u0017J\b\u0010;\u001a\u00020:H\u0002J\b\u0010<\u001a\u00020:H\u0002J\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020:H\u0002J\b\u0010@\u001a\u00020:H\u0002J\b\u0010A\u001a\u00020:H\u0002J\b\u0010B\u001a\u00020:H\u0002J\b\u0010C\u001a\u00020:H\u0002J\u0014\u0010D\u001a\u00020:2\n\u0010E\u001a\u00060Fj\u0002`GH\u0002R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018R\u000e\u0010'\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0014\u001a\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0018R\u000e\u00104\u001a\u000205X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020.0\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010$\u00a8\u0006H"}, d2={"Lcom/getkeepsafe/dexcount/DexCountTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "chartDir", "Lorg/gradle/api/file/DirectoryProperty;", "getChartDir", "()Lorg/gradle/api/file/DirectoryProperty;", "config", "Lcom/getkeepsafe/dexcount/DexCountExtension;", "getConfig", "()Lcom/getkeepsafe/dexcount/DexCountExtension;", "setConfig", "(Lcom/getkeepsafe/dexcount/DexCountExtension;)V", "deobfuscator", "Lcom/getkeepsafe/dexcount/Deobfuscator;", "getDeobfuscator", "()Lcom/getkeepsafe/dexcount/Deobfuscator;", "deobfuscator$delegate", "Lkotlin/Lazy;", "inputFileProperty", "Lorg/gradle/api/file/RegularFileProperty;", "getInputFileProperty", "()Lorg/gradle/api/file/RegularFileProperty;", "ioTime", "", "isAndroidProject", "", "isInstantRun", "mappingFileProvider", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/file/FileCollection;", "mappingFileProvider$annotations", "()V", "getMappingFileProvider", "()Lorg/gradle/api/provider/Property;", "outputFile", "getOutputFile", "outputTime", "printOptions", "Lcom/getkeepsafe/dexcount/PrintOptions;", "getPrintOptions", "()Lcom/getkeepsafe/dexcount/PrintOptions;", "printOptions$delegate", "rawInputRepresentation", "", "getRawInputRepresentation", "()Ljava/lang/String;", "startTime", "summaryFile", "getSummaryFile", "tree", "Lcom/getkeepsafe/dexcount/PackageTree;", "treegenTime", "variantOutputName", "getVariantOutputName", "execute", "", "failBuildMaxMethods", "generatePackageTree", "getInputFile", "Ljava/io/File;", "printChart", "printFullTree", "printPreamble", "printSummary", "printTaskDiagnosticData", "printTreeToAppendable", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dexcount-gradle-plugin"})
public class DexCountTask
extends DefaultTask {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private PackageTree tree;
    @InputFile
    @NotNull
    private final RegularFileProperty inputFileProperty;
    @Input
    @NotNull
    private final Property<String> variantOutputName;
    @InputFiles
    @NotNull
    private final Property<FileCollection> mappingFileProvider;
    @OutputFile
    @NotNull
    private final RegularFileProperty outputFile;
    @OutputFile
    @NotNull
    private final RegularFileProperty summaryFile;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty chartDir;
    @Nested
    @NotNull
    public DexCountExtension config;
    private long startTime;
    private long ioTime;
    private long treegenTime;
    private long outputTime;
    private final Lazy printOptions$delegate;
    private final Lazy deobfuscator$delegate;
    private boolean isInstantRun;
    private boolean isAndroidProject;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DexCountTask.class), "printOptions", "getPrintOptions()Lcom/getkeepsafe/dexcount/PrintOptions;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DexCountTask.class), "deobfuscator", "getDeobfuscator()Lcom/getkeepsafe/dexcount/Deobfuscator;"))};
    }

    private final File getInputFile() {
        Object object = this.inputFileProperty.getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputFileProperty.asFile.get()");
        return (File)object;
    }

    @NotNull
    public final RegularFileProperty getInputFileProperty() {
        return this.inputFileProperty;
    }

    private final String getRawInputRepresentation() {
        return String.valueOf(this.getInputFile());
    }

    @NotNull
    public final Property<String> getVariantOutputName() {
        return this.variantOutputName;
    }

    @Nullable
    public static /* synthetic */ void mappingFileProvider$annotations() {
    }

    @NotNull
    public final Property<FileCollection> getMappingFileProvider() {
        return this.mappingFileProvider;
    }

    @NotNull
    public final RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @NotNull
    public final RegularFileProperty getSummaryFile() {
        return this.summaryFile;
    }

    @NotNull
    public final DirectoryProperty getChartDir() {
        return this.chartDir;
    }

    @NotNull
    public final DexCountExtension getConfig() {
        DexCountExtension dexCountExtension = this.config;
        if (dexCountExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return dexCountExtension;
    }

    public final void setConfig(@NotNull DexCountExtension dexCountExtension) {
        Intrinsics.checkParameterIsNotNull((Object)dexCountExtension, (String)"<set-?>");
        this.config = dexCountExtension;
    }

    private final PrintOptions getPrintOptions() {
        Lazy lazy = this.printOptions$delegate;
        DexCountTask dexCountTask = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (PrintOptions)lazy.getValue();
    }

    private final Deobfuscator getDeobfuscator() {
        Lazy lazy = this.deobfuscator$delegate;
        DexCountTask dexCountTask = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (Deobfuscator)lazy.getValue();
    }

    @TaskAction
    public void execute() {
        try {
            DexCountExtension dexCountExtension = this.config;
            if (dexCountExtension == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            boolean bl = dexCountExtension.getEnabled();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Tasks should not be executed if the plugin is disabled";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (!this.getInputFile().exists()) {
                return;
            }
            this.printPreamble();
            this.generatePackageTree();
            this.printSummary();
            this.printFullTree();
            this.printChart();
            this.printTaskDiagnosticData();
            this.failBuildMaxMethods();
        }
        catch (DexCountException e) {
            ColorConsoleKt.withStyledOutput(this, Color.RED, LogLevel.ERROR, (Function1<? super PrintWriter, Unit>)((Function1)new Function1<PrintWriter, Unit>(e){
                final /* synthetic */ DexCountException $e;

                public final void invoke(@NotNull PrintWriter out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    out.println("Error counting dex methods. Please contact the developer at https://github.com/KeepSafe/dexcount-gradle-plugin/issues");
                    this.$e.printStackTrace(out);
                }
                {
                    this.$e = dexCountException;
                    super(1);
                }
            }));
        }
    }

    private final void printPreamble() {
        DexCountExtension dexCountExtension = this.config;
        if (dexCountExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        if (dexCountExtension.getPrintVersion()) {
            Package package_ = ((Object)((Object)this)).getClass().getPackage();
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"javaClass.`package`");
            String projectName = package_.getImplementationTitle();
            Package package_2 = ((Object)((Object)this)).getClass().getPackage();
            Intrinsics.checkExpressionValueIsNotNull((Object)package_2, (String)"javaClass.`package`");
            String projectVersion = package_2.getImplementationVersion();
            ColorConsoleKt.withStyledOutput$default(this, null, null, (Function1)new Function1<PrintWriter, Unit>(this, projectName, projectVersion){
                final /* synthetic */ DexCountTask this$0;
                final /* synthetic */ String $projectName;
                final /* synthetic */ String $projectVersion;

                public final void invoke(@NotNull PrintWriter out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    out.println("Dexcount name:    " + this.$projectName);
                    out.println("Dexcount version: " + this.$projectVersion);
                    out.println("Dexcount input:   " + DexCountTask.access$getRawInputRepresentation$p(this.this$0));
                }
                {
                    this.this$0 = dexCountTask;
                    this.$projectName = string;
                    this.$projectVersion = string2;
                    super(1);
                }
            }, 3, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void generatePackageTree() {
        block28: {
            block30: {
                block29: {
                    file = this.getInputFile();
                    isApk = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"apk");
                    isAar = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"aar");
                    isJar = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar");
                    this.isAndroidProject = isAar != false || isApk != false;
                    var5_5 = isApk != false || isAar != false || isJar != false;
                    var6_7 = false;
                    var7_9 = false;
                    if (!var5_5) {
                        $i$a$-check-DexCountTask$generatePackageTree$1 = false;
                        var7_10 = "File extension is unclear: " + file;
                        throw (Throwable)new IllegalStateException(var7_10.toString());
                    }
                    this.startTime = System.currentTimeMillis();
                    if (this.isAndroidProject) {
                        v0 = this.config;
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        }
                        v1 = DexFile.Companion.extractDexData(file, v0.getDxTimeoutSec());
                    } else {
                        v1 = CollectionsKt.emptyList();
                    }
                    dataList = v1;
                    if (!isAar) break block29;
                    v2 = this.config;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    }
                    if (!v2.getPrintDeclarations()) break block29;
                    v3 = JarFile.Companion.extractJarFromAar(file);
                    break block30;
                }
                if (!isJar) ** GOTO lbl-1000
                v4 = this.config;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                }
                if (v4.getPrintDeclarations()) {
                    v3 = JarFile.Companion.extractJarFromJar(file);
                } else lbl-1000:
                // 2 sources

                {
                    v3 = null;
                }
            }
            jarFile = v3;
            this.ioTime = System.currentTimeMillis();
            try {
                this.tree = new PackageTree(this.getDeobfuscator());
                $this$flatMap$iv = dataList;
                $i$f$flatMap = false;
                var9_20 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (DexFile)element$iv$iv;
                    $i$a$-flatMap-DexCountTask$generatePackageTree$2 = false;
                    list$iv$iv = it.getMethodRefs();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                v5 = this.tree;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                }
                $i$f$flatMap = v5;
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    p1 = (MethodRef)element$iv;
                    $i$a$-unknown-DexCountTask$generatePackageTree$3 = false;
                    $i$f$flatMap.addMethodRef((MethodRef)p1);
                }
                $this$flatMap$iv = dataList;
                $i$f$flatMap = false;
                $i$f$forEach = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (E element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (DexFile)element$iv$iv;
                    $i$a$-flatMap-DexCountTask$generatePackageTree$4 = false;
                    list$iv$iv = it.getFieldRefs();
                    CollectionsKt.addAll(destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                v6 = this.tree;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                }
                $i$f$flatMap = v6;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    p1 = (FieldRef)element$iv;
                    $i$a$-unknown-DexCountTask$generatePackageTree$5 = false;
                    $i$f$flatMap.addFieldRef((FieldRef)p1);
                }
                if (jarFile != null) {
                    $this$forEach$iv = jarFile.getMethodRefs();
                    v7 = this.tree;
                    if (v7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                    }
                    $i$f$flatMap = v7;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p1 = (MethodRef)element$iv;
                        $i$a$-unknown-DexCountTask$generatePackageTree$6 = false;
                        $i$f$flatMap.addDeclaredMethodRef((MethodRef)p1);
                    }
                    $this$forEach$iv = jarFile.getFieldRefs();
                    v8 = this.tree;
                    if (v8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                    }
                    $i$f$flatMap = v8;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p1 = (FieldRef)element$iv;
                        $i$a$-unknown-DexCountTask$generatePackageTree$7 = false;
                        $i$f$flatMap.addDeclaredFieldRef((FieldRef)p1);
                    }
                }
            }
            finally {
                $this$forEach$iv = dataList;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (DexFile)element$iv;
                    $i$a$-forEach-DexCountTask$generatePackageTree$8 = false;
                    it.close();
                }
                v9 = jarFile;
                if (v9 != null) {
                    v9.close();
                }
            }
            this.treegenTime = System.currentTimeMillis();
            $this$forEach$iv = dataList;
            var16_49 = this;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v10 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (DexFile)element$iv;
                    $i$a$-any-DexCountTask$generatePackageTree$9 = false;
                    if (!it.isInstantRun()) continue;
                    v10 = true;
                    break block28;
                }
                v10 = false;
            }
        }
        var16_49.isInstantRun = var17_50 = v10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printSummary() {
        block16: {
            block15: {
                String filename = this.getInputFile().getName();
                if (this.isInstantRun) {
                    ColorConsoleKt.withStyledOutput$default(this, Color.RED, null, printSummary.1.INSTANCE, 2, null);
                }
                PackageTree packageTree = this.tree;
                if (packageTree == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                }
                Color color = packageTree.getMethodCount() < 50000 ? Color.GREEN : Color.YELLOW;
                ColorConsoleKt.withStyledOutput$default(this, color, null, (Function1)new Function1<PrintWriter, Unit>(this, filename){
                    final /* synthetic */ DexCountTask this$0;
                    final /* synthetic */ String $filename;

                    public final void invoke(@NotNull PrintWriter out) {
                        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                        printSummary.1 $fun$percentUsed$1 = printSummary.1.INSTANCE;
                        String percentMethodsUsed = $fun$percentUsed$1.invoke(DexCountTask.access$getTree$p(this.this$0).getMethodCount());
                        String percentFieldsUsed = $fun$percentUsed$1.invoke(DexCountTask.access$getTree$p(this.this$0).getFieldCount());
                        String percentClassesUsed = $fun$percentUsed$1.invoke(DexCountTask.access$getTree$p(this.this$0).getClassCount());
                        int methodsRemaining = Math.max(65535 - DexCountTask.access$getTree$p(this.this$0).getMethodCount(), 0);
                        int fieldsRemaining = Math.max(65535 - DexCountTask.access$getTree$p(this.this$0).getFieldCount(), 0);
                        int classesRemaining = Math.max(65535 - DexCountTask.access$getTree$p(this.this$0).getClassCount(), 0);
                        if (DexCountTask.access$isAndroidProject$p(this.this$0)) {
                            out.println("Total methods in " + this.$filename + ": " + DexCountTask.access$getTree$p(this.this$0).getMethodCount() + " (" + percentMethodsUsed + "% used)");
                            out.println("Total fields in " + this.$filename + ":  " + DexCountTask.access$getTree$p(this.this$0).getFieldCount() + " (" + percentFieldsUsed + "% used)");
                            out.println("Total classes in " + this.$filename + ":  " + DexCountTask.access$getTree$p(this.this$0).getClassCount() + " (" + percentClassesUsed + "% used)");
                            out.println("Methods remaining in " + this.$filename + ": " + methodsRemaining);
                            out.println("Fields remaining in " + this.$filename + ":  " + fieldsRemaining);
                            out.println("Classes remaining in " + this.$filename + ":  " + classesRemaining);
                        } else {
                            out.println("Total methods in " + this.$filename + ": " + DexCountTask.access$getTree$p(this.this$0).getMethodCountDeclared() + " (" + percentMethodsUsed + "% used)");
                            out.println("Total fields in " + this.$filename + ":  " + DexCountTask.access$getTree$p(this.this$0).getFieldCountDeclared() + " (" + percentFieldsUsed + "% used)");
                            out.println("Total classes in " + this.$filename + ":  " + DexCountTask.access$getTree$p(this.this$0).getClassCountDeclared() + " (" + percentClassesUsed + "% used)");
                        }
                    }
                    {
                        this.this$0 = dexCountTask;
                        this.$filename = string;
                        super(1);
                    }
                }, 2, null);
                Object object = this.summaryFile.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"summaryFile.get()");
                File file = ((RegularFile)object).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"summaryFile.get().asFile");
                file.getParentFile().mkdirs();
                Object object2 = this.summaryFile.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"summaryFile.get()");
                ((RegularFile)object2).getAsFile().createNewFile();
                String headers = "methods,fields,classes";
                StringBuilder stringBuilder = new StringBuilder();
                PackageTree packageTree2 = this.tree;
                if (packageTree2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                }
                StringBuilder stringBuilder2 = stringBuilder.append(packageTree2.getMethodCount()).append(',');
                PackageTree packageTree3 = this.tree;
                if (packageTree3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                }
                StringBuilder stringBuilder3 = stringBuilder2.append(packageTree3.getFieldCount()).append(',');
                PackageTree packageTree4 = this.tree;
                if (packageTree4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                }
                String counts = stringBuilder3.append(packageTree4.getClassCount()).toString();
                Object object3 = this.summaryFile.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"summaryFile.get()");
                File file2 = ((RegularFile)object3).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"summaryFile.get().asFile");
                Object object4 = file2;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                File file3 = object4;
                int n = 8192;
                boolean bl2 = false;
                Object object5 = file3;
                boolean bl3 = false;
                Object object6 = object5;
                boolean bl4 = false;
                object6 = new FileOutputStream((File)object6);
                bl4 = false;
                object5 = new OutputStreamWriter((OutputStream)object6, charset);
                bl3 = false;
                BufferedWriter bufferedWriter = object5 instanceof BufferedWriter ? (BufferedWriter)object5 : new BufferedWriter((Writer)object5, n);
                Writer writer = bufferedWriter;
                object4 = new PrintWriter(writer);
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    PrintWriter writer2 = (PrintWriter)object4;
                    boolean bl6 = false;
                    writer2.println(headers);
                    writer2.println(counts);
                    file3 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable);
                }
                if (this.getPrintOptions().getTeamCityIntegration()) break block15;
                DexCountExtension dexCountExtension = this.config;
                if (dexCountExtension == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                }
                if (dexCountExtension.getTeamCitySlug() == null) break block16;
            }
            ColorConsoleKt.withStyledOutput$default(this, null, null, (Function1)new Function1<PrintWriter, Unit>(this){
                final /* synthetic */ DexCountTask this$0;

                public final void invoke(@NotNull PrintWriter out) {
                    String string;
                    StringBuilder stringBuilder;
                    block3: {
                        block2: {
                            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                            stringBuilder = new StringBuilder().append("Dexcount");
                            string = this.this$0.getConfig().getTeamCitySlug();
                            if (string == null) break block2;
                            String string2 = string;
                            StringBuilder stringBuilder2 = stringBuilder;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            String string3 = "_" + StringsKt.replace$default((String)it, (char)' ', (char)'_', (boolean)false, (int)4, null);
                            stringBuilder = stringBuilder2;
                            string = string3;
                            if (string != null) break block3;
                        }
                        string = "";
                    }
                    String slug = stringBuilder.append((Object)string).toString();
                    String prefix = slug + '_' + (String)this.this$0.getVariantOutputName().get();
                    Function2<String, Integer, Unit> $fun$printTeamCityStatisticValue$1 = new Function2<String, Integer, Unit>(out, prefix){
                        final /* synthetic */ PrintWriter $out;
                        final /* synthetic */ String $prefix;

                        public final void invoke(@NotNull String key, int value) {
                            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                            this.$out.println("##teamcity[buildStatisticValue key='" + this.$prefix + '_' + key + "' value='" + value + "']");
                        }
                        {
                            this.$out = printWriter;
                            this.$prefix = string;
                            super(2);
                        }
                    };
                    $fun$printTeamCityStatisticValue$1.invoke("ClassCount", DexCountTask.access$getTree$p(this.this$0).getClassCount());
                    $fun$printTeamCityStatisticValue$1.invoke("MethodCount", DexCountTask.access$getTree$p(this.this$0).getMethodCount());
                    $fun$printTeamCityStatisticValue$1.invoke("FieldCount", DexCountTask.access$getTree$p(this.this$0).getFieldCount());
                }
                {
                    this.this$0 = dexCountTask;
                    super(1);
                }
            }, 3, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printFullTree() {
        Object object = this.outputFile.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile.get().asFile");
        Closeable closeable = IOUtilKt.printStream(file);
        DexCountTask dexCountTask = this;
        boolean bl = false;
        Throwable throwable = null;
        try {
            Appendable p1 = (Appendable)((Object)closeable);
            boolean bl2 = false;
            dexCountTask.printTreeToAppendable(p1);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.outputTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printChart() {
        PrintOptions printOptions2 = this.getPrintOptions();
        printOptions2.setIncludeClasses(true);
        Object object = this.chartDir.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"chartDir.get()");
        File directory = ((Directory)object).getAsFile();
        Closeable closeable = IOUtilKt.printStream(new File(directory, "data.js"));
        boolean bl = false;
        Object object2 = null;
        try {
            PrintStream out = (PrintStream)closeable;
            boolean bl2 = false;
            out.print("var data = ");
            PackageTree packageTree = this.tree;
            if (packageTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
            }
            packageTree.printJson(out, printOptions2);
            out = Unit.INSTANCE;
        }
        catch (Throwable out) {
            object2 = out;
            throw out;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new String[]{"chart-builder.js", "d3.v3.min.js", "index.html", "styles.css"});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String resourceName = (String)element$iv;
            boolean bl3 = false;
            InputStream resource = ((Object)((Object)this)).getClass().getResourceAsStream("/com/getkeepsafe/dexcount/" + resourceName);
            File targetFile = new File(directory, resourceName);
            InputStream inputStream = resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"resource");
            IOUtilKt.copyToFile(inputStream, targetFile);
        }
    }

    private final void printTaskDiagnosticData() {
        DexCountExtension dexCountExtension = this.config;
        if (dexCountExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        LogLevel level = dexCountExtension.getVerbose() ? LogLevel.LIFECYCLE : LogLevel.DEBUG;
        ColorConsoleKt.withStyledOutput(this, Color.YELLOW, level, (Function1<? super PrintWriter, Unit>)((Function1)new Function1<PrintWriter, Unit>(this){
            final /* synthetic */ DexCountTask this$0;

            public final void invoke(@NotNull PrintWriter out) {
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                StringBuilder strBuilder = new StringBuilder();
                DexCountTask.access$printTreeToAppendable(this.this$0, strBuilder);
                out.format(strBuilder.toString(), new Object[0]);
                out.format("\n\nTask runtimes:", new Object[0]);
                out.format("--------------", new Object[0]);
                out.format("parsing:    " + (DexCountTask.access$getIoTime$p(this.this$0) - DexCountTask.access$getStartTime$p(this.this$0)) + " ms", new Object[0]);
                out.format("counting:   " + (DexCountTask.access$getTreegenTime$p(this.this$0) - DexCountTask.access$getIoTime$p(this.this$0)) + " ms", new Object[0]);
                out.format("printing:   " + (DexCountTask.access$getOutputTime$p(this.this$0) - DexCountTask.access$getTreegenTime$p(this.this$0)) + " ms", new Object[0]);
                out.format("total:      " + (DexCountTask.access$getOutputTime$p(this.this$0) - DexCountTask.access$getStartTime$p(this.this$0)) + " ms", new Object[0]);
                out.format("", new Object[0]);
                out.format("input:      {}", DexCountTask.access$getRawInputRepresentation$p(this.this$0));
            }
            {
                this.this$0 = dexCountTask;
                super(1);
            }
        }));
    }

    private final void failBuildMaxMethods() {
        DexCountExtension dexCountExtension = this.config;
        if (dexCountExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        if (dexCountExtension.getMaxMethodCount() > 0) {
            PackageTree packageTree = this.tree;
            if (packageTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
            }
            int n = packageTree.getMethodCount();
            DexCountExtension dexCountExtension2 = this.config;
            if (dexCountExtension2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            if (n > dexCountExtension2.getMaxMethodCount()) {
                StringBuilder stringBuilder = new StringBuilder().append("The current APK has ");
                PackageTree packageTree2 = this.tree;
                if (packageTree2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                }
                StringBuilder stringBuilder2 = stringBuilder.append(packageTree2.getMethodCount()).append(" methods, the current max is: ");
                DexCountExtension dexCountExtension3 = this.config;
                if (dexCountExtension3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                }
                throw (Throwable)new GradleException(stringBuilder2.append(dexCountExtension3.getMaxMethodCount()).append('.').toString());
            }
        }
    }

    private final void printTreeToAppendable(Appendable out) {
        PackageTree packageTree = this.tree;
        if (packageTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
        }
        DexCountExtension dexCountExtension = this.config;
        if (dexCountExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        Object object = dexCountExtension.getFormat();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.getkeepsafe.dexcount.OutputFormat");
        }
        packageTree.print(out, (OutputFormat)((Object)object), this.getPrintOptions());
    }

    @Inject
    public DexCountTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        RegularFileProperty regularFileProperty = objects.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.inputFileProperty = regularFileProperty;
        Property property = objects.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objects.property(String::class.java)");
        this.variantOutputName = property;
        Property property2 = objects.property(FileCollection.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objects.property(FileCollection::class.java)");
        this.mappingFileProvider = property2;
        RegularFileProperty regularFileProperty2 = objects.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty2, (String)"objects.fileProperty()");
        this.outputFile = regularFileProperty2;
        RegularFileProperty regularFileProperty3 = objects.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty3, (String)"objects.fileProperty()");
        this.summaryFile = regularFileProperty3;
        DirectoryProperty directoryProperty = objects.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.chartDir = directoryProperty;
        this.printOptions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PrintOptions>(this){
            final /* synthetic */ DexCountTask this$0;

            @NotNull
            public final PrintOptions invoke() {
                boolean bl = DexCountTask.access$isAndroidProject$p(this.this$0);
                boolean bl2 = this.this$0.getConfig().getPrintDeclarations();
                int n = this.this$0.getConfig().getMaxTreeDepth();
                boolean bl3 = true;
                boolean bl4 = this.this$0.getConfig().getIncludeClasses();
                boolean bl5 = this.this$0.getConfig().getOrderByMethodCount();
                boolean bl6 = this.this$0.getConfig().getTeamCityIntegration();
                boolean bl7 = this.this$0.getConfig().getIncludeTotalMethodCount();
                boolean bl8 = this.this$0.getConfig().getIncludeFieldCount();
                boolean bl9 = true;
                boolean bl10 = this.this$0.getConfig().getIncludeClassCount();
                return new PrintOptions(bl4, bl10, bl9, bl8, bl7, bl6, bl3, bl5, n, bl2, bl);
            }
            {
                this.this$0 = dexCountTask;
                super(0);
            }
        }));
        this.deobfuscator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Deobfuscator>(this){
            final /* synthetic */ DexCountTask this$0;

            @NotNull
            public final Deobfuscator invoke() {
                Deobfuscator deobfuscator2;
                FileCollection fileCollection = (FileCollection)this.this$0.getMappingFileProvider().getOrNull();
                if (fileCollection == null) {
                    return Deobfuscator.Companion.getEmpty();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"mappingFileProvider.orNu\u2026n@lazy Deobfuscator.empty");
                FileCollection fileCollection2 = fileCollection;
                File file = (File)CollectionsKt.singleOrNull((Iterable)((Iterable)fileCollection2));
                if (file == null) {
                    return Deobfuscator.Companion.getEmpty();
                }
                File file2 = file;
                if (file2.exists()) {
                    deobfuscator2 = Deobfuscator.Companion.create(file2);
                } else {
                    ColorConsoleKt.withStyledOutput$default(this.this$0, null, LogLevel.DEBUG, (Function1)new Function1<PrintWriter, Unit>(file2){
                        final /* synthetic */ File $file;

                        public final void invoke(@NotNull PrintWriter it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            it.println("Mapping file specified at " + this.$file.getAbsolutePath() + " does not exist, assuming output is not obfuscated.");
                        }
                        {
                            this.$file = file;
                            super(1);
                        }
                    }, 1, null);
                    deobfuscator2 = Deobfuscator.Companion.getEmpty();
                }
                return deobfuscator2;
            }
            {
                this.this$0 = dexCountTask;
                super(0);
            }
        }));
        this.isAndroidProject = true;
    }

    public static final /* synthetic */ String access$getRawInputRepresentation$p(DexCountTask $this) {
        return $this.getRawInputRepresentation();
    }

    public static final /* synthetic */ PackageTree access$getTree$p(DexCountTask $this) {
        PackageTree packageTree = $this.tree;
        if (packageTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
        }
        return packageTree;
    }

    public static final /* synthetic */ void access$setTree$p(DexCountTask $this, PackageTree packageTree) {
        $this.tree = packageTree;
    }

    public static final /* synthetic */ boolean access$isAndroidProject$p(DexCountTask $this) {
        return $this.isAndroidProject;
    }

    public static final /* synthetic */ void access$setAndroidProject$p(DexCountTask $this, boolean bl) {
        $this.isAndroidProject = bl;
    }

    public static final /* synthetic */ void access$printTreeToAppendable(DexCountTask $this, Appendable out) {
        $this.printTreeToAppendable(out);
    }

    public static final /* synthetic */ long access$getIoTime$p(DexCountTask $this) {
        return $this.ioTime;
    }

    public static final /* synthetic */ void access$setIoTime$p(DexCountTask $this, long l) {
        $this.ioTime = l;
    }

    public static final /* synthetic */ long access$getStartTime$p(DexCountTask $this) {
        return $this.startTime;
    }

    public static final /* synthetic */ void access$setStartTime$p(DexCountTask $this, long l) {
        $this.startTime = l;
    }

    public static final /* synthetic */ long access$getTreegenTime$p(DexCountTask $this) {
        return $this.treegenTime;
    }

    public static final /* synthetic */ void access$setTreegenTime$p(DexCountTask $this, long l) {
        $this.treegenTime = l;
    }

    public static final /* synthetic */ long access$getOutputTime$p(DexCountTask $this) {
        return $this.outputTime;
    }

    public static final /* synthetic */ void access$setOutputTime$p(DexCountTask $this, long l) {
        $this.outputTime = l;
    }
}

