/*
 * Decompiled with CFR 0.152.
 */
package com.android.dexdeps;

import com.android.dexdeps.ClassRef;
import com.android.dexdeps.DexData;
import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;
import java.io.PrintStream;

public class Output {
    private static final String IN0 = "";
    private static final String IN1 = "  ";
    private static final String IN2 = "    ";
    private static final String IN3 = "      ";
    private static final String IN4 = "        ";
    private static final PrintStream out = System.out;

    private static void generateHeader0(String fileName, String format) {
        if (format.equals("brief")) {
            if (fileName != null) {
                out.println("File: " + fileName);
            }
        } else if (format.equals("xml")) {
            if (fileName != null) {
                out.println("<external file=\"" + fileName + "\">");
            } else {
                out.println("<external>");
            }
        } else {
            throw new RuntimeException("unknown output format");
        }
    }

    public static void generateFirstHeader(String fileName, String format) {
        Output.generateHeader0(fileName, format);
    }

    public static void generateHeader(String fileName, String format) {
        out.println();
        Output.generateHeader0(fileName, format);
    }

    public static void generateFooter(String format) {
        if (!format.equals("brief")) {
            if (format.equals("xml")) {
                out.println("</external>");
            } else {
                throw new RuntimeException("unknown output format");
            }
        }
    }

    public static void generate(DexData dexData, String format, boolean justClasses) {
        if (format.equals("brief")) {
            Output.printBrief(dexData, justClasses);
        } else if (format.equals("xml")) {
            Output.printXml(dexData, justClasses);
        } else {
            throw new RuntimeException("unknown output format");
        }
    }

    static void printBrief(DexData dexData, boolean justClasses) {
        ClassRef[] externClassRefs = dexData.getExternalReferences();
        Output.printClassRefs(externClassRefs, justClasses);
        if (!justClasses) {
            Output.printFieldRefs(externClassRefs);
            Output.printMethodRefs(externClassRefs);
        }
    }

    static void printClassRefs(ClassRef[] classes2, boolean justClasses) {
        if (!justClasses) {
            out.println("Classes:");
        }
        for (int i = 0; i < classes2.length; ++i) {
            ClassRef ref = classes2[i];
            out.println(Output.descriptorToDot(ref.getName()));
        }
    }

    static void printFieldRefs(ClassRef[] classes2) {
        out.println("\nFields:");
        for (int i = 0; i < classes2.length; ++i) {
            FieldRef[] fields = classes2[i].getFieldArray();
            for (int j = 0; j < fields.length; ++j) {
                FieldRef ref = fields[j];
                out.println(Output.descriptorToDot(ref.getDeclClassName()) + "." + ref.getName() + " : " + ref.getTypeName());
            }
        }
    }

    static void printMethodRefs(ClassRef[] classes2) {
        out.println("\nMethods:");
        for (int i = 0; i < classes2.length; ++i) {
            MethodRef[] methods = classes2[i].getMethodArray();
            for (int j = 0; j < methods.length; ++j) {
                MethodRef ref = methods[j];
                out.println(Output.descriptorToDot(ref.getDeclClassName()) + "." + ref.getName() + " : " + ref.getDescriptor());
            }
        }
    }

    static void printXml(DexData dexData, boolean justClasses) {
        ClassRef[] externClassRefs = dexData.getExternalReferences();
        String prevPackage = null;
        for (int i = 0; i < externClassRefs.length; ++i) {
            ClassRef cref = externClassRefs[i];
            String declClassName = cref.getName();
            String className = Output.classNameOnly(declClassName);
            String packageName = Output.packageNameOnly(declClassName);
            if (!packageName.equals(prevPackage)) {
                if (prevPackage != null) {
                    out.println("  </package>");
                }
                out.println("  <package name=\"" + packageName + "\">");
                prevPackage = packageName;
            }
            out.println("    <class name=\"" + className + "\">");
            if (!justClasses) {
                Output.printXmlFields(cref);
                Output.printXmlMethods(cref);
            }
            out.println("    </class>");
        }
        if (prevPackage != null) {
            out.println("  </package>");
        }
    }

    private static void printXmlFields(ClassRef cref) {
        FieldRef[] fields = cref.getFieldArray();
        for (int i = 0; i < fields.length; ++i) {
            FieldRef fref = fields[i];
            out.println("      <field name=\"" + fref.getName() + "\" type=\"" + Output.descriptorToDot(fref.getTypeName()) + "\"/>");
        }
    }

    private static void printXmlMethods(ClassRef cref) {
        MethodRef[] methods = cref.getMethodArray();
        for (int i = 0; i < methods.length; ++i) {
            MethodRef mref = methods[i];
            String declClassName = mref.getDeclClassName();
            boolean constructor = mref.getName().equals("<init>");
            if (constructor) {
                out.println("      <constructor name=\"" + Output.classNameOnly(declClassName) + "\">");
            } else {
                out.println("      <method name=\"" + mref.getName() + "\" return=\"" + Output.descriptorToDot(mref.getReturnTypeName()) + "\">");
            }
            String[] args = mref.getArgumentTypeNames();
            for (int j = 0; j < args.length; ++j) {
                out.println("        <parameter type=\"" + Output.descriptorToDot(args[j]) + "\"/>");
            }
            if (constructor) {
                out.println("      </constructor>");
                continue;
            }
            out.println("      </method>");
        }
    }

    public static String primitiveTypeLabel(char typeChar) {
        switch (typeChar) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
        }
        System.err.println("Unexpected class char " + typeChar);
        assert (false);
        return "UNKNOWN";
    }

    public static String descriptorToDot(String descr) {
        int i;
        int targetLen;
        int offset = 0;
        int arrayDepth = 0;
        for (targetLen = descr.length(); targetLen > 1 && descr.charAt(offset) == '['; --targetLen) {
            ++offset;
        }
        arrayDepth = offset;
        if (targetLen == 1) {
            descr = Output.primitiveTypeLabel(descr.charAt(offset));
            offset = 0;
            targetLen = descr.length();
        } else if (targetLen >= 2 && descr.charAt(offset) == 'L' && descr.charAt(offset + targetLen - 1) == ';') {
            targetLen -= 2;
            ++offset;
        }
        char[] buf = new char[targetLen + arrayDepth * 2];
        for (i = 0; i < targetLen; ++i) {
            char ch = descr.charAt(offset + i);
            buf[i] = ch == '/' ? 46 : (int)ch;
        }
        while (arrayDepth-- > 0) {
            buf[i++] = 91;
            buf[i++] = 93;
        }
        assert (i == buf.length);
        return new String(buf);
    }

    public static String classNameOnly(String typeName) {
        String dotted = Output.descriptorToDot(typeName);
        int start = dotted.lastIndexOf(".");
        if (start < 0) {
            return dotted;
        }
        return dotted.substring(start + 1);
    }

    public static String packageNameOnly(String typeName) {
        String dotted = Output.descriptorToDot(typeName);
        int end = dotted.lastIndexOf(".");
        if (end < 0) {
            return IN0;
        }
        return dotted.substring(0, end);
    }
}

