package com.gamepublish.sdk.web;

import android.text.TextUtils;

import java.util.Locale;

import tv.athena.util.JsonParser;

/**
 * Created by chenrenzhan on 2018/8/21.
 */

public class JsEventUtils {

    public static final String CALL_WEB_PURE_JS = "javascript:try{%s}catch(e){if(console)console.log(e)}";
    // methodName, context, param
    public static final String CALL_WEB_METHOD_OBJECT =
            "javascript:try{callWebviewMethod('%s', '%s', %s)}catch(e){if(console)console.log(e)}";

    public static final String CALL_WEB_METHOD_STRING =
            "javascript:try{callWebviewMethod('%s', '%s', '%s')}catch(e){if(console)console.log(e)}";

    public static String formatLoadJs(String methodName, String context, String param) {
        if (isJsonString(param)) {
            return String.format(Locale.US, CALL_WEB_METHOD_OBJECT, methodName, context,
                    param);
        } else {
            return String.format(Locale.US, CALL_WEB_METHOD_STRING, methodName, context,
                    param);
        }
    }

    public static final String formatPureLoadJs(String js) {
        return String.format(Locale.US, JsEventUtils.CALL_WEB_PURE_JS, js);
    }

    public static boolean isJsonString(String param) {
        if (!TextUtils.isEmpty(param)) {
            if ((param.startsWith("{") && param.endsWith("}")) || (param.startsWith("[") && param.endsWith("]"))) {
                return true;
            }
        }
        return false;
    }

    public static String formatString(String param) {
        if (TextUtils.isEmpty(param)) {
            return param;
        }
        if (isJsonString(param)) {
            return JsonParser.toJSONString(param);
        }
        return param;
    }
}
