package com.gamepublish.sdk.ui.feedback;

import android.os.Build;
import android.view.View;
import android.widget.TextView;

import com.gamepublish.sdk.R;

import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by songjipeng on 2018/11/22.
 * Email:songjipeng@yy.com
 */
public class FeedBackTypeViewHolder extends RecyclerView.ViewHolder {
    private static final String TAG = "FeedBackTypeViewHolder";
    private TextView feedbackType;
    public View rootView;
    private FeedBackTypeItemInfo itemInfo;
    private FeedBackItemClickListener listener;
    private int position;
    private String result;

    public FeedBackTypeViewHolder(final View itemView) {
        super(itemView);
        rootView = itemView;
        feedbackType = itemView.findViewById(R.id.fk_types);
        feedbackType.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                listener.itemClick(itemInfo, position);
            }
        });

    }

    public void bindViewHolder(int position, FeedBackTypeItemInfo itemInfo) {
        if (itemInfo == null) {
            return;
        }
        this.position = position;
        this.itemInfo = itemInfo;
        feedbackType.setText(getTypeContent(itemInfo.getType()));
        if (itemInfo.isState()) {
            checkRTLDrawable(R.drawable.feedback_radio_pre);
        } else {
            checkRTLDrawable(R.drawable.feedback_radio_nor);
        }
    }

    public void setItemClickListener(FeedBackItemClickListener feedBackItemClickListener) {
        listener = feedBackItemClickListener;
    }

    private void checkRTLDrawable(int mRadioDrawable) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            feedbackType.setCompoundDrawablesRelativeWithIntrinsicBounds(mRadioDrawable, 0, 0, 0);
        } else {
            feedbackType.setCompoundDrawablesWithIntrinsicBounds(mRadioDrawable, 0, 0, 0);
        }
    }

    private String getTypeContent(int type) {
        if (type == FeedbackType.FEED_BACK_ACCOUNT_ISSUE) {
            result = itemView.getContext().getString(R.string.login_problem_report);
        } else if (type == FeedbackType.FEED_BACK_BUGS) {
            result = itemView.getContext().getString(R.string.short_summary_bugs);
        } else if (type == FeedbackType.FEED_BACK_VIOLATIONS) {
            result = itemView.getContext().getString(R.string.short_summary_violations);
        } else if (type == FeedbackType.FEED_BACK_SUGGESTIONS) {
            result = itemView.getContext().getString(R.string.short_summary_other_problems);
        } else if (type == FeedbackType.FEED_BACK_RECHARGE) {
            result = itemView.getContext().getString(R.string.short_summary_recharge_problem);
        }
        return result;
    }

}
