package com.gamepublish.sdk.ui.feedback;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.gamepublish.sdk.R;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by songjipeng on 2018/10/13.
 * Email:songjipeng@yy.com
 */
public class FeedBackAdapter extends RecyclerView.Adapter<FeedBackTypeViewHolder> {
    private final List<FeedBackTypeItemInfo> mData = new ArrayList<>();
    private FeedBackItemClickListener feedBackItemClickListener;

    public void setData(List<FeedBackTypeItemInfo> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        mData.clear();
        mData.addAll(data);
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public FeedBackTypeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view =
                LayoutInflater.from(parent.getContext())
                        .inflate(R.layout.layout_feedback_type_item, parent, false);
        FeedBackTypeViewHolder holder = new FeedBackTypeViewHolder(view);
        if (feedBackItemClickListener != null) {
            holder.setItemClickListener(feedBackItemClickListener);
        }
        return holder;
    }

    @Override
    public void onBindViewHolder(@NonNull FeedBackTypeViewHolder holder, int position) {
        holder.bindViewHolder(position, mData.get(position));
    }

    @Override
    public int getItemCount() {
        int size = mData.size();
        return size;
    }

    public void setItemClickListener(FeedBackItemClickListener feedBackItemClickListener) {
        this.feedBackItemClickListener = feedBackItemClickListener;
    }
}
