/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lcom/facebook/imagepipeline/memory/MemoryChunkUtil;", "", "()V", "adjustByteCount", "", "offset", "count", "memorySize", "checkBounds", "", "otherLength", "otherOffset", "imagepipeline_release"})
public final class MemoryChunkUtil {
    @NotNull
    public static final MemoryChunkUtil INSTANCE = new MemoryChunkUtil();

    private MemoryChunkUtil() {
    }

    @JvmStatic
    public static final int adjustByteCount(int offset, int count, int memorySize) {
        int available = Math.max(0, memorySize - offset);
        return Math.min(available, count);
    }

    @JvmStatic
    public static final void checkBounds(int offset, int otherLength, int otherOffset, int count, int memorySize) {
        Object[] objectArray = new Object[]{count};
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (String)"count (%d) ! >= 0", (Object[])objectArray);
        objectArray = new Object[]{offset};
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset (%d) ! >= 0", (Object[])objectArray);
        objectArray = new Object[]{otherOffset};
        Preconditions.checkArgument((otherOffset >= 0 ? 1 : 0) != 0, (String)"otherOffset (%d) ! >= 0", (Object[])objectArray);
        objectArray = new Object[]{offset, count, memorySize};
        Preconditions.checkArgument((offset + count <= memorySize ? 1 : 0) != 0, (String)"offset (%d) + count (%d) ! <= %d", (Object[])objectArray);
        objectArray = new Object[]{otherOffset, count, otherLength};
        Preconditions.checkArgument((otherOffset + count <= otherLength ? 1 : 0) != 0, (String)"otherOffset (%d) + count (%d) ! <= %d", (Object[])objectArray);
    }
}

