/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.SparseArray;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadSafe;
import java.util.LinkedList;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
@ThreadSafe
public class BucketMap<T> {
    protected final SparseArray<LinkedEntry<T>> mMap = new SparseArray();
    @Nullable
    @VisibleForTesting
    LinkedEntry<T> mHead;
    @Nullable
    @VisibleForTesting
    LinkedEntry<T> mTail;

    @Nullable
    public synchronized T acquire(int key) {
        LinkedEntry bucket = (LinkedEntry)this.mMap.get(key);
        if (bucket == null) {
            return null;
        }
        Object result = bucket.value.pollFirst();
        this.moveToFront(bucket);
        return (T)result;
    }

    public synchronized void release(int key, T value) {
        LinkedEntry bucket = (LinkedEntry)this.mMap.get(key);
        if (bucket == null) {
            bucket = new LinkedEntry(null, key, new LinkedList(), null);
            this.mMap.put(key, bucket);
        }
        bucket.value.addLast(value);
        this.moveToFront(bucket);
    }

    @VisibleForTesting
    synchronized int valueCount() {
        int count = 0;
        LinkedEntry<Object> entry = this.mHead;
        while (entry != null) {
            if (entry.value != null) {
                count += entry.value.size();
            }
            entry = entry.next;
        }
        return count;
    }

    private synchronized void prune(LinkedEntry<T> bucket) {
        LinkedEntry prev = bucket.prev;
        LinkedEntry next = bucket.next;
        if (prev != null) {
            prev.next = next;
        }
        if (next != null) {
            next.prev = prev;
        }
        bucket.prev = null;
        bucket.next = null;
        if (bucket == this.mHead) {
            this.mHead = next;
        }
        if (bucket == this.mTail) {
            this.mTail = prev;
        }
    }

    private void moveToFront(LinkedEntry<T> bucket) {
        if (this.mHead == bucket) {
            return;
        }
        this.prune(bucket);
        if (this.mHead == null) {
            this.mHead = bucket;
            this.mTail = bucket;
            return;
        }
        bucket.next = this.mHead;
        this.mHead.prev = bucket;
        this.mHead = bucket;
    }

    @Nullable
    public synchronized T removeFromEnd() {
        LinkedEntry<T> last = this.mTail;
        if (last == null) {
            return null;
        }
        Object value = last.value.pollLast();
        this.maybePrune(last);
        return (T)value;
    }

    private void maybePrune(LinkedEntry<T> bucket) {
        if (bucket != null && bucket.value.isEmpty()) {
            this.prune(bucket);
            this.mMap.remove(bucket.key);
        }
    }

    @VisibleForTesting
    static class LinkedEntry<I> {
        @Nullable
        LinkedEntry<I> prev;
        int key;
        LinkedList<I> value;
        @Nullable
        LinkedEntry<I> next;

        private LinkedEntry(@Nullable LinkedEntry<I> prev, int key, LinkedList<I> value, @Nullable LinkedEntry<I> next) {
            this.prev = prev;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public String toString() {
            return "LinkedEntry(key: " + this.key + ")";
        }
    }
}

