/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import bolts.Task;
import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteStreams;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.ImageCacheStatsTracker;
import com.facebook.imagepipeline.cache.StagingArea;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.instrumentation.FrescoInstrumenter;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0001/B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\"H\u0002J\u001f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0086\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010)\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\"J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/facebook/imagepipeline/cache/BufferedDiskCache;", "", "fileCache", "Lcom/facebook/cache/disk/FileCache;", "pooledByteBufferFactory", "Lcom/facebook/common/memory/PooledByteBufferFactory;", "pooledByteStreams", "Lcom/facebook/common/memory/PooledByteStreams;", "readExecutor", "Ljava/util/concurrent/Executor;", "writeExecutor", "imageCacheStatsTracker", "Lcom/facebook/imagepipeline/cache/ImageCacheStatsTracker;", "(Lcom/facebook/cache/disk/FileCache;Lcom/facebook/common/memory/PooledByteBufferFactory;Lcom/facebook/common/memory/PooledByteStreams;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Lcom/facebook/imagepipeline/cache/ImageCacheStatsTracker;)V", "size", "", "getSize", "()J", "stagingArea", "Lcom/facebook/imagepipeline/cache/StagingArea;", "addKeyForAsyncProbing", "", "key", "Lcom/facebook/cache/common/CacheKey;", "checkInStagingAreaAndFileCache", "", "clearAll", "Lbolts/Task;", "Ljava/lang/Void;", "contains", "containsAsync", "containsSync", "diskCheckSync", "foundPinnedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "pinnedImage", "get", "isCancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getAsync", "probe", "put", "encodedImage", "readFromDiskCache", "Lcom/facebook/common/memory/PooledByteBuffer;", "remove", "writeToDiskCache", "Companion", "imagepipeline_release"})
@SourceDebugExtension(value={"SMAP\nBufferedDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedDiskCache.kt\ncom/facebook/imagepipeline/cache/BufferedDiskCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1#2:408\n*E\n"})
public final class BufferedDiskCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCache fileCache;
    @NotNull
    private final PooledByteBufferFactory pooledByteBufferFactory;
    @NotNull
    private final PooledByteStreams pooledByteStreams;
    @NotNull
    private final Executor readExecutor;
    @NotNull
    private final Executor writeExecutor;
    @NotNull
    private final ImageCacheStatsTracker imageCacheStatsTracker;
    @NotNull
    private final StagingArea stagingArea;
    @NotNull
    private static final Class<?> TAG = BufferedDiskCache.class;

    public BufferedDiskCache(@NotNull FileCache fileCache, @NotNull PooledByteBufferFactory pooledByteBufferFactory, @NotNull PooledByteStreams pooledByteStreams, @NotNull Executor readExecutor, @NotNull Executor writeExecutor, @NotNull ImageCacheStatsTracker imageCacheStatsTracker) {
        Intrinsics.checkNotNullParameter((Object)fileCache, (String)"fileCache");
        Intrinsics.checkNotNullParameter((Object)pooledByteBufferFactory, (String)"pooledByteBufferFactory");
        Intrinsics.checkNotNullParameter((Object)pooledByteStreams, (String)"pooledByteStreams");
        Intrinsics.checkNotNullParameter((Object)readExecutor, (String)"readExecutor");
        Intrinsics.checkNotNullParameter((Object)writeExecutor, (String)"writeExecutor");
        Intrinsics.checkNotNullParameter((Object)imageCacheStatsTracker, (String)"imageCacheStatsTracker");
        this.fileCache = fileCache;
        this.pooledByteBufferFactory = pooledByteBufferFactory;
        this.pooledByteStreams = pooledByteStreams;
        this.readExecutor = readExecutor;
        this.writeExecutor = writeExecutor;
        this.imageCacheStatsTracker = imageCacheStatsTracker;
        StagingArea stagingArea = StagingArea.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)stagingArea, (String)"getInstance()");
        this.stagingArea = stagingArea;
    }

    public final boolean containsSync(@NotNull CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.stagingArea.containsKey(key) || this.fileCache.hasKeySync(key);
    }

    @NotNull
    public final Task<Boolean> contains(@NotNull CacheKey key) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.containsSync(key)) {
            Task task2 = Task.forResult((Object)true);
            task = task2;
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"{\n        Task.forResult(true)\n      }");
        } else {
            task = this.containsAsync(key);
        }
        return task;
    }

    private final Task<Boolean> containsAsync(CacheKey key) {
        Task task;
        try {
            Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_containsAsync");
            Task task2 = Task.call(() -> BufferedDiskCache.containsAsync$lambda$0(token, this, key), (Executor)this.readExecutor);
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"{\n      val token = Fres\u2026      readExecutor)\n    }");
            task = task2;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{key.getUriString()};
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache read for %s", (Object[])objectArray);
            Task task3 = Task.forError((Exception)exception);
            Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"{\n      // Log failure\n \u2026forError(exception)\n    }");
            task = task3;
        }
        return task;
    }

    public final boolean diskCheckSync(@NotNull CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.containsSync(key) ? true : this.checkInStagingAreaAndFileCache(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Task<EncodedImage> get(@NotNull CacheKey key, @NotNull AtomicBoolean isCancelled) {
        Task<EncodedImage> task;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)isCancelled, (String)"isCancelled");
        try {
            Task<EncodedImage> task2;
            block10: {
                block9: {
                    Task<EncodedImage> pinnedImage;
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.beginSection((String)"BufferedDiskCache#get");
                    }
                    if ((task2 = (pinnedImage = this.stagingArea.get(key))) == null) break block9;
                    Task<EncodedImage> it = task2;
                    boolean bl = false;
                    Task<EncodedImage> task3 = this.foundPinnedImage(key, (EncodedImage)it);
                    task2 = task3;
                    if (task3 != null) break block10;
                }
                task2 = this.getAsync(key, isCancelled);
            }
            task = task2;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        return task;
    }

    @NotNull
    public final Task<Void> probe(@NotNull CacheKey key) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_probe");
            Task task2 = Task.call(() -> BufferedDiskCache.probe$lambda$2(token, this, key), (Executor)this.writeExecutor);
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"{\n      val token = Fres\u2026     writeExecutor)\n    }");
            task = task2;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{key.getUriString()};
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache probe for %s", (Object[])objectArray);
            Task task3 = Task.forError((Exception)exception);
            Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"{\n      FLog.w(TAG, exce\u2026forError(exception)\n    }");
            task = task3;
        }
        return task;
    }

    public final void addKeyForAsyncProbing(@NotNull CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.fileCache.probe(key);
    }

    private final boolean checkInStagingAreaAndFileCache(CacheKey key) {
        boolean bl;
        EncodedImage result = this.stagingArea.get(key);
        if (result != null) {
            result.close();
            FLog.v(TAG, (String)"Found image for %s in staging area", (Object)key.getUriString());
            this.imageCacheStatsTracker.onStagingAreaHit(key);
            bl = true;
        } else {
            boolean bl2;
            FLog.v(TAG, (String)"Did not find image for %s in staging area", (Object)key.getUriString());
            this.imageCacheStatsTracker.onStagingAreaMiss(key);
            try {
                bl2 = this.fileCache.hasKey(key);
            }
            catch (Exception exception) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final Task<EncodedImage> getAsync(CacheKey key, AtomicBoolean isCancelled) {
        Task task;
        try {
            Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_getAsync");
            Task task2 = Task.call(() -> BufferedDiskCache.getAsync$lambda$3(token, isCancelled, this, key), (Executor)this.readExecutor);
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"{\n      val token = Fres\u2026      readExecutor)\n    }");
            task = task2;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{key.getUriString()};
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache read for %s", (Object[])objectArray);
            Task task3 = Task.forError((Exception)exception);
            Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"{\n      // Log failure\n \u2026forError(exception)\n    }");
            task = task3;
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@NotNull CacheKey key, @NotNull EncodedImage encodedImage) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"BufferedDiskCache#put");
            }
            if (!EncodedImage.isValid((EncodedImage)encodedImage)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            this.stagingArea.put(key, encodedImage);
            EncodedImage finalEncodedImage = EncodedImage.cloneOrNull((EncodedImage)encodedImage);
            try {
                Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_putAsync");
                this.writeExecutor.execute(() -> BufferedDiskCache.put$lambda$4(token, this, key, finalEncodedImage));
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{key.getUriString()};
                FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache write for %s", (Object[])objectArray);
                this.stagingArea.remove(key, encodedImage);
                EncodedImage.closeSafely((EncodedImage)finalEncodedImage);
            }
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    @NotNull
    public final Task<Void> remove(@NotNull CacheKey key) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.stagingArea.remove(key);
        try {
            Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_remove");
            Task task2 = Task.call(() -> BufferedDiskCache.remove$lambda$5(token, this, key), (Executor)this.writeExecutor);
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"{\n      val token = Fres\u2026     writeExecutor)\n    }");
            task = task2;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{key.getUriString()};
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache remove for %s", (Object[])objectArray);
            Task task3 = Task.forError((Exception)exception);
            Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"{\n      // Log failure\n \u2026forError(exception)\n    }");
            task = task3;
        }
        return task;
    }

    @NotNull
    public final Task<Void> clearAll() {
        Task task;
        this.stagingArea.clearAll();
        Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_clearAll");
        try {
            Task task2 = Task.call(() -> BufferedDiskCache.clearAll$lambda$6(token, this), (Executor)this.writeExecutor);
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"{\n      Task.call(\n     \u2026     writeExecutor)\n    }");
            task = task2;
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache clear", (Object[])new Object[0]);
            Task task3 = Task.forError((Exception)exception);
            Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"{\n      // Log failure\n \u2026forError(exception)\n    }");
            task = task3;
        }
        return task;
    }

    public final long getSize() {
        return this.fileCache.getSize();
    }

    private final Task<EncodedImage> foundPinnedImage(CacheKey key, EncodedImage pinnedImage) {
        FLog.v(TAG, (String)"Found image for %s in staging area", (Object)key.getUriString());
        this.imageCacheStatsTracker.onStagingAreaHit(key);
        Task task = Task.forResult((Object)pinnedImage);
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"forResult(pinnedImage)");
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PooledByteBuffer readFromDiskCache(CacheKey key) throws IOException {
        PooledByteBuffer pooledByteBuffer;
        try {
            PooledByteBuffer pooledByteBuffer2;
            FLog.v(TAG, (String)"Disk cache read for %s", (Object)key.getUriString());
            BinaryResource diskCacheResource = this.fileCache.getResource(key);
            if (diskCacheResource == null) {
                FLog.v(TAG, (String)"Disk cache miss for %s", (Object)key.getUriString());
                this.imageCacheStatsTracker.onDiskCacheMiss(key);
                return null;
            }
            FLog.v(TAG, (String)"Found entry in disk cache for %s", (Object)key.getUriString());
            this.imageCacheStatsTracker.onDiskCacheHit(key);
            try (InputStream is = diskCacheResource.openStream();){
                pooledByteBuffer2 = this.pooledByteBufferFactory.newByteBuffer(is, (int)diskCacheResource.size());
            }
            PooledByteBuffer byteBuffer = pooledByteBuffer2;
            FLog.v(TAG, (String)"Successful read from disk cache for %s", (Object)key.getUriString());
            pooledByteBuffer = byteBuffer;
        }
        catch (IOException ioe) {
            Object[] objectArray = new Object[]{key.getUriString()};
            FLog.w(TAG, (Throwable)ioe, (String)"Exception reading from cache for %s", (Object[])objectArray);
            this.imageCacheStatsTracker.onDiskCacheGetFail(key);
            throw ioe;
        }
        return pooledByteBuffer;
    }

    private final void writeToDiskCache(CacheKey key, EncodedImage encodedImage) {
        FLog.v(TAG, (String)"About to write to disk-cache for key %s", (Object)key.getUriString());
        try {
            this.fileCache.insert(key, arg_0 -> BufferedDiskCache.writeToDiskCache$lambda$7(encodedImage, this, arg_0));
            this.imageCacheStatsTracker.onDiskCachePut(key);
            FLog.v(TAG, (String)"Successful disk-cache write for key %s", (Object)key.getUriString());
        }
        catch (IOException ioe) {
            Object[] objectArray = new Object[]{key.getUriString()};
            FLog.w(TAG, (Throwable)ioe, (String)"Failed to write to disk-cache for key %s", (Object[])objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean containsAsync$lambda$0(Object $token, BufferedDiskCache this$0, CacheKey $key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Object currentToken = FrescoInstrumenter.onBeginWork((Object)$token, null);
        try {
            Boolean bl = this$0.checkInStagingAreaAndFileCache($key);
            return bl;
        }
        catch (Throwable th) {
            FrescoInstrumenter.markFailure((Object)$token, (Throwable)th);
            throw th;
        }
        finally {
            FrescoInstrumenter.onEndWork((Object)currentToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void probe$lambda$2(Object $token, BufferedDiskCache this$0, CacheKey $key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Object currentToken = FrescoInstrumenter.onBeginWork((Object)$token, null);
        try {
            this$0.fileCache.probe($key);
        }
        finally {
            FrescoInstrumenter.onEndWork((Object)currentToken);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final EncodedImage getAsync$lambda$3(Object $token, AtomicBoolean $isCancelled, BufferedDiskCache this$0, CacheKey $key) {
        Intrinsics.checkNotNullParameter((Object)$isCancelled, (String)"$isCancelled");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Object currentToken = FrescoInstrumenter.onBeginWork((Object)$token, null);
        try {
            EncodedImage buffer;
            if ($isCancelled.get()) {
                throw new CancellationException();
            }
            EncodedImage result = this$0.stagingArea.get($key);
            if (result != null) {
                FLog.v(TAG, (String)"Found image for %s in staging area", (Object)$key.getUriString());
                this$0.imageCacheStatsTracker.onStagingAreaHit($key);
            } else {
                EncodedImage encodedImage;
                PooledByteBuffer pooledByteBuffer;
                block17: {
                    FLog.v(TAG, (String)"Did not find image for %s in staging area", (Object)$key.getUriString());
                    this$0.imageCacheStatsTracker.onStagingAreaMiss($key);
                    try {
                        if (this$0.readFromDiskCache($key) != null) break block17;
                        EncodedImage encodedImage2 = null;
                        return encodedImage2;
                    }
                    catch (Exception exception) {
                        EncodedImage encodedImage3 = null;
                        FrescoInstrumenter.onEndWork((Object)currentToken);
                        return encodedImage3;
                    }
                }
                buffer = pooledByteBuffer;
                CloseableReference closeableReference = CloseableReference.of((Closeable)((Closeable)buffer));
                Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"of(buffer)");
                CloseableReference ref = closeableReference;
                try {
                    encodedImage = new EncodedImage(ref);
                }
                finally {
                    CloseableReference.closeSafely((CloseableReference)ref);
                }
                buffer = encodedImage;
                result = buffer;
            }
            if (Thread.interrupted()) {
                FLog.v(TAG, (String)"Host thread was interrupted, decreasing reference count");
                result.close();
                throw new InterruptedException();
            }
            buffer = result;
            return buffer;
        }
        catch (Throwable th) {
            FrescoInstrumenter.markFailure((Object)$token, (Throwable)th);
            throw th;
        }
        finally {
            FrescoInstrumenter.onEndWork((Object)currentToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void put$lambda$4(Object $token, BufferedDiskCache this$0, CacheKey $key, EncodedImage $finalEncodedImage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Object currentToken = FrescoInstrumenter.onBeginWork((Object)$token, null);
        try {
            this$0.writeToDiskCache($key, $finalEncodedImage);
        }
        catch (Throwable th) {
            FrescoInstrumenter.markFailure((Object)$token, (Throwable)th);
            throw th;
        }
        finally {
            StagingArea stagingArea = this$0.stagingArea;
            EncodedImage encodedImage = $finalEncodedImage;
            Intrinsics.checkNotNull((Object)encodedImage);
            stagingArea.remove($key, encodedImage);
            EncodedImage.closeSafely((EncodedImage)$finalEncodedImage);
            FrescoInstrumenter.onEndWork((Object)currentToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void remove$lambda$5(Object $token, BufferedDiskCache this$0, CacheKey $key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Object currentToken = FrescoInstrumenter.onBeginWork((Object)$token, null);
        try {
            this$0.stagingArea.remove($key);
            this$0.fileCache.remove($key);
        }
        catch (Throwable th) {
            FrescoInstrumenter.markFailure((Object)$token, (Throwable)th);
            throw th;
        }
        finally {
            FrescoInstrumenter.onEndWork((Object)currentToken);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void clearAll$lambda$6(Object $token, BufferedDiskCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object currentToken = FrescoInstrumenter.onBeginWork((Object)$token, null);
        try {
            this$0.stagingArea.clearAll();
            this$0.fileCache.clearAll();
            Void void_ = null;
            return void_;
        }
        catch (Throwable th) {
            FrescoInstrumenter.markFailure((Object)$token, (Throwable)th);
            throw th;
        }
        finally {
            FrescoInstrumenter.onEndWork((Object)currentToken);
        }
    }

    private static final void writeToDiskCache$lambda$7(EncodedImage $encodedImage, BufferedDiskCache this$0, OutputStream os) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        EncodedImage encodedImage = $encodedImage;
        Intrinsics.checkNotNull((Object)encodedImage);
        InputStream inputStream = encodedImage.getInputStream();
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this$0.pooledByteStreams.copy(inputStream, os);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/imagepipeline/cache/BufferedDiskCache$Companion;", "", "()V", "TAG", "Ljava/lang/Class;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

