/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class CloseableAnimatedImage
extends CloseableImage {
    @Nullable
    private AnimatedImageResult mImageResult;
    private boolean mIsStateful;

    public CloseableAnimatedImage(AnimatedImageResult imageResult) {
        this(imageResult, true);
    }

    public CloseableAnimatedImage(AnimatedImageResult imageResult, boolean isStateful) {
        this.mImageResult = imageResult;
        this.mIsStateful = isStateful;
    }

    public synchronized int getWidth() {
        return this.mImageResult == null ? 0 : this.mImageResult.getImage().getWidth();
    }

    public synchronized int getHeight() {
        return this.mImageResult == null ? 0 : this.mImageResult.getImage().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AnimatedImageResult imageResult;
        CloseableAnimatedImage closeableAnimatedImage = this;
        synchronized (closeableAnimatedImage) {
            if (this.mImageResult == null) {
                return;
            }
            imageResult = this.mImageResult;
            this.mImageResult = null;
        }
        imageResult.dispose();
    }

    public synchronized boolean isClosed() {
        return this.mImageResult == null;
    }

    public synchronized int getSizeInBytes() {
        return this.mImageResult == null ? 0 : this.mImageResult.getImage().getSizeInBytes();
    }

    public boolean isStateful() {
        return this.mIsStateful;
    }

    @Nullable
    public synchronized AnimatedImageResult getImageResult() {
        return this.mImageResult;
    }

    @Nullable
    public synchronized AnimatedImage getImage() {
        return this.mImageResult == null ? null : this.mImageResult.getImage();
    }
}

