/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Logger;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.internal.WorkQueue;
import com.facebook.share.internal.LikeContent;
import com.facebook.share.internal.LikeDialog;
import com.facebook.share.internal.LikeStatusClient;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.widget.LikeView;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class LikeActionController {
    @Deprecated
    public static final String ACTION_LIKE_ACTION_CONTROLLER_UPDATED = "com.facebook.sdk.LikeActionController.UPDATED";
    @Deprecated
    public static final String ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR = "com.facebook.sdk.LikeActionController.DID_ERROR";
    @Deprecated
    public static final String ACTION_LIKE_ACTION_CONTROLLER_DID_RESET = "com.facebook.sdk.LikeActionController.DID_RESET";
    @Deprecated
    public static final String ACTION_OBJECT_ID_KEY = "com.facebook.sdk.LikeActionController.OBJECT_ID";
    @Deprecated
    public static final String ERROR_INVALID_OBJECT_ID = "Invalid Object Id";
    @Deprecated
    public static final String ERROR_PUBLISH_ERROR = "Unable to publish the like/unlike action";
    private static final String TAG = LikeActionController.class.getSimpleName();
    private static final int LIKE_ACTION_CONTROLLER_VERSION = 3;
    private static final int MAX_CACHE_SIZE = 128;
    private static final int MAX_OBJECT_SUFFIX = 1000;
    private static final String LIKE_ACTION_CONTROLLER_STORE = "com.facebook.LikeActionController.CONTROLLER_STORE_KEY";
    private static final String LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY = "PENDING_CONTROLLER_KEY";
    private static final String LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY = "OBJECT_SUFFIX";
    private static final String JSON_INT_VERSION_KEY = "com.facebook.share.internal.LikeActionController.version";
    private static final String JSON_STRING_OBJECT_ID_KEY = "object_id";
    private static final String JSON_INT_OBJECT_TYPE_KEY = "object_type";
    private static final String JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY = "like_count_string_with_like";
    private static final String JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY = "like_count_string_without_like";
    private static final String JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY = "social_sentence_with_like";
    private static final String JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY = "social_sentence_without_like";
    private static final String JSON_BOOL_IS_OBJECT_LIKED_KEY = "is_object_liked";
    private static final String JSON_STRING_UNLIKE_TOKEN_KEY = "unlike_token";
    private static final String JSON_BUNDLE_FACEBOOK_DIALOG_ANALYTICS_BUNDLE = "facebook_dialog_analytics_bundle";
    private static final String LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY = "object_is_liked";
    private static final String LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY = "like_count_string";
    private static final String LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY = "social_sentence";
    private static final String LIKE_DIALOG_RESPONSE_UNLIKE_TOKEN_KEY = "unlike_token";
    private static final int ERROR_CODE_OBJECT_ALREADY_LIKED = 3501;
    private static FileLruCache controllerDiskCache;
    private static final ConcurrentHashMap<String, LikeActionController> cache;
    private static WorkQueue mruCacheWorkQueue;
    private static WorkQueue diskIOWorkQueue;
    private static Handler handler;
    private static String objectIdForPendingController;
    private static boolean isInitialized;
    private static volatile int objectSuffix;
    private static AccessTokenTracker accessTokenTracker;
    private String objectId;
    private LikeView.ObjectType objectType;
    private boolean isObjectLiked;
    private String likeCountStringWithLike;
    private String likeCountStringWithoutLike;
    private String socialSentenceWithLike;
    private String socialSentenceWithoutLike;
    private String unlikeToken;
    private String verifiedObjectId;
    private boolean objectIsPage;
    private boolean isObjectLikedOnServer;
    private boolean isPendingLikeOrUnlike;
    private Bundle facebookDialogAnalyticsBundle;
    private AppEventsLogger appEventsLogger;

    @Deprecated
    public static boolean handleOnActivityResult(final int requestCode, final int resultCode, final Intent data) {
        if (Utility.isNullOrEmpty((String)objectIdForPendingController)) {
            Context appContext = FacebookSdk.getApplicationContext();
            SharedPreferences sharedPreferences = appContext.getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0);
            objectIdForPendingController = sharedPreferences.getString(LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY, null);
        }
        if (Utility.isNullOrEmpty((String)objectIdForPendingController)) {
            return false;
        }
        LikeActionController.getControllerForObjectId(objectIdForPendingController, LikeView.ObjectType.UNKNOWN, new CreationCallback(){

            @Override
            public void onComplete(LikeActionController likeActionController, FacebookException error) {
                if (error == null) {
                    likeActionController.onActivityResult(requestCode, resultCode, data);
                } else {
                    Utility.logd((String)TAG, (Exception)((Object)error));
                }
            }
        });
        return true;
    }

    @Deprecated
    public static void getControllerForObjectId(String objectId, LikeView.ObjectType objectType, CreationCallback callback) {
        LikeActionController controllerForObject;
        if (!isInitialized) {
            LikeActionController.performFirstInitialize();
        }
        if ((controllerForObject = LikeActionController.getControllerFromInMemoryCache(objectId)) != null) {
            LikeActionController.verifyControllerAndInvokeCallback(controllerForObject, objectType, callback);
        } else {
            diskIOWorkQueue.addActiveWorkItem((Runnable)new CreateLikeActionControllerWorkItem(objectId, objectType, callback));
        }
    }

    private static void verifyControllerAndInvokeCallback(LikeActionController likeActionController, LikeView.ObjectType objectType, CreationCallback callback) {
        LikeView.ObjectType bestObjectType = ShareInternalUtility.getMostSpecificObjectType(objectType, likeActionController.objectType);
        FacebookException error = null;
        if (bestObjectType == null) {
            error = new FacebookException("Object with id:\"%s\" is already marked as type:\"%s\". Cannot change the type to:\"%s\"", new Object[]{likeActionController.objectId, likeActionController.objectType.toString(), objectType.toString()});
            likeActionController = null;
        } else {
            likeActionController.objectType = bestObjectType;
        }
        LikeActionController.invokeCallbackWithController(callback, likeActionController, error);
    }

    private static void createControllerForObjectIdAndType(String objectId, LikeView.ObjectType objectType, CreationCallback callback) {
        LikeActionController controllerForObject = LikeActionController.getControllerFromInMemoryCache(objectId);
        if (controllerForObject != null) {
            LikeActionController.verifyControllerAndInvokeCallback(controllerForObject, objectType, callback);
            return;
        }
        controllerForObject = LikeActionController.deserializeFromDiskSynchronously(objectId);
        if (controllerForObject == null) {
            controllerForObject = new LikeActionController(objectId, objectType);
            LikeActionController.serializeToDiskAsync(controllerForObject);
        }
        LikeActionController.putControllerInMemoryCache(objectId, controllerForObject);
        final LikeActionController controllerToRefresh = controllerForObject;
        handler.post(new Runnable(){

            @Override
            public void run() {
                controllerToRefresh.refreshStatusAsync();
            }
        });
        LikeActionController.invokeCallbackWithController(callback, controllerToRefresh, null);
    }

    private static synchronized void performFirstInitialize() {
        if (isInitialized) {
            return;
        }
        handler = new Handler(Looper.getMainLooper());
        Context appContext = FacebookSdk.getApplicationContext();
        SharedPreferences sharedPreferences = appContext.getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0);
        objectSuffix = sharedPreferences.getInt(LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY, 1);
        controllerDiskCache = new FileLruCache(TAG, new FileLruCache.Limits());
        LikeActionController.registerAccessTokenTracker();
        CallbackManagerImpl.registerStaticCallback((int)CallbackManagerImpl.RequestCodeOffset.Like.toRequestCode(), (CallbackManagerImpl.Callback)new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                return LikeActionController.handleOnActivityResult(CallbackManagerImpl.RequestCodeOffset.Like.toRequestCode(), resultCode, data);
            }
        });
        isInitialized = true;
    }

    private static void invokeCallbackWithController(final CreationCallback callback, final LikeActionController controller, final FacebookException error) {
        if (callback == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onComplete(controller, error);
            }
        });
    }

    private static void registerAccessTokenTracker() {
        accessTokenTracker = new AccessTokenTracker(){

            @Override
            protected void onCurrentAccessTokenChanged(AccessToken oldAccessToken, AccessToken currentAccessToken) {
                Context appContext = FacebookSdk.getApplicationContext();
                if (currentAccessToken == null) {
                    objectSuffix = (objectSuffix + 1) % 1000;
                    appContext.getSharedPreferences(LikeActionController.LIKE_ACTION_CONTROLLER_STORE, 0).edit().putInt(LikeActionController.LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY, objectSuffix).apply();
                    cache.clear();
                    controllerDiskCache.clearCache();
                }
                LikeActionController.broadcastAction(null, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_RESET);
            }
        };
    }

    private static void putControllerInMemoryCache(String objectId, LikeActionController controllerForObject) {
        String cacheKey = LikeActionController.getCacheKeyForObjectId(objectId);
        mruCacheWorkQueue.addActiveWorkItem((Runnable)new MRUCacheWorkItem(cacheKey, true));
        cache.put(cacheKey, controllerForObject);
    }

    private static LikeActionController getControllerFromInMemoryCache(String objectId) {
        String cacheKey = LikeActionController.getCacheKeyForObjectId(objectId);
        LikeActionController controller = cache.get(cacheKey);
        if (controller != null) {
            mruCacheWorkQueue.addActiveWorkItem((Runnable)new MRUCacheWorkItem(cacheKey, false));
        }
        return controller;
    }

    private static void serializeToDiskAsync(LikeActionController controller) {
        String controllerJson = LikeActionController.serializeToJson(controller);
        String cacheKey = LikeActionController.getCacheKeyForObjectId(controller.objectId);
        if (!Utility.isNullOrEmpty((String)controllerJson) && !Utility.isNullOrEmpty((String)cacheKey)) {
            diskIOWorkQueue.addActiveWorkItem((Runnable)new SerializeToDiskWorkItem(cacheKey, controllerJson));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeToDiskSynchronously(String cacheKey, String controllerJson) {
        OutputStream outputStream = null;
        try {
            outputStream = controllerDiskCache.openPutStream(cacheKey);
            outputStream.write(controllerJson.getBytes());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Unable to serialize controller to disk", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                Utility.closeQuietly((Closeable)outputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LikeActionController deserializeFromDiskSynchronously(String objectId) {
        LikeActionController controller = null;
        InputStream inputStream = null;
        try {
            String controllerJsonString;
            String cacheKey = LikeActionController.getCacheKeyForObjectId(objectId);
            inputStream = controllerDiskCache.get(cacheKey);
            if (inputStream != null && !Utility.isNullOrEmpty((String)(controllerJsonString = Utility.readStreamToString((InputStream)inputStream)))) {
                controller = LikeActionController.deserializeFromJson(controllerJsonString);
            }
            if (inputStream == null) return controller;
        }
        catch (IOException e) {
            try {
                Log.e((String)TAG, (String)"Unable to deserialize controller from disk", (Throwable)e);
                controller = null;
                if (inputStream == null) return controller;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                Utility.closeQuietly(inputStream);
                throw throwable;
            }
            Utility.closeQuietly((Closeable)inputStream);
            return controller;
        }
        Utility.closeQuietly((Closeable)inputStream);
        return controller;
    }

    private static LikeActionController deserializeFromJson(String controllerJsonString) {
        LikeActionController controller;
        try {
            JSONObject controllerJson = new JSONObject(controllerJsonString);
            int version = controllerJson.optInt(JSON_INT_VERSION_KEY, -1);
            if (version != 3) {
                return null;
            }
            String objectId = controllerJson.getString(JSON_STRING_OBJECT_ID_KEY);
            int objectTypeInt = controllerJson.optInt(JSON_INT_OBJECT_TYPE_KEY, LikeView.ObjectType.UNKNOWN.getValue());
            controller = new LikeActionController(objectId, LikeView.ObjectType.fromInt(objectTypeInt));
            controller.likeCountStringWithLike = controllerJson.optString(JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY, null);
            controller.likeCountStringWithoutLike = controllerJson.optString(JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY, null);
            controller.socialSentenceWithLike = controllerJson.optString(JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, null);
            controller.socialSentenceWithoutLike = controllerJson.optString(JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, null);
            controller.isObjectLiked = controllerJson.optBoolean(JSON_BOOL_IS_OBJECT_LIKED_KEY);
            controller.unlikeToken = controllerJson.optString("unlike_token", null);
            JSONObject analyticsJSON = controllerJson.optJSONObject(JSON_BUNDLE_FACEBOOK_DIALOG_ANALYTICS_BUNDLE);
            if (analyticsJSON != null) {
                controller.facebookDialogAnalyticsBundle = BundleJSONConverter.convertToBundle((JSONObject)analyticsJSON);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Unable to deserialize controller from JSON", (Throwable)e);
            controller = null;
        }
        return controller;
    }

    private static String serializeToJson(LikeActionController controller) {
        JSONObject controllerJson = new JSONObject();
        try {
            JSONObject analyticsJSON;
            controllerJson.put(JSON_INT_VERSION_KEY, 3);
            controllerJson.put(JSON_STRING_OBJECT_ID_KEY, (Object)controller.objectId);
            controllerJson.put(JSON_INT_OBJECT_TYPE_KEY, controller.objectType.getValue());
            controllerJson.put(JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY, (Object)controller.likeCountStringWithLike);
            controllerJson.put(JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY, (Object)controller.likeCountStringWithoutLike);
            controllerJson.put(JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, (Object)controller.socialSentenceWithLike);
            controllerJson.put(JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, (Object)controller.socialSentenceWithoutLike);
            controllerJson.put(JSON_BOOL_IS_OBJECT_LIKED_KEY, controller.isObjectLiked);
            controllerJson.put("unlike_token", (Object)controller.unlikeToken);
            if (controller.facebookDialogAnalyticsBundle != null && (analyticsJSON = BundleJSONConverter.convertToJSON((Bundle)controller.facebookDialogAnalyticsBundle)) != null) {
                controllerJson.put(JSON_BUNDLE_FACEBOOK_DIALOG_ANALYTICS_BUNDLE, (Object)analyticsJSON);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Unable to serialize controller to JSON", (Throwable)e);
            return null;
        }
        return controllerJson.toString();
    }

    private static String getCacheKeyForObjectId(String objectId) {
        String accessTokenPortion = null;
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        if (AccessToken.isCurrentAccessTokenActive()) {
            accessTokenPortion = accessToken.getToken();
        }
        if (accessTokenPortion != null) {
            accessTokenPortion = Utility.md5hash((String)accessTokenPortion);
        }
        return String.format(Locale.ROOT, "%s|%s|com.fb.sdk.like|%d", objectId, Utility.coerceValueIfNullOrEmpty((String)accessTokenPortion, (String)""), objectSuffix);
    }

    private static void broadcastAction(LikeActionController controller, String action) {
        LikeActionController.broadcastAction(controller, action, null);
    }

    private static void broadcastAction(LikeActionController controller, String action, Bundle data) {
        Intent broadcastIntent = new Intent(action);
        if (controller != null) {
            if (data == null) {
                data = new Bundle();
            }
            data.putString(ACTION_OBJECT_ID_KEY, controller.getObjectId());
        }
        if (data != null) {
            broadcastIntent.putExtras(data);
        }
        LocalBroadcastManager.getInstance((Context)FacebookSdk.getApplicationContext()).sendBroadcast(broadcastIntent);
    }

    private LikeActionController(String objectId, LikeView.ObjectType objectType) {
        this.objectId = objectId;
        this.objectType = objectType;
    }

    @Deprecated
    public String getObjectId() {
        return this.objectId;
    }

    @Deprecated
    public String getLikeCountString() {
        return this.isObjectLiked ? this.likeCountStringWithLike : this.likeCountStringWithoutLike;
    }

    @Deprecated
    public String getSocialSentence() {
        return this.isObjectLiked ? this.socialSentenceWithLike : this.socialSentenceWithoutLike;
    }

    @Deprecated
    public boolean isObjectLiked() {
        return this.isObjectLiked;
    }

    @Deprecated
    public boolean shouldEnableView() {
        return false;
    }

    @Deprecated
    public void toggleLike(Activity activity, FragmentWrapper fragment, Bundle analyticsParameters) {
        boolean shouldLikeObject;
        boolean bl = shouldLikeObject = !this.isObjectLiked;
        if (this.canUseOGPublish()) {
            this.updateLikeState(shouldLikeObject);
            if (this.isPendingLikeOrUnlike) {
                this.getAppEventsLogger().logSdkEvent("fb_like_control_did_undo_quickly", null, analyticsParameters);
            } else if (!this.publishLikeOrUnlikeAsync(shouldLikeObject, analyticsParameters)) {
                this.updateLikeState(!shouldLikeObject);
                this.presentLikeDialog(activity, fragment, analyticsParameters);
            }
        } else {
            this.presentLikeDialog(activity, fragment, analyticsParameters);
        }
    }

    private AppEventsLogger getAppEventsLogger() {
        if (this.appEventsLogger == null) {
            this.appEventsLogger = AppEventsLogger.newLogger((Context)FacebookSdk.getApplicationContext());
        }
        return this.appEventsLogger;
    }

    private boolean publishLikeOrUnlikeAsync(boolean shouldLikeObject, Bundle analyticsParameters) {
        boolean requested = false;
        if (this.canUseOGPublish()) {
            if (shouldLikeObject) {
                requested = true;
                this.publishLikeAsync(analyticsParameters);
            } else if (!Utility.isNullOrEmpty((String)this.unlikeToken)) {
                requested = true;
                this.publishUnlikeAsync(analyticsParameters);
            }
        }
        return requested;
    }

    private void publishDidError(boolean oldLikeState) {
        this.updateLikeState(oldLikeState);
        Bundle errorBundle = new Bundle();
        errorBundle.putString("com.facebook.platform.status.ERROR_DESCRIPTION", ERROR_PUBLISH_ERROR);
        LikeActionController.broadcastAction(this, ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, errorBundle);
    }

    private void updateLikeState(boolean isObjectLiked) {
        this.updateState(isObjectLiked, this.likeCountStringWithLike, this.likeCountStringWithoutLike, this.socialSentenceWithLike, this.socialSentenceWithoutLike, this.unlikeToken);
    }

    private void updateState(boolean isObjectLiked, String likeCountStringWithLike, String likeCountStringWithoutLike, String socialSentenceWithLike, String socialSentenceWithoutLike, String unlikeToken) {
        boolean stateChanged;
        likeCountStringWithLike = Utility.coerceValueIfNullOrEmpty((String)likeCountStringWithLike, null);
        likeCountStringWithoutLike = Utility.coerceValueIfNullOrEmpty((String)likeCountStringWithoutLike, null);
        socialSentenceWithLike = Utility.coerceValueIfNullOrEmpty((String)socialSentenceWithLike, null);
        socialSentenceWithoutLike = Utility.coerceValueIfNullOrEmpty((String)socialSentenceWithoutLike, null);
        unlikeToken = Utility.coerceValueIfNullOrEmpty((String)unlikeToken, null);
        boolean bl = stateChanged = isObjectLiked != this.isObjectLiked || !Utility.areObjectsEqual((Object)likeCountStringWithLike, (Object)this.likeCountStringWithLike) || !Utility.areObjectsEqual((Object)likeCountStringWithoutLike, (Object)this.likeCountStringWithoutLike) || !Utility.areObjectsEqual((Object)socialSentenceWithLike, (Object)this.socialSentenceWithLike) || !Utility.areObjectsEqual((Object)socialSentenceWithoutLike, (Object)this.socialSentenceWithoutLike) || !Utility.areObjectsEqual((Object)unlikeToken, (Object)this.unlikeToken);
        if (!stateChanged) {
            return;
        }
        this.isObjectLiked = isObjectLiked;
        this.likeCountStringWithLike = likeCountStringWithLike;
        this.likeCountStringWithoutLike = likeCountStringWithoutLike;
        this.socialSentenceWithLike = socialSentenceWithLike;
        this.socialSentenceWithoutLike = socialSentenceWithoutLike;
        this.unlikeToken = unlikeToken;
        LikeActionController.serializeToDiskAsync(this);
        LikeActionController.broadcastAction(this, ACTION_LIKE_ACTION_CONTROLLER_UPDATED);
    }

    private void presentLikeDialog(Activity activity, FragmentWrapper fragmentWrapper, Bundle analyticsParameters) {
        String analyticsEvent = null;
        if (LikeDialog.canShowNativeDialog()) {
            analyticsEvent = "fb_like_control_did_present_dialog";
        } else if (LikeDialog.canShowWebFallback()) {
            analyticsEvent = "fb_like_control_did_present_fallback_dialog";
        } else {
            this.logAppEventForError("present_dialog", analyticsParameters);
            Utility.logd((String)TAG, (String)"Cannot show the Like Dialog on this device.");
            LikeActionController.broadcastAction(null, ACTION_LIKE_ACTION_CONTROLLER_UPDATED);
        }
        if (analyticsEvent != null) {
            String objectTypeString = this.objectType != null ? this.objectType.toString() : LikeView.ObjectType.UNKNOWN.toString();
            LikeContent likeContent = new LikeContent.Builder().setObjectId(this.objectId).setObjectType(objectTypeString).build();
            if (fragmentWrapper != null) {
                new LikeDialog(fragmentWrapper).show(likeContent);
            } else {
                new LikeDialog(activity).show(likeContent);
            }
            this.saveState(analyticsParameters);
            this.getAppEventsLogger().logSdkEvent("fb_like_control_did_present_dialog", null, analyticsParameters);
        }
    }

    private void onActivityResult(int requestCode, int resultCode, Intent data) {
        ShareInternalUtility.handleActivityResult(requestCode, resultCode, data, this.getResultProcessor(this.facebookDialogAnalyticsBundle));
        this.clearState();
    }

    private ResultProcessor getResultProcessor(final Bundle analyticsParameters) {
        return new ResultProcessor(null){

            @Override
            public void onSuccess(AppCall appCall, Bundle data) {
                if (data == null || !data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY)) {
                    return;
                }
                boolean isObjectLiked = data.getBoolean(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY);
                String likeCountStringWithLike = LikeActionController.this.likeCountStringWithLike;
                String likeCountStringWithoutLike = LikeActionController.this.likeCountStringWithoutLike;
                if (data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY)) {
                    likeCountStringWithoutLike = likeCountStringWithLike = data.getString(LikeActionController.LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY);
                }
                String socialSentenceWithLike = LikeActionController.this.socialSentenceWithLike;
                String socialSentenceWithoutWithoutLike = LikeActionController.this.socialSentenceWithoutLike;
                if (data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY)) {
                    socialSentenceWithoutWithoutLike = socialSentenceWithLike = data.getString(LikeActionController.LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY);
                }
                String unlikeToken = data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY) ? data.getString("unlike_token") : LikeActionController.this.unlikeToken;
                Bundle logParams = analyticsParameters == null ? new Bundle() : analyticsParameters;
                logParams.putString("call_id", appCall.getCallId().toString());
                LikeActionController.this.getAppEventsLogger().logSdkEvent("fb_like_control_dialog_did_succeed", null, logParams);
                LikeActionController.this.updateState(isObjectLiked, likeCountStringWithLike, likeCountStringWithoutLike, socialSentenceWithLike, socialSentenceWithoutWithoutLike, unlikeToken);
            }

            @Override
            public void onError(AppCall appCall, FacebookException error) {
                Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Like Dialog failed with error : %s", (Object[])new Object[]{error});
                Bundle logParams = analyticsParameters == null ? new Bundle() : analyticsParameters;
                logParams.putString("call_id", appCall.getCallId().toString());
                LikeActionController.this.logAppEventForError("present_dialog", logParams);
                LikeActionController.broadcastAction(LikeActionController.this, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, NativeProtocol.createBundleForException((FacebookException)error));
            }

            @Override
            public void onCancel(AppCall appCall) {
                this.onError(appCall, (FacebookException)new FacebookOperationCanceledException());
            }
        };
    }

    private void saveState(Bundle analyticsParameters) {
        LikeActionController.storeObjectIdForPendingController(this.objectId);
        this.facebookDialogAnalyticsBundle = analyticsParameters;
        LikeActionController.serializeToDiskAsync(this);
    }

    private void clearState() {
        this.facebookDialogAnalyticsBundle = null;
        LikeActionController.storeObjectIdForPendingController(null);
    }

    private static void storeObjectIdForPendingController(String objectId) {
        objectIdForPendingController = objectId;
        Context appContext = FacebookSdk.getApplicationContext();
        appContext.getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0).edit().putString(LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY, objectIdForPendingController).apply();
    }

    private boolean canUseOGPublish() {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        return !this.objectIsPage && this.verifiedObjectId != null && AccessToken.isCurrentAccessTokenActive() && accessToken.getPermissions() != null && accessToken.getPermissions().contains("publish_actions");
    }

    private void publishLikeAsync(final Bundle analyticsParameters) {
        this.isPendingLikeOrUnlike = true;
        this.fetchVerifiedObjectId(new RequestCompletionCallback(){

            @Override
            public void onComplete() {
                if (Utility.isNullOrEmpty((String)LikeActionController.this.verifiedObjectId)) {
                    Bundle errorBundle = new Bundle();
                    errorBundle.putString("com.facebook.platform.status.ERROR_DESCRIPTION", LikeActionController.ERROR_INVALID_OBJECT_ID);
                    LikeActionController.broadcastAction(LikeActionController.this, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, errorBundle);
                    return;
                }
                GraphRequestBatch requestBatch = new GraphRequestBatch();
                final PublishLikeRequestWrapper likeRequest = new PublishLikeRequestWrapper(LikeActionController.this.verifiedObjectId, LikeActionController.this.objectType);
                likeRequest.addToBatch(requestBatch);
                requestBatch.addCallback(new GraphRequestBatch.Callback(){

                    public void onBatchCompleted(GraphRequestBatch batch) {
                        LikeActionController.this.isPendingLikeOrUnlike = false;
                        if (likeRequest.getError() != null) {
                            LikeActionController.this.publishDidError(false);
                        } else {
                            LikeActionController.this.unlikeToken = Utility.coerceValueIfNullOrEmpty((String)likeRequest.unlikeToken, null);
                            LikeActionController.this.isObjectLikedOnServer = true;
                            LikeActionController.this.getAppEventsLogger().logSdkEvent("fb_like_control_did_like", null, analyticsParameters);
                            LikeActionController.this.publishAgainIfNeeded(analyticsParameters);
                        }
                    }
                });
                requestBatch.executeAsync();
            }
        });
    }

    private void publishUnlikeAsync(final Bundle analyticsParameters) {
        this.isPendingLikeOrUnlike = true;
        GraphRequestBatch requestBatch = new GraphRequestBatch();
        final PublishUnlikeRequestWrapper unlikeRequest = new PublishUnlikeRequestWrapper(this.unlikeToken);
        unlikeRequest.addToBatch(requestBatch);
        requestBatch.addCallback(new GraphRequestBatch.Callback(){

            public void onBatchCompleted(GraphRequestBatch batch) {
                LikeActionController.this.isPendingLikeOrUnlike = false;
                if (unlikeRequest.getError() != null) {
                    LikeActionController.this.publishDidError(true);
                } else {
                    LikeActionController.this.unlikeToken = null;
                    LikeActionController.this.isObjectLikedOnServer = false;
                    LikeActionController.this.getAppEventsLogger().logSdkEvent("fb_like_control_did_unlike", null, analyticsParameters);
                    LikeActionController.this.publishAgainIfNeeded(analyticsParameters);
                }
            }
        });
        requestBatch.executeAsync();
    }

    private void refreshStatusAsync() {
        if (!AccessToken.isCurrentAccessTokenActive()) {
            this.refreshStatusViaService();
            return;
        }
        this.fetchVerifiedObjectId(new RequestCompletionCallback(){

            @Override
            public void onComplete() {
                AbstractRequestWrapper likeRequestWrapper;
                switch (LikeActionController.this.objectType) {
                    case PAGE: {
                        likeRequestWrapper = new GetPageLikesRequestWrapper(LikeActionController.this.verifiedObjectId);
                        break;
                    }
                    default: {
                        likeRequestWrapper = new GetOGObjectLikesRequestWrapper(LikeActionController.this.verifiedObjectId, LikeActionController.this.objectType);
                    }
                }
                GetEngagementRequestWrapper engagementRequest = new GetEngagementRequestWrapper(LikeActionController.this.verifiedObjectId, LikeActionController.this.objectType);
                GraphRequestBatch requestBatch = new GraphRequestBatch();
                likeRequestWrapper.addToBatch(requestBatch);
                engagementRequest.addToBatch(requestBatch);
                requestBatch.addCallback(new GraphRequestBatch.Callback((LikeRequestWrapper)((Object)likeRequestWrapper), engagementRequest){
                    final /* synthetic */ LikeRequestWrapper val$likeRequestWrapper;
                    final /* synthetic */ GetEngagementRequestWrapper val$engagementRequest;
                    {
                        this.val$likeRequestWrapper = likeRequestWrapper;
                        this.val$engagementRequest = getEngagementRequestWrapper;
                    }

                    public void onBatchCompleted(GraphRequestBatch batch) {
                        if (this.val$likeRequestWrapper.getError() != null || this.val$engagementRequest.getError() != null) {
                            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Unable to refresh like state for id: '%s'", (Object[])new Object[]{LikeActionController.this.objectId});
                            return;
                        }
                        LikeActionController.this.updateState(this.val$likeRequestWrapper.isObjectLiked(), this.val$engagementRequest.likeCountStringWithLike, this.val$engagementRequest.likeCountStringWithoutLike, this.val$engagementRequest.socialSentenceStringWithLike, this.val$engagementRequest.socialSentenceStringWithoutLike, this.val$likeRequestWrapper.getUnlikeToken());
                    }
                });
                requestBatch.executeAsync();
            }
        });
    }

    private void refreshStatusViaService() {
        LikeStatusClient likeStatusClient = new LikeStatusClient(FacebookSdk.getApplicationContext(), FacebookSdk.getApplicationId(), this.objectId);
        if (!likeStatusClient.start()) {
            return;
        }
        PlatformServiceClient.CompletedListener callback = new PlatformServiceClient.CompletedListener(){

            @Override
            public void completed(Bundle result) {
                if (result == null || !result.containsKey("com.facebook.platform.extra.OBJECT_IS_LIKED")) {
                    return;
                }
                boolean objectIsLiked = result.getBoolean("com.facebook.platform.extra.OBJECT_IS_LIKED");
                String likeCountWithLike = result.containsKey("com.facebook.platform.extra.LIKE_COUNT_STRING_WITH_LIKE") ? result.getString("com.facebook.platform.extra.LIKE_COUNT_STRING_WITH_LIKE") : LikeActionController.this.likeCountStringWithLike;
                String likeCountWithoutLike = result.containsKey("com.facebook.platform.extra.LIKE_COUNT_STRING_WITHOUT_LIKE") ? result.getString("com.facebook.platform.extra.LIKE_COUNT_STRING_WITHOUT_LIKE") : LikeActionController.this.likeCountStringWithoutLike;
                String socialSentenceWithLike = result.containsKey("com.facebook.platform.extra.SOCIAL_SENTENCE_WITH_LIKE") ? result.getString("com.facebook.platform.extra.SOCIAL_SENTENCE_WITH_LIKE") : LikeActionController.this.socialSentenceWithLike;
                String socialSentenceWithoutLike = result.containsKey("com.facebook.platform.extra.SOCIAL_SENTENCE_WITHOUT_LIKE") ? result.getString("com.facebook.platform.extra.SOCIAL_SENTENCE_WITHOUT_LIKE") : LikeActionController.this.socialSentenceWithoutLike;
                String unlikeToken = result.containsKey("com.facebook.platform.extra.UNLIKE_TOKEN") ? result.getString("com.facebook.platform.extra.UNLIKE_TOKEN") : LikeActionController.this.unlikeToken;
                LikeActionController.this.updateState(objectIsLiked, likeCountWithLike, likeCountWithoutLike, socialSentenceWithLike, socialSentenceWithoutLike, unlikeToken);
            }
        };
        likeStatusClient.setCompletedListener(callback);
    }

    private void publishAgainIfNeeded(Bundle analyticsParameters) {
        if (this.isObjectLiked != this.isObjectLikedOnServer && !this.publishLikeOrUnlikeAsync(this.isObjectLiked, analyticsParameters)) {
            this.publishDidError(!this.isObjectLiked);
        }
    }

    private void fetchVerifiedObjectId(final RequestCompletionCallback completionHandler) {
        if (!Utility.isNullOrEmpty((String)this.verifiedObjectId)) {
            if (completionHandler != null) {
                completionHandler.onComplete();
            }
            return;
        }
        final GetOGObjectIdRequestWrapper objectIdRequest = new GetOGObjectIdRequestWrapper(this.objectId, this.objectType);
        final GetPageIdRequestWrapper pageIdRequest = new GetPageIdRequestWrapper(this.objectId, this.objectType);
        GraphRequestBatch requestBatch = new GraphRequestBatch();
        objectIdRequest.addToBatch(requestBatch);
        pageIdRequest.addToBatch(requestBatch);
        requestBatch.addCallback(new GraphRequestBatch.Callback(){

            public void onBatchCompleted(GraphRequestBatch batch) {
                LikeActionController.this.verifiedObjectId = objectIdRequest.verifiedObjectId;
                if (Utility.isNullOrEmpty((String)LikeActionController.this.verifiedObjectId)) {
                    LikeActionController.this.verifiedObjectId = pageIdRequest.verifiedObjectId;
                    LikeActionController.this.objectIsPage = pageIdRequest.objectIsPage;
                }
                if (Utility.isNullOrEmpty((String)LikeActionController.this.verifiedObjectId)) {
                    Logger.log((LoggingBehavior)LoggingBehavior.DEVELOPER_ERRORS, (String)TAG, (String)"Unable to verify the FB id for '%s'. Verify that it is a valid FB object or page", (Object[])new Object[]{LikeActionController.this.objectId});
                    LikeActionController.this.logAppEventForError("get_verified_id", pageIdRequest.getError() != null ? pageIdRequest.getError() : objectIdRequest.getError());
                }
                if (completionHandler != null) {
                    completionHandler.onComplete();
                }
            }
        });
        requestBatch.executeAsync();
    }

    private void logAppEventForError(String action, Bundle parameters) {
        Bundle logParams = new Bundle(parameters);
        logParams.putString(JSON_STRING_OBJECT_ID_KEY, this.objectId);
        logParams.putString(JSON_INT_OBJECT_TYPE_KEY, this.objectType.toString());
        logParams.putString("current_action", action);
        this.getAppEventsLogger().logSdkEvent("fb_like_control_error", null, logParams);
    }

    private void logAppEventForError(String action, FacebookRequestError error) {
        JSONObject requestResult;
        Bundle logParams = new Bundle();
        if (error != null && (requestResult = error.getRequestResult()) != null) {
            logParams.putString("error", requestResult.toString());
        }
        this.logAppEventForError(action, logParams);
    }

    static {
        cache = new ConcurrentHashMap();
        mruCacheWorkQueue = new WorkQueue(1);
        diskIOWorkQueue = new WorkQueue(1);
    }

    private static class CreateLikeActionControllerWorkItem
    implements Runnable {
        private String objectId;
        private LikeView.ObjectType objectType;
        private CreationCallback callback;

        CreateLikeActionControllerWorkItem(String objectId, LikeView.ObjectType objectType, CreationCallback callback) {
            this.objectId = objectId;
            this.objectType = objectType;
            this.callback = callback;
        }

        @Override
        public void run() {
            LikeActionController.createControllerForObjectIdAndType(this.objectId, this.objectType, this.callback);
        }
    }

    private static class SerializeToDiskWorkItem
    implements Runnable {
        private String cacheKey;
        private String controllerJson;

        SerializeToDiskWorkItem(String cacheKey, String controllerJson) {
            this.cacheKey = cacheKey;
            this.controllerJson = controllerJson;
        }

        @Override
        public void run() {
            LikeActionController.serializeToDiskSynchronously(this.cacheKey, this.controllerJson);
        }
    }

    private static class MRUCacheWorkItem
    implements Runnable {
        private static ArrayList<String> mruCachedItems = new ArrayList();
        private String cacheItem;
        private boolean shouldTrim;

        MRUCacheWorkItem(String cacheItem, boolean shouldTrim) {
            this.cacheItem = cacheItem;
            this.shouldTrim = shouldTrim;
        }

        @Override
        public void run() {
            if (this.cacheItem != null) {
                mruCachedItems.remove(this.cacheItem);
                mruCachedItems.add(0, this.cacheItem);
            }
            if (this.shouldTrim && mruCachedItems.size() >= 128) {
                int targetSize = 64;
                while (targetSize < mruCachedItems.size()) {
                    String cacheKey = mruCachedItems.remove(mruCachedItems.size() - 1);
                    cache.remove(cacheKey);
                }
            }
        }
    }

    private abstract class AbstractRequestWrapper
    implements RequestWrapper {
        private GraphRequest request;
        protected String objectId;
        protected LikeView.ObjectType objectType;
        protected FacebookRequestError error;

        protected AbstractRequestWrapper(String objectId, LikeView.ObjectType objectType) {
            this.objectId = objectId;
            this.objectType = objectType;
        }

        @Override
        public void addToBatch(GraphRequestBatch batch) {
            batch.add(this.request);
        }

        @Override
        public FacebookRequestError getError() {
            return this.error;
        }

        protected void setRequest(GraphRequest request) {
            this.request = request;
            request.setVersion(FacebookSdk.getGraphApiVersion());
            request.setCallback(new GraphRequest.Callback(){

                public void onCompleted(GraphResponse response) {
                    AbstractRequestWrapper.this.error = response.getError();
                    if (AbstractRequestWrapper.this.error != null) {
                        AbstractRequestWrapper.this.processError(AbstractRequestWrapper.this.error);
                    } else {
                        AbstractRequestWrapper.this.processSuccess(response);
                    }
                }
            });
        }

        protected void processError(FacebookRequestError error) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error running request for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, error});
        }

        protected abstract void processSuccess(GraphResponse var1);
    }

    private static interface RequestWrapper {
        public FacebookRequestError getError();

        public void addToBatch(GraphRequestBatch var1);
    }

    private class GetEngagementRequestWrapper
    extends AbstractRequestWrapper {
        String likeCountStringWithLike;
        String likeCountStringWithoutLike;
        String socialSentenceStringWithLike;
        String socialSentenceStringWithoutLike;

        GetEngagementRequestWrapper(String objectId, LikeView.ObjectType objectType) {
            super(objectId, objectType);
            this.likeCountStringWithLike = LikeActionController.this.likeCountStringWithLike;
            this.likeCountStringWithoutLike = LikeActionController.this.likeCountStringWithoutLike;
            this.socialSentenceStringWithLike = LikeActionController.this.socialSentenceWithLike;
            this.socialSentenceStringWithoutLike = LikeActionController.this.socialSentenceWithoutLike;
            Bundle requestParams = new Bundle();
            requestParams.putString("fields", "engagement.fields(count_string_with_like,count_string_without_like,social_sentence_with_like,social_sentence_without_like)");
            requestParams.putString("locale", Locale.getDefault().toString());
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), objectId, requestParams, HttpMethod.GET));
        }

        @Override
        protected void processSuccess(GraphResponse response) {
            JSONObject engagementResults = Utility.tryGetJSONObjectFromResponse((JSONObject)response.getJSONObject(), (String)"engagement");
            if (engagementResults != null) {
                this.likeCountStringWithLike = engagementResults.optString("count_string_with_like", this.likeCountStringWithLike);
                this.likeCountStringWithoutLike = engagementResults.optString("count_string_without_like", this.likeCountStringWithoutLike);
                this.socialSentenceStringWithLike = engagementResults.optString(LikeActionController.JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, this.socialSentenceStringWithLike);
                this.socialSentenceStringWithoutLike = engagementResults.optString(LikeActionController.JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, this.socialSentenceStringWithoutLike);
            }
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error fetching engagement for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, error});
            LikeActionController.this.logAppEventForError("get_engagement", error);
        }
    }

    private class GetOGObjectLikesRequestWrapper
    extends AbstractRequestWrapper
    implements LikeRequestWrapper {
        private boolean objectIsLiked;
        private String unlikeToken;
        private final String objectId;
        private final LikeView.ObjectType objectType;

        GetOGObjectLikesRequestWrapper(String objectId, LikeView.ObjectType objectType) {
            super(objectId, objectType);
            this.objectIsLiked = LikeActionController.this.isObjectLiked;
            this.objectId = objectId;
            this.objectType = objectType;
            Bundle requestParams = new Bundle();
            requestParams.putString("fields", "id,application");
            requestParams.putString("object", this.objectId);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "me/og.likes", requestParams, HttpMethod.GET));
        }

        @Override
        protected void processSuccess(GraphResponse response) {
            JSONArray dataSet = Utility.tryGetJSONArrayFromResponse((JSONObject)response.getJSONObject(), (String)"data");
            if (dataSet != null) {
                for (int i = 0; i < dataSet.length(); ++i) {
                    JSONObject data = dataSet.optJSONObject(i);
                    if (data == null) continue;
                    this.objectIsLiked = true;
                    JSONObject appData = data.optJSONObject("application");
                    AccessToken accessToken = AccessToken.getCurrentAccessToken();
                    if (appData == null || !AccessToken.isCurrentAccessTokenActive() || !Utility.areObjectsEqual((Object)accessToken.getApplicationId(), (Object)appData.optString("id"))) continue;
                    this.unlikeToken = data.optString("id");
                }
            }
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error fetching like status for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, error});
            LikeActionController.this.logAppEventForError("get_og_object_like", error);
        }

        @Override
        public boolean isObjectLiked() {
            return this.objectIsLiked;
        }

        @Override
        public String getUnlikeToken() {
            return this.unlikeToken;
        }
    }

    private class GetPageLikesRequestWrapper
    extends AbstractRequestWrapper
    implements LikeRequestWrapper {
        private boolean objectIsLiked;
        private String pageId;

        GetPageLikesRequestWrapper(String pageId) {
            super(pageId, LikeView.ObjectType.PAGE);
            this.objectIsLiked = LikeActionController.this.isObjectLiked;
            this.pageId = pageId;
            Bundle requestParams = new Bundle();
            requestParams.putString("fields", "id");
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "me/likes/" + pageId, requestParams, HttpMethod.GET));
        }

        @Override
        protected void processSuccess(GraphResponse response) {
            JSONArray dataSet = Utility.tryGetJSONArrayFromResponse((JSONObject)response.getJSONObject(), (String)"data");
            if (dataSet != null && dataSet.length() > 0) {
                this.objectIsLiked = true;
            }
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error fetching like status for page id '%s': %s", (Object[])new Object[]{this.pageId, error});
            LikeActionController.this.logAppEventForError("get_page_like", error);
        }

        @Override
        public boolean isObjectLiked() {
            return this.objectIsLiked;
        }

        @Override
        public String getUnlikeToken() {
            return null;
        }
    }

    private static interface LikeRequestWrapper
    extends RequestWrapper {
        public boolean isObjectLiked();

        public String getUnlikeToken();
    }

    private class PublishUnlikeRequestWrapper
    extends AbstractRequestWrapper {
        private String unlikeToken;

        PublishUnlikeRequestWrapper(String unlikeToken) {
            super(null, null);
            this.unlikeToken = unlikeToken;
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), unlikeToken, null, HttpMethod.DELETE));
        }

        @Override
        protected void processSuccess(GraphResponse response) {
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error unliking object with unlike token '%s' : %s", (Object[])new Object[]{this.unlikeToken, error});
            LikeActionController.this.logAppEventForError("publish_unlike", error);
        }
    }

    private class PublishLikeRequestWrapper
    extends AbstractRequestWrapper {
        String unlikeToken;

        PublishLikeRequestWrapper(String objectId, LikeView.ObjectType objectType) {
            super(objectId, objectType);
            Bundle likeRequestParams = new Bundle();
            likeRequestParams.putString("object", objectId);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "me/og.likes", likeRequestParams, HttpMethod.POST));
        }

        @Override
        protected void processSuccess(GraphResponse response) {
            this.unlikeToken = Utility.safeGetStringFromResponse((JSONObject)response.getJSONObject(), (String)"id");
        }

        @Override
        protected void processError(FacebookRequestError error) {
            int errorCode = error.getErrorCode();
            if (errorCode == 3501) {
                this.error = null;
            } else {
                Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error liking object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, error});
                LikeActionController.this.logAppEventForError("publish_like", error);
            }
        }
    }

    private class GetPageIdRequestWrapper
    extends AbstractRequestWrapper {
        String verifiedObjectId;
        boolean objectIsPage;

        GetPageIdRequestWrapper(String objectId, LikeView.ObjectType objectType) {
            super(objectId, objectType);
            Bundle pageIdRequestParams = new Bundle();
            pageIdRequestParams.putString("fields", "id");
            pageIdRequestParams.putString("ids", objectId);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "", pageIdRequestParams, HttpMethod.GET));
        }

        @Override
        protected void processSuccess(GraphResponse response) {
            JSONObject results = Utility.tryGetJSONObjectFromResponse((JSONObject)response.getJSONObject(), (String)this.objectId);
            if (results != null) {
                this.verifiedObjectId = results.optString("id");
                this.objectIsPage = !Utility.isNullOrEmpty((String)this.verifiedObjectId);
            }
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error getting the FB id for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, error});
        }
    }

    private class GetOGObjectIdRequestWrapper
    extends AbstractRequestWrapper {
        String verifiedObjectId;

        GetOGObjectIdRequestWrapper(String objectId, LikeView.ObjectType objectType) {
            super(objectId, objectType);
            Bundle objectIdRequestParams = new Bundle();
            objectIdRequestParams.putString("fields", "og_object.fields(id)");
            objectIdRequestParams.putString("ids", objectId);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "", objectIdRequestParams, HttpMethod.GET));
        }

        @Override
        protected void processError(FacebookRequestError error) {
            if (error.getErrorMessage().contains("og_object")) {
                this.error = null;
            } else {
                Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error getting the FB id for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, error});
            }
        }

        @Override
        protected void processSuccess(GraphResponse response) {
            JSONObject ogObject;
            JSONObject results = Utility.tryGetJSONObjectFromResponse((JSONObject)response.getJSONObject(), (String)this.objectId);
            if (results != null && (ogObject = results.optJSONObject("og_object")) != null) {
                this.verifiedObjectId = ogObject.optString("id");
            }
        }
    }

    private static interface RequestCompletionCallback {
        public void onComplete();
    }

    @Deprecated
    public static interface CreationCallback {
        public void onComplete(LikeActionController var1, FacebookException var2);
    }
}

