/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.send.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.ISendPacketListener;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.ui.SendPacketItemViewHolder;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.redpacket.SendGear;

public class SendPacketAdapter
extends RecyclerView.Adapter<SendPacketItemViewHolder> {
    private final List<SendGear> mDataList = new ArrayList<SendGear>();
    private ISendPacketListener mItemClickListener;
    private SendPacketItemViewHolder mLastSelectedHolder;

    public SendPacketAdapter(ISendPacketListener listener) {
        this.mItemClickListener = listener;
    }

    public void setData(List<SendGear> list) {
        if (!FP.empty(list)) {
            this.mDataList.clear();
            this.mDataList.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    @NonNull
    public SendPacketItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new SendPacketItemViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_packet_item, parent, false));
    }

    public void onBindViewHolder(final @NonNull SendPacketItemViewHolder holder, int position) {
        final SendGear gear = this.mDataList.get(position);
        holder.update(gear);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SendPacketAdapter.this.mItemClickListener != null) {
                    SendPacketAdapter.this.mItemClickListener.onSelectedGear(gear);
                }
                SendPacketAdapter.this.selectedItem(holder);
            }
        });
        if (this.mLastSelectedHolder == null) {
            this.mLastSelectedHolder = holder;
            holder.itemView.setSelected(true);
            if (this.mItemClickListener != null) {
                this.mItemClickListener.onSelectedGear(gear);
            }
        }
    }

    private void selectedItem(@NonNull SendPacketItemViewHolder holder) {
        if (this.mLastSelectedHolder == null) {
            this.mLastSelectedHolder = holder;
            holder.itemView.setSelected(true);
        } else if (this.mLastSelectedHolder != holder) {
            this.mLastSelectedHolder.itemView.setSelected(false);
            holder.itemView.setSelected(true);
            this.mLastSelectedHolder = holder;
        }
    }

    public int getItemCount() {
        return this.mDataList.size();
    }
}

