/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.DR;

public class RedPacketFloatingBannerView
extends YYFrameLayout {
    static final int COUNTDOWN_STRAR_MILLISECOND = 10;
    static final int COUNTDOWN_STRAR_GAP = 1000;
    int mCurrentSec = 0;
    YYTextView timerTv;
    private int[] yellowCountDown = new int[]{R.drawable.red_packet_yellow_0, R.drawable.red_packet_yellow_1, R.drawable.red_packet_yellow_2, R.drawable.red_packet_yellow_3, R.drawable.red_packet_yellow_4, R.drawable.red_packet_yellow_5, R.drawable.red_packet_yellow_6, R.drawable.red_packet_yellow_7, R.drawable.red_packet_yellow_8, R.drawable.red_packet_yellow_9};
    CountDownRunnable mCountDownTimer;
    public static final int SHOW_ANI_DURATION = 800;
    public static final int HIDE_ANI_DURATION = 500;
    IFloatingBannerViewCallback iFloatingBannerViewCallback;
    protected AnimatorSet mShowAnim = this.createShowAnimation();
    protected AnimatorSet mHideAnim = this.createHideAnimation();

    public RedPacketFloatingBannerView(Context context) {
        super(context);
        this.initView();
    }

    public RedPacketFloatingBannerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_floating_banner, (ViewGroup)this, true);
        this.timerTv = (YYTextView)this.findViewById(R.id.tv_timer);
        View redPacketBg = this.findViewById(R.id.red_packet_bg);
        DyResLoader.INSTANCE.loadNineImg(this.getContext(), redPacketBg, DR.redpacket_floating_banner_bg9);
    }

    public void showView() {
        this.mShowAnim.start();
    }

    private void hideView() {
        this.mHideAnim.start();
    }

    private SpannableStringBuilder getTimerSpannable(int num) {
        SpannableStringBuilder spannableString = new SpannableStringBuilder();
        spannableString.append((CharSequence)String.valueOf(num));
        for (int numStartPosition = 0; numStartPosition < spannableString.length(); ++numStartPosition) {
            String c = String.valueOf(spannableString.charAt(numStartPosition));
            Integer number = Integer.valueOf(c);
            spannableString.setSpan((Object)this.getImageSpan(number, this.yellowCountDown), numStartPosition, numStartPosition + 1, 34);
        }
        return spannableString;
    }

    private ImageSpan getImageSpan(int num, int[] drawableIds) {
        if (drawableIds != null && num >= drawableIds.length) {
            return null;
        }
        Drawable drawable2 = this.getContext().getResources().getDrawable(drawableIds[num]);
        double height = ResolutionUtils.dip2Px((float)22.0f);
        int width = (int)((double)drawable2.getIntrinsicWidth() * 1.0 / (double)drawable2.getIntrinsicHeight() * height);
        drawable2.setBounds(0, 0, width, (int)height);
        ImageSpan imageSpan = new ImageSpan(drawable2);
        return imageSpan;
    }

    public void setCountDownNum(int num) {
        this.mCurrentSec = num;
    }

    public void startCountDown() {
        if (this.mCurrentSec == 0) {
            this.mCurrentSec = 10;
        }
        this.timerTv.setVisibility(0);
        this.timerTv.setText((CharSequence)this.getTimerSpannable(this.mCurrentSec));
        if (this.mCountDownTimer != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCountDownTimer);
        }
        this.mCountDownTimer = new CountDownRunnable();
        this.countDown(this.mCountDownTimer);
    }

    public void countDown(CountDownRunnable countDownRunnable) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)countDownRunnable);
        YYTaskExecutor.postToMainThread((Runnable)countDownRunnable, (long)1000L);
    }

    public AnimatorSet createShowAnimation() {
        AnimatorSet animSet = new AnimatorSet();
        ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator tranAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{-((float)ResolutionUtils.dip2Px((float)90.0f)), 0.0f});
        animSet.play((Animator)alphaAnim).with((Animator)tranAni);
        animSet.setDuration(800L);
        animSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (RedPacketFloatingBannerView.this.iFloatingBannerViewCallback != null) {
                    RedPacketFloatingBannerView.this.iFloatingBannerViewCallback.onBannerViewShow();
                }
                RedPacketFloatingBannerView.this.startCountDown();
            }
        });
        return animSet;
    }

    public AnimatorSet createHideAnimation() {
        AnimatorSet aniSet = new AnimatorSet();
        ObjectAnimator alphaAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator transY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f, -((float)ResolutionUtils.dip2Px((float)90.0f))});
        aniSet.play((Animator)alphaAni).with((Animator)transY);
        aniSet.setDuration(500L);
        aniSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (RedPacketFloatingBannerView.this.iFloatingBannerViewCallback != null) {
                    RedPacketFloatingBannerView.this.iFloatingBannerViewCallback.onBannerViewHide();
                }
            }
        });
        return aniSet;
    }

    public void setFloatingBannerViewCallback(IFloatingBannerViewCallback iFloatingBannerViewCallback) {
        this.iFloatingBannerViewCallback = iFloatingBannerViewCallback;
    }

    public static interface IFloatingBannerViewCallback {
        public void onCountDownFinish();

        public void onBannerViewShow();

        public void onBannerViewHide();
    }

    class CountDownRunnable
    implements Runnable {
        CountDownRunnable() {
        }

        @Override
        public void run() {
            --RedPacketFloatingBannerView.this.mCurrentSec;
            if (RedPacketFloatingBannerView.this.mCurrentSec >= 0) {
                RedPacketFloatingBannerView.this.timerTv.setText((CharSequence)RedPacketFloatingBannerView.this.getTimerSpannable(RedPacketFloatingBannerView.this.mCurrentSec));
                if (RedPacketFloatingBannerView.this.mCurrentSec > 0) {
                    RedPacketFloatingBannerView.this.countDown(this);
                } else {
                    RedPacketFloatingBannerView.this.timerTv.setVisibility(8);
                    RedPacketFloatingBannerView.this.hideView();
                    if (RedPacketFloatingBannerView.this.iFloatingBannerViewCallback != null) {
                        RedPacketFloatingBannerView.this.iFloatingBannerViewCallback.onCountDownFinish();
                    }
                }
            }
        }
    }
}

