/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.flow;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.redpacket.PacketUtils;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.PacketResult;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.IFlowPacketCallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.IRedPacketContainerCallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.BaseFloatingItem;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.RedPacketFlatingContiner;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.RedPacketFloatingView;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.ihago.money.api.redpacket.PacketInfo;
import net.ihago.money.api.redpacket.UserJoinNotify;

public class FlowPacketPresenter
implements IPacketPresenter,
IRedPacketContainerCallback {
    private static final String TAG = "FTRedPacketFlowPacketPresenter";
    private ViewGroup mParent;
    private IFlowPacketCallback mCallback;
    private RedPacketFlatingContiner mContiner;
    private String roomId;
    private final Queue<PacketInfo> mPendingBroQueue = new ConcurrentLinkedQueue<PacketInfo>();

    @Override
    public void onCreate(RedPacketParam createParam) {
        this.roomId = createParam.getRoomId();
    }

    @Override
    public void onStart(ViewGroup parent) {
        this.mParent = parent;
        this.showNext();
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onDestroy() {
        if (this.mContiner != null && this.mContiner.getVisibility() == 0) {
            ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).stopHighPerfScene("red_packet");
        }
        if (this.mParent != null) {
            this.mParent.removeView((View)this.mContiner);
        }
    }

    public void onGrabSuccess(PacketResult result) {
        if (this.mContiner != null) {
            this.mContiner.hideView();
        }
        if (this.mCallback != null) {
            if (result.isGrabPacket()) {
                this.mCallback.onFloatFinished(result.getPacketInfo(), 1);
            } else {
                this.mCallback.onFloatFinished(result.getPacketInfo(), 2);
            }
        }
    }

    public void onGrabFailed(RedPacketFloatingView view, int errCode, String msg) {
        if (this.mContiner != null) {
            this.mContiner.onGrabFailed(view);
        }
    }

    public void setCallback(IFlowPacketCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public void onReceiveBro(Object notify) {
        if (notify instanceof UserJoinNotify) {
            UserJoinNotify userJoinNotify = (UserJoinNotify)notify;
            MLog.info((Object)TAG, (String)"onReceiveBro userJoinNotify packetId: %s", (Object[])new Object[]{userJoinNotify.rec_packet.id});
            this.addQueue(userJoinNotify.rec_packet);
            this.showNext();
        }
    }

    private void addQueue(PacketInfo info) {
        for (PacketInfo packet : this.mPendingBroQueue) {
            if (!packet.id.equals(info.id)) continue;
            MLog.info((Object)TAG, (String)"addQueue duplication packet in queue, packetId: %s", (Object[])new Object[]{info.id});
            return;
        }
        this.mPendingBroQueue.add(info);
    }

    private void showNext() {
        MLog.info((Object)TAG, (String)"showNext mPendingBroQueue.size: %d", (Object[])new Object[]{this.mPendingBroQueue.size()});
        if (!this.mPendingBroQueue.isEmpty() && this.mParent != null) {
            this.showRedPocketRainReal(this.mPendingBroQueue.poll());
        }
    }

    public void showRedPocketRain(PacketInfo info) {
        this.addQueue(info);
        this.showNext();
    }

    private void showRedPocketRainReal(PacketInfo info) {
        boolean hadRemain = PacketUtils.hadRemainPacket(info);
        MLog.info((Object)TAG, (String)"showRedPocketRain hadRemain: %b, packetId: %s", (Object[])new Object[]{hadRemain, info == null ? "" : info.id});
        if (info != null && this.mParent != null && hadRemain) {
            if (this.mContiner == null) {
                this.mContiner = new RedPacketFlatingContiner(this.mParent.getContext(), this, this.roomId);
            }
            if (this.mContiner.getParent() == null) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                this.mParent.addView((View)this.mContiner, (ViewGroup.LayoutParams)layoutParams);
            }
            this.mContiner.setVisibility(0);
            this.mContiner.startCountDown(info.rain_second);
            this.mContiner.setPacketInfo(info);
            ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).startHighPerfScene("red_packet");
        } else {
            this.showNext();
        }
    }

    @Override
    public void onFloatFinished(PacketInfo packetInfo) {
        this.showNext();
        ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).stopHighPerfScene("red_packet");
        if (this.mCallback != null) {
            this.mCallback.onFloatFinished(packetInfo, 3);
        }
    }

    @Override
    public void onItemClick(RedPacketFloatingView view, BaseFloatingItem floatingItem) {
        if (this.mCallback != null) {
            this.mCallback.onItemClick(view, floatingItem);
        }
    }
}

