/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.entrance;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketEntrance;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketEntranceReqParam;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import net.ihago.money.api.redpacket.Code;
import net.ihago.money.api.redpacket.GetEntranceConfigReq;
import net.ihago.money.api.redpacket.GetEntranceConfigRes;

public class EntrancePresenter
implements IPacketPresenter {
    private static final String TAG = "FTRedPacketEntrancePresenter";
    private RedPacketParam mPacketParam;
    private RedPacketEntrance mEntrance;
    private int mRetryCount = 0;

    @Override
    public void onCreate(RedPacketParam createParam) {
        this.mPacketParam = createParam;
    }

    public void reqRedPacketEntrance(RedPacketEntranceReqParam param, @Nullable ICommonCallback<RedPacketEntrance> callback) {
        MLog.info((Object)TAG, (String)"reqRedPacketEntrance param: %s", (Object[])new Object[]{param});
        if (param == null) {
            return;
        }
        this.request(param, callback);
    }

    @Nullable
    public RedPacketEntrance getRedPacketEntrance(RedPacketEntranceReqParam param) {
        if (this.mEntrance == null) {
            this.request(param, null);
        }
        return this.mEntrance;
    }

    private void request(final @NonNull RedPacketEntranceReqParam param, final @Nullable ICommonCallback<RedPacketEntrance> callback) {
        if (this.mPacketParam == null) {
            return;
        }
        GetEntranceConfigReq req = new GetEntranceConfigReq.Builder().room_tag(param.getRoomTag()).gameid(param.getGameId()).build();
        ProtoManager.getInstance().sendRpc(this.mPacketParam.getRoomId(), (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetEntranceConfigRes>(){

            public void onResponse(@NonNull GetEntranceConfigRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)EntrancePresenter.TAG, (String)"onResponse code: %d, msg: %s", (Object[])new Object[]{code, msg});
                if (code == (long)Code.CodeOk.getValue()) {
                    EntrancePresenter.this.mEntrance = new RedPacketEntrance(message.has.booleanValue(), message.getModeValue(), message.pos.intValue(), message.icon_url);
                    if (callback != null) {
                        callback.onSuccess((Object)EntrancePresenter.this.mEntrance, new Object[0]);
                    }
                } else if (callback != null) {
                    callback.onFail((int)code, msg, new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)EntrancePresenter.TAG, (String)"retryWhenTimeout canRetry: %b", (Object[])new Object[]{canRetry});
                if (callback != null) {
                    callback.onFail(-1, "request time out without response", new Object[0]);
                }
                EntrancePresenter.this.checkoutRetry(param);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)EntrancePresenter.TAG, (String)"retryWhenError canRetry: %b, reason: %s", (Object[])new Object[]{canRetry, code, reason});
                if (callback != null) {
                    callback.onFail(code, reason, new Object[0]);
                }
                EntrancePresenter.this.checkoutRetry(param);
                return false;
            }
        });
    }

    private void checkoutRetry(final @NonNull RedPacketEntranceReqParam param) {
        if (this.mEntrance == null && this.mRetryCount < 5) {
            ++this.mRetryCount;
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    EntrancePresenter.this.request(param, (ICommonCallback<RedPacketEntrance>)null);
                }
            }, (long)(1000 * this.mRetryCount));
        }
    }
}

