/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.chat;

import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import com.yy.appbase.common.Callback;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.PacketChatMsg;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.redpacket.PacketUtils;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import net.ihago.money.api.redpacket.PacketInfo;
import net.ihago.money.api.redpacket.RoomMsgNotify;
import net.ihago.money.api.redpacket.UserGrabNotify;
import net.ihago.money.api.redpacket.UserJoinNotify;

public class PacketMsgPresenter
implements IPacketPresenter {
    private static final String TAG = "FTRedPacketMsgPresenter";
    private RedPacketParam mPacketParam;
    private PacketChatMsg.OnClickListener mClickListener;

    @Override
    public void onCreate(RedPacketParam createParam) {
        this.mPacketParam = createParam;
    }

    @Override
    public void onReceiveBro(Object notify) {
        if (notify instanceof RoomMsgNotify) {
            this.remainPacketChatMsg(((RoomMsgNotify)notify).packet_info);
        } else if (notify instanceof UserJoinNotify) {
            UserJoinNotify userJoinNotify = (UserJoinNotify)notify;
            for (PacketInfo jn : userJoinNotify.packets) {
                MLog.info((Object)TAG, (String)"onReceiveBro join list packetId: %s", (Object[])new Object[]{jn.id});
                if (PacketUtils.hadRemainPacket(jn)) {
                    this.remainPacketChatMsg(jn);
                    continue;
                }
                this.packetRainFinish(jn);
            }
            MLog.info((Object)TAG, (String)"onReceiveBro join RecPacket packetId: %s", (Object[])new Object[]{userJoinNotify.rec_packet.id});
            if (PacketUtils.hadRemainPacket(userJoinNotify.rec_packet)) {
                this.remainPacketChatMsg(userJoinNotify.rec_packet);
            } else {
                this.packetRainFinish(userJoinNotify.rec_packet);
            }
        } else if (notify instanceof UserGrabNotify) {
            UserGrabNotify userGrabNotify = (UserGrabNotify)notify;
            this.grabMyPacket(userGrabNotify);
        }
    }

    public void setClickListener(PacketChatMsg.OnClickListener mClickListener) {
        this.mClickListener = mClickListener;
    }

    public void remainPacketChatMsg(PacketInfo info) {
        if (info == null || this.mPacketParam == null) {
            MLog.error((Object)TAG, (String)"remainPacketChatMsg PacketInfo is null", (Object[])new Object[0]);
            return;
        }
        if (this.mClickListener != null && this.mClickListener.hadGrab(info.id)) {
            MLog.info((Object)TAG, (String)"remainPacketChatMsg had grab packet, packetId: %s", (Object[])new Object[]{info.id});
            return;
        }
        MLog.info((Object)TAG, (String)"remainPacketChatMsg packetId: %s", (Object[])new Object[]{info.id});
        PacketChatMsg.Builder builder = this.getChatMsg(info, 3);
        builder.message((CharSequence)new SpannableStringBuilder((CharSequence)ResourceUtils.getString((int)R.string.short_summary_sending_packet, (Object[])new Object[]{this.getNickname(info)})));
        this.mPacketParam.getBehavior().addPacketChatMsg(builder.build());
        GiftHiidoReport.packetSendingMsg(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
    }

    public void gotPacketMsg(PacketInfo info) {
        if (info == null) {
            MLog.error((Object)TAG, (String)"gotPacketMsg PacketInfo is null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"gotPacketMsg packetId: %s", (Object[])new Object[]{info.id});
        PacketChatMsg.Builder builder = this.getChatMsg(info, 2);
        this.genSpan(builder, R.string.short_summary_packet_got, this.getNickname(info));
        GiftHiidoReport.packetGetSuccessMsg(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
    }

    public void packetRainFinish(PacketInfo info) {
        if (info == null) {
            MLog.error((Object)TAG, (String)"packetRainFinish PacketInfo is null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"packetRainFinish packetId: %s", (Object[])new Object[]{info.id});
        PacketChatMsg.Builder builder = this.getChatMsg(info, 1);
        this.genSpan(builder, R.string.short_summary_packet_rain_finish, this.getNickname(info));
        GiftHiidoReport.packetFinishMsg(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
    }

    public void grabMyPacket(UserGrabNotify userGrabNotify) {
        MLog.info((Object)TAG, (String)"grabMyPacket packetId: %s", (Object[])new Object[]{userGrabNotify.packet_id});
        final PacketChatMsg.Builder msg = PacketChatMsg.newBuilder().iconUrl(userGrabNotify.winner_avatar).defaultIconRes(R.drawable.icon_packet_chat).packetId(userGrabNotify.packet_id).type(4).uid(userGrabNotify.winner_uid.longValue()).listener(this.mClickListener);
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.summary_grab_my_packet, (Object[])new Object[]{userGrabNotify.winner_nick, userGrabNotify.sender_nick})).onFinish((Callback)new Callback<Spannable>(){

            public void onResponse(Spannable data) {
                PacketMsgPresenter.this.addChatMsg(data, msg);
            }
        }).build();
        GiftHiidoReport.packetGetMsg(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
    }

    private void genSpan(final PacketChatMsg.Builder builder, int res, String nick) {
        String detail = StringUtils.format((String)"%s  >", (Object[])new Object[]{ResourceUtils.getString((int)R.string.btn_packet_chat_detail)});
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)res, (Object[])new Object[]{nick})).space().space().beginBlock().append((CharSequence)detail, new Object[]{TextSpan.of().size(13).color(Color.parseColor((String)"#FFFED77A")).build()}).endBlock().onFinish((Callback)new Callback<Spannable>(){

            public void onResponse(Spannable data) {
                PacketMsgPresenter.this.addChatMsg(data, builder);
            }
        }).build();
    }

    private void addChatMsg(Spannable data, PacketChatMsg.Builder builder) {
        builder.message((CharSequence)data);
        if (this.mPacketParam != null) {
            this.mPacketParam.getBehavior().addPacketChatMsg(builder.build());
        }
    }

    private PacketChatMsg.Builder getChatMsg(PacketInfo info, int type) {
        String icon = info.sender_avatar;
        long uid = type == 2 ? 0L : info.sender;
        PacketChatMsg.Builder msg = PacketChatMsg.newBuilder().iconUrl(icon).defaultIconRes(R.drawable.icon_packet_chat).packetId(info.id).type(type).uid(uid).listener(this.mClickListener);
        return msg;
    }

    private String getNickname(PacketInfo info) {
        return info.sender_nick;
    }
}

