/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.recharge.internal.nonsdk;

import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.base.pay.PayPlatform;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.internal.Callback;
import com.yy.hiyo.wallet.base.revenue.internal.IRechargeStorage;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.monitor.PayMonitor;
import com.yy.hiyo.wallet.pay.proto.bean.RechargeListResponse;
import com.yy.hiyo.wallet.pay.request.PayRequestUtils;
import com.yy.hiyo.wallet.recharge.internal.nonsdk.RemoteProductList;
import com.yy.hiyo.wallet.recharge.internal.nonsdk.RemoteProductListKt;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J0\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010\u0018\u00010\u000fH\u0003J\u0012\u0010\u0012\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J>\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00172\u0016\u0010\u000e\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010\u0018\u00010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yy/hiyo/wallet/recharge/internal/nonsdk/RemoteProductList;", "", "storage", "Lcom/yy/hiyo/wallet/recharge/internal/nonsdk/RemoteProductList$Storage;", "(Lcom/yy/hiyo/wallet/recharge/internal/nonsdk/RemoteProductList$Storage;)V", "filterPayChannel", "", "res", "Lcom/yy/hiyo/wallet/pay/proto/bean/RechargeListResponse;", "handleRechargeListRes", "response", "Lcom/yy/hiyo/wallet/base/revenue/proto/RevenueProtoRes;", "seq", "", "callback", "Lcom/yy/hiyo/wallet/base/pay/callback/IPayCallback;", "", "Lcom/yy/hiyo/wallet/base/pay/bean/ProductItemInfo;", "parseExpand", "requestRechargeListAsync", "from", "", "expand", "", "writeCache", "BuiltinStorage", "Storage", "wallet_billDebug"})
public final class RemoteProductList {
    private final Storage storage;

    /*
     * WARNING - void declaration
     */
    public final void requestRechargeListAsync(int from, @Nullable Map<String, ? extends Object> expand, @Nullable IPayCallback<List<ProductItemInfo>> callback) {
        RevenueProtoReq req;
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(1021);
        builder.countryCode(AccountUtil.realCountry());
        String seq = RevenueProto.uniqueSeq();
        JsonStringBuilder param = RevenueProto.getCommonParam();
        param.put("seq", (Object)seq);
        param.put("cmd", (Object)1021);
        param.put("usedChannel", (Object)PayUtils.getPayUseChannel());
        if (expand != null && !expand.isEmpty()) {
            JsonStringBuilder expandJson = JsonStringBuilder.newBuilder();
            Object object = expand;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, ? extends Object> entry;
                Map.Entry<String, ? extends Object> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Object value = entry2.getValue();
                expandJson.put((String)key, value);
            }
            param.put("expand", (Object)expandJson.buildJson());
        } else {
            param.put("expand", (Object)"");
        }
        builder.jsonMsg(param.jsonObject());
        RevenueProtoReq revenueProtoReq = req = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)revenueProtoReq, (String)"req");
        String url = RevenueProto.getUrl((String)"query", (int)revenueProtoReq.getCmd());
        MLog.info((Object)"FTPay.Default.RemoteProductList", (String)"requestRechargeListAsync url: %s", (Object[])new Object[]{url});
        PayMonitor.monitorRequest(from, seq, 1021, new String[0]);
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(this, callback, seq){
            final /* synthetic */ RemoteProductList this$0;
            final /* synthetic */ IPayCallback $callback;
            final /* synthetic */ String $seq;

            public void onError(@NotNull Call call, @NotNull Exception e, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                MLog.error((Object)"FTPay.Default.RemoteProductList", (String)"requestRechargeListAsync", (Throwable)e, (Object[])new Object[0]);
                String msg = e.getMessage();
                PayUtils.callbackFailed(this.$callback, 30002, msg);
                int code = NetworkUtils.getErrorCodeByExc((Throwable)e);
                PayMonitor.reportRequestMetri(this.$seq, String.valueOf(code));
                PayMonitor.monitorRequestFailed(this.$seq, code, msg);
            }

            public void onResponse(@NotNull RevenueProtoRes response, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                MLog.info((Object)"FTPay.Default.RemoteProductList", (String)"requestRechargeListAsync onResponse: %s", (Object[])new Object[]{response});
                PayMonitor.reportRequestMetri(this.$seq, "0");
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(this, response){
                        final /* synthetic */ requestRechargeListAsync.1 this$0;
                        final /* synthetic */ RevenueProtoRes $response;

                        public final void run() {
                            RemoteProductList remoteProductList = this.this$0.this$0;
                            String string2 = this.this$0.$seq;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"seq");
                            RemoteProductList.access$handleRechargeListRes(remoteProductList, this.$response, string2, this.this$0.$callback);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$response = revenueProtoRes;
                        }
                    });
                } else {
                    String string2 = this.$seq;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"seq");
                    RemoteProductList.access$handleRechargeListRes(this.this$0, response, string2, this.$callback);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                this.$seq = $captured_local_variable$2;
            }
        });
    }

    @WorkerThread
    private final void handleRechargeListRes(RevenueProtoRes response, String seq, IPayCallback<List<ProductItemInfo>> callback) {
        RechargeListResponse res = PayRequestUtils.parseResponse(response, RechargeListResponse.class);
        this.parseExpand(res);
        if (res == null) {
            PayUtils.callbackFailed(callback, 30001, "maybe parse response json error");
            PayMonitor.monitorRequestFailed(seq, 30001, "maybe parse response json error");
            return;
        }
        this.filterPayChannel(res);
        this.writeCache(response);
        PayUtils.callbackSucceed(callback, res.confList);
        PayMonitor.monitorResponse(res.seq, response.result, res.result, new String[0]);
    }

    private final void parseExpand(RechargeListResponse res) {
        if (res != null && res.confList != null) {
            for (ProductItemInfo itemInfo : res.confList) {
                itemInfo.parseProductItemExpand();
            }
        }
    }

    private final void filterPayChannel(RechargeListResponse res) {
        if (res == null || res.confList == null) {
            return;
        }
        PayPlatform payPlatform = PayUtils.getPayPlatform();
        String payChannel = payPlatform.getChannel();
        Iterator<ProductItemInfo> iterator = res.confList.iterator();
        while (iterator.hasNext()) {
            ProductItemInfo itemInfo = iterator.next();
            if (TextUtils.isEmpty((CharSequence)itemInfo.payChannel) || StringUtils.equalsIgnoreCase((String)payChannel, (String)itemInfo.payChannel)) continue;
            iterator.remove();
        }
    }

    private final void writeCache(RevenueProtoRes response) {
        String string2 = response.jsonMsg;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"response.jsonMsg");
        this.storage.write(string2);
    }

    public RemoteProductList(@NotNull Storage storage2) {
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        this.storage = storage2;
    }

    public static final /* synthetic */ void access$handleRechargeListRes(RemoteProductList $this, RevenueProtoRes response, String seq, IPayCallback callback) {
        $this.handleRechargeListRes(response, seq, (IPayCallback<List<ProductItemInfo>>)callback);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/yy/hiyo/wallet/recharge/internal/nonsdk/RemoteProductList$Storage;", "Lcom/yy/hiyo/wallet/base/revenue/internal/IRechargeStorage;", "()V", "isDefault", "", "()Z", "setDefault", "(Z)V", "response", "", "Lcom/yy/hiyo/wallet/base/pay/bean/ProductItemInfo;", "getResponse", "()Ljava/util/List;", "setResponse", "(Ljava/util/List;)V", "clear", "", "read", "callback", "Lcom/yy/hiyo/wallet/base/revenue/internal/Callback;", "readAsync", "write", "json", "", "writeAsync", "Companion", "wallet_billDebug"})
    public static final class Storage
    implements IRechargeStorage {
        @Nullable
        private List<ProductItemInfo> response;
        private boolean isDefault;
        public static final Companion Companion = new Companion(null);

        @Nullable
        public List<ProductItemInfo> getResponse() {
            return this.response;
        }

        public void setResponse(@Nullable List<ProductItemInfo> list) {
            this.response = list;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        public final void setDefault(boolean bl) {
            this.isDefault = bl;
        }

        public synchronized void read(@Nullable Callback callback) {
            if (this.getResponse() != null) {
                Callback callback2 = callback;
                if (callback2 != null) {
                    callback2.onFinished(this.getResponse(), this.isDefault);
                }
                return;
            }
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute((Runnable)new Runnable(this, callback){
                    final /* synthetic */ Storage this$0;
                    final /* synthetic */ Callback $callback;

                    public final void run() {
                        Storage.access$readAsync(this.this$0, this.$callback);
                    }
                    {
                        this.this$0 = storage2;
                        this.$callback = callback;
                    }
                });
            } else {
                this.readAsync(callback);
            }
        }

        public void clear() {
            this.setResponse(null);
        }

        public final synchronized void write(@NotNull String json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute((Runnable)new Runnable(this, json){
                    final /* synthetic */ Storage this$0;
                    final /* synthetic */ String $json;

                    public final void run() {
                        Storage.access$writeAsync(this.this$0, this.$json);
                    }
                    {
                        this.this$0 = storage2;
                        this.$json = string2;
                    }
                });
            } else {
                this.writeAsync(json);
            }
        }

        private final synchronized void readAsync(Callback callback) {
            block6: {
                RechargeListResponse res;
                String path = Storage.Companion.getNewPath();
                String content = null;
                if (!YYFileUtils.isFileExisted((String)path) && !YYFileUtils.isFileExisted((String)(path = Storage.Companion.getOldPath()))) {
                    MLog.info((Object)"FTPay.Default.RemoteProductList", (String)"readAsync file not exist path: %s", (Object[])new Object[]{path});
                    String string2 = AccountUtil.registerCountry();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"AccountUtil.registerCountry()");
                    content = BuiltinStorage.INSTANCE.readDefault(string2);
                    this.isDefault = true;
                }
                if (!this.isDefault) {
                    content = YYFileUtils.readJsonData((String)path);
                }
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"FTPay.Default.RemoteProductList", (String)"readAsync recharge isDefault: %b content: %s", (Object[])new Object[]{this.isDefault, content});
                }
                if (FP.empty((CharSequence)content)) {
                    Callback callback2 = callback;
                    if (callback2 != null) {
                        callback2.onFinished(null, false);
                    }
                    return;
                }
                RechargeListResponse rechargeListResponse = res = PayRequestUtils.parseJsonMsg(content, RechargeListResponse.class);
                if ((rechargeListResponse != null ? rechargeListResponse.confList : null) != null) {
                    RemoteProductListKt.access$filterPayChannel(res.confList);
                }
                RechargeListResponse rechargeListResponse2 = res;
                this.setResponse(rechargeListResponse2 != null ? rechargeListResponse2.confList : null);
                Callback callback3 = callback;
                if (callback3 == null) break block6;
                callback3.onFinished(this.getResponse(), this.isDefault);
            }
        }

        private final synchronized void writeAsync(String json) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"FTPay.Default.RemoteProductList", (String)"writeAsync recharge json: %s", (Object[])new Object[]{json});
            }
            YYFileUtils.saveJsonData((String)json, (String)Storage.Companion.getNewPath());
        }

        public static final /* synthetic */ void access$readAsync(Storage $this, Callback callback) {
            $this.readAsync(callback);
        }

        public static final /* synthetic */ void access$writeAsync(Storage $this, String json) {
            $this.writeAsync(json);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/yy/hiyo/wallet/recharge/internal/nonsdk/RemoteProductList$Storage$Companion;", "", "()V", "newPath", "", "getNewPath", "()Ljava/lang/String;", "oldPath", "getOldPath", "wallet_billDebug"})
        public static final class Companion {
            private final String getOldPath() {
                String name = "ascc545ccadsasdcsacz12dw";
                if (RuntimeContext.sIsDebuggable) {
                    name = "recharge_list.txt";
                }
                StringBuilder stringBuilder = new StringBuilder();
                FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
                return stringBuilder.append(fileStorageUtils.getExternalCacheRootDir()).append(File.separator).append(name).toString();
            }

            private final String getNewPath() {
                File dir = FileStorageUtils.getInstance().getDirAndCreate(true, "wallet");
                if (dir == null) {
                    FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
                    dir = new File(fileStorageUtils.getInternalCacheRootDir());
                }
                String name = "ascc545ccadsasdcsacz12dw";
                if (RuntimeContext.sIsDebuggable) {
                    name = "recharge_list.txt";
                }
                return dir.getAbsolutePath() + File.separator + AccountUtil.getUid() + File.separator + name;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/yy/hiyo/wallet/recharge/internal/nonsdk/RemoteProductList$BuiltinStorage;", "", "()V", "readDefault", "", "countryCode", "wallet_billDebug"})
    private static final class BuiltinStorage {
        public static final BuiltinStorage INSTANCE;

        @Nullable
        public final String readDefault(@NotNull String countryCode) {
            String countryCode2;
            Intrinsics.checkParameterIsNotNull((Object)countryCode, (String)"countryCode");
            String string2 = countryCode2 = countryCode;
            boolean bl = false;
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            countryCode2 = string3;
            String file = "recharge" + File.separator + "recharge_list-" + countryCode2 + ".txt";
            byte[] content = YYFileUtils.readFromAssets((String)file);
            if (content == null || content.length <= 0) {
                file = "recharge" + File.separator + "recharge_list-us.txt";
                content = YYFileUtils.readFromAssets((String)file);
            }
            return content == null ? null : StringUtils.byteToStringUtf8((byte[])content);
        }

        private BuiltinStorage() {
        }

        static {
            BuiltinStorage builtinStorage;
            INSTANCE = builtinStorage = new BuiltinStorage();
        }
    }
}

