/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.prop.proto;

import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftExpand;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.gift.data.bean.ReceiverUserInfo;
import com.yy.hiyo.wallet.gift.data.param.SendGiftArgv;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.prop.monitor.BuyPropRequestMonitor;
import com.yy.hiyo.wallet.prop.proto.param.BuyPropParam;
import com.yy.mobile.framework.revenuesdk.gift.protocol.UseItemResponse;
import okhttp3.Call;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BuyPropRequest {
    private static final String TAG = "FTGiftBuyPropRequest";
    private final BuyPropRequestMonitor mMonitor = new BuyPropRequestMonitor();

    public void buyProp(final BuyPropParam param, final IGiftCallback<SendGiftRes> callback) {
        if (param == null || param.getGift() == null) {
            GiftUtils.callbackFailed(callback, (int)10001, (String)"param is null");
            return;
        }
        if (GuestLoginUtils.checkAndShowGuide((int)8)) {
            GiftUtils.callbackFailed(callback, (int)10012, (String)"guest can not buy prop");
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    BuyPropRequest.this.sendGiftAsync(param, (IGiftCallback<SendGiftRes>)callback);
                }
            });
        } else {
            this.sendGiftAsync(param, callback);
        }
    }

    private int getCmd(SendGiftArgv gift) {
        if (this.isUseMultiple(gift)) {
            return 1042;
        }
        return 1009;
    }

    private boolean isUseMultiple(SendGiftArgv gift) {
        return gift.getReceiverUserInfos() != null && gift.getReceiverUserInfos().size() > 1;
    }

    private void sendGiftAsync(final BuyPropParam param, final IGiftCallback<SendGiftRes> callback) {
        SendGiftArgv gift = param.getGift();
        RechargeParam recharge2 = param.getRecharge();
        JsonStringBuilder json = RevenueProto.getCommonParam();
        JsonStringBuilder expand = JsonStringBuilder.newBuilder();
        int cmd = recharge2 != null ? this.getCmd(gift) : (gift.isAutoBuy() ? this.getCmd(gift) : 1007);
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(cmd);
        builder.countryCode(AccountUtil.realCountry());
        final String seq = RevenueProto.uniqueSeq();
        json.put("seq", (Object)seq);
        json.put("cmd", (Object)cmd);
        json.put("usedChannel", (Object)param.getUsedChannel());
        json.put("propsId", (Object)gift.getPropsId());
        json.put("count", (Object)gift.getCount());
        if (this.isUseMultiple(gift)) {
            JSONArray jsonArray = new JSONArray();
            for (ReceiverUserInfo info : gift.getReceiverUserInfos()) {
                JsonStringBuilder userInfo = JsonStringBuilder.newBuilder();
                userInfo.put("uid", (Object)info.getUid());
                userInfo.put("yyno", (Object)info.getYyno());
                userInfo.put("nickName", (Object)info.getNickName());
                userInfo.put("userType", (Object)info.getUserType());
                jsonArray.put((Object)userInfo.jsonObject());
            }
            JsonStringBuilder senderUserInfo = JsonStringBuilder.newBuilder();
            senderUserInfo.put("uid", (Object)AccountUtil.getUid());
            senderUserInfo.put("yyno", (Object)0);
            senderUserInfo.put("nickName", (Object)this.getMyNickname());
            json.put("senderUserInfo", (Object)senderUserInfo.jsonObject());
            json.put("recverUserInfos", (Object)jsonArray);
            expand.put("playType", (Object)"1");
        } else {
            json.put("uid", (Object)AccountUtil.getUid());
            json.put("senderuid", (Object)AccountUtil.getUid());
            json.put("sendernickname", (Object)this.getMyNickname());
            json.put("anchorUid", (Object)gift.getAnchorUid());
            json.put("bid", (Object)gift.getRoomId());
            if (gift.getReceiverUserInfos() != null && !gift.getReceiverUserInfos().isEmpty()) {
                ReceiverUserInfo receiverUserInfo = gift.getReceiverUserInfos().get(0);
                json.put("recveruid", (Object)receiverUserInfo.getUid());
                json.put("recvernickname", (Object)receiverUserInfo.getNickName());
                json.put("userType", (Object)receiverUserInfo.getUserType());
            } else {
                json.put("recveruid", (Object)0);
                json.put("recvernickname", (Object)"");
            }
        }
        if (!gift.isUseDiamond()) {
            json.put("payWay", (Object)29);
        }
        if (recharge2 == null && gift.getExpand() != null) {
            SendGiftExpand giftExpand = gift.getExpand();
            expand.put("senderHeaderUrl", (Object)giftExpand.senderHeaderUrl);
            expand.put("receiverHeaderUrl", (Object)giftExpand.receiverHeaderUrl);
            expand.put("bid", (Object)giftExpand.roomId);
            expand.put("roomOwnerUid", (Object)giftExpand.roomOwnerUid);
            if (!TextUtils.isEmpty((CharSequence)giftExpand.gameId)) {
                expand.put("gameId", (Object)giftExpand.gameId);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.giftSlogan)) {
                expand.put("giftSlogan", (Object)giftExpand.giftSlogan);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.topId)) {
                expand.put("topId", (Object)giftExpand.topId);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.subId)) {
                expand.put("subId", (Object)giftExpand.subId);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.vcid)) {
                expand.put("vcid", (Object)giftExpand.vcid);
            }
            expand.put("giftLevel", (Object)giftExpand.giftLevel);
            if (giftExpand.mode != 0) {
                expand.put("mode", (Object)giftExpand.mode);
                if (giftExpand.subMode != 0) {
                    expand.put("sub_mode", (Object)giftExpand.subMode);
                }
                if (giftExpand.videoMode != 0) {
                    expand.put("videoMode", (Object)giftExpand.videoMode);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.pkId)) {
                expand.put("pkId", (Object)giftExpand.pkId);
            }
            expand.put("pkFinishTime", (Object)giftExpand.videoPkFinishTime);
            if (!TextUtils.isEmpty((CharSequence)giftExpand.recommendToken)) {
                String dispatchId = "";
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)giftExpand.recommendToken);
                    dispatchId = jsonObject.optString("dispatch_id");
                }
                catch (JSONException e) {
                    MLog.error((Object)TAG, (String)("parse recommendToken error, " + e.getMessage()), (Object[])new Object[0]);
                }
                expand.put("pushToken", (Object)dispatchId);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.roundId)) {
                expand.put("round_id", (Object)giftExpand.roundId);
            }
            if (giftExpand.playType > 0) {
                if (this.isUseMultiple(gift)) {
                    MLog.error((Object)TAG, (String)"\u5168\u9ea6\u548cpk\u540c\u65f6\u5b58\u5728\uff1f", (Object[])new Object[0]);
                    if (RuntimeContext.sIsDebuggable) {
                        throw new IllegalArgumentException("\u5168\u9ea6\u548cpk\u540c\u65f6\u5b58\u5728\uff1f");
                    }
                }
                expand.put("playType", (Object)("" + giftExpand.playType));
            }
            if (giftExpand.modePlay > 0) {
                expand.put("modePlay", (Object)giftExpand.modePlay);
            }
            expand.put("minCharm", (Object)giftExpand.minCharm);
            if (!TextUtils.isEmpty((CharSequence)giftExpand.familyName)) {
                expand.put("familyName", (Object)giftExpand.familyName);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.familyLvIcon)) {
                expand.put("familyLvIcon", (Object)giftExpand.familyLvIcon);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.songId)) {
                expand.put("songId", (Object)giftExpand.songId);
            }
            if (!TextUtils.isEmpty((CharSequence)giftExpand.songName)) {
                expand.put("songName", (Object)giftExpand.songName);
            }
        }
        if (recharge2 != null) {
            expand.put("quantity", (Object)String.valueOf(recharge2.getQuantity()));
            expand.put("unitPrice", (Object)recharge2.getUnitPrice());
            expand.put("product_id", (Object)recharge2.getProductId());
        }
        if (!TextUtils.isEmpty((CharSequence)param.getExpand())) {
            expand.merge(param.getExpand());
        }
        expand.put("appCode", (Object)4);
        json.put("expand", (Object)expand.buildJson());
        builder.jsonMsg(json.jsonObject());
        RevenueProtoReq req = builder.build();
        final String url = RevenueProto.getUrl((String)"api", (int)req.getCmd());
        MLog.info((Object)TAG, (String)"sendGift url: %s", (Object[])new Object[]{url});
        this.mMonitor.request(seq, cmd, param.type, param);
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)BuyPropRequest.TAG, (String)"sendGift url: %s", (Throwable)e, (Object[])new Object[]{url});
                String msg = e.getMessage();
                BuyPropRequest.this.mMonitor.reportMetr(seq, String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                BuyPropRequest.this.mMonitor.fail(seq, 10002, msg);
                GiftUtils.callbackFailed((IGiftCallback)callback, (int)10002, (String)msg);
            }

            public void onResponse(final RevenueProtoRes response, int id2) {
                MLog.info((Object)BuyPropRequest.TAG, (String)"sendDataAsync onResponse response == null: %b", (Object[])new Object[]{response == null});
                BuyPropRequest.this.mMonitor.reportMetr(seq, "0");
                if (response == null) {
                    BuyPropRequest.this.mMonitor.fail(seq, 10003, "response of send gift data is null");
                    GiftUtils.callbackFailed((IGiftCallback)callback, (int)10003, (String)"response of send gift data is null");
                    return;
                }
                if (response.result != 1) {
                    String msg = "result of response error return from service with result: " + response.result;
                    BuyPropRequest.this.mMonitor.fail(seq, 21000 + response.result, msg);
                    GiftUtils.callbackFailed((IGiftCallback)callback, (int)(21000 + response.result), (String)msg);
                    return;
                }
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BuyPropRequest.this.handleSendGiftRes(seq, param.getUsedChannel(), response, (IGiftCallback<SendGiftRes>)callback);
                        }
                    });
                } else {
                    BuyPropRequest.this.handleSendGiftRes(seq, param.getUsedChannel(), response, (IGiftCallback<SendGiftRes>)callback);
                }
            }
        });
    }

    @WorkerThread
    private void handleSendGiftRes(String seq, int channelId, RevenueProtoRes response, IGiftCallback<SendGiftRes> callback) {
        UseItemResponse res = new UseItemResponse(response.jsonMsg);
        if (res.getResult() != 1) {
            int code = 21000 + res.getResult();
            String msg = "";
            msg = code == 20990 ? this.confirmUrl(response.jsonMsg) : (code == 20928 || code == 20982 ? res.getMessage() : "result of jsonMsg error return from service with code: " + res.getResult() + "\uff1b msg: " + res.getMessage());
            this.mMonitor.fail(seq, code, msg);
            GiftUtils.callbackFailed(callback, (int)code, (String)msg);
            return;
        }
        SendGiftExpand expand = null;
        if (!TextUtils.isEmpty((CharSequence)res.getExpend())) {
            expand = GiftUtils.parseSendGiftExpand((String)res.getExpend());
        }
        SendGiftRes result = new SendGiftRes(channelId, res, expand);
        this.mMonitor.success(seq);
        GiftUtils.callbackSucceed(callback, (Object)result);
    }

    private String confirmUrl(String jsonMsg) {
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)jsonMsg);
            return jsonObject.optString("confirmUrl");
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return "";
        }
    }

    private String getMyNickname() {
        if (ServiceManagerProxy.getServiceManager() == null) {
            return "";
        }
        UserInfoKS sender = ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        if (sender != null) {
            return sender.nick;
        }
        return "";
    }

    public static interface PROP_TYPE {
        public static final int gift = 1;
        public static final int giftBag = 2;
    }
}

