/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.prop;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.thirdnotify.IThirdNotify;
import com.yy.hiyo.proto.thirdnotify.ThirdNotifyUri;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;
import com.yy.hiyo.wallet.base.pay.callback.SimpleRechargeCallback;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeHandler;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.pay.PayService;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.prop.monitor.PropHandlerMonitor;
import com.yy.hiyo.wallet.prop.proto.BuyPropRequest;
import com.yy.hiyo.wallet.prop.proto.callback.IBuyPropCallback;
import com.yy.hiyo.wallet.prop.proto.param.BuyPropParam;
import com.yy.hiyo.wallet.prop.proto.res.ConsumeConfirmBroInfo;
import com.yy.hiyo.wallet.prop.proto.res.GiftBagAcquireBroInfo;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.json.JSONException;
import org.json.JSONObject;

public class BuyPropHandler {
    private static final String TAG = "BuyPropHandler";
    private static final long TIMEOUT = 20000L;
    private IBuyPropCallback mCallback;
    private IRechargeHandler mRechargeHandler;
    private ICallback mHandlerCallback;
    private final PropHandlerMonitor mPropHandlerMonitor = new PropHandlerMonitor();
    private Runnable mTimeoutTask = new Runnable(){

        @Override
        public void run() {
            MLog.error((Object)BuyPropHandler.TAG, (String)"wait for GiftBagAcquireMessage time out", (Object[])new Object[0]);
            BuyPropHandler.this.onFail(BuyPropHandler.this.mCallback, 7, "wait for GiftBagAcquireMessage time out");
            BuyPropHandler.this.destroy();
        }
    };
    private IThirdNotify<ConsumeConfirmBroInfo> mConfirmBro = new IThirdNotify<ConsumeConfirmBroInfo>(){

        public ThirdNotifyUri.Uri uri() {
            return ThirdNotifyUri.CONSUME_CONFIRM_BBROADCAST;
        }

        public void onNotify(@NonNull ConsumeConfirmBroInfo notify) {
            MLog.info((Object)BuyPropHandler.TAG, (String)"mConfirmBro ConsumeConfirmBroInfo: %s", (Object[])new Object[]{notify});
            BuyPropHandler.this.onConsumeConfirmBro(BuyPropHandler.this.mCallback, notify);
        }
    };
    private IThirdNotify<GiftBagAcquireBroInfo> mAcquireBro = new IThirdNotify<GiftBagAcquireBroInfo>(){

        public ThirdNotifyUri.Uri uri() {
            return ThirdNotifyUri.GIFT_BAG_ACQUIRE_BBROADCAST;
        }

        public void onNotify(@NonNull GiftBagAcquireBroInfo notify) {
            MLog.info((Object)BuyPropHandler.TAG, (String)"mAcquireBro GiftBagAcquireBroInfo: %s", (Object[])new Object[]{notify});
            BuyPropHandler.this.onAcquireGiftBagBro(BuyPropHandler.this.mCallback, notify);
        }
    };

    public BuyPropHandler(@NonNull ICallback callback) {
        this.mHandlerCallback = callback;
        ProtoManager.getInstance().registerThirdNotify(ConsumeConfirmBroInfo.class, this.mConfirmBro);
        ProtoManager.getInstance().registerThirdNotify(GiftBagAcquireBroInfo.class, this.mAcquireBro);
    }

    public void buyProp(final BuyPropParam param, IBuyPropCallback callback) {
        this.mCallback = callback;
        this.mPropHandlerMonitor.monitorStep(1);
        new BuyPropRequest().buyProp(param, new IGiftCallback<SendGiftRes>(){

            public void onSucceed(SendGiftRes result) {
                MLog.error((Object)BuyPropHandler.TAG, (String)"buyProp onSucceed result: %s", (Object[])new Object[]{result});
                BuyPropHandler.this.onBuyPropResponse(BuyPropHandler.this.mCallback, result);
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)BuyPropHandler.TAG, (String)"buyProp onFailed code: %s, msg: %s", (Object[])new Object[]{code, msg});
                if (code == 20990) {
                    BuyPropHandler.this.recharge(param.getRecharge(), msg);
                } else {
                    BuyPropHandler.this.onBuyFail(BuyPropHandler.this.mCallback, code, msg);
                }
            }
        });
    }

    public void destroy() {
        MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        ProtoManager.getInstance().unregisterThirdNotify(this.mConfirmBro);
        ProtoManager.getInstance().unregisterThirdNotify(this.mAcquireBro);
        this.mCallback = null;
        if (this.mRechargeHandler != null) {
            this.mRechargeHandler.destroy();
            this.mRechargeHandler = null;
        }
        YYTaskExecutor.removeTask((Runnable)this.mTimeoutTask);
    }

    private void recharge(RechargeParam param, String confirmUrl) {
        this.mPropHandlerMonitor.monitorStep(11);
        String orderId = this.getOrderId(confirmUrl);
        if (TextUtils.isEmpty((CharSequence)orderId)) {
            this.onRechargeFail(this.mCallback, 6, "need to recharge but orderId is empty");
        } else {
            Activity activity;
            if (this.mRechargeHandler == null) {
                IPayService payService = (IPayService)ServiceManagerProxy.getService(IPayService.class);
                if (payService instanceof PayService) {
                    this.mRechargeHandler = ((PayService)payService).createRechargeHandler(PayUtils.getPayPlatform(), (Function1<IRechargeHandler, Unit>)((Function1)handler -> {
                        if (this.mRechargeHandler != null) {
                            this.mRechargeHandler.destroy();
                        }
                        this.mRechargeHandler = null;
                        return null;
                    }));
                } else {
                    this.onRechargeFail(this.mCallback, 10011, "illegal status, pay sevice is null");
                    return;
                }
            }
            if ((activity = this.mHandlerCallback.getActivity()) == null) {
                this.onRechargeFail(this.mCallback, 10001, "illegal param, activity can not be null");
                return;
            }
            this.mRechargeHandler.rechargeDirect(orderId, this.getPayload(confirmUrl), activity, param, (IRechargeCallback)new SimpleRechargeCallback(){

                public void onSucceed(@Nullable RechargeInfo data) {
                    BuyPropHandler.this.rechargeSuccess(BuyPropHandler.this.mCallback, data);
                    YYTaskExecutor.postToMainThread((Runnable)BuyPropHandler.this.mTimeoutTask, (long)20000L);
                }

                public void onFailed(int code, String msg) {
                    super.onFailed(code, msg);
                    BuyPropHandler.this.onRechargeFail(BuyPropHandler.this.mCallback, code, msg);
                }
            });
        }
    }

    private String getPayload(String confirmUrl) {
        if (TextUtils.isEmpty((CharSequence)confirmUrl)) {
            return "";
        }
        return confirmUrl;
    }

    private String getOrderId(String confirmUrl) {
        if (TextUtils.isEmpty((CharSequence)confirmUrl)) {
            return "";
        }
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)confirmUrl);
            return jo.optString("chOrderId", "");
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return "";
        }
    }

    void onRechargeFail(IBuyPropCallback callback, int code, String msg) {
        this.mPropHandlerMonitor.monitorFail(13, code, msg);
        this.onFail(callback, code, msg);
    }

    void onBuyFail(IBuyPropCallback callback, int code, String msg) {
        this.mPropHandlerMonitor.monitorFail(3, code, msg);
        if (code == 20982) {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)msg, (int)1);
            } else {
                MLog.error((Object)TAG, (String)"message tips is empty", (Object[])new Object[0]);
            }
        }
        this.onFail(callback, code, msg);
    }

    void onFail(final IBuyPropCallback callback, final int code, final String msg) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFail(code, msg);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onFail(code, msg);
                }
            });
        }
    }

    void onBuyPropResponse(final IBuyPropCallback callback, final SendGiftRes result) {
        this.mPropHandlerMonitor.monitorStep(2);
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onBuyPropResponse(result);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onBuyPropResponse(result);
                }
            });
        }
    }

    void rechargeSuccess(final IBuyPropCallback callback, final RechargeInfo data) {
        this.mPropHandlerMonitor.monitorStep(12);
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onRechargeSuccess(data);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onRechargeSuccess(data);
                }
            });
        }
    }

    void onConsumeConfirmBro(final IBuyPropCallback callback, final ConsumeConfirmBroInfo info) {
        this.mPropHandlerMonitor.monitorStep(14);
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onConsumeConfirmBro(info);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onConsumeConfirmBro(info);
                }
            });
        }
    }

    void onAcquireGiftBagBro(final IBuyPropCallback callback, final GiftBagAcquireBroInfo info) {
        this.mPropHandlerMonitor.monitorStep(4);
        YYTaskExecutor.removeTask((Runnable)this.mTimeoutTask);
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onAcquireGiftBagBro(info);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onAcquireGiftBagBro(info);
                }
            });
        }
    }

    public static interface ICallback {
        public Activity getActivity();
    }
}

