/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.sku.strategy;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.billing.base.SkuDetailsInfo;
import com.yy.hiyo.wallet.base.IPlatformPay;
import com.yy.hiyo.wallet.base.ProductType;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.sku.strategy.ISkuStrategy;
import com.yy.hiyo.wallet.pay.sku.strategy.IStrategyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 32\u00020\u0001:\u000223B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u000fR\u00020\u0000H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0002J\u0016\u0010#\u001a\u00020\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0002J\u0014\u0010%\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u000fR\u00020\u0000H\u0002J&\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0002J$\u0010+\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"J0\u0010,\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\t2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010.H\u0016J \u0010/\u001a\u000e\u0012\b\u0012\u00060\u000fR\u00020\u0000\u0018\u00010\"2\n\u0010\u0019\u001a\u00060\u000fR\u00020\u0000H\u0002J\u0016\u00100\u001a\u00020\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR1\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000fR\u00020\u00000\u000e0\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lcom/yy/hiyo/wallet/pay/sku/strategy/ISkuStrategy;", "", "strategyId", "", "listener", "Lcom/yy/hiyo/wallet/pay/sku/strategy/IStrategyListener;", "(ILcom/yy/hiyo/wallet/pay/sku/strategy/IStrategyListener;)V", "allSkuDetails", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/yy/billing/base/SkuDetailsInfo;", "getAllSkuDetails", "()Ljava/util/concurrent/ConcurrentHashMap;", "callbackMap", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/yy/hiyo/wallet/pay/sku/strategy/ISkuStrategy$CallbackTask;", "getCallbackMap", "callbackMap$delegate", "Lkotlin/Lazy;", "getListener", "()Lcom/yy/hiyo/wallet/pay/sku/strategy/IStrategyListener;", "getStrategyId", "()I", "addTask", "", "task", "getDetail", "sku", "getOldDetail", "isValid", "", "strategy", "onQueryFail", "skus", "", "onQuerySuccess", "data", "onTimeout", "query", "pay", "Lcom/yy/hiyo/wallet/base/IPlatformPay;", "type", "Lcom/yy/hiyo/wallet/base/ProductType;", "queryDetail", "queryDetails", "callback", "Lcom/yy/hiyo/wallet/base/pay/callback/IPayCallback;", "removeTask", "updateDetails", "list", "CallbackTask", "Companion", "wallet_billDebug"})
public abstract class ISkuStrategy {
    @NotNull
    private final ConcurrentHashMap<String, SkuDetailsInfo> allSkuDetails;
    @NotNull
    private final Lazy callbackMap$delegate;
    private final int strategyId;
    @NotNull
    private final IStrategyListener listener;
    private static final String TAG = "FTPayStrategy";
    private static final long TIMEOUT = 5000L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ConcurrentHashMap<String, SkuDetailsInfo> getAllSkuDetails() {
        return this.allSkuDetails;
    }

    @NotNull
    protected final ConcurrentHashMap<String, CopyOnWriteArrayList<CallbackTask>> getCallbackMap() {
        Lazy lazy = this.callbackMap$delegate;
        ISkuStrategy iSkuStrategy = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConcurrentHashMap)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void queryDetail(@NotNull IPlatformPay pay2, @NotNull ProductType type, @NotNull List<String> skus) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)pay2, (String)"pay");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(skus, (String)"skus");
        Iterable $this$filter$iv = skus;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.getCallbackMap().containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List queryList = (List)destination$iv$iv;
        this.query(pay2, type, queryList);
    }

    public void queryDetails(@NotNull IPlatformPay pay2, @NotNull ProductType type, @NotNull String sku, @Nullable IPayCallback<SkuDetailsInfo> callback) {
        Intrinsics.checkParameterIsNotNull((Object)pay2, (String)"pay");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)sku, (String)"sku");
        boolean needQuery = !this.getCallbackMap().containsKey(sku);
        CallbackTask task = new CallbackTask(pay2, type, sku, callback);
        this.addTask(task);
        task.start();
        if (needQuery) {
            this.query(pay2, type, CollectionsKt.mutableListOf((Object[])new String[]{sku}));
        }
    }

    @Nullable
    public SkuDetailsInfo getDetail(@NotNull String sku) {
        Intrinsics.checkParameterIsNotNull((Object)sku, (String)"sku");
        return this.allSkuDetails.get(sku);
    }

    @Nullable
    public SkuDetailsInfo getOldDetail(@NotNull String sku) {
        Intrinsics.checkParameterIsNotNull((Object)sku, (String)"sku");
        return this.allSkuDetails.get(sku);
    }

    public void updateDetails(@NotNull List<SkuDetailsInfo> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SkuDetailsInfo it = (SkuDetailsInfo)element$iv;
            boolean bl = false;
            ((Map)this.allSkuDetails).put(it.getProductId(), it);
        }
    }

    public final boolean isValid(int strategy) {
        return (strategy & this.strategyId) == this.strategyId;
    }

    private final void query(IPlatformPay pay2, ProductType type, List<String> skus) {
        long start = System.currentTimeMillis();
        pay2.querySkuDetails(type, skus, (IPayCallback)new IPayCallback<List<? extends SkuDetailsInfo>>(this, start, skus){
            final /* synthetic */ ISkuStrategy this$0;
            final /* synthetic */ long $start;
            final /* synthetic */ List $skus;

            public void onSucceed(@Nullable List<SkuDetailsInfo> data) {
                MLog.info((Object)"FTPayStrategy", (String)"query onSucceed data.size: %d", (Object[])new Object[]{FP.size((Collection)data)});
                List<SkuDetailsInfo> list = data;
                if (list != null) {
                    List<SkuDetailsInfo> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<SkuDetailsInfo> it = list2;
                    boolean bl3 = false;
                    long duration = System.currentTimeMillis() - this.$start;
                    this.this$0.getListener().onQuerySuccess(this.this$0.getStrategyId(), it, duration);
                    ISkuStrategy.access$onQuerySuccess(this.this$0, it);
                } else {
                    ISkuStrategy.access$onQueryFail(this.this$0, this.$skus);
                }
            }

            public void onFailed(int code, @Nullable String msg) {
                MLog.error((Object)"FTPayStrategy", (String)"query onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
                ISkuStrategy.access$onQueryFail(this.this$0, this.$skus);
            }
            {
                this.this$0 = $outer;
                this.$start = $captured_local_variable$1;
                this.$skus = $captured_local_variable$2;
            }
        });
    }

    private final void onQuerySuccess(List<SkuDetailsInfo> data) {
        Iterable $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SkuDetailsInfo it = (SkuDetailsInfo)element$iv;
            boolean bl = false;
            CopyOnWriteArrayList<CallbackTask> copyOnWriteArrayList = this.getCallbackMap().remove(it.getProductId());
            if (copyOnWriteArrayList == null) continue;
            Iterable $this$forEach$iv2 = copyOnWriteArrayList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CallbackTask task = (CallbackTask)element$iv2;
                boolean bl2 = false;
                task.stop();
                PayUtils.callbackSucceed(task.getCallback(), it);
            }
        }
    }

    private final void onQueryFail(List<String> skus) {
        Iterable $this$forEach$iv = skus;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            CopyOnWriteArrayList<CallbackTask> copyOnWriteArrayList = this.getCallbackMap().remove(it);
            if (copyOnWriteArrayList == null) continue;
            Iterable $this$forEach$iv2 = copyOnWriteArrayList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CallbackTask task = (CallbackTask)element$iv2;
                boolean bl2 = false;
                task.stop();
                PayUtils.callbackFailed(task.getCallback(), 60002, "\u4ecegp\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u8fd4\u56de\u5931\u8d25");
            }
        }
    }

    private final void onTimeout(CallbackTask task) {
        block0: {
            List<CallbackTask> list = this.removeTask(task);
            PayUtils.callbackFailed(task.getCallback(), 60001, "\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u8d85\u65f6");
            List<CallbackTask> list2 = list;
            if (list2 == null || (list2 = list2.get(0)) == null) break block0;
            List<CallbackTask> list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List<CallbackTask> it = list3;
            boolean bl3 = false;
            this.query(((CallbackTask)((Object)it)).getPay(), ((CallbackTask)((Object)it)).getType(), CollectionsKt.mutableListOf((Object[])new String[]{((CallbackTask)((Object)it)).getSku()}));
        }
    }

    private final void addTask(CallbackTask task) {
        CopyOnWriteArrayList<CallbackTask> list = this.getCallbackMap().get(task.getSku());
        if (list == null) {
            list = new CopyOnWriteArrayList();
            ((Map)this.getCallbackMap()).put(task.getSku(), list);
        }
        if (!list.contains(task)) {
            list.add(task);
        }
    }

    private final List<CallbackTask> removeTask(CallbackTask task) {
        Map $this$forEach$iv = this.getCallbackMap();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            List list;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            if (!((CopyOnWriteArrayList)it.getValue()).remove(task)) continue;
            if (((CopyOnWriteArrayList)it.getValue()).isEmpty()) {
                this.getCallbackMap().remove(it.getKey(), it.getValue());
                list = null;
            } else {
                list = (List)it.getValue();
            }
            return list;
        }
        return null;
    }

    public final int getStrategyId() {
        return this.strategyId;
    }

    @NotNull
    public final IStrategyListener getListener() {
        return this.listener;
    }

    public ISkuStrategy(int strategyId, @NotNull IStrategyListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.strategyId = strategyId;
        this.listener = listener;
        this.allSkuDetails = new ConcurrentHashMap();
        this.callbackMap$delegate = LazyKt.lazy((Function0)callbackMap.2.INSTANCE);
    }

    public static final /* synthetic */ void access$onQuerySuccess(ISkuStrategy $this, List data) {
        $this.onQuerySuccess(data);
    }

    public static final /* synthetic */ void access$onQueryFail(ISkuStrategy $this, List skus) {
        $this.onQueryFail(skus);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/yy/hiyo/wallet/pay/sku/strategy/ISkuStrategy$CallbackTask;", "Ljava/lang/Runnable;", "pay", "Lcom/yy/hiyo/wallet/base/IPlatformPay;", "type", "Lcom/yy/hiyo/wallet/base/ProductType;", "sku", "", "callback", "Lcom/yy/hiyo/wallet/base/pay/callback/IPayCallback;", "Lcom/yy/billing/base/SkuDetailsInfo;", "(Lcom/yy/hiyo/wallet/pay/sku/strategy/ISkuStrategy;Lcom/yy/hiyo/wallet/base/IPlatformPay;Lcom/yy/hiyo/wallet/base/ProductType;Ljava/lang/String;Lcom/yy/hiyo/wallet/base/pay/callback/IPayCallback;)V", "getCallback", "()Lcom/yy/hiyo/wallet/base/pay/callback/IPayCallback;", "getPay", "()Lcom/yy/hiyo/wallet/base/IPlatformPay;", "getSku", "()Ljava/lang/String;", "getType", "()Lcom/yy/hiyo/wallet/base/ProductType;", "run", "", "start", "stop", "wallet_billDebug"})
    protected final class CallbackTask
    implements Runnable {
        @NotNull
        private final IPlatformPay pay;
        @NotNull
        private final ProductType type;
        @NotNull
        private final String sku;
        @Nullable
        private final IPayCallback<SkuDetailsInfo> callback;

        @Override
        public void run() {
            ISkuStrategy.this.onTimeout(this);
        }

        public final void start() {
            YYTaskExecutor.postToMainThread((Runnable)this, (long)5000L);
            ISkuStrategy.this.addTask(this);
        }

        public final void stop() {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this);
            ISkuStrategy.this.removeTask(this);
        }

        @NotNull
        public final IPlatformPay getPay() {
            return this.pay;
        }

        @NotNull
        public final ProductType getType() {
            return this.type;
        }

        @NotNull
        public final String getSku() {
            return this.sku;
        }

        @Nullable
        public final IPayCallback<SkuDetailsInfo> getCallback() {
            return this.callback;
        }

        public CallbackTask(@NotNull IPlatformPay pay2, @NotNull ProductType type, @Nullable String sku, IPayCallback<SkuDetailsInfo> callback) {
            Intrinsics.checkParameterIsNotNull((Object)pay2, (String)"pay");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)sku, (String)"sku");
            this.pay = pay2;
            this.type = type;
            this.sku = sku;
            this.callback = callback;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/wallet/pay/sku/strategy/ISkuStrategy$Companion;", "", "()V", "TAG", "", "TIMEOUT", "", "wallet_billDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

