/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.request;

import androidx.annotation.WorkerThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.billing.base.RechargeResult;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.monitor.PayHandlerMonitor;
import com.yy.hiyo.wallet.pay.proto.PayStatus;
import com.yy.hiyo.wallet.pay.proto.bean.ReportRechargeResult;
import com.yy.hiyo.wallet.pay.proto.bean.ReportResultResponse;
import com.yy.hiyo.wallet.pay.request.PayRequestUtils;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.util.HashMap;
import okhttp3.Call;

public class ReportPayResult {
    private static final String TAG = "FTPayReportPayResult";
    private static final long REPORT_RESULT_TIME_OUT = 20000L;
    private IPayCallback<ReportRechargeResult> mCallback;
    private PayHandlerMonitor mPayHandlerMonitor;
    private Runnable mTimeoutTask = new Runnable(){

        @Override
        public void run() {
            PayUtils.callbackFailed(ReportPayResult.this.mCallback, 10010, "report pay result timeout");
        }
    };

    public ReportPayResult(RechargeParam info, RechargeResult rechargeResult, String seq, boolean consume2, PayHandlerMonitor monitor, int reportType, IPayCallback<ReportRechargeResult> callback) {
        this.mCallback = callback;
        this.mPayHandlerMonitor = monitor;
        this.reportPayResult(info, rechargeResult, seq, consume2, reportType, callback);
    }

    public void cancel() {
        YYTaskExecutor.removeTask((Runnable)this.mTimeoutTask);
        this.mCallback = null;
    }

    private void reportPayResult(final RechargeParam info, final RechargeResult rechargeResult, final String seq, final boolean consume2, final int reportType, final IPayCallback<ReportRechargeResult> callback) {
        MLog.info((Object)TAG, (String)"reportPayResult", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)this.mTimeoutTask, (long)20000L);
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ReportPayResult.this.reportPayResultAsync(info, rechargeResult, seq, consume2, reportType, (IPayCallback<ReportRechargeResult>)callback);
                }
            });
        } else {
            this.reportPayResultAsync(info, rechargeResult, seq, consume2, reportType, callback);
        }
    }

    private void reportPayResultAsync(final RechargeParam info, final RechargeResult rechargeResult, final String seq, boolean consume2, int reportType, final IPayCallback<ReportRechargeResult> callback) {
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(1045);
        builder.countryCode(AccountUtil.realCountry());
        JsonStringBuilder param = RevenueProto.getCommonParam();
        param.put("seq", (Object)seq);
        param.put("cmd", (Object)1045);
        param.put("usedChannel", (Object)info.getUseChannel());
        param.put("purchaseData", (Object)rechargeResult.purchaseData);
        param.put("purchaseSign", (Object)rechargeResult.purchaseSign);
        HashMap<String, Object> ext = new HashMap<String, Object>();
        if (info.getUserCouponId() != 0L) {
            ext.put("userCouponId", info.getUserCouponId());
        }
        ext.put("confirm", consume2);
        ext.put("retryType", reportType);
        String expand = PayRequestUtils.getExpand(1, info.getUnitPrice(), info.getProductId(), HiidoUtils.getHdid(), info.getSrcCurrencySymbol(), ext);
        param.put("expand", (Object)expand);
        builder.jsonMsg(param.jsonObject());
        RevenueProtoReq req = builder.build();
        String url = RevenueProto.getUrl((String)"api", (int)req.getCmd());
        MLog.info((Object)TAG, (String)"reportPayResultAsync url: %s", (Object[])new Object[]{url});
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)ReportPayResult.TAG, (String)"reportPayResultAsync", (Throwable)e, (Object[])new Object[0]);
                int code = NetworkUtils.getErrorCodeByExc((Throwable)e);
                if (ReportPayResult.this.mPayHandlerMonitor != null) {
                    ReportPayResult.this.mPayHandlerMonitor.reportRequestMetric(seq, String.valueOf(code));
                }
                YYTaskExecutor.removeTask((Runnable)ReportPayResult.this.mTimeoutTask);
                String msg = e.getMessage();
                PayUtils.callbackFailed(callback, 51000 + code, msg);
            }

            public void onResponse(final RevenueProtoRes response, int id2) {
                MLog.info((Object)ReportPayResult.TAG, (String)"reportPayResultAsync onResponse: %s", (Object[])new Object[]{response});
                if (ReportPayResult.this.mPayHandlerMonitor != null) {
                    ReportPayResult.this.mPayHandlerMonitor.reportRequestMetric(seq, "0");
                }
                YYTaskExecutor.removeTask((Runnable)ReportPayResult.this.mTimeoutTask);
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ReportPayResult.this.handleReportRes(info, rechargeResult, response, (IPayCallback<ReportRechargeResult>)callback);
                        }
                    });
                } else {
                    ReportPayResult.this.handleReportRes(info, rechargeResult, response, (IPayCallback<ReportRechargeResult>)callback);
                }
            }
        });
    }

    @WorkerThread
    private void handleReportRes(RechargeParam info, RechargeResult rechargeResult, RevenueProtoRes response, IPayCallback<ReportRechargeResult> callback) {
        ReportResultResponse res = PayRequestUtils.parseResponse(response, ReportResultResponse.class);
        if (res == null) {
            PayUtils.callbackFailed(callback, 51100, "maybe parse response json error");
            return;
        }
        PayStatus status = PayStatus.valueOf(res.result);
        if (status == PayStatus.HAD_FINISH) {
            PayUtils.callbackFailed(callback, 51000 + res.result, res.result + " , " + status.getMessage());
            return;
        }
        if (status != PayStatus.OK) {
            PayUtils.callbackFailed(callback, 51000 + res.result, res.result + " , " + status.getMessage());
            return;
        }
        ReportRechargeResult result = new ReportRechargeResult(status, res, response.result);
        PayUtils.callbackSucceed(callback, result);
    }
}

