/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.request;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.internal.Callback;
import com.yy.hiyo.wallet.base.revenue.internal.IRechargeService;
import com.yy.hiyo.wallet.base.revenue.internal.IRechargeStorage;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.proto.bean.RechargeListResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class RechargeListRequest {
    private static final String TAG = "FTPayRechargeListRequest";
    private static IRechargeStorage storage;
    private List<? extends ProductItemInfo> mCurResponse;
    private Runnable mPendingRequestTask;
    private IPayCallback<List<ProductItemInfo>> mPendingCallback;
    private final IRechargeService rechargeImpl;
    private boolean isInitCache = false;

    public RechargeListRequest(IRechargeService rechargeService) {
        this.rechargeImpl = rechargeService;
        storage = this.rechargeImpl.getStorage();
    }

    public void initCache() {
        MLog.info((Object)TAG, (String)"initCache isInitCache %b, storage == null: %b", (Object[])new Object[]{this.isInitCache, storage == null});
        if (this.isInitCache) {
            return;
        }
        if (storage == null) {
            storage = this.rechargeImpl.getStorage();
        }
        this.isInitCache = true;
        storage.read(new Callback(){

            public void onFinished(@Nullable List<? extends ProductItemInfo> res, boolean isDefault) {
                boolean isvalid = RechargeListRequest.this.isListValid(res);
                MLog.info((Object)RechargeListRequest.TAG, (String)"onFinished isDefault: %b, isvalid: %b, mPpendingCallback: %b", (Object[])new Object[]{isDefault, isvalid, RechargeListRequest.this.mPendingCallback == null});
                if (!(!isDefault && isvalid || RechargeListRequest.this.isListValid(RechargeListRequest.this.mCurResponse))) {
                    RechargeListRequest.this.requestRechargeList(-1, null, null);
                }
                if (isvalid && !RechargeListRequest.this.isListValid(RechargeListRequest.this.mCurResponse)) {
                    RechargeListRequest.this.mCurResponse = res;
                    if (RechargeListRequest.this.mPendingCallback != null) {
                        PayUtils.callbackSucceed(RechargeListRequest.this.mPendingCallback, res);
                        RechargeListRequest.this.mPendingCallback = null;
                    }
                }
            }
        });
    }

    public void netWorkChange() {
        if (this.mPendingRequestTask != null) {
            YYTaskExecutor.execute((Runnable)this.mPendingRequestTask);
        }
    }

    public void clearCache() {
        this.mCurResponse = null;
        this.isInitCache = false;
        if (storage != null) {
            storage.clear();
        }
    }

    @androidx.annotation.Nullable
    public List<ProductItemInfo> getRechargeList() {
        List list = this.mCurResponse;
        if (FP.empty(list)) {
            if (storage != null) {
                list = storage.getResponse();
                if (!FP.empty((Collection)list)) {
                    this.mCurResponse = storage.getResponse();
                } else {
                    this.initCache();
                }
            } else {
                this.initCache();
            }
        }
        return list;
    }

    @androidx.annotation.Nullable
    public ProductItemInfo getRechargeItemInfo(String productId) {
        if (TextUtils.isEmpty((CharSequence)productId)) {
            return null;
        }
        List<ProductItemInfo> list = this.getRechargeList();
        ProductItemInfo itemInfo = null;
        if (!FP.empty(list)) {
            for (ProductItemInfo info : list) {
                if (!productId.equals(info.getProductId())) continue;
                itemInfo = info;
                break;
            }
        }
        return itemInfo;
    }

    @androidx.annotation.Nullable
    private List<ProductItemInfo> getRechargeList(RechargeListResponse res) {
        if (res != null && !FP.empty(res.confList)) {
            return res.confList;
        }
        return null;
    }

    public void requestRechargeList(int from, Map<String, Object> expand, IPayCallback<List<ProductItemInfo>> callback) {
        this.requestRechargeList(from, "", expand, callback);
    }

    public void requestRechargeList(final int from, final String pageId, final Map<String, Object> expand, final IPayCallback<List<ProductItemInfo>> callback) {
        Runnable task;
        if (!(NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) && AccountUtil.getUid() > 0L || callback == null)) {
            callback.onFailed(250, "network is not available or no login");
            return;
        }
        MLog.info((Object)TAG, (String)"requestRechargeList", (Object[])new Object[0]);
        if (!this.isListValid(this.mCurResponse)) {
            MLog.info((Object)TAG, (String)"requestRechargeList invalid callback: %b", (Object[])new Object[]{callback == null});
            if (callback != null) {
                this.mPendingCallback = callback;
            }
            this.initCache();
        }
        this.mPendingRequestTask = task = new Runnable(){

            @Override
            public void run() {
                RechargeListRequest.this.rechargeImpl.fetchProductList(from, pageId, RechargeListRequest.this.addCommonExpandParam(expand), (IPayCallback)new IPayCallback<List<ProductItemInfo>>(){

                    public void onSucceed(@androidx.annotation.Nullable List<ProductItemInfo> data) {
                        RechargeListRequest.this.mCurResponse = data;
                        PayUtils.callbackSucceed(callback, data);
                    }

                    public void onFailed(int code, String msg) {
                        List<ProductItemInfo> data = RechargeListRequest.this.getRechargeList();
                        if (!FP.empty(data)) {
                            PayUtils.callbackSucceed(callback, data);
                        } else {
                            PayUtils.callbackFailed(callback, code, msg);
                        }
                    }
                });
            }
        };
        if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute((Runnable)task);
            } else {
                task.run();
            }
        } else {
            MLog.error((Object)TAG, (String)"requestRechargeList net invalid", (Object[])new Object[0]);
        }
    }

    private Map<String, Object> addCommonExpandParam(Map<String, Object> expand) {
        if (expand == null) {
            expand = new HashMap<String, Object>();
        }
        expand.put("native", 1);
        return expand;
    }

    private boolean isListValid(List<? extends ProductItemInfo> res) {
        return res != null && !FP.empty(res);
    }
}

