/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.question.ui;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.R;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.pay.question.FaqClickListener;

public class OtherQuestionDialog
extends YYDialog {
    private static String TAG = "OtherQuestionPanel";
    private int maxTextLength = 60;
    private Context mContext;
    private YYEditText mEtContent;
    private YYTextView mTvLimit;
    private YYTextView mSubmit;
    private FaqClickListener mUiCallBack;
    private View mView;
    InputFilter mFilter = new InputFilter(){

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (source.toString().contentEquals("\n")) {
                return "";
            }
            return null;
        }
    };

    public OtherQuestionDialog(Context context, FaqClickListener uiCallBack) {
        super(context, R.style.cTransparentDialog);
        this.mContext = context;
        this.mUiCallBack = uiCallBack;
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.createView();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mUiCallBack != null) {
            this.mUiCallBack.onDismiss();
        }
    }

    private void createView() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.window_question_text_edit, null);
        this.setContentView(this.mView);
        Window window = this.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        params.height = -2;
        window.setGravity(80);
        window.setAttributes(params);
        this.getWindow().setWindowAnimations(R.style.DialogAnimation);
        this.mEtContent = (YYEditText)this.findViewById(R.id.et_content);
        this.mEtContent.setBackgroundResource(R.drawable.bg_edit);
        this.mSubmit = (YYTextView)this.findViewById(R.id.submit);
        this.mTvLimit = (YYTextView)this.findViewById(R.id.tv_limit);
        this.mTvLimit.setText((CharSequence)"0/60");
        this.mEtContent.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                OtherQuestionDialog.this.updateLimitText();
            }
        });
        this.mSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OtherQuestionDialog.this.mUiCallBack.onClick(7, OtherQuestionDialog.this.getMsg());
            }
        });
        InputFilter.LengthFilter lengthInputFilter = new InputFilter.LengthFilter(this.maxTextLength);
        this.mEtContent.setFilters(new InputFilter[]{this.mFilter, lengthInputFilter});
    }

    private String getMsg() {
        return this.mEtContent.getText().toString();
    }

    private void updateLimitText() {
        int length;
        String text = this.mEtContent.getText().toString();
        this.mTvLimit.setText((CharSequence)(text.length() + "/" + this.maxTextLength));
        this.checkSubmitbutton(text);
        int n = length = FP.empty((CharSequence)text) ? 0 : text.length();
        if (length >= this.maxTextLength) {
            this.mTvLimit.setTextColor(ResourceUtils.getColor((int)R.color.color_ff4a6d));
        } else {
            this.mTvLimit.setTextColor(ResourceUtils.getColor((int)R.color.color_bbbbbb));
        }
    }

    private void checkSubmitbutton(String text) {
        if (text.length() > 0) {
            this.mSubmit.setEnabled(true);
            this.mSubmit.setBackgroundResource(R.drawable.shape_ffc102_24);
        } else {
            this.mSubmit.setEnabled(false);
            this.mSubmit.setBackgroundResource(R.drawable.shape_d3d3d3_3dp);
        }
    }

    public void hidePanel() {
        ImeUtil.hideIME((Context)this.mContext, (View)this.mEtContent);
    }
}

