/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.question;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.feedback.FeedbackCallBack;
import com.yy.hiyo.wallet.base.revenue.internal.IPayHandler;
import com.yy.hiyo.wallet.pay.handler.IHandlerCallback;
import com.yy.hiyo.wallet.pay.question.FaqClickListener;
import com.yy.hiyo.wallet.pay.question.adapter.ItemClickCallBack;
import com.yy.hiyo.wallet.pay.question.bean.QuestionInfo;
import com.yy.hiyo.wallet.pay.question.ui.JumpFaqDialog;
import com.yy.hiyo.wallet.pay.question.ui.OtherQuestionDialog;
import com.yy.hiyo.wallet.pay.question.ui.QuestionDialog;
import com.yy.hiyo.wallet.pay.stats.RechargeHiidoReport;
import com.yy.webservice.WebEnvSettings;
import java.util.ArrayList;
import java.util.List;

public class QuestionPresent
implements IPayHandler {
    private static String TAG = "QuestionPresent";
    private QuestionDialog questionDialog;
    private OtherQuestionDialog otherQuestionDialog;
    private JumpFaqDialog jumpFaqDialog;
    private int[] typesWithSim = new int[]{0, 5, 1, 2, 3};
    private int[] types = new int[]{5, 1, 2, 3};
    private List<QuestionInfo> list;
    private IHandlerCallback callback;
    Runnable closeWindowRunnable = new Runnable(){

        @Override
        public void run() {
            if (QuestionPresent.this.jumpFaqDialog != null && QuestionPresent.this.jumpFaqDialog.isShowing()) {
                QuestionPresent.this.jumpFaqDialog.dismiss();
            }
        }
    };

    public void showQuestions(final Context context, final IHandlerCallback callback) {
        AConfigData aConfigData;
        this.callback = callback;
        MLog.info((Object)TAG, (String)"showQuestions", (Object[])new Object[0]);
        if (this.questionDialog == null) {
            this.questionDialog = new QuestionDialog(context, new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog2) {
                    QuestionPresent.this.finishCallback(callback);
                }
            });
            this.questionDialog.setOnClickListener(new ItemClickCallBack(){

                @Override
                public void itemClick(QuestionInfo questionInfo) {
                    QuestionPresent.this.closeDialog();
                    if (questionInfo != null) {
                        RechargeHiidoReport.quePopClick(questionInfo.getType());
                        if (questionInfo.getType() == 2) {
                            QuestionPresent.this.showOtherQuestionDialog(context, callback);
                        } else if (questionInfo.getType() == 3 || questionInfo.getType() == 1) {
                            QuestionPresent.this.showJumpFaqDialog(context);
                            YYTaskExecutor.postToMainThread((Runnable)QuestionPresent.this.closeWindowRunnable, (long)2000L);
                        } else if (questionInfo.getType() == 0) {
                            QuestionPresent.this.showJumpFaqDialog(context);
                            QuestionPresent.this.updateTittle(0);
                        } else if (questionInfo.getType() == 5) {
                            QuestionPresent.this.showJumpFaqDialog(context);
                            QuestionPresent.this.updateTittle(5);
                        }
                    }
                }
            });
        }
        if (!this.questionDialog.isShowing()) {
            this.questionDialog.show();
            RechargeHiidoReport.quePopShow();
        }
        if ((aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG)) instanceof CommonConfig) {
            CommonConfig contactQuizConfig = (CommonConfig)aConfigData;
            CommonConfigData commonConfigData = contactQuizConfig.getData();
            if (commonConfigData.simRechargeSwitch) {
                this.updateDate(this.typesWithSim);
            } else {
                this.updateDate(this.types);
            }
        } else {
            this.updateDate(this.types);
        }
    }

    private void jumpToFAQ(int type) {
        WebEnvSettings wes = new WebEnvSettings();
        wes.url = UriProvider.getHelpCenterUrl();
        wes.disablePullRefresh = true;
        ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(wes);
    }

    private void updateTittle(int type) {
        if (this.jumpFaqDialog != null) {
            this.jumpFaqDialog.updateTittle(type);
        }
    }

    private void closeDialog() {
        if (this.questionDialog != null && this.questionDialog.isShowing()) {
            this.questionDialog.dismiss();
        }
    }

    private void updateDate(int[] creditTypes) {
        if (this.list != null) {
            this.list.clear();
        } else {
            this.list = new ArrayList<QuestionInfo>();
        }
        for (int type : creditTypes) {
            this.list.add(new QuestionInfo(type));
        }
        if (this.questionDialog != null) {
            this.questionDialog.setData(this.list);
        }
    }

    private void showJumpFaqDialog(final Context context) {
        if (this.jumpFaqDialog == null) {
            this.jumpFaqDialog = new JumpFaqDialog(context, new FaqClickListener(){

                @Override
                public void onClick(int type, String feedback) {
                    QuestionPresent.this.jumpFaqDialog.dismiss();
                    RechargeHiidoReport.thinkPopFaqClick();
                    if (type == 5) {
                        ToastUtils.showToast((Context)context, (int)R.string.short_tips_jump_faq);
                        QuestionPresent.this.jumpToFAQ(type);
                    } else if (type == 0) {
                        QuestionPresent.this.closeDialog();
                        ToastUtils.showToast((Context)context, (int)R.string.short_tips_jump_faq);
                        QuestionPresent.this.jumpToFAQ(type);
                    }
                }

                @Override
                public void onDismiss() {
                    QuestionPresent.this.finishCallback(QuestionPresent.this.callback);
                    RechargeHiidoReport.thinkPopDismiss();
                }
            });
        }
        this.jumpFaqDialog.hiddenFAQ();
        this.jumpFaqDialog.show();
        RechargeHiidoReport.thinkPopShow();
    }

    private void showOtherQuestionDialog(final Context context, final IHandlerCallback callback) {
        if (this.otherQuestionDialog == null) {
            this.otherQuestionDialog = new OtherQuestionDialog(context, new FaqClickListener(){

                @Override
                public void onClick(int type, String feedback) {
                    Message message = new Message();
                    Bundle bundle = new Bundle();
                    bundle.putString("feedback_content", feedback);
                    message.what = BaseMsgDef.MSG_FEED_BACK;
                    message.arg1 = type;
                    message.setData(bundle);
                    message.obj = new FeedbackCallBack(){

                        public void onSuccess() {
                            QuestionPresent.this.showJumpFaqDialog(context);
                            YYTaskExecutor.postToMainThread((Runnable)QuestionPresent.this.closeWindowRunnable, (long)2000L);
                        }

                        public void onError(int code, String msg) {
                        }
                    };
                    if (QuestionPresent.this.otherQuestionDialog != null && QuestionPresent.this.otherQuestionDialog.isShowing()) {
                        QuestionPresent.this.otherQuestionDialog.dismiss();
                    }
                    MsgDispatcher.getInstance().sendMessage(message);
                    RechargeHiidoReport.otherQuePopSubmit();
                }

                @Override
                public void onDismiss() {
                    QuestionPresent.this.finishCallback(callback);
                    RechargeHiidoReport.otherQuePopDismiss();
                }
            });
        }
        RechargeHiidoReport.otherQuePopShow();
        this.otherQuestionDialog.show();
    }

    public void destroy() {
        if (this.questionDialog != null) {
            this.hideDialog(this.questionDialog);
            this.questionDialog = null;
        }
        if (this.otherQuestionDialog != null) {
            this.hideDialog(this.otherQuestionDialog);
            this.otherQuestionDialog.hide();
            this.otherQuestionDialog = null;
        }
        if (this.jumpFaqDialog != null) {
            this.hideDialog(this.jumpFaqDialog);
            this.jumpFaqDialog.hide();
            this.jumpFaqDialog = null;
        }
    }

    private void hideDialog(YYDialog dialog2) {
        if (dialog2 != null && dialog2.isShowing()) {
            dialog2.hide();
        }
    }

    private void finishCallback(final IHandlerCallback callback) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onHandlerFinished(this);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onHandlerFinished(QuestionPresent.this);
                }
            });
        }
    }
}

