/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.platform.gp.billing;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.hago.billingclient.api.AcknowledgePurchaseParams;
import com.hago.billingclient.api.AcknowledgePurchaseResponseListener;
import com.hago.billingclient.api.BillingClient;
import com.hago.billingclient.api.BillingClientStateListener;
import com.hago.billingclient.api.BillingFlowParams;
import com.hago.billingclient.api.BillingResult;
import com.hago.billingclient.api.ConsumeParams;
import com.hago.billingclient.api.ConsumeResponseListener;
import com.hago.billingclient.api.Purchase;
import com.hago.billingclient.api.PurchasesUpdatedListener;
import com.hago.billingclient.api.SkuDetails;
import com.hago.billingclient.api.SkuDetailsParams;
import com.hago.billingclient.api.SkuDetailsResponseListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.billing.base.ISkuDetailsCallback;
import com.yy.billing.base.PurchaseInfo;
import com.yy.billing.base.SkuDetailsInfo;
import com.yy.hiyo.wallet.pay.platform.gp.billing.BillingWrapperUpdate;
import com.yy.socialplatformbase.platform.google.billing.IConsumeCallback;
import com.yy.socialplatformbase.platform.google.billing.IGooglePay;
import com.yy.socialplatformbase.platform.google.billing.IPayConnectCallback;
import com.yy.socialplatformbase.platform.google.billing.IPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.IQueryPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.PurchaseParams;
import com.yy.socialplatformbase.platform.google.billing.QueryDetailsParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u001c\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u0018\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J(\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\u0004H\u0002J(\u0010!\u001a\u00020\f2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020%H\u0002J(\u0010&\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\u001e2\u0006\u0010\u000e\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020\u0011H\u0016J\"\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u00100\u001a\u00020\f2\u0006\u0010/\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\u001a\u00101\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010%H\u0016J\u001a\u00102\u001a\u00020\f2\u0006\u00103\u001a\u0002042\b\u0010\u000e\u001a\u0004\u0018\u00010)H\u0016J\u0012\u00105\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/yy/hiyo/wallet/pay/platform/gp/billing/BillingWrapperUpdate;", "Lcom/yy/socialplatformbase/platform/google/billing/IGooglePay;", "()V", "TAG", "", "mBillingClient", "Lcom/hago/billingclient/api/BillingClient;", "mPurchaseCallbackMap", "", "Lcom/yy/socialplatformbase/platform/google/billing/PurchaseParams;", "Lcom/yy/socialplatformbase/platform/google/billing/IPurchaseCallback;", "acknowledgePurchase", "", "token", "callback", "Lcom/yy/socialplatformbase/platform/google/billing/IConsumeCallback;", "checkProductId", "", "productId", "checkState", "checkToken", "purchaseToken", "checkType", "type", "consume", "endConnect", "handlePurchaseResponse", "result", "Lcom/hago/billingclient/api/BillingResult;", "purchases", "", "Lcom/hago/billingclient/api/Purchase;", "customPayload", "handleQuery", "purchasesList", "responseCode", "", "Lcom/yy/socialplatformbase/platform/google/billing/IQueryPurchaseCallback;", "handleQueryDetails", "skuDetailsList", "Lcom/hago/billingclient/api/SkuDetails;", "Lcom/yy/billing/base/ISkuDetailsCallback;", "handleQueryPurchase", "isReady", "purchase", "activity", "Landroid/app/Activity;", "param", "putPurchase", "queryPurchase", "querySkuDetails", "params", "Lcom/yy/socialplatformbase/platform/google/billing/QueryDetailsParam;", "startConnect", "Lcom/yy/socialplatformbase/platform/google/billing/IPayConnectCallback;", "transformSku", "Lcom/yy/billing/base/SkuDetailsInfo;", "details", "wallet_billDebug"})
public final class BillingWrapperUpdate
implements IGooglePay {
    private final String TAG = "FTPayGoogleSdkBillingWrapper";
    private BillingClient mBillingClient;
    private Map<PurchaseParams, IPurchaseCallback> mPurchaseCallbackMap;

    public void startConnect(@Nullable IPayConnectCallback callback) {
        boolean ready = this.isReady();
        MLog.info((Object)this.TAG, (String)"startConnect ready: %b", (Object[])new Object[]{ready});
        if (ready) {
            IPayConnectCallback iPayConnectCallback = callback;
            if (iPayConnectCallback != null) {
                iPayConnectCallback.onPaySetupFinished(0);
            }
            return;
        }
        BillingClient billingClient = this.mBillingClient;
        if (billingClient == null) {
            Intrinsics.throwNpe();
        }
        billingClient.startConnection(new BillingClientStateListener(this, callback){
            final /* synthetic */ BillingWrapperUpdate this$0;
            final /* synthetic */ IPayConnectCallback $callback;

            public void onBillingSetupFinished(@NotNull BillingResult result) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                    MLog.info((Object)BillingWrapperUpdate.access$getTAG$p(this.this$0), (String)"startConnect onBillingSetupFinished responseCode: %d, msg: %s", (Object[])new Object[]{result.getResponseCode(), result.getDebugMessage()});
                    IPayConnectCallback iPayConnectCallback = this.$callback;
                    if (iPayConnectCallback == null) break block0;
                    iPayConnectCallback.onPaySetupFinished(result.getResponseCode());
                }
            }

            public void onBillingServiceDisconnected() {
                block0: {
                    MLog.info((Object)BillingWrapperUpdate.access$getTAG$p(this.this$0), (String)"onBillingServiceDisconnected", (Object[])new Object[0]);
                    this.this$0.endConnect();
                    IPayConnectCallback iPayConnectCallback = this.$callback;
                    if (iPayConnectCallback == null) break block0;
                    iPayConnectCallback.onPayDisconnected();
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    public void endConnect() {
        MLog.info((Object)this.TAG, (String)"endConnect mBillingClient == null : %b", (Object[])new Object[]{this.mBillingClient == null});
        if (this.mBillingClient != null) {
            BillingClient billingClient = this.mBillingClient;
            if (billingClient == null) {
                Intrinsics.throwNpe();
            }
            billingClient.endConnection();
        }
        this.mBillingClient = null;
    }

    public void purchase(@NotNull Activity activity, @NotNull PurchaseParams param, @Nullable IPurchaseCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        MLog.info((Object)this.TAG, (String)"purchase param: %s", (Object[])new Object[]{param});
        String string2 = param.getProductId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"param.productId");
        if (this.checkProductId(string2, callback)) {
            String string3 = param.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"param.type");
            if (this.checkType(string3, callback)) {
                BillingResult result;
                if (!this.checkState()) {
                    IPurchaseCallback iPurchaseCallback = callback;
                    if (iPurchaseCallback != null) {
                        iPurchaseCallback.onPurchasesUpdated(1002, null);
                    }
                    return;
                }
                String skuJson = param.getSkuDetails();
                if (TextUtils.isEmpty((CharSequence)skuJson)) {
                    IPurchaseCallback iPurchaseCallback = callback;
                    if (iPurchaseCallback != null) {
                        iPurchaseCallback.onPurchasesUpdated(1005, null);
                    }
                    return;
                }
                SkuDetails sku = new SkuDetails(skuJson);
                BillingFlowParams.Builder flowParams = BillingFlowParams.newBuilder().setSkuDetails(sku).setDeveloperId(param.getPayload()).setOldSkus(null);
                if (!TextUtils.isEmpty((CharSequence)param.getAccountId())) {
                    flowParams.setAccountId(param.getAccountId());
                }
                BillingClient billingClient = this.mBillingClient;
                if (billingClient == null) {
                    Intrinsics.throwNpe();
                }
                BillingResult billingResult = result = billingClient.launchBillingFlow(activity, flowParams.build());
                Intrinsics.checkExpressionValueIsNotNull((Object)billingResult, (String)"result");
                if (billingResult.getResponseCode() != 0) {
                    IPurchaseCallback iPurchaseCallback = callback;
                    if (iPurchaseCallback != null) {
                        iPurchaseCallback.onPurchasesUpdated(result.getResponseCode(), null);
                    }
                } else {
                    this.putPurchase(param, callback);
                }
            }
        }
    }

    public void consume(@Nullable String token, @Nullable IConsumeCallback callback) {
        MLog.info((Object)this.TAG, (String)"consume purchaseToken: %s", (Object[])new Object[]{token});
        if (this.checkToken(token, callback)) {
            if (!this.checkState()) {
                IConsumeCallback iConsumeCallback = callback;
                if (iConsumeCallback != null) {
                    iConsumeCallback.onConsumeResponse(1002, null);
                }
                return;
            }
            ConsumeParams param = ConsumeParams.newBuilder().setPurchaseToken(token).build();
            BillingClient billingClient = this.mBillingClient;
            if (billingClient == null) {
                Intrinsics.throwNpe();
            }
            billingClient.consumeAsync(param, new ConsumeResponseListener(callback){
                final /* synthetic */ IConsumeCallback $callback;

                public final void onConsumeResponse(BillingResult result, String purchaseToken) {
                    block0: {
                        IConsumeCallback iConsumeCallback = this.$callback;
                        if (iConsumeCallback == null) break block0;
                        BillingResult billingResult = result;
                        Intrinsics.checkExpressionValueIsNotNull((Object)billingResult, (String)"result");
                        iConsumeCallback.onConsumeResponse(billingResult.getResponseCode(), purchaseToken);
                    }
                }
                {
                    this.$callback = iConsumeCallback;
                }
            });
        }
    }

    public void acknowledgePurchase(@Nullable String token, @Nullable IConsumeCallback callback) {
        MLog.info((Object)this.TAG, (String)"acknowledgePurchase purchaseToken: %s", (Object[])new Object[]{token});
        if (this.checkToken(token, callback)) {
            if (!this.checkState()) {
                IConsumeCallback iConsumeCallback = callback;
                if (iConsumeCallback != null) {
                    iConsumeCallback.onConsumeResponse(1002, null);
                }
                return;
            }
            AcknowledgePurchaseParams param = AcknowledgePurchaseParams.newBuilder().setPurchaseToken(token).build();
            BillingClient billingClient = this.mBillingClient;
            if (billingClient == null) {
                Intrinsics.throwNpe();
            }
            billingClient.acknowledgePurchase(param, new AcknowledgePurchaseResponseListener(callback, token){
                final /* synthetic */ IConsumeCallback $callback;
                final /* synthetic */ String $token;

                public final void onAcknowledgePurchaseResponse(BillingResult result) {
                    block0: {
                        IConsumeCallback iConsumeCallback = this.$callback;
                        if (iConsumeCallback == null) break block0;
                        BillingResult billingResult = result;
                        Intrinsics.checkExpressionValueIsNotNull((Object)billingResult, (String)"result");
                        iConsumeCallback.onConsumeResponse(billingResult.getResponseCode(), this.$token);
                    }
                }
                {
                    this.$callback = iConsumeCallback;
                    this.$token = string2;
                }
            });
        }
    }

    public void queryPurchase(@NotNull String type, @Nullable IQueryPurchaseCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (callback == null) {
            return;
        }
        if (!this.checkState()) {
            callback.onPurchaseHistory(1002, null);
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(this, type, callback){
            final /* synthetic */ BillingWrapperUpdate this$0;
            final /* synthetic */ String $type;
            final /* synthetic */ IQueryPurchaseCallback $callback;

            public final void run() {
                try {
                    BillingWrapperUpdate.access$handleQueryPurchase(this.this$0, this.$type, this.$callback);
                }
                catch (Exception e) {
                    MLog.error((Object)BillingWrapperUpdate.access$getTAG$p(this.this$0), (Throwable)e);
                    this.$callback.onPurchaseHistory(1004, null);
                }
            }
            {
                this.this$0 = billingWrapperUpdate;
                this.$type = string2;
                this.$callback = iQueryPurchaseCallback;
            }
        });
    }

    private final void handleQueryPurchase(String type, IQueryPurchaseCallback callback) {
        Purchase.PurchasesResult result;
        BillingClient billingClient = this.mBillingClient;
        if (billingClient == null) {
            Intrinsics.throwNpe();
        }
        if ((result = billingClient.queryPurchases(type)) == null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(callback){
                final /* synthetic */ IQueryPurchaseCallback $callback;

                public final void run() {
                    this.$callback.onPurchaseHistory(3, null);
                }
                {
                    this.$callback = iQueryPurchaseCallback;
                }
            });
        }
        Purchase.PurchasesResult purchasesResult = result;
        if (purchasesResult == null) {
            Intrinsics.throwNpe();
        }
        List purchasesList = purchasesResult.getPurchasesList();
        int responseCode = result.getResponseCode();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, purchasesList, responseCode, callback){
            final /* synthetic */ BillingWrapperUpdate this$0;
            final /* synthetic */ List $purchasesList;
            final /* synthetic */ int $responseCode;
            final /* synthetic */ IQueryPurchaseCallback $callback;

            public final void run() {
                BillingWrapperUpdate.access$handleQuery(this.this$0, this.$purchasesList, this.$responseCode, this.$callback);
            }
            {
                this.this$0 = billingWrapperUpdate;
                this.$purchasesList = list;
                this.$responseCode = n;
                this.$callback = iQueryPurchaseCallback;
            }
        });
    }

    public void querySkuDetails(@NotNull QueryDetailsParam params, @Nullable ISkuDetailsCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (callback == null) {
            return;
        }
        if (!this.checkState()) {
            callback.onResponse(1002, null);
            return;
        }
        SkuDetailsParams p = SkuDetailsParams.newBuilder().setType(params.getSkuType()).setSkusList(params.getSkuList()).build();
        BillingClient billingClient = this.mBillingClient;
        if (billingClient == null) {
            Intrinsics.throwNpe();
        }
        billingClient.querySkuDetailsAsync(p, new SkuDetailsResponseListener(this, callback){
            final /* synthetic */ BillingWrapperUpdate this$0;
            final /* synthetic */ ISkuDetailsCallback $callback;

            public final void onSkuDetailsResponse(BillingResult result, List<SkuDetails> skuDetailsList) {
                YYTaskExecutor.execute((Runnable)new Runnable(this, result, skuDetailsList){
                    final /* synthetic */ querySkuDetails.1 this$0;
                    final /* synthetic */ BillingResult $result;
                    final /* synthetic */ List $skuDetailsList;

                    public final void run() {
                        try {
                            BillingWrapperUpdate billingWrapperUpdate = this.this$0.this$0;
                            BillingResult billingResult = this.$result;
                            Intrinsics.checkExpressionValueIsNotNull((Object)billingResult, (String)"result");
                            BillingWrapperUpdate.access$handleQueryDetails(billingWrapperUpdate, billingResult, this.$skuDetailsList, this.this$0.$callback);
                        }
                        catch (Exception e) {
                            MLog.error((Object)BillingWrapperUpdate.access$getTAG$p(this.this$0.this$0), (Throwable)e);
                            this.this$0.$callback.onResponse(1004, null);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = billingResult;
                        this.$skuDetailsList = list;
                    }
                });
            }
            {
                this.this$0 = billingWrapperUpdate;
                this.$callback = iSkuDetailsCallback;
            }
        });
    }

    private final void handleQueryDetails(BillingResult result, List<? extends SkuDetails> skuDetailsList, ISkuDetailsCallback callback) {
        List list = null;
        if (skuDetailsList != null) {
            Collection collection = skuDetailsList;
            boolean bl = false;
            if (!collection.isEmpty()) {
                list = new ArrayList(skuDetailsList.size());
                for (SkuDetails skuDetails : skuDetailsList) {
                    list.add(this.transformSku(skuDetails));
                }
            }
        }
        List list2 = list;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(callback, result, list2){
            final /* synthetic */ ISkuDetailsCallback $callback;
            final /* synthetic */ BillingResult $result;
            final /* synthetic */ List $finalList;

            public final void run() {
                this.$callback.onResponse(this.$result.getResponseCode(), this.$finalList);
            }
            {
                this.$callback = iSkuDetailsCallback;
                this.$result = billingResult;
                this.$finalList = list;
            }
        });
    }

    private final SkuDetailsInfo transformSku(SkuDetails details) {
        return new SkuDetailsInfo.Builder().productId(details.getSku()).type(details.getType()).price(details.getPrice()).priceAmountMicros(Long.valueOf(details.getPriceAmountMicros())).priceCurrencyCode(details.getPriceCurrencyCode()).title(details.getTitle()).description(details.getDescription()).subscriptionPeriod(details.getSubscriptionPeriod()).freeTrialPeriod(details.getFreeTrialPeriod()).introductoryPrice(details.getIntroductoryPrice()).introductoryPriceAmountMicros(Long.valueOf(StringUtils.safeParseLong((String)String.valueOf(details.getIntroductoryPriceAmountMicros())))).introductoryPricePeriod(details.getIntroductoryPricePeriod()).introductoryPriceCycles(Integer.valueOf(StringUtils.safeParseInt((String)details.getIntroductoryPriceCycles()))).originalJson(details.getOriginalJson()).build();
    }

    private final void handleQuery(List<? extends Purchase> purchasesList, int responseCode, IQueryPurchaseCallback callback) {
        if (purchasesList == null) {
            callback.onPurchaseHistory(responseCode, null);
        } else {
            List list = new ArrayList(purchasesList.size());
            for (Purchase purchase : purchasesList) {
                PurchaseInfo info;
                if (purchase == null) continue;
                PurchaseInfo purchaseInfo = info = PurchaseInfo.newBuilder((String)purchase.getSignature(), (String)purchase.getOriginalJson()).orderId(purchase.getOrderId()).purchaseTime(purchase.getPurchaseTime()).purchaseToken(purchase.getPurchaseToken()).productId(purchase.getSku()).payload(purchase.getDeveloperPayload()).isAcknowledged(purchase.isAcknowledged()).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)purchaseInfo, (String)"info");
                list.add(purchaseInfo);
            }
            callback.onPurchaseHistory(responseCode, list);
        }
    }

    public boolean isReady() {
        boolean bl;
        if (this.mBillingClient != null) {
            BillingClient billingClient = this.mBillingClient;
            if (billingClient == null) {
                Intrinsics.throwNpe();
            }
            bl = billingClient.isReady();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void handlePurchaseResponse(BillingResult result, List<? extends Purchase> purchases, String customPayload) {
        block16: {
            block15: {
                if (this.mPurchaseCallbackMap == null) break block15;
                Map<PurchaseParams, IPurchaseCallback> map = this.mPurchaseCallbackMap;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                if (!map.isEmpty()) break block16;
            }
            MLog.error((Object)this.TAG, (String)"handlePurchaseResponse mPurchaseCallbackMap is empty, responseCode: %d, msg: %s, customPayload: %s", (Object[])new Object[]{result.getResponseCode(), result.getDebugMessage(), customPayload});
            return;
        }
        if (purchases == null || purchases.isEmpty()) {
            MLog.error((Object)this.TAG, (String)"handlePurchaseResponse purchases is empty, responseCode: %d, msg: %s, customPayload: %s", (Object[])new Object[]{result.getResponseCode(), result.getDebugMessage(), customPayload});
            if (this.mPurchaseCallbackMap != null && !TextUtils.isEmpty((CharSequence)customPayload)) {
                void var4_6;
                PurchaseParams purchaseParams = null;
                Map<PurchaseParams, IPurchaseCallback> map = this.mPurchaseCallbackMap;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                for (PurchaseParams p : map.keySet()) {
                    if (p == null || !Intrinsics.areEqual((Object)customPayload, (Object)p.getPayload())) continue;
                    PurchaseParams purchaseParams2 = p;
                    break;
                }
                if (var4_6 != null) {
                    IPurchaseCallback callback;
                    Map<PurchaseParams, IPurchaseCallback> map2 = this.mPurchaseCallbackMap;
                    if (map2 == null) {
                        Intrinsics.throwNpe();
                    }
                    IPurchaseCallback iPurchaseCallback = callback = map2.remove(var4_6);
                    if (iPurchaseCallback != null) {
                        iPurchaseCallback.onPurchasesUpdated(result.getResponseCode(), null);
                    }
                }
            }
            return;
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = result.getResponseCode();
        objectArray[1] = result.getDebugMessage();
        objectArray[2] = purchases.size();
        Map<PurchaseParams, IPurchaseCallback> map = this.mPurchaseCallbackMap;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        objectArray[3] = map.size();
        objectArray[4] = customPayload;
        MLog.info((Object)this.TAG, (String)"handlePurchaseResponse responseCode: %d, msg: %s, purchases.size: %d mPurchaseCallbackMap.size: %d, customPayload: %s", (Object[])objectArray);
        for (Purchase purchase : purchases) {
            IPurchaseCallback callback;
            if (purchase == null) continue;
            PurchaseParams rp = new PurchaseParams("", purchase.getSku(), purchase.getDeveloperPayload());
            Map<PurchaseParams, IPurchaseCallback> map3 = this.mPurchaseCallbackMap;
            if (map3 == null) {
                Intrinsics.throwNpe();
            }
            if ((callback = map3.remove(rp)) != null) {
                PurchaseInfo info = PurchaseInfo.newBuilder((String)purchase.getSignature(), (String)purchase.getOriginalJson()).orderId(purchase.getOrderId()).purchaseTime(purchase.getPurchaseTime()).purchaseToken(purchase.getPurchaseToken()).productId(rp.getProductId()).payload(rp.getPayload()).isAcknowledged(purchase.isAcknowledged()).build();
                callback.onPurchasesUpdated(result.getResponseCode(), info);
                continue;
            }
            MLog.info((Object)this.TAG, (String)"handlePurchaseResponse can not found callback, consume it", (Object[])new Object[0]);
        }
    }

    private final synchronized void putPurchase(PurchaseParams param, IPurchaseCallback callback) {
        if (callback != null) {
            if (this.mPurchaseCallbackMap == null) {
                this.mPurchaseCallbackMap = new HashMap();
            }
            Map<PurchaseParams, IPurchaseCallback> map = this.mPurchaseCallbackMap;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            map.put(param, callback);
        }
    }

    private final boolean checkType(String type, IPurchaseCallback callback) {
        block2: {
            if (Intrinsics.areEqual((Object)"inapp", (Object)type) || Intrinsics.areEqual((Object)"subs", (Object)type)) {
                return true;
            }
            String msg = "purchase type must be 'inapp' or 'subs'";
            boolean bl = !RuntimeContext.sIsDebuggable;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = msg;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            MLog.error((Object)this.TAG, (String)msg, (Object[])new Object[0]);
            IPurchaseCallback iPurchaseCallback = callback;
            if (iPurchaseCallback == null) break block2;
            iPurchaseCallback.onPurchasesUpdated(1001, null);
        }
        return false;
    }

    private final boolean checkProductId(String productId, IPurchaseCallback callback) {
        if (TextUtils.isEmpty((CharSequence)productId)) {
            String msg = "purchase productId can not be empty, it may be sku that create in google play console";
            boolean bl = !RuntimeContext.sIsDebuggable;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = msg;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            MLog.error((Object)this.TAG, (String)msg, (Object[])new Object[0]);
            IPurchaseCallback iPurchaseCallback = callback;
            if (iPurchaseCallback != null) {
                iPurchaseCallback.onPurchasesUpdated(1001, null);
            }
            return false;
        }
        return true;
    }

    private final boolean checkToken(String purchaseToken, IConsumeCallback callback) {
        if (TextUtils.isEmpty((CharSequence)purchaseToken)) {
            String msg = "consume purchaseToken can not be empty";
            boolean bl = !RuntimeContext.sIsDebuggable;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = msg;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            MLog.error((Object)this.TAG, (String)msg, (Object[])new Object[0]);
            IConsumeCallback iConsumeCallback = callback;
            if (iConsumeCallback != null) {
                iConsumeCallback.onConsumeResponse(1001, purchaseToken);
            }
            return false;
        }
        return true;
    }

    private final boolean checkState() {
        if (this.mBillingClient == null && !this.isReady()) {
            String msg = "billing service is not ready, you must call startConnect before";
            boolean bl = !RuntimeContext.sIsDebuggable;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = msg;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            MLog.error((Object)this.TAG, (String)msg, (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public BillingWrapperUpdate() {
        PurchasesUpdatedListener mPurchasesUpdatedListener2 = new PurchasesUpdatedListener(this){
            final /* synthetic */ BillingWrapperUpdate this$0;

            public final void onPurchasesUpdated(BillingResult result, @Nullable List<Purchase> purchases, String customPayload) {
                BillingResult billingResult = result;
                Intrinsics.checkExpressionValueIsNotNull((Object)billingResult, (String)"result");
                String string2 = customPayload;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"customPayload");
                BillingWrapperUpdate.access$handlePurchaseResponse(this.this$0, billingResult, purchases, string2);
            }
            {
                this.this$0 = billingWrapperUpdate;
            }
        };
        this.mBillingClient = BillingClient.newBuilder((Context)RuntimeContext.sApplicationContext).setListener(mPurchasesUpdatedListener2).enablePendingPurchases().build();
    }

    public static final /* synthetic */ String access$getTAG$p(BillingWrapperUpdate $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$handleQueryPurchase(BillingWrapperUpdate $this, String type, IQueryPurchaseCallback callback) {
        $this.handleQueryPurchase(type, callback);
    }

    public static final /* synthetic */ void access$handleQuery(BillingWrapperUpdate $this, List purchasesList, int responseCode, IQueryPurchaseCallback callback) {
        $this.handleQuery(purchasesList, responseCode, callback);
    }

    public static final /* synthetic */ void access$handleQueryDetails(BillingWrapperUpdate $this, BillingResult result, List skuDetailsList, ISkuDetailsCallback callback) {
        $this.handleQueryDetails(result, skuDetailsList, callback);
    }

    public static final /* synthetic */ void access$handlePurchaseResponse(BillingWrapperUpdate $this, BillingResult result, List purchases, String customPayload) {
        $this.handlePurchaseResponse(result, purchases, customPayload);
    }
}

