/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.platform.gp.billing;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.billing.base.ISkuDetailsCallback;
import com.yy.billing.base.PurchaseInfo;
import com.yy.billing.base.SkuDetailsInfo;
import com.yy.hiyo.billingclient.api.BillingClient;
import com.yy.hiyo.billingclient.api.BillingClientStateListener;
import com.yy.hiyo.billingclient.api.BillingFlowParams;
import com.yy.hiyo.billingclient.api.ConsumeResponseListener;
import com.yy.hiyo.billingclient.api.Purchase;
import com.yy.hiyo.billingclient.api.PurchasesUpdatedListener;
import com.yy.hiyo.billingclient.api.SkuDetails;
import com.yy.hiyo.billingclient.api.SkuDetailsParams;
import com.yy.hiyo.billingclient.api.SkuDetailsResponseListener;
import com.yy.socialplatformbase.platform.google.billing.IConsumeCallback;
import com.yy.socialplatformbase.platform.google.billing.IGooglePay;
import com.yy.socialplatformbase.platform.google.billing.IPayConnectCallback;
import com.yy.socialplatformbase.platform.google.billing.IPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.IQueryPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.PurchaseParams;
import com.yy.socialplatformbase.platform.google.billing.QueryDetailsParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BillingWrapper
implements IGooglePay {
    private static final String TAG = "FTPayGoogleSdkBillingWrapper";
    private BillingClient mBillingClient;
    private Map<PurchaseParams, IPurchaseCallback> mPurchaseCallbackMap;

    public BillingWrapper() {
        PurchasesUpdatedListener mPurchasesUpdatedListener2 = new PurchasesUpdatedListener(){

            public void onPurchasesUpdated(int responseCode, @Nullable List<Purchase> purchases, String customPayload) {
                BillingWrapper.this.handlePurchaseResponse(responseCode, purchases, customPayload);
            }
        };
        this.mBillingClient = BillingClient.newBuilder((Context)RuntimeContext.sApplicationContext).setListener(mPurchasesUpdatedListener2).build();
    }

    public void startConnect(final IPayConnectCallback callback) {
        boolean ready = this.isReady();
        MLog.info((Object)TAG, (String)"startConnect ready: %b", (Object[])new Object[]{ready});
        if (ready) {
            if (callback != null) {
                callback.onPaySetupFinished(0);
            }
            return;
        }
        this.mBillingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(int responseCode) {
                MLog.info((Object)BillingWrapper.TAG, (String)"startConnect onBillingSetupFinished responseCode: %d", (Object[])new Object[]{responseCode});
                if (callback != null) {
                    callback.onPaySetupFinished(responseCode);
                }
            }

            public void onBillingServiceDisconnected() {
                MLog.info((Object)BillingWrapper.TAG, (String)"onBillingServiceDisconnected", (Object[])new Object[0]);
                BillingWrapper.this.endConnect();
                if (callback != null) {
                    callback.onPayDisconnected();
                }
            }
        });
    }

    public void endConnect() {
        MLog.info((Object)TAG, (String)"endConnect mBillingClient == null : %b", (Object[])new Object[]{this.mBillingClient == null});
        if (this.mBillingClient != null) {
            this.mBillingClient.endConnection();
        }
        this.mBillingClient = null;
    }

    public void purchase(@NonNull Activity activity, @NonNull PurchaseParams param, IPurchaseCallback callback) {
        MLog.info((Object)TAG, (String)"purchase param: %s", (Object[])new Object[]{param});
        if (this.checkProductId(param.getProductId(), callback) && this.checkType(param.getType(), callback)) {
            int result;
            if (!this.checkState()) {
                if (callback != null) {
                    callback.onPurchasesUpdated(1002, null);
                }
                return;
            }
            BillingFlowParams.Builder flowParams = BillingFlowParams.newBuilder().setType(param.getType()).setSku(param.getProductId()).setOldSkus(null);
            if (!TextUtils.isEmpty((CharSequence)param.getAccountId())) {
                flowParams.setAccountId(param.getAccountId());
            }
            if ((result = this.mBillingClient.launchBillingFlow(activity, flowParams.build(), param.getPayload())) != 0) {
                if (callback != null) {
                    callback.onPurchasesUpdated(result, null);
                }
            } else {
                this.putPurchase(param, callback);
            }
        }
    }

    public void consume(String purchaseToken, final IConsumeCallback callback) {
        MLog.info((Object)TAG, (String)"consume purchaseToken: %s", (Object[])new Object[]{purchaseToken});
        if (this.checkToken(purchaseToken, callback)) {
            if (!this.checkState()) {
                if (callback != null) {
                    callback.onConsumeResponse(1002, null);
                }
                return;
            }
            this.mBillingClient.consumeAsync(purchaseToken, new ConsumeResponseListener(){

                public void onConsumeResponse(int responseCode, String purchaseToken) {
                    if (callback != null) {
                        callback.onConsumeResponse(responseCode, purchaseToken);
                    }
                }
            });
        }
    }

    public void acknowledgePurchase(String purchaseToken, IConsumeCallback callback) {
        if (callback != null) {
            callback.onConsumeResponse(0, purchaseToken);
        }
    }

    public void queryPurchase(final String type, final IQueryPurchaseCallback callback) {
        if (callback == null) {
            return;
        }
        if (!this.checkState()) {
            callback.onPurchaseHistory(1002, null);
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    BillingWrapper.this.handleQueryPurchase(type, callback);
                }
                catch (Exception e) {
                    MLog.error((Object)BillingWrapper.TAG, (Throwable)e);
                    callback.onPurchaseHistory(1004, null);
                }
            }
        });
    }

    private void handleQueryPurchase(String type, final IQueryPurchaseCallback callback) {
        Purchase.PurchasesResult result = this.mBillingClient.queryPurchases(type);
        if (result == null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onPurchaseHistory(3, null);
                }
            });
        }
        final List purchasesList = result.getPurchasesList();
        final int responseCode = result.getResponseCode();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                BillingWrapper.this.handleQuery(purchasesList, responseCode, callback);
            }
        });
    }

    public void querySkuDetails(QueryDetailsParam params, final ISkuDetailsCallback callback) {
        if (callback == null) {
            return;
        }
        if (!this.checkState()) {
            callback.onResponse(1002, null);
            return;
        }
        SkuDetailsParams p = SkuDetailsParams.newBuilder().setType(params.getSkuType()).setSkusList(params.getSkuList()).build();
        this.mBillingClient.querySkuDetailsAsync(p, new SkuDetailsResponseListener(){

            public void onSkuDetailsResponse(final int responseCode, final List<SkuDetails> skuDetailsList) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BillingWrapper.this.handleQueryDetails(responseCode, skuDetailsList, callback);
                        }
                        catch (Exception e) {
                            MLog.error((Object)BillingWrapper.TAG, (Throwable)e);
                            callback.onResponse(1004, null);
                        }
                    }
                });
            }
        });
    }

    private void handleQueryDetails(final int responseCode, List<SkuDetails> skuDetailsList, final ISkuDetailsCallback callback) {
        ArrayList<SkuDetailsInfo> list = null;
        if (skuDetailsList != null && !skuDetailsList.isEmpty()) {
            list = new ArrayList<SkuDetailsInfo>(skuDetailsList.size());
            for (SkuDetails detail : skuDetailsList) {
                list.add(BillingWrapper.transformSku(detail));
            }
        }
        final ArrayList<SkuDetailsInfo> finalList = list;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                callback.onResponse(responseCode, finalList);
            }
        });
    }

    private static SkuDetailsInfo transformSku(SkuDetails details) {
        return new SkuDetailsInfo.Builder().productId(details.getSku()).type(details.getType()).price(details.getPrice()).priceAmountMicros(Long.valueOf(details.getPriceAmountMicros())).priceCurrencyCode(details.getPriceCurrencyCode()).title(details.getTitle()).description(details.getDescription()).subscriptionPeriod(details.getSubscriptionPeriod()).freeTrialPeriod(details.getFreeTrialPeriod()).introductoryPrice(details.getIntroductoryPrice()).introductoryPriceAmountMicros(Long.valueOf(StringUtils.safeParseLong((String)details.getIntroductoryPriceAmountMicros()))).introductoryPricePeriod(details.getIntroductoryPricePeriod()).introductoryPriceCycles(Integer.valueOf(StringUtils.safeParseInt((String)details.getIntroductoryPriceCycles()))).originalJson(details.getOriginalJson()).build();
    }

    private void handleQuery(List<Purchase> purchasesList, int responseCode, IQueryPurchaseCallback callback) {
        if (purchasesList == null) {
            callback.onPurchaseHistory(responseCode, null);
        } else {
            ArrayList<PurchaseInfo> list = new ArrayList<PurchaseInfo>(purchasesList.size());
            for (Purchase p : purchasesList) {
                if (p == null) continue;
                PurchaseInfo info = PurchaseInfo.newBuilder((String)p.getSignature(), (String)p.getOriginalJson()).orderId(p.getOrderId()).purchaseTime(p.getPurchaseTime()).purchaseToken(p.getPurchaseToken()).productId(p.getSku()).payload(p.getPayload()).build();
                list.add(info);
            }
            callback.onPurchaseHistory(responseCode, list);
        }
    }

    public boolean isReady() {
        if (this.mBillingClient != null) {
            return this.mBillingClient.isReady();
        }
        return false;
    }

    private synchronized void handlePurchaseResponse(int responseCode, @Nullable List<Purchase> purchases, String customPayload) {
        if (this.mPurchaseCallbackMap == null || this.mPurchaseCallbackMap.isEmpty()) {
            MLog.error((Object)TAG, (String)"handlePurchaseResponse mPurchaseCallbackMap is empty, responseCode: %d, customPayload: %s", (Object[])new Object[]{responseCode, customPayload});
            return;
        }
        if (purchases == null || purchases.isEmpty()) {
            MLog.error((Object)TAG, (String)"handlePurchaseResponse purchases is empty, responseCode: %d, customPayload: %s", (Object[])new Object[]{responseCode, customPayload});
            if (this.mPurchaseCallbackMap != null && !TextUtils.isEmpty((CharSequence)customPayload)) {
                IPurchaseCallback callback;
                PurchaseParams param = null;
                for (PurchaseParams p : this.mPurchaseCallbackMap.keySet()) {
                    if (p == null || !customPayload.equals(p.getPayload())) continue;
                    param = p;
                    break;
                }
                if (param != null && (callback = this.mPurchaseCallbackMap.remove(param)) != null) {
                    callback.onPurchasesUpdated(responseCode, null);
                }
            }
            return;
        }
        MLog.info((Object)TAG, (String)"handlePurchaseResponse responseCode: %d, purchases.size: %d, mPurchaseCallbackMap.size: %d, customPayload: %s", (Object[])new Object[]{responseCode, purchases.size(), this.mPurchaseCallbackMap.size(), customPayload});
        for (Purchase p : purchases) {
            if (p == null) continue;
            PurchaseParams rp = new PurchaseParams("", p.getSku(), p.getPayload());
            IPurchaseCallback callback = this.mPurchaseCallbackMap.remove(rp);
            if (callback != null) {
                PurchaseInfo info = PurchaseInfo.newBuilder((String)p.getSignature(), (String)p.getOriginalJson()).orderId(p.getOrderId()).purchaseTime(p.getPurchaseTime()).purchaseToken(p.getPurchaseToken()).productId(rp.getProductId()).payload(rp.getPayload()).build();
                callback.onPurchasesUpdated(responseCode, info);
                continue;
            }
            MLog.info((Object)TAG, (String)"handlePurchaseResponse can not found callback, consume it", (Object[])new Object[0]);
        }
    }

    private synchronized void putPurchase(@NonNull PurchaseParams param, IPurchaseCallback callback) {
        if (callback != null) {
            if (this.mPurchaseCallbackMap == null) {
                this.mPurchaseCallbackMap = new HashMap<PurchaseParams, IPurchaseCallback>();
            }
            this.mPurchaseCallbackMap.put(param, callback);
        }
    }

    private boolean checkType(String type, IPurchaseCallback callback) {
        if ("inapp".equals(type) || "subs".equals(type)) {
            return true;
        }
        String msg = "purchase type must be 'inapp' or 'subs'";
        if (RuntimeContext.sIsDebuggable) {
            throw new IllegalArgumentException(msg);
        }
        MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
        if (callback != null) {
            callback.onPurchasesUpdated(1001, null);
        }
        return false;
    }

    private boolean checkProductId(String productId, IPurchaseCallback callback) {
        if (TextUtils.isEmpty((CharSequence)productId)) {
            String msg = "purchase productId can not be empty, it may be sku that create in google play console";
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException(msg);
            }
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            if (callback != null) {
                callback.onPurchasesUpdated(1001, null);
            }
            return false;
        }
        return true;
    }

    private boolean checkToken(String purchaseToken, IConsumeCallback callback) {
        if (TextUtils.isEmpty((CharSequence)purchaseToken)) {
            String msg = "consume purchaseToken can not be empty";
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException(msg);
            }
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            if (callback != null) {
                callback.onConsumeResponse(1001, purchaseToken);
            }
            return false;
        }
        return true;
    }

    private boolean checkState() {
        if (this.mBillingClient == null && !this.isReady()) {
            String msg = "billing service is not ready, you must call startConnect before";
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException(msg);
            }
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

