/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.platform.gp;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.billing.base.ISkuDetailsCallback;
import com.yy.billing.base.PurchaseInfo;
import com.yy.billing.base.RechargeResult;
import com.yy.billing.base.SkuDetailsInfo;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.wallet.base.IPlatformPay;
import com.yy.hiyo.wallet.base.IPlatformRechargeCallback;
import com.yy.hiyo.wallet.base.ProductType;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.monitor.PayMonitor;
import com.yy.hiyo.wallet.pay.platform.gp.billing.BillingWrapper;
import com.yy.hiyo.wallet.pay.platform.gp.billing.BillingWrapperUpdate;
import com.yy.socialplatformbase.platform.google.billing.IConsumeCallback;
import com.yy.socialplatformbase.platform.google.billing.IGooglePay;
import com.yy.socialplatformbase.platform.google.billing.IPayConnectCallback;
import com.yy.socialplatformbase.platform.google.billing.IPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.IQueryPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.PurchaseParams;
import com.yy.socialplatformbase.platform.google.billing.QueryDetailsParam;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class GpPay
implements IPlatformPay,
IPayConnectCallback {
    private static final String TAG = "FTPayGoogleGpPay";
    private static final long CONNECT_TIME_OUT = 60000L;
    private static final long FOREGROUND_TIME_OUT = 15000L;
    private volatile IGooglePay mGooglePay;
    private boolean isConnecting = false;
    private final Map<String, GpPayInfo> mRechargingInfo = new ConcurrentHashMap<String, GpPayInfo>();
    private final List<PendingTask> mPendingTask = new ArrayList<PendingTask>();
    private Runnable mForegroundTimeoutTask = new Runnable(){

        @Override
        public void run() {
            GpPay.this.onForegroundTimeout();
        }
    };
    private INotify mNotify = new INotify(){

        public void notify(Notification notification) {
            Object obj = notification.extObj;
            if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && obj instanceof Boolean) {
                boolean fore = (Boolean)obj;
                if (fore && !GpPay.this.mRechargingInfo.isEmpty()) {
                    YYTaskExecutor.postToMainThread((Runnable)GpPay.this.mForegroundTimeoutTask, (long)15000L);
                } else {
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)GpPay.this.mForegroundTimeoutTask);
                }
            }
        }
    };
    private WeakReference<IPayConnectCallback> mPreConnIPayConnectCallback;

    public GpPay() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, this.mNotify);
    }

    public void recharge(@NonNull Activity activity, String productId, ProductType type, String payload, String accountId, String skuDetails, IPlatformRechargeCallback<RechargeResult> callback) {
        MLog.info((Object)TAG, (String)"recharge productId: %s, payload: %s", (Object[])new Object[]{productId, payload});
        if (this.checkGooglePlay((IPayCallback)callback)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)productId) || TextUtils.isEmpty((CharSequence)payload)) {
            PayUtils.callbackFailed(callback, 10001, "productId or payload can not be empty!");
            return;
        }
        final GpPayInfo info = new GpPayInfo(this, activity, productId, type, payload, accountId, skuDetails, callback);
        this.mRechargingInfo.put(payload, info);
        boolean ready = this.mGooglePay.isReady();
        Runnable rechargeTask = new Runnable(){

            @Override
            public void run() {
                GpPay.this.startPurchase(info);
            }
        };
        if (!ready) {
            info.update(2);
            this.startConnect(null);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)rechargeTask);
        }
    }

    public void queryPurchases(final ProductType type, IPayCallback<List<PurchaseInfo>> callback) {
        MLog.info((Object)TAG, (String)"queryUnConsumeProduct", (Object[])new Object[0]);
        if (this.checkGooglePlay(callback)) {
            return;
        }
        boolean ready = this.mGooglePay.isReady();
        PendingTask task = new PendingTask(callback){

            @Override
            public void onConnected() {
                GpPay.this.mGooglePay.queryPurchase(GpPay.convertType(type), new IQueryPurchaseCallback(){

                    public void onPurchaseHistory(int responseCode, @Nullable List<PurchaseInfo> purchasesList) {
                        MLog.info((Object)GpPay.TAG, (String)"queryUnConsumeProduct responseCode: %s, purchasesList: %d", (Object[])new Object[]{responseCode, FP.size(purchasesList)});
                        if (responseCode == 0) {
                            PayUtils.callbackSucceed(callback, purchasesList);
                        } else {
                            PayUtils.callbackFailed(callback, responseCode, "query unconsume product fail");
                        }
                    }
                });
            }
        };
        if (!ready) {
            this.startConnect(task);
        } else {
            task.onConnected();
        }
    }

    public void consume(final ProductType type, final PurchaseInfo purchase, IPayCallback<PurchaseInfo> callback) {
        MLog.info((Object)TAG, (String)"consume purchase: %s", (Object[])new Object[]{purchase});
        if (purchase == null) {
            PayUtils.callbackFailed(callback, 10001, "illegal param");
            return;
        }
        if (this.checkGooglePlay(callback)) {
            return;
        }
        boolean ready = this.mGooglePay.isReady();
        PendingTask task = new PendingTask(callback){

            @Override
            public void onConnected() {
                if (type == ProductType.SUBS) {
                    GpPay.this.mGooglePay.acknowledgePurchase(purchase.getPurchaseToken(), this::onConsumeFinish);
                } else {
                    GpPay.this.mGooglePay.consume(purchase.getPurchaseToken(), this::onConsumeFinish);
                }
            }

            private void onConsumeFinish(int responseCode, String purchaseToken) {
                String payload = purchase.getPayload();
                MLog.info((Object)GpPay.TAG, (String)"consume productId: %s, type: %s, responseCode: %d, payload: %s, purchaseToken: %s", (Object[])new Object[]{purchase.getProductId(), type, responseCode, payload, purchaseToken});
                if (responseCode == 0 && StringUtils.equal((String)purchaseToken, (String)purchase.getPurchaseToken())) {
                    PayUtils.callbackSucceed(this.callback, purchase);
                } else {
                    PayUtils.callbackFailed(this.callback, 20000 + responseCode, "consume product fail! responseCode: " + responseCode);
                }
            }
        };
        if (!ready) {
            this.startConnect(task);
        } else {
            task.onConnected();
        }
    }

    private <T> boolean checkGooglePlay(IPayCallback<T> callback) {
        boolean isGpServiceAvail = PayUtils.isGooglePlayServicesAvailable();
        MLog.info((Object)TAG, (String)"checkGooglePlay isReady: %b, isGpServiceAvail: %b", (Object[])new Object[]{this.mGooglePay != null && this.mGooglePay.isReady(), isGpServiceAvail});
        if (!isGpServiceAvail) {
            PayUtils.callbackFailed(callback, 10011, "google service is not available!");
            return true;
        }
        if (this.mGooglePay == null) {
            this.mGooglePay = this.createGooglePay(PayUtils.getBillingVersion());
        }
        if (this.mGooglePay == null) {
            MLog.error((Object)TAG, (String)"can not create IGooglePay", (Object[])new Object[0]);
            PayUtils.callbackFailed(callback, 10005, "can not create IGooglePay");
            return true;
        }
        return false;
    }

    public void cancelRecharge(String payload) {
        MLog.info((Object)TAG, (String)"cancelRecharge isReady: %b, payload: %s", (Object[])new Object[]{this.mGooglePay != null && this.mGooglePay.isReady(), payload});
        if (TextUtils.isEmpty((CharSequence)payload) || this.mRechargingInfo.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, GpPayInfo>> it = this.mRechargingInfo.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, GpPayInfo> entry = it.next();
            if (entry == null) {
                it.remove();
                continue;
            }
            if (!payload.equals(entry.getKey())) continue;
            if (entry.getValue() != null) {
                PayUtils.callbackFailed(entry.getValue().callback, 10006, "cancel");
            }
            it.remove();
        }
        if (this.mRechargingInfo.isEmpty()) {
            this.endConnect();
        }
    }

    public void querySkuDetails(final @NotNull ProductType type, final @NotNull List<String> skus, @NotNull IPayCallback<List<SkuDetailsInfo>> callback) {
        MLog.info((Object)TAG, (String)"querySkuDetails isReady: %b, params: %s", (Object[])new Object[]{this.mGooglePay != null && this.mGooglePay.isReady(), skus});
        if (this.checkGooglePlay(callback)) {
            return;
        }
        boolean ready = this.mGooglePay.isReady();
        PendingTask task = new PendingTask(callback){

            @Override
            public void onConnected() {
                QueryDetailsParam param = new QueryDetailsParam(GpPay.convertType(type), skus);
                GpPay.this.mGooglePay.querySkuDetails(param, new ISkuDetailsCallback(){

                    public void onResponse(int code, List<SkuDetailsInfo> skuDetailsList) {
                        MLog.info((Object)GpPay.TAG, (String)"querySkuDetails responseCode: %s, purchasesList: %d", (Object[])new Object[]{code, FP.size(skuDetailsList)});
                        if (code == 0) {
                            PayUtils.callbackSucceed(callback, skuDetailsList);
                        } else {
                            PayUtils.callbackFailed(callback, code, "query details product fail");
                        }
                    }
                });
            }
        };
        if (!ready) {
            this.startConnect(task);
        } else {
            task.onConnected();
        }
    }

    public void onPaySetupFinished(int responseCode) {
        IPayConnectCallback iPayConnectCallback;
        MLog.info((Object)TAG, (String)"onPaySetupFinished responseCode:  %d, isConnecting: %b", (Object[])new Object[]{responseCode, this.isConnecting});
        this.isConnecting = false;
        HashMap<String, GpPayInfo> copy = new HashMap<String, GpPayInfo>(this.mRechargingInfo);
        for (Object info : copy.values()) {
            if (responseCode == 0) {
                ((GpPayInfo)info).update(4);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable((GpPayInfo)info){
                    final /* synthetic */ GpPayInfo val$info;
                    {
                        this.val$info = gpPayInfo;
                    }

                    @Override
                    public void run() {
                        GpPay.this.startPurchase(this.val$info);
                    }
                });
                continue;
            }
            this.mRechargingInfo.remove(((GpPayInfo)info).payload);
            MLog.error((Object)TAG, (String)"onPaySetupFinished error responseCode:  %d", (Object[])new Object[]{responseCode});
            ((GpPayInfo)info).update(512);
            PayUtils.callbackFailed(((GpPayInfo)info).callback, responseCode + 20000, "connect google billing service error! responseCode: " + responseCode);
        }
        ArrayList<PendingTask> copyTask = new ArrayList<PendingTask>(this.mPendingTask);
        this.clearPendingTask();
        for (PendingTask task : copyTask) {
            if (responseCode == 0) {
                task.onConnected();
                continue;
            }
            MLog.error((Object)TAG, (String)"onPaySetupFinished error responseCode:  %d", (Object[])new Object[]{responseCode});
            PayUtils.callbackFailed(task.callback, responseCode + 20000, "connect google billing service error! responseCode: " + responseCode);
        }
        if (responseCode != 0) {
            this.endConnect();
            this.mRechargingInfo.clear();
        }
        if (this.mPreConnIPayConnectCallback != null && (iPayConnectCallback = (IPayConnectCallback)this.mPreConnIPayConnectCallback.get()) != null) {
            iPayConnectCallback.onPaySetupFinished(responseCode);
        }
    }

    private void startPurchase(final GpPayInfo info) {
        MLog.info((Object)TAG, (String)"startPurchase info: %s, mGooglePay == null: %b", (Object[])new Object[]{info, this.mGooglePay == null});
        if (info == null || this.mGooglePay == null) {
            return;
        }
        info.update(8);
        this.mGooglePay.purchase(info.activity, info.params, new IPurchaseCallback(){

            public void onPurchasesUpdated(int responseCode, @Nullable PurchaseInfo purchase) {
                MLog.info((Object)GpPay.TAG, (String)"onPurchasesUpdated responseCode: %d, purchase: %s", (Object[])new Object[]{responseCode, purchase});
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)GpPay.this.mForegroundTimeoutTask);
                GpPay.this.onPurchaseUpdated(responseCode, purchase, info);
            }
        });
    }

    private void onPurchaseUpdated(int responseCode, final @Nullable PurchaseInfo purchase, GpPayInfo info) {
        if (responseCode == 0) {
            if (purchase == null) {
                String msg = "PurchaseInfo is null with callback OK!";
                MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
                PayUtils.callbackFailed(info.callback, -1000, msg);
                return;
            }
            if ("inapp".equals(info.params.getType())) {
                info.update(16);
                RechargeResult ri = new RechargeResult(purchase);
                PayUtils.callbackSucceed(info.callback, ri);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GpPay.this.consume(purchase);
                    }
                });
            } else {
                this.acknowledgePurchase(purchase);
            }
        } else if (responseCode == 7) {
            if ("subs".equals(info.params.getType())) {
                PayUtils.callbackFailed(info.callback, 20701, "had already subs");
                if (purchase == null) {
                    info.update(32);
                    this.finishPurchase(info.payload);
                } else {
                    this.acknowledgePurchase(purchase);
                }
            } else if (purchase == null) {
                this.queryHistory(info);
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GpPay.this.consume(purchase);
                    }
                });
                PayUtils.callbackUnConsume(info.callback, Collections.singletonList(purchase));
            }
        } else if (responseCode == 1002) {
            this.startConnect(null);
        } else {
            info.update(32);
            String msg = "purchase from google failed!, google sdk responseCode: " + responseCode;
            PayUtils.callbackFailed(info.callback, responseCode + 20000, msg);
            this.finishPurchase(info.payload);
        }
    }

    private void queryHistory(final GpPayInfo gpPayInfo) {
        MLog.info((Object)TAG, (String)"queryHistory mGooglePay == null: %b, ", (Object[])new Object[]{this.mGooglePay == null});
        if (this.mGooglePay == null || gpPayInfo == null) {
            return;
        }
        this.mGooglePay.queryPurchase(gpPayInfo.params.getType(), new IQueryPurchaseCallback(){

            public void onPurchaseHistory(int responseCode, final @Nullable List<PurchaseInfo> purchasesList) {
                MLog.info((Object)GpPay.TAG, (String)"queryHistory responseCode: %s, purchasesList: %d", (Object[])new Object[]{responseCode, FP.size(purchasesList)});
                if (responseCode == 0) {
                    if (!FP.empty(purchasesList)) {
                        PayUtils.callbackUnConsume(gpPayInfo.callback, purchasesList);
                        for (final PurchaseInfo info : purchasesList) {
                            MLog.error((Object)GpPay.TAG, (String)"consume history PurchaseInfo : %s", (Object[])new Object[]{info});
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if ("inapp".equals(gpPayInfo.params.getType())) {
                                        GpPay.this.consume(info);
                                    } else {
                                        GpPay.this.acknowledgePurchase(purchasesList);
                                    }
                                }
                            });
                            PayMonitor.unconsumePurchase(info);
                        }
                    } else {
                        PayUtils.callbackFailed(gpPayInfo.callback, 1003, "gp callback 7, but with empty PurchaseInfo");
                        GpPay.this.mRechargingInfo.values().remove(gpPayInfo);
                    }
                }
            }
        });
    }

    public void onPayDisconnected() {
        IPayConnectCallback iPayConnectCallback;
        MLog.info((Object)TAG, (String)"onPayDisconnected mGooglePay == null: %b, isConnecting: %b", (Object[])new Object[]{this.mGooglePay == null, this.isConnecting});
        this.isConnecting = false;
        for (GpPayInfo info : this.mRechargingInfo.values()) {
            if (info == null || info.callback == null) continue;
            PayUtils.callbackFailed(info.callback, 10012, "google service is disconnect");
        }
        this.endConnect();
        if (this.mPreConnIPayConnectCallback != null && (iPayConnectCallback = (IPayConnectCallback)this.mPreConnIPayConnectCallback.get()) != null) {
            iPayConnectCallback.onPayDisconnected();
        }
    }

    private void startConnect(PendingTask task) {
        MLog.info((Object)TAG, (String)"startConnect mGooglePay == null: %b, isConnecting: %b", (Object[])new Object[]{this.mGooglePay == null, this.isConnecting});
        if (this.mGooglePay == null) {
            return;
        }
        if (task != null) {
            this.mPendingTask.add(task);
            YYTaskExecutor.postToMainThread((Runnable)task, (long)60000L);
        }
        if (this.isConnecting) {
            return;
        }
        this.isConnecting = true;
        if (YYTaskExecutor.isMainThread()) {
            this.mGooglePay.startConnect((IPayConnectCallback)this);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GpPay.this.mGooglePay.startConnect((IPayConnectCallback)GpPay.this);
                }
            });
        }
    }

    private void startPreConnect(IPayConnectCallback iPayConnectCallback) {
        MLog.info((Object)TAG, (String)"startConnect mGooglePay == null: %b, isConnecting: %b", (Object[])new Object[]{this.mGooglePay == null, this.isConnecting});
        if (this.mGooglePay == null) {
            return;
        }
        if (this.isConnecting) {
            return;
        }
        this.isConnecting = true;
        if (YYTaskExecutor.isMainThread()) {
            this.mGooglePay.startConnect(iPayConnectCallback);
        } else {
            YYTaskExecutor.postToMainThread(() -> this.mGooglePay.startConnect(iPayConnectCallback));
        }
    }

    private void endConnect() {
        MLog.info((Object)TAG, (String)"endConnect", (Object[])new Object[0]);
        this.clearPendingTask();
        this.mRechargingInfo.clear();
        if (this.mGooglePay != null) {
            this.mGooglePay.endConnect();
            this.mGooglePay = null;
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mForegroundTimeoutTask);
    }

    private void clearPendingTask() {
        for (PendingTask task : this.mPendingTask) {
            YYTaskExecutor.removeTask((Runnable)task);
        }
        this.mPendingTask.clear();
    }

    private void consume(final PurchaseInfo purchase) {
        MLog.info((Object)TAG, (String)"consume mGooglePay == null: %b, PurchaseInfo: %s", (Object[])new Object[]{this.mGooglePay == null, purchase});
        if (purchase == null || this.mGooglePay == null) {
            return;
        }
        if (this.mRechargingInfo.containsKey(purchase.getPayload())) {
            this.mRechargingInfo.get(purchase.getPayload()).update(64);
        }
        this.mGooglePay.consume(purchase.getPurchaseToken(), new IConsumeCallback(){

            public void onConsumeResponse(int responseCode, String purchaseToken) {
                String payload = purchase.getPayload();
                MLog.info((Object)GpPay.TAG, (String)"consume productId: %s, responseCode: %d, payload: %s, purchaseToken: %s", (Object[])new Object[]{purchase.getProductId(), responseCode, payload, purchaseToken});
                GpPayInfo info = GpPay.this.findPayInfo(purchase.getProductId());
                if (info == null) {
                    MLog.error((Object)GpPay.TAG, (String)"can not found GpPayInfo", (Object[])new Object[0]);
                    return;
                }
                if (responseCode != 0) {
                    if (info.isPurchasing()) {
                        PayUtils.callbackFailed(info.callback, 21000 + responseCode, "consume fail");
                    } else {
                        PayUtils.callbackConsumeFail(info.callback, 20900 + responseCode);
                    }
                    info.update(1024);
                    GpPay.this.finishPurchase(info.payload);
                } else {
                    info.update(128);
                    GpPay.this.checkPurchaseFinished(purchase.getProductId());
                }
            }
        });
    }

    private void acknowledgePurchase(@Nullable List<PurchaseInfo> purchasesList) {
        if (FP.empty(purchasesList)) {
            return;
        }
        for (PurchaseInfo info : purchasesList) {
            this.acknowledgePurchase(info);
        }
    }

    private void acknowledgePurchase(final @Nullable PurchaseInfo purchase) {
        if (purchase == null || this.mGooglePay == null) {
            MLog.info((Object)TAG, (String)"acknowledgePurchase is null, mGooglePay=null: %b ", (Object[])new Object[]{this.mGooglePay == null});
            return;
        }
        if (purchase.isAcknowledged()) {
            GpPayInfo info = this.findPayInfo(purchase.getProductId());
            MLog.info((Object)TAG, (String)"acknowledgePurchase is isAcknowledged info: %s", (Object[])new Object[]{info});
            if (info != null) {
                info.update(16);
                RechargeResult ri = new RechargeResult(purchase);
                PayUtils.callbackSucceed(info.callback, ri);
                info.update(256);
                this.finishPurchase(info.payload);
            }
            return;
        }
        this.mGooglePay.acknowledgePurchase(purchase.getPurchaseToken(), new IConsumeCallback(){

            public void onConsumeResponse(int responseCode, String purchaseToken) {
                GpPayInfo info = GpPay.this.findPayInfo(purchase.getProductId());
                MLog.info((Object)GpPay.TAG, (String)"acknowledgePurchase productId: %s, responseCode: %d, info: %s", (Object[])new Object[]{purchase.getProductId(), responseCode, info});
                if (info == null) {
                    return;
                }
                if (responseCode == 0) {
                    info.update(16);
                    RechargeResult ri = new RechargeResult(purchase);
                    PayUtils.callbackSucceed(info.callback, ri);
                } else {
                    PayUtils.callbackFailed(info.callback, 22000 + responseCode, "acknowledgePurchase fail");
                }
                info.update(256);
                GpPay.this.finishPurchase(info.payload);
            }
        });
    }

    private int testCode() {
        return (int)(Math.random() * 9.0);
    }

    private GpPayInfo findPayInfo(String productId) {
        if (TextUtils.isEmpty((CharSequence)productId)) {
            return null;
        }
        for (GpPayInfo info : this.mRechargingInfo.values()) {
            if (!productId.equals(info.productId)) continue;
            return info;
        }
        return null;
    }

    @Nullable
    private IGooglePay createGooglePay(IGooglePay.VERSION version) {
        if (IGooglePay.VERSION.V2_0_3 == version) {
            return new BillingWrapperUpdate();
        }
        return new BillingWrapper();
    }

    private void checkPurchaseFinished(String productId) {
        MLog.info((Object)TAG, (String)"checkPurchaseFinished productId: %s", (Object[])new Object[]{productId});
        if (TextUtils.isEmpty((CharSequence)productId)) {
            return;
        }
        GpPayInfo info = this.findPayInfo(productId);
        MLog.info((Object)TAG, (String)"checkPurchaseFinished info: %s", (Object[])new Object[]{info});
        if (info != null) {
            if (info.hadPurchase()) {
                info.release();
                this.mRechargingInfo.values().remove(info);
                this.checkFinished();
                info.update(256);
            } else {
                this.startPurchase(info);
            }
        }
    }

    private void onForegroundTimeout() {
        MLog.info((Object)TAG, (String)"onForegroundTimeout size: %d", (Object[])new Object[]{FP.size(this.mRechargingInfo)});
        for (Map.Entry<String, GpPayInfo> entry : this.mRechargingInfo.entrySet()) {
            PayUtils.callbackFailed(entry.getValue().callback, 10013, "foreground loading timeout");
        }
        this.mRechargingInfo.clear();
        this.checkFinished();
    }

    private void finishPurchase(String payload) {
        MLog.info((Object)TAG, (String)"finishPurchase payload: %s", (Object[])new Object[]{payload});
        if (TextUtils.isEmpty((CharSequence)payload)) {
            return;
        }
        GpPayInfo info = this.mRechargingInfo.get(payload);
        MLog.info((Object)TAG, (String)"finishPurchase info: %s", (Object[])new Object[]{info});
        if (info != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mForegroundTimeoutTask);
            info.release();
            this.mRechargingInfo.remove(payload);
            info.update(256);
            this.checkFinished();
        }
    }

    private void onTimeout(GpPayInfo info) {
        MLog.info((Object)TAG, (String)"onTimeout info: %s", (Object[])new Object[]{info});
        if (info == null) {
            return;
        }
        this.mRechargingInfo.remove(info.payload);
        PayUtils.callbackFailed(info.callback, 10003, "time out to finish google purchase");
        this.checkFinished();
    }

    private void checkFinished() {
        if (this.mRechargingInfo.isEmpty()) {
            this.endConnect();
        }
    }

    private static String convertType(ProductType type) {
        if (type == ProductType.INAPP) {
            return "inapp";
        }
        if (type == ProductType.SUBS) {
            return "subs";
        }
        throw new IllegalArgumentException("illegal product type " + type);
    }

    public void preConnectionService(@NotNull IPayConnectCallback iPayConnectCallback, @NotNull Activity activity) {
        if (!this.checkGooglePlay(null)) {
            this.mPreConnIPayConnectCallback = new WeakReference<IPayConnectCallback>(iPayConnectCallback);
            YYTaskExecutor.execute(() -> this.startPreConnect(this));
        }
    }

    public String getPayType() {
        return "gp";
    }

    private abstract class PendingTask
    implements Runnable {
        IPayCallback callback;

        public PendingTask(IPayCallback callback) {
            this.callback = callback;
        }

        abstract void onConnected();

        @Override
        public void run() {
            MLog.error((Object)GpPay.TAG, (String)"connect gp service timeout", (Object[])new Object[0]);
            PayUtils.callbackFailed(this.callback, 10003, "connect gp service timeout");
            GpPay.this.mPendingTask.remove(this);
        }
    }

    private static class GpPayInfo {
        static final int BEFORE = 0;
        static final int CONNECTING = 2;
        static final int CONNECTED = 4;
        static final int PURCHASING = 8;
        static final int PURCHASED_SUCCESS = 16;
        static final int PURCHASED_FAIL = 32;
        static final int CONSUMING = 64;
        static final int CONSUMED = 128;
        static final int FINISHED = 256;
        static final int ERROR = 512;
        static final int CONSUME_FAIL = 1024;
        GpPay pay;
        Activity activity;
        String productId;
        String payload;
        PurchaseParams params;
        IPlatformRechargeCallback<RechargeResult> callback;
        int stage = 0;
        int curStage = 0;
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                if (pay != null) {
                    pay.onTimeout(this);
                }
            }
        };

        GpPayInfo(GpPay pay2, @NonNull Activity activity, String productId, ProductType type, String payload, String accountId, String skuDetails, IPlatformRechargeCallback<RechargeResult> callback) {
            this.pay = pay2;
            this.activity = activity;
            this.payload = payload;
            this.productId = productId;
            this.params = PurchaseParams.newBuilder().productId(productId).payload(payload).type(GpPay.convertType(type)).accountId(accountId).skuDetails(skuDetails).build();
            this.callback = callback;
            YYTaskExecutor.postToMainThread((Runnable)this.timeoutTask, (long)60000L);
        }

        void release() {
            YYTaskExecutor.removeTask((Runnable)this.timeoutTask);
        }

        void update(int stage) {
            MLog.info((Object)GpPay.TAG, (String)"update old state: %s, update state: %s, curStage: %s", (Object[])new Object[]{Integer.toBinaryString(this.stage), Integer.toBinaryString(stage), Integer.toBinaryString(this.curStage)});
            this.curStage = stage;
            this.stage |= stage;
            if (stage != 2) {
                this.release();
            }
        }

        boolean hadPurchase() {
            return (this.stage & 0x10) == 16;
        }

        boolean isPurchasing() {
            return this.curStage == 8;
        }

        public String toString() {
            return "GpPayInfo{state=" + Integer.toBinaryString(this.stage) + ", params=" + this.params + '}';
        }
    }
}

