/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.platform;

import com.yy.hiyo.wallet.base.IPlatformPay;
import com.yy.hiyo.wallet.base.ProductType;
import com.yy.hiyo.wallet.base.pay.PayPlatform;
import com.yy.hiyo.wallet.pay.platform.gp.GpPay;
import com.yy.hiyo.wallet.recharge.internal.RechargeService;
import com.yy.hiyo.wallet.recharge.internal.sdk.SdkGpPay;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/yy/hiyo/wallet/pay/platform/PlatformPayFactory;", "", "()V", "mPays", "", "Lcom/yy/hiyo/wallet/base/pay/PayPlatform;", "Lcom/yy/hiyo/wallet/base/IPlatformPay;", "createPay", "platform", "getPay", "getSkuType", "", "type", "Lcom/yy/hiyo/wallet/base/ProductType;", "wallet_billDebug"})
public final class PlatformPayFactory {
    private static final Map<PayPlatform, IPlatformPay> mPays;
    public static final PlatformPayFactory INSTANCE;

    @JvmStatic
    @Nullable
    public static final IPlatformPay getPay(@NotNull PayPlatform platform) {
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        if (mPays.containsKey(platform)) {
            return mPays.get(platform);
        }
        IPlatformPay pay2 = INSTANCE.createPay(platform);
        mPays.put(platform, pay2);
        return pay2;
    }

    private final IPlatformPay createPay(PayPlatform platform) {
        return RechargeService.INSTANCE.isUseSdk() ? (IPlatformPay)new SdkGpPay() : (IPlatformPay)new GpPay();
    }

    @NotNull
    public final String getSkuType(@NotNull ProductType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return type == ProductType.INAPP ? "inapp" : "subs";
    }

    private PlatformPayFactory() {
    }

    static {
        PlatformPayFactory platformPayFactory;
        INSTANCE = platformPayFactory = new PlatformPayFactory();
        mPays = new ConcurrentHashMap(1);
    }
}

