/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.monitor;

import android.text.TextUtils;
import com.yy.base.utils.PackageUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.billing.base.PurchaseInfo;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.wallet.monitor.RequestTask;
import com.yy.hiyo.wallet.monitor.RequestTaskCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PayMonitor {
    private static final String SEPARATOR = "--h--";
    private static final String RECHARGE_TIME = "RECHARGE_TIME";
    private static final String RECHARGE_PRODUCT_ID = "RECHARGE_PRODUCT_ID";
    private static final String RECHARGE_ORDER_ID = "RECHARGE_ORDER_ID";
    private static final Map<String, RequestTask> mRequestList = new ConcurrentHashMap<String, RequestTask>();

    public static void checkLastUnfinishRecharge() {
        PayMonitor.reportUnFinishRecharge();
    }

    public static void monitorRequest(int from, String seqId, int cmd, String ... extend) {
        RequestTask task = new RequestTask(seqId, cmd, new RequestTaskCallback(){

            @Override
            public void onTimeout(RequestTask task) {
                PayMonitor.requestTimeout(task);
            }

            @Override
            public void onRelease(RequestTask task) {
                PayMonitor.removeRequest(task.seqId);
            }
        });
        task.putExtend("from", from);
        task.putExtend("extend", PayMonitor.formatExtend(extend));
        mRequestList.put(seqId, task);
    }

    public static void monitorRequestFailed(String seqId, int code, String msg) {
        RequestTask task = mRequestList.remove(seqId);
        if (task != null) {
            PayMonitor.reportRequest(2, task, msg);
            PayMonitor.reportReqResultMetri(task.cmd, task.duration(), code);
            task.release();
        }
    }

    public static void reportRequestMetri(String seqId, String code) {
        RequestTask task = mRequestList.get(seqId);
        if (task != null) {
            StringBuilder builder = new StringBuilder("revenue/cmd/");
            if (PayUtils.isHuaweiPayChannel()) {
                builder.append("huawei/");
            }
            builder.append(task.cmd);
            HiidoStatis.reportAppMonitorReturnCode((String)builder.toString(), (long)task.duration(), (String)code);
        }
    }

    public static void reportReqResultMetri(int cmd, long duration, int code) {
        if (code == 1) {
            code = 0;
        }
        StringBuilder builder = new StringBuilder("revenue/result/cmd/");
        if (PayUtils.isHuaweiPayChannel()) {
            builder.append("huawei/");
        }
        builder.append(cmd);
        HiidoStatis.reportAppMonitorReturnCode((String)builder.toString(), (long)duration, (String)("" + code));
    }

    public static void monitorResponse(String seqId, int code, int result, String ... extend) {
        RequestTask task = mRequestList.remove(seqId);
        if (task != null) {
            PayMonitor.reportRequestRes(1, task, code, result, PayMonitor.formatExtend(extend));
            task.release();
        }
    }

    public static void unconsumePurchase(PurchaseInfo info) {
        if (info == null) {
            return;
        }
        String date = TimeUtils.getTimeStringFromMillis((long)info.getPurchaseTime(), (String)"%04d-%02d-%02d_%02d-%02d-%02d");
        StatisContent content = PayMonitor.createContent();
        content.put("sfield", "recharge");
        content.put("sfieldtwo", info.getProductId());
        content.put("sfieldthree", info.getPayload() + SEPARATOR + info.getOrderId() + SEPARATOR + info.getPurchaseToken());
        content.put("sfieldfour", date);
        content.put("sfieldfive", PayMonitor.getGoogleVersion());
        content.put("ifield", 4);
        HiidoStatis.reportContent((StatisContent)content);
    }

    public static void requestTimeout(RequestTask task) {
        PayMonitor.reportRequest(3, task, "timeout");
        if (task != null) {
            PayMonitor.reportReqResultMetri(task.cmd, task.duration(), -1);
        }
    }

    public static void reportRiskChallenge(int code, long duration) {
        StatisContent content = PayMonitor.createContent();
        content.put("sfield", "riskChallenge");
        content.put("sfieldtwo", "" + duration);
        content.put("ifield", code);
        HiidoStatis.reportContent((StatisContent)content);
    }

    private static void removeRequest(String seqId) {
        mRequestList.remove(seqId);
    }

    static void reportRequest(int resultType, RequestTask task, String resultExtend) {
        if (task == null) {
            return;
        }
        StatisContent content = PayMonitor.createContent();
        content.put("sfield", "request");
        content.put("sfieldtwo", task.seqId);
        content.put("sfieldthree", PayMonitor.getExtend(task));
        content.put("sfieldfour", resultExtend);
        content.put("sfieldfive", task.getInt("from"));
        content.put("ifield", task.cmd);
        content.put("ifieldtwo", resultType);
        content.put("ifieldthree", task.duration());
        HiidoStatis.reportContent((StatisContent)content);
    }

    static void reportRequestRes(int resultType, RequestTask task, int code, int result, String resultExtend) {
        if (task == null) {
            return;
        }
        int duration = task.duration();
        StatisContent content = PayMonitor.createContent();
        content.put("sfield", "request");
        content.put("sfieldtwo", task.seqId);
        content.put("sfieldthree", PayMonitor.getExtend(task));
        content.put("sfieldfour", resultExtend);
        content.put("sfieldfive", task.getInt("from"));
        content.put("ifield", task.cmd);
        content.put("ifieldtwo", resultType);
        content.put("ifieldthree", duration);
        content.put("ifieldfour", code);
        content.put("ifieldfive", result);
        HiidoStatis.reportContent((StatisContent)content);
        PayMonitor.reportReqResultMetri(task.cmd, duration, result);
    }

    public static void recordRecharge(String productId, String orderId, long time) {
        String oldOrderId = SettingFlags.getStringValue((String)RECHARGE_ORDER_ID);
        if (StringUtils.equal((String)orderId, (String)oldOrderId)) {
            SettingFlags.removeKey((String)RECHARGE_PRODUCT_ID);
            SettingFlags.removeKey((String)RECHARGE_ORDER_ID);
            SettingFlags.removeKey((String)RECHARGE_TIME);
        } else {
            PayMonitor.reportUnFinishRecharge();
            SettingFlags.setStringValue((String)RECHARGE_PRODUCT_ID, (String)productId);
            SettingFlags.setStringValue((String)RECHARGE_ORDER_ID, (String)orderId);
            SettingFlags.setLongValue((String)RECHARGE_TIME, (long)time);
        }
    }

    private static String getExtend(RequestTask task) {
        if (task == null) {
            return "";
        }
        return task.getString("extend");
    }

    private static void reportUnFinishRecharge() {
        String productId = SettingFlags.getStringValue((String)RECHARGE_PRODUCT_ID);
        String orderId = SettingFlags.getStringValue((String)RECHARGE_ORDER_ID);
        long time = SettingFlags.getLongValue((String)RECHARGE_TIME);
        String date = TimeUtils.getTimeStringFromMillis((long)time, (String)"%04d-%02d-%02d_%02d-%02d-%02d");
        if (TextUtils.isEmpty((CharSequence)orderId)) {
            return;
        }
        StatisContent content = PayMonitor.createContent();
        content.put("sfield", "recharge");
        content.put("sfieldtwo", productId);
        content.put("sfieldthree", orderId);
        content.put("sfieldfour", date);
        content.put("sfieldfive", PayMonitor.getGoogleVersion());
        content.put("ifield", 5);
        HiidoStatis.reportContent((StatisContent)content);
        SettingFlags.removeKey((String)RECHARGE_PRODUCT_ID);
        SettingFlags.removeKey((String)RECHARGE_ORDER_ID);
        SettingFlags.removeKey((String)RECHARGE_TIME);
    }

    static String formatExtend(String ... extend) {
        if (extend == null) {
            return "";
        }
        StringBuilder sb = null;
        for (String ex : extend) {
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(ex);
                continue;
            }
            sb.append(SEPARATOR).append(ex);
        }
        if (sb == null) {
            return "";
        }
        return sb.toString();
    }

    static String getGoogleVersion() {
        String gsm = PackageUtils.getPackageVersion((String)"com.google.android.gms");
        String play = PackageUtils.getPackageVersion((String)"com.android.vending");
        return gsm + SEPARATOR + play;
    }

    static StatisContent createContent() {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        if (PayUtils.isHuaweiPayChannel()) {
            statContent.put("perftype", "pay_huawei");
        } else {
            statContent.put("perftype", "pay");
        }
        return statContent;
    }

    public static interface MetricReport {
        public static final String PAY_GP = "pay_gp";
        public static final String PAY_HUAWEI = "pay_huawei";
    }

    public static interface ReportEvent {
        public static final String REQUEST = "request";
        public static final String NOTIFY = "notify";
        public static final String RECHARGE = "recharge";
        public static final String RISK_CHALLENGE = "riskChallenge";
    }

    public static interface RechargeType {
        public static final int START = 1;
        public static final int SUCCESS = 2;
        public static final int FAIL = 3;
        public static final int UNCONSUME = 4;
        public static final int UNFINISH = 5;
    }

    public static interface RequestResultType {
        public static final int RES = 1;
        public static final int FAILED = 2;
        public static final int TIMEOUT = 3;
        public static final int CANCEL = 4;
    }
}

