/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.monitor;

import android.os.SystemClock;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.revenue.internal.IPayMonitor;
import com.yy.hiyo.wallet.monitor.RequestTask;
import com.yy.hiyo.wallet.monitor.RequestTaskCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.monitor.PayMonitor;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PayHandlerMonitor
implements IPayMonitor {
    public static final String REVENUE_SDK = "revenue";
    public static final String GOOGLE_PAY_SDK = "gp";
    public static final String HUAWEI_PAY_SDK = "huawei";
    public static final int PAY_NATIVE = 1;
    public static final int PAY_WEB = 2;
    public static final int PAY_JS = 3;
    private final Map<String, RequestTask> mRequestList = new ConcurrentHashMap<String, RequestTask>();
    private final Map<String, RechargeTask> mRechargeList = new ConcurrentHashMap<String, RechargeTask>();

    public void monitorRequest(int from, String seqId, int cmd, String ... extend) {
        RequestTask task = new RequestTask(seqId, cmd, new RequestTaskCallback(){

            @Override
            public void onTimeout(RequestTask task) {
                PayHandlerMonitor.this.requestTimeout(task);
            }

            @Override
            public void onRelease(RequestTask task) {
                PayHandlerMonitor.this.removeRequest(task.seqId);
            }
        });
        task.putExtend("from", from);
        task.putExtend("extend", PayMonitor.formatExtend(extend));
        this.mRequestList.put(seqId, task);
    }

    public void monitorRequestFailed(String seqId, int code, String msg) {
        RequestTask task = this.mRequestList.remove(seqId);
        if (task != null) {
            PayMonitor.reportRequest(2, task, msg);
            PayMonitor.reportReqResultMetri(task.cmd, task.duration(), code);
            task.release();
        }
    }

    public void monitorResponse(String seqId, int code, int result, String ... extend) {
        RequestTask task = this.mRequestList.remove(seqId);
        if (task != null) {
            PayMonitor.reportRequestRes(1, task, code, result, PayMonitor.formatExtend(extend));
            task.release();
        }
    }

    public void reportRequestMetric(String seqId, String code) {
        RequestTask task = this.mRequestList.get(seqId);
        if (task != null) {
            StringBuilder builder = new StringBuilder("revenue/cmd/");
            if (PayUtils.isHuaweiPayChannel()) {
                builder.append("huawei/");
            }
            builder.append(task.cmd);
            HiidoStatis.reportAppMonitorReturnCode((String)builder.toString(), (long)task.duration(), (String)code);
        }
    }

    public void startRecharge(String productId, String chOrderId) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("product_id", productId);
        content.put("order_id", chOrderId);
        content.put("gp_version", PayMonitor.getGoogleVersion());
        String uri = PayUtils.isHuaweiPayChannel() ? "pay_huawei" : "pay_gp";
        MLog.debug((Object)"PayMonitor", (String)("uri " + uri + " code 0  content " + content.toString()), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCodeNow((String)(uri + "_start"), (long)0L, (String)"0", content);
        RechargeTask task = new RechargeTask(productId, chOrderId);
        this.mRechargeList.put(chOrderId, task);
        PayMonitor.recordRecharge(productId, chOrderId, System.currentTimeMillis());
    }

    public void rechargeSuccess(String productId, String chOrderId, String gpOrderId, int fromType, String nativePayType) {
        RechargeTask task = this.mRechargeList.get(StringUtils.isNotEmpty((String)chOrderId) ? chOrderId : "");
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("product_id", productId);
        content.put("order_id", chOrderId);
        content.put("gp_order_id", gpOrderId);
        content.put("gp_version", PayMonitor.getGoogleVersion());
        content.put("pay_use_time", (task == null ? -1 : task.duration()) + "");
        content.put("from_type", String.valueOf(fromType));
        content.put("native_pay_type", nativePayType);
        content.put("ab_value", NewABDefine.PAY_PRE_CONNECT_SERVICE.getHiidoValue());
        String uri = PayUtils.isHuaweiPayChannel() ? "pay_huawei" : "pay_gp";
        MLog.debug((Object)"PayMonitor", (String)("uri " + uri + " code 0  content " + content.toString()), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCodeNow((String)uri, (long)(task == null ? -1L : (long)task.duration()), (String)"0", content);
        PayMonitor.recordRecharge(productId, chOrderId, 0L);
    }

    public void rechargeFail(String productId, String chOrderId, int code, String msg, int fromType, String nativePayType) {
        code = code == 20101 ? 20001 : code;
        RechargeTask task = this.mRechargeList.get(StringUtils.isNotEmpty((String)chOrderId) ? chOrderId : "");
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("product_id", productId);
        content.put("order_id", chOrderId);
        content.put("err_msg", msg);
        content.put("gp_version", PayMonitor.getGoogleVersion());
        content.put("pay_use_time", String.valueOf(task == null ? -1 : task.duration()));
        content.put("from_type", String.valueOf(fromType));
        content.put("native_pay_type", nativePayType);
        content.put("ab_value", NewABDefine.PAY_PRE_CONNECT_SERVICE.getHiidoValue());
        String uri = PayUtils.isHuaweiPayChannel() ? "pay_huawei" : "pay_gp";
        MLog.debug((Object)"PayMonitor", (String)("uri " + uri + " code " + code + " content " + content.toString()), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCodeNow((String)uri, (long)(task == null ? -1L : (long)task.duration()), (String)String.valueOf(code), content);
        PayMonitor.recordRecharge(productId, chOrderId, 0L);
    }

    public void reportMetriGpRecharge(String code) {
        HiidoStatis.reportAppMonitorReturnCode((String)"google/recharge/", (long)0L, (String)code);
    }

    public void monitorNotifyTimeout(String productId, String chOrderId, long duration) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("product_id", productId);
        content.put("order_id", chOrderId);
        String uri = (PayUtils.isHuaweiPayChannel() ? "pay_huawei" : "pay_gp") + "notify" + "_timeout";
        MLog.debug((Object)"PayMonitor", (String)("uri " + uri + " content " + content.toString()), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCodeNow((String)uri, (long)duration, (String)"0", content);
    }

    public void monitorNotify(String productId, RechargeInfo info, long duration) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("product_id", productId);
        content.put("order_id", info.getOrderId());
        content.put("amount", String.valueOf(info.getAmount()));
        content.put("currency_amount", String.valueOf(info.getCurrencyAmount()));
        String uri = (PayUtils.isHuaweiPayChannel() ? "pay_huawei" : "pay_gp") + "notify" + "_balance";
        MLog.debug((Object)"PayMonitor", (String)("uri " + uri + " content " + content.toString()), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCodeNow((String)uri, (long)duration, (String)"0", content);
    }

    public void stopMonitor() {
        ArrayList<RequestTask> requestList = new ArrayList<RequestTask>(this.mRequestList.values());
        for (RequestTask task : requestList) {
            PayMonitor.reportRequest(4, task, "stop");
            PayMonitor.reportReqResultMetri(task.cmd, task.duration(), -2);
            task.release();
        }
        this.mRequestList.clear();
    }

    private void requestTimeout(RequestTask task) {
        PayMonitor.requestTimeout(task);
    }

    private void removeRequest(String seqId) {
        this.mRequestList.remove(seqId);
    }

    private class RechargeTask {
        String productId;
        String chOrderId;
        long startTime;

        public RechargeTask(String productId, String chOrderId) {
            this.productId = productId;
            this.chOrderId = chOrderId;
            this.startTime = SystemClock.elapsedRealtime();
        }

        int duration() {
            return (int)Math.abs(SystemClock.elapsedRealtime() - this.startTime);
        }
    }
}

