/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.handler;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.NavigationUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.PayCode;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.revenue.internal.IPayHandler;
import com.yy.hiyo.wallet.pay.RechargeResultDialog;
import com.yy.hiyo.wallet.pay.RechargeResultDialogLister;
import com.yy.hiyo.wallet.pay.stats.RechargeHiidoReport;
import com.yy.webservice.WebEnvSettings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;

public class RechargeRetryHandler
implements IPayHandler,
INotify {
    private static final String TAG = "FTPayRechargeRetryHandler";
    private DialogLinkManager mDialogManager;
    private Activity mActivity;
    private boolean isForeground = true;
    private boolean needShowConfirmDialog = false;
    private IHandleResult mRetryCallback;
    private int rechargeFailCount = 0;

    public RechargeRetryHandler(Activity activity) {
        this.mActivity = activity;
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        this.isForeground = RuntimeContext.sIsForeground;
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && notification.extObj instanceof Boolean) {
            this.onChangeBackground((Boolean)notification.extObj);
        }
    }

    public void destroy() {
        this.mActivity = null;
        if (this.mDialogManager != null) {
            this.mDialogManager.dismissDialog();
            this.mDialogManager = null;
        }
        this.needShowConfirmDialog = false;
        this.mRetryCallback = null;
        this.rechargeFailCount = 0;
    }

    public boolean interceptReportFail(int code, String payload, String msg, IHandleResult callback) {
        MLog.error((Object)TAG, (String)"interceptReportFail code: %d, msg: %s", (Object[])new Object[]{code, msg});
        if (PayCode.isReportPayError((int)code) || code == 10010) {
            this.showOkDialog(callback, payload);
            return true;
        }
        return false;
    }

    public boolean interceptRechargeFail(RechargeParam info, String orderId, int code, String msg, IHandleResult callback) {
        MLog.error((Object)TAG, (String)"interceptRechargeFail code: %d, msg: %s", (Object[])new Object[]{code, msg});
        if (code == 20701) {
            callback.onHandle(false);
            return true;
        }
        if (code >= 20002 && code <= 21000) {
            if (this.rechargeFailCount == 0) {
                this.showOpenGpDialog(callback);
            } else if (this.rechargeFailCount == 1) {
                this.showFailAgainDialog(info, orderId, callback);
            } else {
                return false;
            }
            ++this.rechargeFailCount;
            return true;
        }
        return false;
    }

    private void onChangeBackground(boolean isForeground) {
        if (!this.isForeground && isForeground && this.needShowConfirmDialog) {
            this.showConfirmGpDialog();
        }
        this.isForeground = isForeground;
    }

    private DialogLinkManager getDialogManager() {
        if (this.mDialogManager == null) {
            this.mDialogManager = new DialogLinkManager((Context)this.mActivity);
        }
        return this.mDialogManager;
    }

    public void showOkDialog(final IHandleResult callback, final String payload) {
        RechargeResultDialog rechargeResultDialog = new RechargeResultDialog((Context)this.mActivity, new RechargeResultDialogLister(){

            @Override
            public void onRechargeOrderClick() {
                if (callback != null) {
                    callback.onHandle(true);
                }
                Message message = Message.obtain();
                Bundle bundle = new Bundle();
                bundle.putLong("target_uid", 13L);
                bundle.putBoolean("xiaolang_from_push", true);
                bundle.putString("recharge_order_id", payload);
                bundle.putInt("recharge_order_state", 11);
                message.setData(bundle);
                message.what = AppbaseMsgDef.GOTO_RECHARGE_OFFICIAL_PAGE;
                MsgDispatcher.getInstance().sendMessage(message);
                RechargeHiidoReport.reportFunctionId("succ_no_dia_pop_sure_but_click");
                RechargeHiidoReport.reportCheckRechargeResultClick();
            }

            @Override
            public void onDismiss() {
                if (callback != null) {
                    callback.onHandle(true);
                }
                RechargeHiidoReport.reportFunctionId("succ_no_dia_pop_close_but_click");
            }
        });
        rechargeResultDialog.show();
        RechargeHiidoReport.reportFunctionId("succ_no_dia_pop_show");
    }

    private void showOpenGpDialog(final IHandleResult callback) {
        OkCancelDialog dialog2 = new OkCancelDialog(new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.tips_recharge_fail_try_open_gp)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_recharge_fail_open_gp)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_recharge_fail_retry)).cancelable(true).outSideCancelable(false).withCloseBtn(true).listener(new OkCancelDialogListener(){

            public void onClose() {
                RechargeRetryHandler.this.openGpCloseClick(callback);
            }

            public void onCancel() {
                RechargeHiidoReport.reportFunctionId("unsucc_guide_pop_retry_but_click");
                RechargeRetryHandler.this.needShowConfirmDialog = false;
                if (callback != null) {
                    callback.onHandle(true);
                }
            }

            public void onOk() {
                RechargeHiidoReport.reportFunctionId("unsucc_guide_pop_gp_but_click");
                if (!RechargeRetryHandler.this.openGp(RechargeRetryHandler.this.mActivity)) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_google_service_unavail), (int)0);
                    if (callback != null) {
                        callback.onHandle(false);
                    }
                } else {
                    RechargeRetryHandler.this.mRetryCallback = callback;
                }
            }

            public void onDismiss() {
            }
        }));
        dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog2) {
                RechargeRetryHandler.this.openGpCloseClick(callback);
            }
        });
        this.getDialogManager().showDialog((BaseDialog)dialog2);
        RechargeHiidoReport.reportFunctionId("unsucc_guide_pop_show");
    }

    public void openGpCloseClick(IHandleResult callback) {
        if (callback != null) {
            callback.onHandle(false);
        }
        RechargeHiidoReport.reportFunctionId("unsucc_guide_pop_close_but_click");
    }

    private void showConfirmGpDialog() {
        OkCancelDialog dialog2 = new OkCancelDialog(new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.tips_recharge_fail_confirm_gp)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_recharge_fail_had_confirm_gp)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_recharge_fail_open_gp)).cancelable(true).outSideCancelable(false).withCloseBtn(true).listener(new OkCancelDialogListener(){

            public void onClose() {
                RechargeRetryHandler.this.closeClick();
            }

            public void onCancel() {
                RechargeHiidoReport.reportFunctionId("unsucc_check_pop_gp_but_click");
                if (!RechargeRetryHandler.this.openGp(RechargeRetryHandler.this.mActivity)) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_google_service_unavail), (int)0);
                    if (RechargeRetryHandler.this.mRetryCallback != null) {
                        RechargeRetryHandler.this.mRetryCallback.onHandle(false);
                    }
                }
            }

            public void onOk() {
                RechargeHiidoReport.reportFunctionId("unsucc_check_pop_retry_but_click");
                RechargeRetryHandler.this.needShowConfirmDialog = false;
                if (RechargeRetryHandler.this.mRetryCallback != null) {
                    RechargeRetryHandler.this.mRetryCallback.onHandle(true);
                    RechargeRetryHandler.this.mRetryCallback = null;
                }
            }
        }));
        dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog2) {
                RechargeRetryHandler.this.closeClick();
            }
        });
        this.getDialogManager().showDialog((BaseDialog)dialog2);
        RechargeHiidoReport.reportFunctionId("unsucc_check_pop_show");
    }

    private void closeClick() {
        this.needShowConfirmDialog = false;
        if (this.mRetryCallback != null) {
            this.mRetryCallback.onHandle(false);
            this.mRetryCallback = null;
        }
        RechargeHiidoReport.reportFunctionId("unsucc_check_pop_close_but_click");
    }

    private void showFailAgainDialog(final RechargeParam info, final String orderId, final IHandleResult callback) {
        OkCancelDialog dialog2 = new OkCancelDialog(new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.tips_recharge_fail_again)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_contact_service)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_jump_faq)).cancelable(true).outSideCancelable(false).withCloseBtn(true).listener(new OkCancelDialogListener(){

            public void onClose() {
                RechargeRetryHandler.this.onFailAgainCloseClick(callback);
            }

            public void onCancel() {
                if (callback != null) {
                    callback.onHandle(false);
                }
                RechargeRetryHandler.this.jumpFAQ();
                RechargeHiidoReport.reportFunctionId("unsucc_sure_pop_faq_but_click");
            }

            public void onOk() {
                if (callback != null) {
                    callback.onHandle(false);
                }
                RechargeRetryHandler.this.jumpHelpCenterOrFeedback(info, orderId);
                RechargeHiidoReport.reportFunctionId("unsucc_sure_pop_cus_but_click");
            }
        }));
        dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog2) {
                RechargeRetryHandler.this.onFailAgainCloseClick(callback);
            }
        });
        this.getDialogManager().showDialog((BaseDialog)dialog2);
        RechargeHiidoReport.reportFunctionId("unsucc_sure_pop_show");
    }

    public void onFailAgainCloseClick(IHandleResult callback) {
        if (callback != null) {
            callback.onHandle(false);
        }
        RechargeHiidoReport.reportFunctionId("unsucc_sure_pop_close_but_click");
    }

    private boolean openGp(Activity activity) {
        boolean canOpen;
        this.needShowConfirmDialog = canOpen = NavigationUtils.openGooglePlayHome((Context)activity);
        return canOpen;
    }

    private void jumpFAQ() {
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IWebService.class) != null) {
            WebEnvSettings wes = new WebEnvSettings();
            wes.url = UriProvider.getHelpCenterUrl();
            wes.disablePullRefresh = true;
            ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(wes);
        }
    }

    private void jumpFeedback(String feedbackContent) {
        Message msg = Message.obtain();
        msg.what = MixBaseMsgDef.SHOW_FEEDBACK_WRAP_WINDOW;
        msg.arg1 = 7;
        msg.arg2 = 8;
        Bundle bundle = new Bundle();
        bundle.putString("feedback_content", feedbackContent);
        msg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    private String transformNumFormat(double num) {
        String country = AccountUtil.realCountry();
        String numText = "";
        DecimalFormat df = StringUtils.equalsIgnoreCase((String)"ID", (String)country) || StringUtils.equalsIgnoreCase((String)"IN", (String)country) || StringUtils.equalsIgnoreCase((String)"VN", (String)country) ? new DecimalFormat("###,###", new DecimalFormatSymbols(this.getLocale(country))) : new DecimalFormat("###,##0.00", new DecimalFormatSymbols(this.getLocale(country)));
        numText = df.format(num);
        return numText;
    }

    private Locale getLocale(String country) {
        if (StringUtils.equalsIgnoreCase((String)"id", (String)country)) {
            return new Locale("in", country);
        }
        if (StringUtils.equalsIgnoreCase((String)"BR", (String)country)) {
            return new Locale("pt", country);
        }
        return new Locale("", country);
    }

    private void jumpHelpCenterOrFeedback(RechargeParam rechargeParam, String payOrderId) {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.PARTY_FEEDBACK_ENTRY_SWITCH);
        MLog.info((Object)TAG, (String)"jumpHelpCenterOrFeedback config == null: %b, baseCode = %s", (Object[])new Object[]{config == null});
        String price = "";
        if (rechargeParam != null) {
            String currency = TextUtils.isEmpty((CharSequence)rechargeParam.getSrcCurrencySymbol()) ? Currency.getInstance(Locale.US).getSymbol(Locale.US) : rechargeParam.getSrcCurrencySymbol();
            price = String.format(Locale.getDefault(), "%s%s", currency, this.transformNumFormat(rechargeParam.getUnitPrice()));
        }
        String time = DateUtils.getTimeFromMillisecond((Long)System.currentTimeMillis(), (SimpleDateFormat)CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss"));
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(ResourceUtils.getString((int)R.string.short_tip_order_id) + ": ");
        contentBuilder.append(payOrderId + "\n");
        contentBuilder.append(ResourceUtils.getString((int)R.string.short_tip_order_state) + ": ");
        contentBuilder.append(ResourceUtils.getString((int)R.string.summary_recharge_fail) + "\n");
        contentBuilder.append(ResourceUtils.getString((int)R.string.short_tip_payment_amount) + ": ");
        contentBuilder.append(price + "\n");
        contentBuilder.append(ResourceUtils.getString((int)R.string.short_tip_order_time) + ": ");
        contentBuilder.append(time);
        String feedbackContent = contentBuilder.toString();
        this.jumpFeedback(feedbackContent);
        MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.HIDE_RECHARGE_DIALOG);
    }

    public static interface IHandleResult {
        public void onHandle(boolean var1);
    }
}

