/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.handler;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.RechargeDbBean;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.billing.base.PurchaseInfo;
import com.yy.billing.base.RechargeResult;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.IPlatformPay;
import com.yy.hiyo.wallet.base.ProductType;
import com.yy.hiyo.wallet.base.pay.bean.OrderInfoRes;
import com.yy.hiyo.wallet.base.pay.bean.OrderStatus;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeOrder;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.internal.IPayHandler;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeHandler;
import com.yy.hiyo.wallet.pay.PayService;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.handler.IHandlerCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class CheckRechargeHandler
implements IPayHandler {
    private static final String TAG = "FTPayCheckRechargeHandler";
    private IHandlerCallback mHandlerCallback;
    private MyBox<RechargeDbBean> mDbBox;
    private final List<RechargeDbBean> mAllOrder = new CopyOnWriteArrayList<RechargeDbBean>();
    private final List<RechargeDbBean> mAbnormalOrder = new ArrayList<RechargeDbBean>();
    private IRechargeHandler mRechargeHandler;
    private PayService payService;
    private boolean hadQueryPurchase = false;

    public CheckRechargeHandler(PayService payService, IHandlerCallback callback) {
        this.mHandlerCallback = callback;
        this.payService = payService;
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IDBService.class) != null) {
            this.mDbBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(RechargeDbBean.class);
        }
        if (this.mDbBox != null) {
            this.mDbBox.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<RechargeDbBean>(){

                public void onLoaded(ArrayList<RechargeDbBean> datas) {
                    if (!FP.empty(datas)) {
                        CheckRechargeHandler.this.mAllOrder.addAll(datas);
                    }
                    CheckRechargeHandler.this.filterAbnormalOrder(datas);
                }
            });
        }
    }

    public void destroy() {
        this.mHandlerCallback = null;
        if (this.mRechargeHandler != null) {
            this.mRechargeHandler.destroy();
            this.mRechargeHandler = null;
        }
        this.mDbBox = null;
    }

    private void filterAbnormalOrder(List<RechargeDbBean> datas) {
        MLog.info((Object)TAG, (String)"filterAbnormalOrder datas.size: %d", (Object[])new Object[]{FP.size(datas)});
        if (FP.empty(datas)) {
            if (this.mHandlerCallback != null) {
                this.mHandlerCallback.onHandlerFinished(this);
            }
        } else {
            for (RechargeDbBean bean : datas) {
                int need = bean.needRetry();
                if (need == 0) {
                    this.updateDb(bean);
                } else if (need == 1 && !this.mAbnormalOrder.contains(bean)) {
                    MLog.info((Object)TAG, (String)"filterAbnormalOrder abnormal bean: %s", (Object[])new Object[]{bean});
                    this.mAbnormalOrder.add(bean);
                }
                if (!bean.needCheckOrderStatus()) continue;
                this.checkOrderStatus(bean);
            }
        }
        this.handleNextAbnormalOrder();
    }

    private void checkOrderStatus(final RechargeDbBean bean) {
        final long orderId = bean.getRechargeOrderId();
        ((IPayService)ServiceManagerProxy.getInstance().getService(IPayService.class)).queryOrderInfo(orderId, (IPayCallback)new IPayCallback<OrderInfoRes>(){

            public void onSucceed(@Nullable OrderInfoRes data) {
                if (data != null && data.getChargeOrder() != null) {
                    CheckRechargeHandler.this.updateOrderStatus(bean, data.getChargeOrder());
                } else {
                    MLog.error((Object)CheckRechargeHandler.TAG, (String)"checkOrderStatus  is null orderId: %d", (Object[])new Object[]{orderId});
                }
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)CheckRechargeHandler.TAG, (String)"checkOrderStatus orderId: %d, code: %d, msg: %s", (Object[])new Object[]{orderId, code, msg});
            }
        });
    }

    private void updateOrderStatus(RechargeDbBean data, RechargeOrder rechargeOrder) {
        int status = rechargeOrder.getStatus();
        MLog.info((Object)TAG, (String)"updateOrderStatus status: %d", (Object[])new Object[]{status});
        if (status == OrderStatus.SUCCESS.getCode()) {
            PayUtils.updateRechargeState(data, 2, this.getDbBox());
        }
    }

    private void handleNextAbnormalOrder() {
        MLog.info((Object)TAG, (String)"handleNextAbnormalOrder mAbnormalOrder.size: %d", (Object[])new Object[]{FP.size(this.mAbnormalOrder)});
        if (FP.empty(this.mAbnormalOrder)) {
            if (this.mHandlerCallback != null) {
                this.mHandlerCallback.onHandlerFinished(this);
            }
            if (!this.hadQueryPurchase) {
                MLog.info((Object)TAG, (String)"handleNextAbnormalOrder check queryPurchase", (Object[])new Object[0]);
                this.queryPurchase();
            }
        } else {
            RechargeDbBean bean = this.mAbnormalOrder.remove(0);
            int state = bean.getState();
            if (state == 1) {
                this.queryPurchase(bean);
            } else if (state == 21) {
                this.reportRecharge(bean, bean.getPayload());
            } else {
                MLog.info((Object)TAG, (String)"handleNextAbnormalOrder don't need to retry bean: %s", (Object[])new Object[]{bean});
            }
        }
    }

    private void queryPurchase(final RechargeDbBean bean) {
        ProductType type = ProductType.from((int)bean.getProductType());
        final ProductType finalType = type = type == null ? ProductType.INAPP : type;
        this.getPayPlatform().queryPurchases(finalType, (IPayCallback)new IPayCallback<List<PurchaseInfo>>(){

            public void onSucceed(@Nullable List<PurchaseInfo> data) {
                MLog.info((Object)CheckRechargeHandler.TAG, (String)"queryUnConsumeProduct onSucceed type: %s, data.size: %d, bean: %s", (Object[])new Object[]{finalType, FP.size(data), bean});
                CheckRechargeHandler.this.hadQueryPurchase = true;
                CheckRechargeHandler.this.onQuerySuccess(finalType, data, bean);
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)CheckRechargeHandler.TAG, (String)"queryUnConsumeProduct onFailed code: %d, msg: %s, bean: %s", (Object[])new Object[]{code, msg, bean});
                bean.increaseRetryCount();
                CheckRechargeHandler.this.updateDb(bean);
                CheckRechargeHandler.this.handleNextAbnormalOrder();
            }
        });
    }

    private void queryPurchase() {
        final ProductType finalType = ProductType.INAPP;
        this.getPayPlatform().queryPurchases(ProductType.INAPP, (IPayCallback)new IPayCallback<List<PurchaseInfo>>(){

            public void onSucceed(@Nullable List<PurchaseInfo> data) {
                MLog.info((Object)CheckRechargeHandler.TAG, (String)"queryUnConsumeProduct onSucceed type: %s, data.size: %d", (Object[])new Object[]{finalType, FP.size(data)});
                CheckRechargeHandler.this.hadQueryPurchase = true;
                CheckRechargeHandler.this.handleUncosumeProduct(finalType, data);
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)CheckRechargeHandler.TAG, (String)"queryUnConsumeProduct onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    private void onQuerySuccess(ProductType type, @Nullable List<PurchaseInfo> data, RechargeDbBean bean) {
        boolean needNext = true;
        if (FP.empty(data)) {
            PayUtils.updateRechargeState(bean, 10, this.getDbBox());
            this.handleNextAbnormalOrder();
        } else {
            needNext = this.handleUncosumeProduct(type, data);
        }
        if (needNext) {
            this.handleNextAbnormalOrder();
        }
    }

    private boolean handleUncosumeProduct(ProductType type, @NotNull List<PurchaseInfo> data) {
        boolean needNext = true;
        if (FP.empty(data)) {
            return true;
        }
        for (PurchaseInfo info : data) {
            if (info == null) continue;
            if (type == ProductType.SUBS && info.isAcknowledged()) {
                MLog.info((Object)TAG, (String)"sub type had acknowledged", (Object[])new Object[0]);
                continue;
            }
            needNext = false;
            RechargeDbBean dbBean = this.findDbBean(info.getPayload());
            if (dbBean != null) {
                RechargeResult result = new RechargeResult(info);
                dbBean.rechargeSuccess(result.orderId, result.purchaseToken, result.purchaseData, result.purchaseSign);
                PayUtils.updateRechargeState(dbBean, 11, this.getDbBox());
                this.reportRecharge(dbBean, info.getPayload());
            } else {
                MLog.error((Object)TAG, (String)"handleUncosumeProduct db is null, info: %s", (Object[])new Object[]{info});
            }
            this.consume(type, info);
        }
        return needNext;
    }

    private void updateDb(RechargeDbBean bean) {
        if (this.getDbBox() != null) {
            this.getDbBox().updateItem((BaseDBBean)bean, false);
        }
    }

    private MyBox<RechargeDbBean> getDbBox() {
        if (this.mDbBox != null) {
            return this.mDbBox;
        }
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IDBService.class) != null) {
            this.mDbBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(RechargeDbBean.class);
        }
        return this.mDbBox;
    }

    private void consume(final ProductType type, PurchaseInfo info) {
        this.getPayPlatform().consume(type, info, (IPayCallback)new IPayCallback<PurchaseInfo>(){

            public void onSucceed(@Nullable PurchaseInfo data) {
                MLog.info((Object)CheckRechargeHandler.TAG, (String)"consume onSucceed data: %s", (Object[])new Object[]{data});
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)CheckRechargeHandler.TAG, (String)"consume type: %s, code: %d, msg: %s", (Object[])new Object[]{type, code, msg});
            }
        });
    }

    private RechargeDbBean findDbBean(String payload) {
        if (TextUtils.isEmpty((CharSequence)payload)) {
            return null;
        }
        for (RechargeDbBean bean : this.mAllOrder) {
            if (bean == null || !payload.equals(bean.getPayload())) continue;
            return bean;
        }
        return null;
    }

    private void reportRecharge(final RechargeDbBean bean, String payload) {
        this.getRechargeHandler().reportPayResult(null, RechargeParam.getRechargeResult((RechargeDbBean)bean), RechargeParam.getRechargeParam((RechargeDbBean)bean), bean.getOrderId(), payload, false, false, 1, (IPayCallback)new IPayCallback<RechargeInfo>(){

            public void onSucceed(@Nullable RechargeInfo data) {
                MLog.info((Object)CheckRechargeHandler.TAG, (String)"reportRecharge onSucceed data: %s, bean: %s", (Object[])new Object[]{data, bean});
                if (data != null) {
                    bean.setDiamond(data.getCurrencyAmount());
                }
                PayUtils.updateRechargeState(bean, 20, (MyBox<RechargeDbBean>)CheckRechargeHandler.this.getDbBox());
                CheckRechargeHandler.this.handleNextAbnormalOrder();
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)CheckRechargeHandler.TAG, (String)"reportRecharge onFailed code: %d, msg: %s, bean: %s", (Object[])new Object[]{code, msg, bean});
                if (code == 50980) {
                    MLog.info((Object)CheckRechargeHandler.TAG, (String)"return -20 order had finish", (Object[])new Object[0]);
                    PayUtils.updateRechargeState(bean, 2, (MyBox<RechargeDbBean>)CheckRechargeHandler.this.getDbBox());
                } else {
                    bean.increaseRetryCount();
                    CheckRechargeHandler.this.updateDb(bean);
                }
                CheckRechargeHandler.this.handleNextAbnormalOrder();
            }
        });
    }

    private IPlatformPay getPayPlatform() {
        return ((IPayService)ServiceManagerProxy.getService(IPayService.class)).getPay(PayUtils.getPayPlatform());
    }

    private IRechargeHandler getRechargeHandler() {
        if (this.mRechargeHandler == null) {
            this.mRechargeHandler = this.payService.createRechargeHandler(PayUtils.getPayPlatform(), (Function1<IRechargeHandler, Unit>)((Function1)handler -> {
                this.handleNextAbnormalOrder();
                return null;
            }));
        }
        return this.mRechargeHandler;
    }
}

