/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay;

import androidx.annotation.WorkerThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.base.pay.bean.BalanceResponse;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.monitor.PayMonitor;
import com.yy.hiyo.wallet.pay.request.PayRequestUtils;
import okhttp3.Call;

class PayRequestManager {
    private static final String TAG = "FTPayPayRequestManager";

    PayRequestManager() {
    }

    public void queryBalance(final int from, final IPayCallback<BalanceResponse> callback) {
        MLog.info((Object)TAG, (String)"queryBalance", (Object[])new Object[0]);
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    PayRequestManager.this.queryBalanceAsync(from, (IPayCallback<BalanceResponse>)callback);
                }
            });
        } else {
            this.queryBalanceAsync(from, callback);
        }
    }

    private void queryBalanceAsync(int from, final IPayCallback<BalanceResponse> callback) {
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(1005);
        builder.countryCode(AccountUtil.realCountry());
        final String seq = RevenueProto.uniqueSeq();
        JsonStringBuilder param = RevenueProto.getCommonParam();
        param.put("seq", (Object)seq);
        param.put("cmd", (Object)1005);
        param.put("seq", (Object)seq);
        param.put("uid", (Object)AccountUtil.getUid());
        param.put("appId", (Object)1802);
        param.put("usedChannel", (Object)PayUtils.getPayUseChannel());
        param.put("returnYb", (Object)false);
        builder.jsonMsg(param.jsonObject());
        RevenueProtoReq req = builder.build();
        String url = RevenueProto.getUrl((String)"query", (int)req.getCmd());
        MLog.info((Object)TAG, (String)"queryBalanceAsync url: %s", (Object[])new Object[]{url});
        PayMonitor.monitorRequest(from, seq, 1005, new String[0]);
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)PayRequestManager.TAG, (String)"queryBalanceAsync", (Throwable)e, (Object[])new Object[0]);
                String msg = e.getMessage();
                PayUtils.callbackFailed(callback, 30002, msg);
                int code = NetworkUtils.getErrorCodeByExc((Throwable)e);
                PayMonitor.reportRequestMetri(seq, String.valueOf(code));
                PayMonitor.monitorRequestFailed(seq, code, msg);
            }

            public void onResponse(final RevenueProtoRes response, int id2) {
                MLog.info((Object)PayRequestManager.TAG, (String)"queryBalanceAsync onResponse: %s", (Object[])new Object[]{response});
                PayMonitor.reportRequestMetri(seq, "0");
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PayRequestManager.this.handleBalanceRes(response, seq, (IPayCallback<BalanceResponse>)callback);
                        }
                    });
                } else {
                    PayRequestManager.this.handleBalanceRes(response, seq, (IPayCallback<BalanceResponse>)callback);
                }
            }
        });
    }

    @WorkerThread
    private void handleBalanceRes(RevenueProtoRes response, String seq, IPayCallback<BalanceResponse> callback) {
        BalanceResponse res = PayRequestUtils.parseResponse(response, BalanceResponse.class);
        if (res == null) {
            PayUtils.callbackFailed(callback, 30001, "maybe parse response json error");
            PayMonitor.monitorRequestFailed(seq, 30001, "maybe parse response json error");
            return;
        }
        PayMonitor.monitorResponse(res.seq, response.result, res.result, new String[0]);
        if (res.result != 1) {
            PayUtils.callbackFailed(callback, res.result, res.message);
            return;
        }
        PayUtils.callbackSucceed(callback, res);
    }
}

