/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.monitor;

import android.os.SystemClock;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.wallet.monitor.RequestTaskCallback;
import java.util.HashMap;
import java.util.Map;

public class RequestTask
implements Runnable {
    private static final long TIMEOUT = 30000L;
    public String seqId;
    public int cmd;
    private Map<String, Object> extend;
    private long startTime;
    private volatile int timeoutCount = 0;
    private RequestTaskCallback callback;

    public RequestTask(String seqId, int cmd, RequestTaskCallback callback) {
        this.seqId = seqId;
        this.cmd = cmd;
        this.startTime = SystemClock.elapsedRealtime();
        this.callback = callback;
        YYTaskExecutor.execute((Runnable)this, (long)30000L);
    }

    public void putExtend(String key, Object value) {
        if (this.extend == null) {
            this.extend = new HashMap<String, Object>();
        }
        this.extend.put(key, value);
    }

    public Object getExtend(String key) {
        if (this.extend == null) {
            return null;
        }
        return this.extend.get(key);
    }

    public String getString(String key) {
        if (this.extend == null) {
            return "";
        }
        Object obj = this.extend.get(key);
        return obj instanceof String ? (String)obj : "";
    }

    public int getInt(String key) {
        if (this.extend == null) {
            return 0;
        }
        Object obj = this.extend.get(key);
        return obj instanceof Integer ? (Integer)obj : 0;
    }

    @Override
    public void run() {
        ++this.timeoutCount;
        if (this.callback != null) {
            this.callback.onTimeout(this);
        }
        if (this.timeoutCount < 1) {
            YYTaskExecutor.execute((Runnable)this, (long)30000L);
        } else {
            this.release();
        }
    }

    public int duration() {
        return (int)Math.abs(SystemClock.elapsedRealtime() - this.startTime);
    }

    public void release() {
        YYTaskExecutor.removeTask((Runnable)this);
        if (this.callback != null) {
            this.callback.onRelease(this);
        }
    }
}

