/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge.page.viewholder;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.module.recharge.page.OnRechargeItemListener;
import com.yy.hiyo.wallet.module.recharge.page.RechargeScaleAnimHelper;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Currency;
import java.util.Locale;

public abstract class BaseRechargeViewHolder
extends RecyclerView.ViewHolder {
    private static final String TAG = "BaseRechargeViewHolder";
    protected YYTextView diamondNum;
    private RecycleImageView diamondIcon;
    protected YYTextView rechargeAmount;
    private TextView tvSrcAmount;
    private View lineSrcAmount;
    private OnRechargeItemListener mItemClickListener;
    public View rootView;
    private DecimalFormat df;
    private ProductItemInfo info;
    private View llRechargeContainer;
    private String mLang = "";
    private String productId;
    protected View bgRecharge;
    private static final int[] DIAMOND_ICONS = new int[]{R.drawable.icon_diamond_01, R.drawable.icon_diamond_02, R.drawable.icon_diamond_03, R.drawable.icon_diamond_04, R.drawable.icon_diamond_05, R.drawable.icon_diamond_06};
    private Rect srcAmountRect;
    private Paint srcAmountPaint;
    private int position = -1;

    public BaseRechargeViewHolder(View itemView, String productId) {
        super(itemView);
        this.rootView = itemView;
        this.productId = productId;
        this.diamondNum = (YYTextView)itemView.findViewById(R.id.recharge_diamond_num_tv);
        this.diamondIcon = (RecycleImageView)itemView.findViewById(R.id.diamond_img);
        this.rechargeAmount = (YYTextView)itemView.findViewById(R.id.recharge_num_tv);
        this.tvSrcAmount = (TextView)itemView.findViewById(R.id.tv_src_amount);
        this.lineSrcAmount = itemView.findViewById(R.id.line_src_amount);
        this.llRechargeContainer = itemView.findViewById(R.id.ll_recharge_item);
        this.bgRecharge = itemView.findViewById(R.id.bg_recharge);
        this.llRechargeContainer.setOnClickListener(v -> {
            MLog.info((Object)TAG, (String)"click recharge item", (Object[])new Object[0]);
            if (this.mItemClickListener != null) {
                this.mItemClickListener.onItemClick(this.info, this.position);
            }
        });
    }

    public void setItemClickListener(OnRechargeItemListener onRechargeItemListener) {
        this.mItemClickListener = onRechargeItemListener;
    }

    public void bindViewHolder(int position, ProductItemInfo itemInfo) {
        if (itemInfo == null) {
            return;
        }
        this.position = position;
        this.info = itemInfo;
        this.diamondNum.setText((CharSequence)String.valueOf(this.info.destAmount));
        String currency = TextUtils.isEmpty((CharSequence)this.info.getSrcCurrencySymbol()) ? Currency.getInstance(Locale.US).getSymbol(Locale.US) : this.info.getSrcCurrencySymbol();
        this.rechargeAmount.setText((CharSequence)String.format(Locale.getDefault(), "%s%s", currency, this.transformNumFormat(this.info.getSrcAmount())));
        if (position >= 0 && position < 6) {
            this.diamondIcon.setImageResource(DIAMOND_ICONS[position]);
        }
        if (this.mItemClickListener != null) {
            this.mItemClickListener.onItemBindView(itemInfo);
        }
        if (StringUtils.equal((String)itemInfo.getProductId(), (String)this.productId)) {
            RechargeScaleAnimHelper.INSTANCE.startDelay((View)this.rechargeAmount);
        }
        this.updateSrcAmountLayout(itemInfo);
    }

    private String transformNumFormat(Double num) {
        String lang = SystemUtils.getLang();
        if (!StringUtils.equalsIgnoreCase((String)lang, (String)this.mLang)) {
            this.df = null;
        }
        this.mLang = lang;
        if (this.df == null) {
            this.df = new DecimalFormat("###,###.##", new DecimalFormatSymbols(new Locale(this.mLang)));
        }
        return this.df.format(num) == null ? "0" : this.df.format(num);
    }

    public boolean isUserCoupon(ProductItemInfo itemInfo) {
        return itemInfo.couponDiscountBean != null && itemInfo.couponDiscountBean.couponEnabled && !(itemInfo.couponDiscountBean.discountAmount <= 0.0);
    }

    private void updateSrcAmountLayout(ProductItemInfo itemInfo) {
        if (!this.isUserCoupon(itemInfo)) {
            this.tvSrcAmount.setVisibility(8);
            this.lineSrcAmount.setVisibility(8);
            return;
        }
        String currency = TextUtils.isEmpty((CharSequence)this.info.getSrcCurrencySymbol()) ? Currency.getInstance(Locale.US).getSymbol(Locale.US) : this.info.getSrcCurrencySymbol();
        String amountText = String.format(Locale.getDefault(), "%s%s", currency, this.transformNumFormat(itemInfo.couponDiscountBean.srcAmount));
        this.tvSrcAmount.setVisibility(0);
        this.lineSrcAmount.setVisibility(0);
        this.tvSrcAmount.setText((CharSequence)amountText);
        if (this.srcAmountRect == null) {
            this.srcAmountRect = new Rect();
        }
        if (this.srcAmountPaint == null) {
            this.srcAmountPaint = new Paint();
            this.srcAmountPaint.setTextSize((float)ResolutionUtils.dip2Px((float)11.0f));
        }
        this.srcAmountPaint.getTextBounds(amountText, 0, amountText.length(), this.srcAmountRect);
        int width = this.srcAmountRect.width();
        ViewGroup.LayoutParams layoutParams = this.lineSrcAmount.getLayoutParams();
        layoutParams.width = width + ResolutionUtils.dip2Px((float)7.0f);
        this.lineSrcAmount.setLayoutParams(layoutParams);
    }
}

