/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge.page;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.module.recharge.page.OnRechargeItemListener;
import com.yy.hiyo.wallet.module.recharge.page.viewholder.BaseRechargeViewHolder;
import com.yy.hiyo.wallet.module.recharge.page.viewholder.RechargeItemHolderNewB;
import java.util.ArrayList;
import java.util.List;

public class RechargeAdapter
extends RecyclerView.Adapter<BaseRechargeViewHolder> {
    private final List<ProductItemInfo> mData = new ArrayList<ProductItemInfo>();
    private OnRechargeItemListener itemClickListener;
    private String productId;
    private int pageType = 4;

    public void setData(List<ProductItemInfo> data) {
        if (FP.empty(data)) {
            return;
        }
        this.mData.clear();
        this.mData.addAll(data);
        this.notifyDataSetChanged();
    }

    public RechargeAdapter(OnRechargeItemListener onRechargeItemListener) {
        this.itemClickListener = onRechargeItemListener;
    }

    @NonNull
    public BaseRechargeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        BaseRechargeViewHolder holder = this.getBaseViewHolder(parent);
        holder.setItemClickListener(this.itemClickListener);
        return holder;
    }

    private BaseRechargeViewHolder getBaseViewHolder(ViewGroup parent) {
        return new RechargeItemHolderNewB(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_diamond_item_new_b, parent, false), this.pageType, this.productId);
    }

    public void onViewDetachedFromWindow(@NonNull BaseRechargeViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
    }

    public void onBindViewHolder(@NonNull BaseRechargeViewHolder holder, int position) {
        holder.bindViewHolder(position, this.mData.get(position));
    }

    public int getItemCount() {
        int size = this.mData.size();
        return size > 6 ? 6 : size;
    }

    public void setProductId(String mProductId) {
        if (!TextUtils.isEmpty((CharSequence)mProductId)) {
            this.productId = mProductId;
            if ("default".equals(mProductId) && this.mData.size() > 0) {
                this.productId = this.mData.get(0).getProductId();
            }
            for (ProductItemInfo productItemInfo : this.mData) {
                if (productItemInfo == null || !productItemInfo.getProductId().equals(this.productId)) continue;
                this.notifyItemChanged(this.mData.indexOf(productItemInfo));
                break;
            }
        }
    }

    public List<ProductItemInfo> getProductData() {
        return this.mData;
    }

    public void setPageType(@NonNull int rechargeDialogType) {
        this.pageType = rechargeDialogType;
    }
}

