/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.R;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.BalanceInfo;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.module.recharge.dialog.IRechargeDialogCallback;
import com.yy.hiyo.wallet.module.recharge.page.RechargeAdapter;
import java.util.ArrayList;
import java.util.List;

public class RechargeDialogTab
extends YYFrameLayout {
    private YYTextView feedBackFAQ;
    private static final long TIMEOUT = 10000L;
    private RecyclerView recyclerView;
    private RechargeAdapter rechargeAdapter;
    private CommonStatusLayout mStatusLayout;
    private IRechargeDialogCallback mRechargeDialogCallback;
    private DialogInterface.OnDismissListener mDismissListener;
    private List<ProductItemInfo> datas = new ArrayList<ProductItemInfo>();
    private YYTextView mStatusText;
    private YYTextView balanceTv;
    private BalanceInfo balanceInfo;
    private Context mContext;
    private View mCouponLayout;
    private TextView mCouponName;
    private View llDiamond;
    private View llContainer;
    private Runnable mLoadingTimeout = new Runnable(){

        @Override
        public void run() {
            if (RechargeDialogTab.this.mStatusLayout != null) {
                RechargeDialogTab.this.mStatusText.setVisibility(0);
            }
        }
    };

    public RechargeDialogTab(Context context) {
        super(context);
    }

    public RechargeDialogTab(Context context, IRechargeDialogCallback listener) {
        super(context);
        this.mContext = context;
        this.mRechargeDialogCallback = listener;
        this.createView();
    }

    public void createView() {
        View view = LinearLayout.inflate((Context)this.mContext, (int)R.layout.layout_recharge_dialog_tab, (ViewGroup)this);
        this.mStatusLayout = (CommonStatusLayout)view.findViewById(R.id.status_layout);
        this.feedBackFAQ = (YYTextView)view.findViewById(R.id.feedback_faq);
        this.mStatusText = (YYTextView)view.findViewById(R.id.text_status);
        this.balanceTv = (YYTextView)view.findViewById(R.id.balance_tv);
        this.mCouponLayout = view.findViewById(R.id.recharge_dialog_coupon);
        this.llContainer = view.findViewById(R.id.ll_container);
        this.mCouponName = (TextView)view.findViewById(R.id.tv_coupon_name);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recharge_list);
        int pageType = this.getPageType(ScreenUtils.getScreenOrientation() == 2);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.rechargeAdapter = new RechargeAdapter(this.mRechargeDialogCallback);
        this.rechargeAdapter.setPageType(pageType);
        if (pageType == 8) {
            this.recyclerView.setPadding(0, 0, 0, 0);
            this.recyclerView.setBackgroundColor(ResourceUtils.getColor((int)R.color.white));
            this.setCouponToRight();
        } else if (pageType == 6) {
            this.setCouponToRight();
            this.recyclerView.setPadding(0, 0, 0, 0);
            this.recyclerView.setBackgroundColor(ResourceUtils.getColor((int)R.color.white));
        }
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.rechargeAdapter);
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.showNetworkError();
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
        } else {
            this.mRechargeDialogCallback.onRefreshClick();
            this.showLoading();
        }
        this.mStatusText.setOnClickListener(v -> {
            this.mRechargeDialogCallback.onRefreshClick();
            this.hideAllStatus();
            this.showLoading();
        });
        this.feedBackFAQ.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RechargeDialogTab.this.mRechargeDialogCallback != null) {
                    RechargeDialogTab.this.mRechargeDialogCallback.jumpToFAQ();
                }
            }
        });
        this.mCouponLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RechargeDialogTab.this.mRechargeDialogCallback != null) {
                    RechargeDialogTab.this.mRechargeDialogCallback.showCouponListPop((View)RechargeDialogTab.this);
                }
            }
        });
    }

    private int getPageType(boolean landScape) {
        return landScape ? 8 : 6;
    }

    private void setCouponToRight() {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.mCouponLayout.getLayoutParams();
        params.topToBottom = -1;
        params.startToStart = -1;
        params.topToTop = R.id.ll_diamond_container;
        params.endToEnd = R.id.ll_diamond_container;
        this.mCouponLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void updateList(List<ProductItemInfo> list) {
        if (!FP.empty(list)) {
            this.hideAllStatus();
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            if (this.rechargeAdapter != null) {
                this.rechargeAdapter.setData(list);
            }
        } else {
            this.loadFailed();
        }
    }

    public void updateBalance(List<BalanceInfo> datas) {
        this.balanceTv.setText((CharSequence)"0");
        if (datas != null && datas.size() > 0) {
            for (BalanceInfo info : datas) {
                if (info.currencyType != 1805) continue;
                this.balanceInfo = info;
                if (this.balanceTv == null) break;
                this.balanceTv.setText((CharSequence)String.valueOf(this.balanceInfo.amount));
                break;
            }
        }
    }

    public void loadFailed() {
        if (this.rechargeAdapter != null) {
            if (this.rechargeAdapter.getItemCount() <= 0) {
                this.showError();
            } else {
                this.hideAllStatus();
            }
        }
        YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
    }

    private void showLoading() {
        if (this.mStatusLayout != null) {
            this.mStatusText.setVisibility(8);
            this.mStatusLayout.showLoading();
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            YYTaskExecutor.postToMainThread((Runnable)this.mLoadingTimeout, (long)10000L);
        }
    }

    private void showError() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.hideAllStatus();
        }
        if (this.mStatusText != null) {
            this.mStatusText.setVisibility(0);
        }
        if (this.mStatusText != null) {
            this.mStatusText.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_error_status_touch));
        }
        if (this.mRechargeDialogCallback != null) {
            this.mRechargeDialogCallback.onEmptyShow();
        }
    }

    private void showNetworkError() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.hideAllStatus();
        }
        if (this.mStatusText != null) {
            this.mStatusText.setVisibility(0);
        }
        if (this.mStatusText != null) {
            this.mStatusText.setText((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry));
        }
        if (this.mRechargeDialogCallback != null) {
            this.mRechargeDialogCallback.onNetErrorShow();
        }
    }

    private void hideAllStatus() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.hideAllStatus();
        }
        if (this.mStatusText != null) {
            this.mStatusText.setVisibility(8);
        }
    }

    public void setProductId(String productId) {
        if (this.rechargeAdapter != null) {
            this.rechargeAdapter.setProductId(productId);
        }
    }

    public void setCouponLayoutStatus(String couponName, boolean visibility) {
        this.mCouponLayout.setVisibility(8);
        this.mCouponName.setText((CharSequence)couponName);
    }

    public List<ProductItemInfo> getProductData() {
        if (this.rechargeAdapter != null) {
            return this.rechargeAdapter.getProductData();
        }
        return null;
    }

    public void updataRechargeList() {
        if (this.rechargeAdapter != null) {
            this.rechargeAdapter.notifyDataSetChanged();
        }
    }
}

