/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge.dialog;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Nullable;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.data.RechargeDbBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.billing.base.RechargeResult;
import com.yy.framework.R;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IPayLevelService;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.pay.bean.BalanceResponse;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.NoCouponBean;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;
import com.yy.hiyo.wallet.base.pay.callback.SimpleRechargeCallback;
import com.yy.hiyo.wallet.module.recharge.BaseRechargeController;
import com.yy.hiyo.wallet.module.recharge.dialog.IRechargeDialogCallback;
import com.yy.hiyo.wallet.module.recharge.dialog.RecentRechargeCallBack;
import com.yy.hiyo.wallet.module.recharge.dialog.RechargeDialog;
import com.yy.hiyo.wallet.module.recharge.dialog.RechargeDialogPresenter;
import com.yy.hiyo.wallet.module.recharge.preconnection.PayServicePreConnection;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.RevenueSdkReport;
import com.yy.hiyo.wallet.pay.stats.RechargeHiidoReport;
import com.yy.webservice.WebEnvSettings;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.ihago.money.api.paylevel.RechargeScene;

public class RechargeDialogController
extends BaseRechargeController
implements IRechargeDialogCallback {
    private static final String TAG = "FTPayRechargeDialogController";
    private RechargeDialog mRechargeDialog;
    private IPayCallback<RechargeInfo> mPayCallback;
    private long mLastShowTime;
    private RechargeDialogPresenter mRechargeDialogPresenter;
    private int promptType = 0;
    private String rechargeUrl;
    private boolean hadCacheUrl = false;
    private String[] defaultSku = new String[]{"hago_default_30diam_0.99_181011", "hago_default_58diam_1.99_181011", "hago_default_150diam_4.99_181011", "hago_default_298diam_9.99_181011", "hago_default_598diam_19.99_181011", "hago_default_1198diam_39.99_181011"};
    private GameLifeWrapper gameLifeWrapper = new GameLifeWrapper(){

        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            MLog.info((Object)RechargeDialogController.TAG, (String)"game exist gameExitType: %d, GamePlayContext: %s", (Object[])new Object[]{gameExitType, context == null ? "mContext id null" : context.getGameInfo()});
            RechargeDialogController.this.hideRechargeDialog(true);
        }
    };
    long mStartShowDialog = System.currentTimeMillis();
    boolean isStartInvokeGooglePay = false;
    Runnable queryHistoryRunnable = new Runnable(){

        @Override
        public void run() {
            RechargeDialogController.this.queryRechargeHistory();
        }
    };

    public RechargeDialogController(Environment env) {
        super(env);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.gameLifeWrapper);
        this.registerMessage(AppbaseMsgDef.HIDE_RECHARGE_DIALOG);
        this.registerMessage(AppbaseMsgDef.UPDATE_COUPON_DISCOUNT_POP);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    @Override
    protected int getLoginDialogType() {
        return 5;
    }

    @Override
    protected int getLoginDialogFrom() {
        return 8;
    }

    public void handleMessage(final Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.SHOW_RECHARGE_DIALOG) {
            if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                return;
            }
            this.sendMessage(BaseMsgDef.MSG_ENTER_RECHARGE);
            ((IPayLevelService)this.getServiceManager().getService(IPayLevelService.class)).updateRechargeUrl(RechargeScene.RechargeScenePopWindow);
            long cur = System.currentTimeMillis();
            if (this.isRechargeDialogShowing() && Math.abs(cur - this.mLastShowTime) < 500L) {
                return;
            }
            this.mLastShowTime = cur;
            if (this.isRechargeDialogShowing()) {
                this.hideRechargeDialog(false);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RechargeDialogController.this.handleShow(msg);
                    }
                }, (long)500L);
            } else {
                this.handleShow(msg);
            }
            YYTaskExecutor.postToMainThread(() -> PayServicePreConnection.preConnectionPayService((Activity)this.getEnvironment().getActivity()), (long)800L);
        } else if (msg.what == AppbaseMsgDef.HIDE_RECHARGE_DIALOG) {
            int code = msg.what;
            if (this.mPayCallback != null && msg.obj instanceof String) {
                this.mPayCallback.onFailed(code, (String)msg.obj);
            }
            this.onFinish();
            if (code != 20001) {
                this.hideRechargeDialog(true);
            }
        } else if (msg.what == AppbaseMsgDef.UPDATE_COUPON_DISCOUNT_POP) {
            if (msg.obj instanceof NoCouponBean) {
                if (this.mRechargeDialog != null && this.mCurrCouponBean != null) {
                    this.mCurrCouponBean = null;
                    this.mRechargeDialog.setCouponLayoutStatus(ResourceUtils.getString((int)R.string.short_tips_coupoin), true);
                    if (this.mRechargeDialog.getProductData() != null) {
                        for (ProductItemInfo productDatum : this.mRechargeDialog.getProductData()) {
                            productDatum.couponDiscountBean = null;
                            productDatum.couponBean = null;
                        }
                        this.updataRechargeListForCoupon();
                    }
                }
            } else if (msg.obj instanceof CouponBean) {
                CouponBean bean = (CouponBean)msg.obj;
                this.requestCouponDiscount(bean);
            }
        } else if (msg.what == AppbaseMsgDef.UPDATE_RED_POINT_RECHARGE_DIALOG && msg.obj instanceof Boolean && this.mRechargeDialog != null) {
            this.mRechargeDialog.updateRedPoint((Boolean)msg.obj);
        }
    }

    private void handleShow(Message msg) {
        if (msg.obj instanceof IPayCallback) {
            this.mPayCallback = (IPayCallback)msg.obj;
        }
        this.promptType = 0;
        Bundle bundle = msg.getData();
        if (bundle != null) {
            this.promptType = msg.arg1;
        }
        this.handleBundle(bundle);
        this.showRechargeDialog(true);
        ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("goods_pop_show").put("gid", (Object)this.mGid).put("enter_type", (Object)String.valueOf(this.fromType)));
        RechargeHiidoReport.goodsPopShow(this.mGid, this.fromType);
    }

    private void requestCouponDiscount(CouponBean couponBean) {
        if (couponBean != null && !couponBean.equals(this.mCurrCouponBean) && this.mRechargeDialog != null) {
            this.mCurrCouponBean = couponBean;
            this.mRechargeDialog.setCouponLayoutStatus(couponBean.couponName, true);
            this.requestCouponDiscount(this.mRechargeDialog.getProductData());
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (NotificationDef.N_FOREGROUND_CHANGE == notification.id && this.isStartInvokeGooglePay) {
            this.isStartInvokeGooglePay = false;
            long useTime = System.currentTimeMillis() - this.mStartShowDialog;
            MLog.info((Object)TAG, (String)("Google Pay Dialog time = " + useTime), (Object[])new Object[0]);
            RechargeHiidoReport.invokeGooglePayDialogShow(this.mGid, this.fromType, useTime);
        }
    }

    @Override
    public void onItemClick(final ProductItemInfo productItemInfo, int position) {
        if (productItemInfo == null) {
            MLog.error((Object)TAG, (String)"onItemClick item info is null", (Object[])new Object[0]);
            return;
        }
        if (productItemInfo.couponBean != null && !productItemInfo.couponBean.isCouponVaild(this.mContext, true)) {
            this.requestRechargeList();
            return;
        }
        if (this.checkItemClick()) {
            RechargeHiidoReport.rechargeClick(this.mGid, this.fromType, this.mRoomId, productItemInfo, this.promptType);
            RevenueSdkReport.INSTANCE.clickProduct(this.mPageId, productItemInfo.productId, position, StringUtils.isEmpty((String)this.rechargeUrl));
            this.showLoading();
            this.mStartShowDialog = System.currentTimeMillis();
            this.isStartInvokeGooglePay = true;
            final int innerFromType = this.fromType;
            this.mRechargeHandler = ((IPayService)this.getServiceManager().getService(IPayService.class)).recharge(PayUtils.getPayPlatform(), (Activity)this.getActivity(), this.getRechargeParam(productItemInfo), (IRechargeCallback)new SimpleRechargeCallback(){

                public void onRechargeSuccess(RechargeResult result) {
                    RechargeDialogController.this.isStartInvokeGooglePay = false;
                    MLog.info((Object)RechargeDialogController.TAG, (String)"onRechargeSuccess data: %s", (Object[])new Object[]{result});
                    RechargeDialogController.this.hideRechargeDialog(false);
                    if (result != null) {
                        RechargeDialogController.this.mRechargeSuccessOrderId = PayUtils.getOrderFromPayload(result.payload);
                    }
                }

                public int rechargeSource() {
                    return 1000 != innerFromType ? 1 : 2;
                }

                public void onSucceed(@Nullable RechargeInfo data) {
                    RechargeDialogController.this.isStartInvokeGooglePay = false;
                    MLog.info((Object)RechargeDialogController.TAG, (String)"onSucceed data: %s", (Object[])new Object[]{data});
                    RechargeDialogController.this.hideLoading();
                    RechargeDialogController.this.handleOnSucceed(productItemInfo, data, RechargeDialogController.this.promptType);
                    RechargeDialogController.this.startBalanceTimeoutTask();
                    if (RechargeDialogController.this.mPayCallback != null) {
                        RechargeDialogController.this.mPayCallback.onSucceed((Object)data);
                    }
                    RechargeDialogController.this.onFinish();
                }

                public void onFailed(int code, String msg) {
                    super.onFailed(code, msg);
                    RechargeDialogController.this.isStartInvokeGooglePay = false;
                    MLog.error((Object)RechargeDialogController.TAG, (String)"onFailed code: %d,  msg: %s", (Object[])new Object[]{code, msg});
                    RechargeDialogController.this.handleOnFailed(productItemInfo, code, msg, RechargeDialogController.this.promptType);
                    RechargeDialogController.this.requestRechargeList();
                }
            });
        }
        YYTaskExecutor.removeTask((Runnable)this.queryHistoryRunnable);
    }

    @Override
    public void onItemBindView(ProductItemInfo productItemInfo) {
        RechargeHiidoReport.goodsShow(this.mGid, this.fromType, productItemInfo);
    }

    @Override
    public void onDismiss(RechargeDialog dialog2) {
        if (this.mRechargeDialog != dialog2) {
            MLog.info((Object)TAG, (String)"onDismiss is not same dialog", (Object[])new Object[0]);
            return;
        }
        if (this.isLogining) {
            MLog.info((Object)TAG, (String)"onDismiss isLogining: %b", (Object[])new Object[]{this.isLogining});
            return;
        }
        this.mCurrCouponBean = null;
        this.mRechargeDialog = null;
        this.hadCacheUrl = false;
        this.rechargeUrl = "";
        RechargeHiidoReport.goodsPopClose(this.mGid, this.fromType);
        this.fromType = 0;
        this.mGid = "";
        this.mRoomId = "";
    }

    @Override
    protected void onDestroy() {
        if (this.mPayCallback != null) {
            this.mPayCallback.onFailed(10006, "cancel by user");
            this.mPayCallback = null;
        }
        super.onDestroy();
    }

    @Override
    protected void onFinish() {
        super.onFinish();
        this.mPayCallback = null;
    }

    @Override
    protected void updataRechargeListForCoupon() {
        if (this.mRechargeDialog != null && TextUtils.isEmpty((CharSequence)this.getWebRechargeUrl())) {
            this.mRechargeDialog.updataRechargeList();
        }
    }

    @Override
    protected void onRequestCouponDiscountFailed() {
        this.requestRechargeList();
    }

    @Override
    protected void onSelectedOther() {
        super.onSelectedOther();
        if (this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    @Override
    protected void onLoginFinish() {
        super.onLoginFinish();
        if (!this.isRechargeDialogShowing()) {
            this.showRechargeDialog(false);
        }
    }

    private void showRechargeDialog(boolean reset) {
        String webRechargeUrl = this.getWebRechargeUrl();
        if (reset) {
            this.mRechargeDialog = new RechargeDialog(this.mContext, this, webRechargeUrl, this.mPageId);
        } else if (this.mRechargeDialog == null) {
            this.mRechargeDialog = new RechargeDialog(this.mContext, this, webRechargeUrl, this.mPageId);
        }
        this.mRechargeDialogPresenter = new RechargeDialogPresenter();
        this.mRechargeDialog.setHasActivity(this.getActivityAction() != null, this.isSelectActivity());
        this.mRechargeDialog.setPresenter(this.mRechargeDialogPresenter);
        this.mRechargeDialogPresenter.setActivityData(this.getActivityAction());
        boolean showSuccess = this.mDialogLinkManager.showDialog((BaseDialog)this.mRechargeDialog);
        if (!showSuccess) {
            MLog.error((Object)TAG, (String)"showRechargeDialog show dialog fail!", (Object[])new Object[0]);
            return;
        }
        RechargeHiidoReport.pageShow(this.mGid, this.fromType, this.promptType, StringUtils.isEmpty((String)webRechargeUrl));
        RevenueSdkReport.INSTANCE.onPageShow(this.fromType, this.mPageId, !StringUtils.isEmpty((String)webRechargeUrl));
        this.requestBalance(false);
        this.requestRechargeList();
        YYTaskExecutor.postToMainThread((Runnable)this.queryHistoryRunnable, (long)2000L);
    }

    private String getWebRechargeUrl() {
        MLog.info((Object)TAG, (String)("isOnlyNative = " + this.isOnlyNative), (Object[])new Object[0]);
        if (this.isOnlyNative) {
            return "";
        }
        if (this.hadCacheUrl) {
            MLog.info((Object)TAG, (String)("hadCacheUrl rechargeUrl = " + this.rechargeUrl), (Object[])new Object[0]);
            return this.rechargeUrl;
        }
        this.hadCacheUrl = true;
        this.rechargeUrl = SettingFlags.getStringValue((String)("key_recharge_url" + AccountUtil.getUid()), (String)"");
        MLog.info((Object)TAG, (String)("rechargeUrl = " + this.rechargeUrl), (Object[])new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)this.rechargeUrl)) {
            this.rechargeUrl = this.appendSourceAndFrom(this.rechargeUrl);
        }
        return this.rechargeUrl;
    }

    private String appendSourceAndFrom(String url) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("source", "2");
        param.put("from", "" + this.fromType);
        param.put("pid", this.mPageId);
        param.put("dialogFrom", "" + this.fromType);
        param.put("packagename", AppKeysDef.getAppPackageName());
        if (!StringUtils.isEmpty((String)this.mActId)) {
            param.put("actId", this.mActId);
        }
        return URLUtils.addParams((String)url, param);
    }

    private void queryRechargeHistory() {
        if (!TextUtils.isEmpty((CharSequence)this.getWebRechargeUrl())) {
            return;
        }
        this.getRecentRechargeSuccessItem(new RecentRechargeCallBack(){

            @Override
            public void onLoad(RechargeDbBean rechargeDbBean) {
                if (RechargeDialogController.this.mRechargeDialog != null) {
                    if (rechargeDbBean != null && rechargeDbBean.getState() == 2) {
                        RechargeDialogController.this.mRechargeDialog.setProductId(RechargeParam.getRechargeParam((RechargeDbBean)rechargeDbBean).getProductId());
                    } else {
                        RechargeDialogController.this.mRechargeDialog.setProductId("default");
                    }
                }
            }
        });
    }

    private void hideRechargeDialog(boolean destroy2) {
        if (this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager.dismissDialog();
        }
        YYTaskExecutor.removeTask((Runnable)this.queryHistoryRunnable);
        if (destroy2) {
            this.onDestroy();
        }
    }

    private boolean isRechargeDialogShowing() {
        return this.mDialogLinkManager.getShowingDialogId() == DialogId.rechargeDialog;
    }

    @Override
    protected void onRechargeSuccess(RechargeInfo info) {
        super.onRechargeSuccess(info);
        this.requestBalance(this.mRechargeSuccessOrderId != null && info != null && this.mRechargeSuccessOrderId.equals(info.getOrderId()));
        this.requestRechargeList();
    }

    private void requestBalance(final boolean hideLoading) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) || !TextUtils.isEmpty((CharSequence)this.getWebRechargeUrl())) {
            return;
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).queryBalance(this.fromType, (IPayCallback)new IPayCallback<BalanceResponse>(){

            public void onSucceed(@Nullable BalanceResponse response) {
                MLog.info((Object)RechargeDialogController.TAG, (String)"request balance onSucceed", (Object[])new Object[0]);
                if (response != null && RechargeDialogController.this.mRechargeDialog != null) {
                    RechargeDialogController.this.mRechargeDialog.updateBalance(response.accountList);
                }
                if (hideLoading) {
                    RechargeDialogController.this.endBalanceTimeoutTask();
                    RechargeDialogController.this.hideLoading();
                }
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)RechargeDialogController.TAG, (String)"request balance fail", (Object[])new Object[0]);
                if (hideLoading) {
                    RechargeDialogController.this.endBalanceTimeoutTask();
                    RechargeDialogController.this.hideLoading();
                }
            }
        });
    }

    private void requestRechargeList() {
        if (!TextUtils.isEmpty((CharSequence)this.getWebRechargeUrl())) {
            return;
        }
        final long startTime = System.currentTimeMillis();
        List list = ((IPayService)this.getServiceManager().getService(IPayService.class)).fetchRechargeList();
        if (!FP.empty((Collection)list) && this.mRechargeDialog != null) {
            for (ProductItemInfo productItemInfo : list) {
                productItemInfo.couponDiscountBean = null;
                productItemInfo.couponBean = null;
            }
            this.mRechargeDialog.updateList(list);
            RechargeHiidoReport.rechargeListDataReady(this.mGid, this.fromType, System.currentTimeMillis() - startTime, true, true);
            RevenueSdkReport.INSTANCE.onProductShow(this.mPageId, StringUtils.isEmpty((String)this.rechargeUrl), startTime);
            this.requestCouponList();
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).fetchRechargeList(this.fromType, this.mPageId, null, (IPayCallback)new IPayCallback<List<ProductItemInfo>>(){

            public void onSucceed(@Nullable List<ProductItemInfo> data) {
                MLog.info((Object)RechargeDialogController.TAG, (String)"requestRechargeList onSucceed data.size: %d", (Object[])new Object[]{FP.size(data)});
                if (!FP.empty(data)) {
                    if (RechargeDialogController.this.mRechargeDialog != null) {
                        RechargeDialogController.this.mRechargeDialog.updateList(data);
                        RechargeHiidoReport.rechargeListDataReady(RechargeDialogController.this.mGid, RechargeDialogController.this.fromType, System.currentTimeMillis() - startTime, false, true);
                        RevenueSdkReport.INSTANCE.onProductShow(RechargeDialogController.this.mPageId, StringUtils.isEmpty((String)RechargeDialogController.this.rechargeUrl), startTime);
                        RechargeDialogController.this.requestCouponList();
                    }
                } else {
                    if (RechargeDialogController.this.mRechargeDialog != null) {
                        RechargeDialogController.this.mRechargeDialog.loadFailed();
                    }
                    ToastUtils.showToast((Context)RechargeDialogController.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_refresh_again), (int)0);
                    RechargeHiidoReport.rechargeListDataReady(RechargeDialogController.this.mGid, RechargeDialogController.this.fromType, System.currentTimeMillis() - startTime, false, false);
                }
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)RechargeDialogController.TAG, (String)"request recharge list fail, code: %d, msg: %s", (Object[])new Object[]{code, msg});
                RechargeDialogController.this.mRechargeHandler = null;
                if (RechargeDialogController.this.mRechargeDialog != null) {
                    RechargeDialogController.this.mRechargeDialog.loadFailed();
                }
                ToastUtils.showToast((Context)RechargeDialogController.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_refresh_again), (int)0);
                RechargeHiidoReport.rechargeListDataReady(RechargeDialogController.this.mGid, RechargeDialogController.this.fromType, System.currentTimeMillis() - startTime, false, false);
            }
        });
    }

    @Override
    public void onRefreshClick() {
        this.requestRechargeList();
        this.requestBalance(false);
    }

    @Override
    public void onNetErrorShow() {
        RechargeHiidoReport.goodsListNetError(this.mGid, this.fromType);
    }

    @Override
    public void onEmptyShow() {
        RechargeHiidoReport.goodsListEmpty(this.mGid, this.fromType);
    }

    @Override
    public void jumpToFAQ() {
        this.hideRechargeDialog(true);
        WebEnvSettings wes = new WebEnvSettings();
        wes.url = UriProvider.getHelpCenterUrl();
        wes.disablePullRefresh = true;
        ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(wes);
        if (this.fromType == 3) {
            RechargeHiidoReport.giftPanelFaqClick();
        }
    }

    @Override
    public void showCouponListPop(View view) {
        view.setTag((Object)(this.mCurrCouponBean == null ? 0L : this.mCurrCouponBean.id));
        this.sendMessage(AppbaseMsgDef.SHOW_COUPON_LIST_POPUPWINDOW, -1, -1, view);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028699").put("function_id", "coupon_enter_click"));
    }

    @Override
    public void requestCouponList() {
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).queryCouponListAsync(false, (IPayCallback)new IPayCallback<List<CouponBean>>(){

            public void onSucceed(@Nullable List<CouponBean> data) {
                if (RechargeDialogController.this.mRechargeDialog != null) {
                    String couponName = ResourceUtils.getString((int)R.string.title_coupon);
                    RechargeDialogController.this.mCurrCouponBean = null;
                    if (!FP.empty(data)) {
                        couponName = data.get((int)0).couponName;
                        RechargeDialogController.this.mCurrCouponBean = data.get(0);
                        RechargeDialogController.this.requestCouponDiscount(RechargeDialogController.this.mRechargeDialog.getProductData());
                    }
                    RechargeDialogController.this.mRechargeDialog.setCouponLayoutStatus(couponName, !FP.empty(data));
                }
            }

            public void onFailed(int code, String msg) {
            }
        });
    }
}

