/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.js;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.prop.BuyPropHandler;
import com.yy.hiyo.wallet.prop.proto.callback.IBuyPropCallback;
import com.yy.hiyo.wallet.prop.proto.param.BuyPropParam;
import com.yy.hiyo.wallet.prop.proto.res.ConsumeConfirmBroInfo;
import com.yy.hiyo.wallet.prop.proto.res.GiftBagAcquireBroInfo;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;

public class BuyGiftBagJsEvent
implements JsEvent {
    private static final String TAG = "BuyGiftBagJsEvent";
    private IWebBusinessHandler mWebHandler;
    private BuyPropHandler mBuyPropHandler;
    private DialogLinkManager mDialogLinkManager;
    private WebBusinessHandlerCallback mHandlerCallback = new WebBusinessHandlerCallback(){

        public void onWebViewDestroy() {
            super.onWebViewDestroy();
            BuyGiftBagJsEvent.this.mWebHandler = null;
            if (BuyGiftBagJsEvent.this.mBuyPropHandler != null) {
                BuyGiftBagJsEvent.this.mBuyPropHandler.destroy();
                BuyGiftBagJsEvent.this.mBuyPropHandler = null;
            }
            BuyGiftBagJsEvent.this.hideLoading();
        }
    };

    @NonNull
    public JsMethod method() {
        return JsEventDefine.REVENUE.buyGiftBag;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        this.mWebHandler = webHandler;
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is empty");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"network unavailable");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        webHandler.addWebViewListener(this.mHandlerCallback);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                BuyGiftBagJsEvent.this.checkParam(param, callback);
            }
        });
    }

    private void checkParam(String json, final @Nullable IJsEventCallback callback) {
        IWebBusinessHandler webHandler;
        BuyPropParam param = null;
        try {
            param = (BuyPropParam)JsonParser.parseJsonObject((String)json, BuyPropParam.class);
            if (param != null && param.getGift() != null && param.getGift().getPropsId() > 0) {
                int propsId = param.getGift().getPropsId();
                param.getRecharge().addExpand("giftBagId", (Object)propsId);
                param.getRecharge().addExpand("giftBagName", (Object)param.getGift().getPackName());
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)json, (Throwable)e, (Object[])new Object[0]);
        }
        if (param == null) {
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        param.type = 2;
        if (param.getRecharge() != null) {
            param.getRecharge().setFrom(101);
            param.getRecharge().setNeedRechargeSuccessBro(false);
        }
        if ((webHandler = this.mWebHandler) == null || !(webHandler.getContext() instanceof Activity)) {
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"error with null activity");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        final Activity activity = (Activity)webHandler.getContext();
        final BuyPropParam finalParam = param;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                BuyGiftBagJsEvent.this.buyProp(activity, finalParam, callback);
            }
        });
    }

    private void buyProp(Activity activity, BuyPropParam param, final @Nullable IJsEventCallback callback) {
        this.showLoading(activity);
        this.mBuyPropHandler = new BuyPropHandler(new BuyPropHandler.ICallback(){

            @Override
            public Activity getActivity() {
                IWebBusinessHandler webHandler = BuyGiftBagJsEvent.this.mWebHandler;
                if (webHandler != null && webHandler.getContext() instanceof Activity) {
                    return (Activity)webHandler.getContext();
                }
                return null;
            }
        });
        this.mBuyPropHandler.buyProp(param, new IBuyPropCallback(){

            @Override
            public void onFail(int code, String msg) {
                MLog.error((Object)BuyGiftBagJsEvent.TAG, (String)"buyProp onFail code: %d, msg: %s", (Object[])new Object[]{code, msg});
                BuyGiftBagJsEvent.this.handleFail(code, msg, callback);
            }

            @Override
            public void onBuyPropResponse(SendGiftRes result) {
                MLog.info((Object)BuyGiftBagJsEvent.TAG, (String)"buyProp onBuyPropResponse result: %s", (Object[])new Object[]{result});
            }

            @Override
            public void onRechargeSuccess(RechargeInfo data) {
                MLog.info((Object)BuyGiftBagJsEvent.TAG, (String)"buyProp onRechargeSuccess data: %s", (Object[])new Object[]{data});
            }

            @Override
            public void onConsumeConfirmBro(ConsumeConfirmBroInfo info) {
                MLog.info((Object)BuyGiftBagJsEvent.TAG, (String)"buyProp onConsumeConfirmBro info: %s", (Object[])new Object[]{info});
            }

            @Override
            public void onAcquireGiftBagBro(GiftBagAcquireBroInfo info) {
                MLog.info((Object)BuyGiftBagJsEvent.TAG, (String)"buyProp onAcquireGiftBagBro info: %s", (Object[])new Object[]{info});
                BuyGiftBagJsEvent.this.handleSuccess(info, callback);
            }
        });
    }

    private void handleSuccess(final GiftBagAcquireBroInfo info, final @Nullable IJsEventCallback callback) {
        if (this.mBuyPropHandler != null) {
            this.mBuyPropHandler.destroy();
        }
        this.hideLoading();
        if (callback == null) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                BuyGiftBagJsEvent.this.onCallback(callback, info);
            }
        });
    }

    private void showLoading(Activity activity) {
        this.mDialogLinkManager = new DialogLinkManager((Context)activity);
        ProgressDialog dialog2 = new ProgressDialog();
        dialog2.setCheckDeadLoop(false);
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    private void hideLoading() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
            this.mDialogLinkManager = null;
        }
    }

    private void handleFail(int code, String msg, @Nullable IJsEventCallback callback) {
        BaseJsParam err;
        if (this.mBuyPropHandler != null) {
            this.mBuyPropHandler.destroy();
        }
        this.hideLoading();
        if (callback == null) {
            return;
        }
        if (code == 20001 || code == 20101 || code == 10006) {
            err = BaseJsParam.errorParam((int)2, (String)("cancel by user. code: " + code + "; errorMsg: " + msg));
        } else if (code == 20982) {
            int originalCode = -18;
            err = BaseJsParam.errorParam((int)originalCode, (String)msg);
        } else {
            err = BaseJsParam.errorParam((int)0, (String)("code: " + code + "; errorMsg: " + msg));
        }
        callback.callJs((IJsParam)err);
    }

    private void onCallback(IJsEventCallback callback, GiftBagAcquireBroInfo info) {
        try {
            String data = JsonParser.toJson((Object)info);
            BaseJsParam res = BaseJsParam.dataParam((String)data);
            callback.callJs((IJsParam)res);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            BaseJsParam res = BaseJsParam.errorParam((int)0, (String)"parse data to json error");
            callback.callJs((IJsParam)res);
        }
    }
}

