/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gold.goldpresent;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.wallet.gold.goldpresent.GoldPresentationMvp;
import net.ihago.money.api.gamecoin.GetGiveCoinReq;
import net.ihago.money.api.gamecoin.GetGiveCoinRes;
import net.ihago.money.api.gamecoin.GetJoinCoinReq;
import net.ihago.money.api.gamecoin.GetJoinCoinRes;

public class GoldPresentationModel
implements GoldPresentationMvp.IModel {
    private static final String TAG = "GameGoldPresentationModel";

    @Override
    public void getJoinCoin(final IGetJoinCoinCallback callback, long id2, String gameId) {
        GetJoinCoinReq req = new GetJoinCoinReq.Builder().game_id(gameId).id(Long.valueOf(id2)).sequence(Long.valueOf(System.currentTimeMillis())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetJoinCoinRes>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)GoldPresentationModel.TAG, (String)"get join coins \u7ed3\u679c: timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail();
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.i((String)GoldPresentationModel.TAG, (String)"get join coins \u7ed3\u679c:%s", (Object[])new Object[]{code});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail();
                    }
                });
                return false;
            }

            public void onResponse(final @NonNull GetJoinCoinRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                FeatureLog.i((String)GoldPresentationModel.TAG, (String)"get join coins \u7ed3\u679c:%s", (Object[])new Object[]{code});
                if (ProtoManager.isSuccessCode((long)code)) {
                    callback.onFail();
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            FeatureLog.i((String)GoldPresentationModel.TAG, (String)"get join coins success,new coins:%s", (Object[])new Object[]{message.game_coin});
                            callback.onSuccess(message.game_coin, message.add_coin, message.join_id);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getGiveCoin(final IGetGiveCoinCallback callback, long id2) {
        GetGiveCoinReq req = new GetGiveCoinReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).id(Long.valueOf(id2)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetGiveCoinRes>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)GoldPresentationModel.TAG, (String)"get give coins \u7ed3\u679c: timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail();
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.i((String)GoldPresentationModel.TAG, (String)"get give coins \u7ed3\u679c:%s", (Object[])new Object[]{code});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail();
                    }
                });
                return false;
            }

            public void onResponse(final @NonNull GetGiveCoinRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            FeatureLog.i((String)GoldPresentationModel.TAG, (String)"get give coins success,new coins:%s", (Object[])new Object[]{message.game_coin});
                            callback.onSuccess(message.game_coin, message.add_coin);
                        }
                    }
                });
            }
        });
    }

    static interface IGetJoinCoinCallback {
        public void onSuccess(long var1, long var3, long var5);

        public void onFail();
    }

    static interface IGetGiveCoinCallback {
        public void onSuccess(long var1, long var3);

        public void onFail();
    }
}

