/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.sendgiftguide;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftGuideInfo;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.gift.ui.sendgiftguide.SendGiftGuideContract;

public class SendGiftGuideView
extends YYConstraintLayout
implements SendGiftGuideContract.View {
    public static final String TAG = "SendGiftGuideView";
    private SendGiftGuideContract.Presenter mPresenter;
    private ObjectAnimator mInTranslation;
    private ObjectAnimator mOutTranslation;
    private ViewGroup mLayer;
    private YYTextView mTvTips;
    private YYTextView mTvBtnSend;
    private ConstraintLayout mClContainer;
    private RecycleImageView mRivGiftIcon;
    private volatile UserInfoKS mReceiver;
    private volatile GiftItemInfo mGiftItemInfo;
    private boolean isShowWithAnim;
    private boolean isShowWithoutAnim;
    private boolean isAnim;

    private SendGiftGuideView(Context context) {
        this(context, null);
    }

    private SendGiftGuideView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private SendGiftGuideView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public SendGiftGuideView(ViewGroup layer) {
        this(layer.getContext());
        this.mLayer = layer;
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_send_gift_guide, (ViewGroup)this);
        this.mTvTips = (YYTextView)this.findViewById(R.id.tv_tips);
        this.mTvBtnSend = (YYTextView)this.findViewById(R.id.tv_btn_send);
        this.mRivGiftIcon = (RecycleImageView)this.findViewById(R.id.riv_gift_icon);
        this.mClContainer = (ConstraintLayout)this.findViewById(R.id.cl_container);
        FontUtils.setFontType((TextView)this.mTvBtnSend, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mTvBtnSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SendGiftGuideView.this.mPresenter != null) {
                    SendGiftGuideView.this.mPresenter.sendGift(SendGiftGuideView.this.mReceiver, SendGiftGuideView.this.mGiftItemInfo, 1);
                    SendGiftGuideView.this.hide();
                }
            }
        });
        this.mClContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SendGiftGuideView.this.hide();
            }
        });
        this.initAnimation();
    }

    private void initAnimation() {
        this.mInTranslation = ObjectAnimator.ofFloat((Object)this, (String)"translationX", (float[])new float[]{-ScreenUtils.getInstance().getWidthPixels(), 0.0f});
        this.mOutTranslation = ObjectAnimator.ofFloat((Object)this, (String)"translationX", (float[])new float[]{0.0f, -ScreenUtils.getInstance().getWidthPixels()});
        this.mInTranslation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                SendGiftGuideView.this.isAnim = true;
                SendGiftGuideView.this.isShowWithAnim = true;
                SendGiftGuideView.this.isShowWithoutAnim = false;
            }

            public void onAnimationEnd(Animator animation) {
                SendGiftGuideView.this.isAnim = false;
                SendGiftGuideView.this.isShowWithoutAnim = true;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SendGiftGuideView.this.hide();
                    }
                }, (long)10000L);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mOutTranslation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                SendGiftGuideView.this.isAnim = true;
                SendGiftGuideView.this.isShowWithoutAnim = false;
            }

            public void onAnimationEnd(Animator animation) {
                SendGiftGuideView.this.isAnim = false;
                SendGiftGuideView.this.isShowWithAnim = false;
                SendGiftGuideView.this.mLayer.removeView((View)SendGiftGuideView.this);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void setPresenter(SendGiftGuideContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    @Override
    public void show(SendGiftGuideInfo info, UserInfoKS receiver, GiftItemInfo giftItemInfo, int type) {
        if (info == null || receiver == null || giftItemInfo == null || TextUtils.isEmpty((CharSequence)receiver.nick)) {
            return;
        }
        this.mReceiver = receiver;
        this.mGiftItemInfo = giftItemInfo;
        if (!this.isShowWithAnim && this.mLayer != null) {
            ImageLoader.loadImage((ImageView)this.mRivGiftIcon, (String)giftItemInfo.getStaticIcon(), (int)R.drawable.icon_gift_default);
            String content = "";
            String senderName = ShortNameUtils.getShortNameWithoutColon((String)giftItemInfo.getName(), (int)7);
            String receiverName = ShortNameUtils.getShortNameWithoutColon((String)receiver.nick, (int)7);
            if (type == 0) {
                content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_host), senderName);
            } else if (type == 1) {
                if (info.getRecvType() == SendGiftGuideInfo.RecvUserType.ATTENTION) {
                    content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_attention), receiverName, senderName);
                } else if (info.getRecvType() == SendGiftGuideInfo.RecvUserType.FRIEND) {
                    content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_friend), senderName, receiverName);
                }
            } else if (type == 2) {
                content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_return), receiverName, senderName);
            }
            int index = content.indexOf(receiverName);
            int length = receiverName.length();
            if (index != -1) {
                SpannableString spannableString = new SpannableString((CharSequence)content);
                spannableString.setSpan((Object)new StyleSpan(1), index, index + length, 17);
                this.mTvTips.setText((CharSequence)spannableString);
            } else {
                this.mTvTips.setText((CharSequence)content);
            }
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            this.mLayer.addView((View)this);
            this.mInTranslation.start();
            if (this.mPresenter != null) {
                GiftHiidoReport.sendGiftGuideShow(giftItemInfo, this.mPresenter.getRoomId());
            }
        }
    }

    @Override
    public boolean isShowWithAnim() {
        return this.isShowWithAnim;
    }

    @Override
    public void hide() {
        if (this.isShowWithoutAnim && !this.isAnim && this.mLayer != null) {
            this.mOutTranslation.start();
        }
    }
}

