/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.data.PageEntity;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.activity.ui.ActivityIconView;
import com.yy.hiyo.wallet.activity.ui.ExtendActivityIconView;
import com.yy.hiyo.wallet.activity.ui.GiftWeekCardEntranceView;
import com.yy.hiyo.wallet.base.action.ActionManager;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.GiftPanelAction;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftExpandInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.gift.data.bean.ConsumeGuideNotifyInfo;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftPanelContract;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftPanelHelper;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftItemPanel;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelCallBack;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelCallback;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelOperator;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftTabCallback;
import com.yy.hiyo.wallet.gift.ui.pannel.act.GiftItemActExpandInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.adapter.GiftItemAdapter;
import com.yy.hiyo.wallet.gift.ui.pannel.bean.ActBannerGiftInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.bean.GiftPanelItemInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.GiftAmountView;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.GiftViewPagelContainer;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.decs.GiftDecsView;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.decs.WeekGiftDecsView;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.holder.MyViewHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GiftPanel
extends YYLinearLayout
implements GiftPanelContract.View,
GiftItemAdapter.OnGiftItemCallback,
IGiftTabCallback,
IGiftPanelCallBack {
    public static final String TAG = "_GiftPanel";
    private static final String STYLE_WEEK_CARD = "weekcard";
    private static final String KEY_STYLE = "style";
    private final int duration = 300;
    private Context mContext;
    private GiftPanelContract.Presenter mPresenter;
    private ViewGroup mGiftLayer;
    private LoadingStatusLayout mLslLoading;
    private YYTextView mTvSend;
    private YYTextView mTvAmount;
    private YYTextView mTvBalance;
    private YYTextView mTvClickCancel;
    private YYImageView mIvArrow;
    private ConstraintLayout mClPanel;
    private ConstraintLayout mClAmount;
    private ConstraintLayout mClRecharge;
    private Animation mAnimRotateUp;
    private Animation mAnimRotateDown;
    private AnimatorSet mPanelInSet;
    private AnimatorSet mPanelOutSet;
    private ObjectAnimator mPanelInAlpha;
    private ObjectAnimator mPanelOutAlpha;
    private ObjectAnimator mPanelInTranslation;
    private ObjectAnimator mPanelOutTranslation;
    private boolean mIsAnimating;
    private boolean mIsShowWithAnim;
    private boolean mIsGiftAmountShow;
    private boolean mIsShowWithoutAnim;
    private GiftViewPagelContainer mGiftViewPagelContainer;
    private String mRoomId;
    private GiftAmountView mGiftAmountView;
    private ActivityIconView mActivityEntryView;
    private YYLinearLayout mLlAbovePanelContainer;
    private ExtendActivityIconView mCommonActivityView;
    private YYTextView rechargeGuide;
    private YYTextView mTvHidePanel;
    private YYImageView giftArrow;
    private BubblePopupWindow mConsumeGuidePop;
    private boolean mIsConsumeGuideShown;
    private boolean mShowGifAboveView = false;
    private int mDescViewVisibility;
    private GiftPanelHelper mGiftPanelHelper;
    private YYFrameLayout mGiftDescContainer;
    private GiftDecsView mGiftDecsView;
    private WeekGiftDecsView mWeekGiftDecsView;
    private boolean isShowFinish = false;
    private IGiftPanelCallback mGiftPanelCallback;
    private IGiftPanelCallBack.IGiftDecsCallback mGiftDecsCallback;
    private YYPlaceHolderView placeHolderView;
    private String jumpTabType = "";
    private MyViewHolder mySelectedHolder = null;
    private GiftWeekCardEntranceView mGiftWeekCardEntranceView;
    private YYLinearLayout mActivityContainer;
    Runnable refreshRunnable = () -> this.refreshGiftPanel();

    public GiftPanel(@NonNull ViewGroup giftLayer, @NonNull IGiftPanelCallback callback) {
        super(giftLayer.getContext());
        this.init(giftLayer.getContext(), giftLayer, callback);
    }

    private void init(Context context, ViewGroup giftLayer, IGiftPanelCallback callback) {
        this.mContext = context;
        this.mGiftLayer = giftLayer;
        this.mGiftPanelCallback = callback;
        this.setOrientation(1);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_gift_panel, (ViewGroup)this);
        this.mIvArrow = (YYImageView)this.findViewById(R.id.iv_arrow);
        this.mTvSend = (YYTextView)this.findViewById(R.id.tv_btn_send);
        this.mGiftDescContainer = (YYFrameLayout)this.findViewById(R.id.gift_decs_view);
        this.rechargeGuide = (YYTextView)this.findViewById(R.id.tv_recharge_guide);
        this.giftArrow = (YYImageView)this.findViewById(R.id.gift_arrow);
        this.mTvAmount = (YYTextView)this.findViewById(R.id.tv_amount);
        this.mTvBalance = (YYTextView)this.findViewById(R.id.tv_balance);
        this.mTvClickCancel = (YYTextView)this.findViewById(R.id.tv_click_cancel);
        this.mClPanel = (ConstraintLayout)this.findViewById(R.id.cl_panel);
        this.mClAmount = (ConstraintLayout)this.findViewById(R.id.cl_amount);
        this.mClRecharge = (ConstraintLayout)this.findViewById(R.id.cl_recharge);
        this.mLslLoading = (LoadingStatusLayout)this.findViewById(R.id.lsl_loading);
        this.placeHolderView = (YYPlaceHolderView)this.findViewById(R.id.receiver_header_holder);
        this.mGiftViewPagelContainer = (GiftViewPagelContainer)this.findViewById(R.id.gift_panel_container);
        this.mActivityEntryView = (ActivityIconView)this.findViewById(R.id.recharge_activity_entry);
        this.mLlAbovePanelContainer = (YYLinearLayout)this.findViewById(R.id.ll_above_panel_container);
        this.mActivityContainer = (YYLinearLayout)this.findViewById(R.id.ll_activity_container);
        this.mGiftViewPagelContainer.setMCallback(this);
        this.mTvBalance.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mGiftAmountView = new GiftAmountView(context, this, this);
        this.initAnimation();
        this.mTvClickCancel.setOnClickListener(v -> this.hide());
        this.mClAmount.setOnClickListener(v -> {
            if (this.mPresenter.getSelectedGift() != null && !FP.empty(this.mPresenter.getSelectedGift().getNumberLists())) {
                FeatureLog.i((String)"FTGiftPanel_GiftPanel", (String)"gift amount clicked, selected gift : %s, number list : %d", (Object[])new Object[]{this.mPresenter.getSelectedGift(), this.mPresenter.getSelectedGift().getNumberLists().size()});
                this.showAmountPopupWindow(this.mTvAmount.getText().toString());
            }
        });
        this.mTvSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GiftPanel.this.mPresenter.sendGifts(StringUtils.parseInt((String)GiftPanel.this.mTvAmount.getText().toString()));
                GiftHiidoReport.consumeGuideSendClickReport(GiftPanel.this.mIsConsumeGuideShown ? 1 : 2);
            }
        });
        this.mClPanel.setOnClickListener(v -> {});
        this.mActivityEntryView.setAutoOpenCharge(false);
        this.mActivityEntryView.setOnClickListener(v -> {
            if (this.isH5BigPage()) {
                ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(this.mActivityEntryView.getData().linkUrl);
            }
            GiftHiidoReport.giftPanelActClick(this.mRoomId, this.mActivityEntryView.getData().id, this.mActivityEntryView.getData().linkUrl);
        });
        this.mClRecharge.setOnClickListener(v -> this.mPresenter.openRecharge());
        if (this.mActivityEntryView.getVisibility() == 8) {
            this.rechargeGuide.setVisibility(0);
            this.giftArrow.setBackgroundResource(R.drawable.icon_right_yellow_arrow);
        } else {
            this.rechargeGuide.setVisibility(8);
            this.giftArrow.setBackgroundResource(R.drawable.icon_right_arrow);
        }
        this.mTvHidePanel = (YYTextView)this.findViewById(R.id.tv_hide_panel);
        this.mTvHidePanel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GiftPanel.this.hide();
            }
        });
    }

    private GiftDecsView getGiftDecsView() {
        if (this.mGiftDecsView == null) {
            this.mGiftDecsView = new GiftDecsView(this.mContext, this.mGiftDecsCallback);
            this.mGiftDescContainer.addView((View)this.mGiftDecsView);
            this.mGiftDecsView.setVisibility(8);
        }
        return this.mGiftDecsView;
    }

    private WeekGiftDecsView getWeekGiftDecsView() {
        if (this.mWeekGiftDecsView == null) {
            this.mWeekGiftDecsView = new WeekGiftDecsView(this.mContext, this.mGiftDecsCallback);
            this.mGiftDescContainer.addView((View)this.mWeekGiftDecsView);
            this.mWeekGiftDecsView.setVisibility(8);
        }
        return this.mWeekGiftDecsView;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mIsAnimating) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public GiftPanelHelper getGiftPanelHelper() {
        if (this.mGiftPanelHelper == null) {
            this.mGiftPanelHelper = new GiftPanelHelper();
        }
        return this.mGiftPanelHelper;
    }

    private boolean isH5BigPage() {
        return this.mActivityEntryView != null && this.mActivityEntryView.getVisibility() == 0 && this.mActivityEntryView.getData().isH5BigPage;
    }

    private void initAnimation() {
        this.mAnimRotateUp = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_arrow_rotate_up);
        this.mAnimRotateDown = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_arrow_rotate_down);
        this.mPanelInSet = new AnimatorSet();
        this.mPanelOutSet = new AnimatorSet();
        this.mPanelInSet.setDuration(300L);
        this.mPanelOutSet.setDuration(300L);
        this.mPanelInSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mPanelOutSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mPanelInTranslation = ObjectAnimator.ofFloat((Object)this, (String)"translationY", (float[])new float[]{0.0f});
        this.mPanelOutTranslation = ObjectAnimator.ofFloat((Object)this, (String)"translationY", (float[])new float[]{ScreenUtils.getInstance().getHeightPixels()});
        this.mPanelInAlpha = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        this.mPanelOutAlpha = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        this.mPanelInSet.play((Animator)this.mPanelInTranslation).with((Animator)this.mPanelInAlpha);
        this.mPanelOutSet.play((Animator)this.mPanelOutTranslation).with((Animator)this.mPanelOutAlpha);
        this.mPanelInSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                GiftPanel.this.mIsConsumeGuideShown = false;
                GiftPanel.this.mIsAnimating = true;
                MLog.info((Object)GiftPanel.TAG, (String)"mPanelInSet, onAnimationStart mIsAnimating=%s", (Object[])new Object[]{GiftPanel.this.mIsAnimating});
            }

            public void onAnimationEnd(Animator animation) {
                GiftPanel.this.mIsAnimating = false;
                GiftPanel.this.mIsShowWithoutAnim = true;
                GiftPanel.this.isShowFinish = true;
                if (GiftPanel.this.mPresenter != null) {
                    GiftPanel.this.mPresenter.onPanelShown(GiftPanel.this.mActivityEntryView != null && GiftPanel.this.mActivityEntryView.getVisibility() == 0);
                }
                MLog.info((Object)GiftPanel.TAG, (String)"mPanelInSet, onAnimationEnd mIsShowWithoutAnim=%s", (Object[])new Object[]{GiftPanel.this.mIsShowWithoutAnim});
                GiftPanel.this.setPageShow();
            }

            public void onAnimationCancel(Animator animation) {
                GiftPanel.this.mIsAnimating = false;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mPanelOutSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                GiftPanel.this.mIsAnimating = true;
                MLog.info((Object)GiftPanel.TAG, (String)"mPanelOutSet, onAnimationStart mIsAnimating=%s", (Object[])new Object[]{GiftPanel.this.mIsAnimating});
            }

            public void onAnimationEnd(Animator animation) {
                GiftPanel.this.mIsAnimating = false;
                GiftPanel.this.mIsShowWithAnim = false;
                GiftPanel.this.hideAfterAnim();
                MLog.info((Object)GiftPanel.TAG, (String)"mPanelOutSet, onAnimationEnd mIsShowWithAnim=%s", (Object[])new Object[]{GiftPanel.this.mIsShowWithAnim});
            }

            public void onAnimationCancel(Animator animation) {
                GiftPanel.this.mIsAnimating = false;
                GiftPanel.this.mIsShowWithAnim = false;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void refreshSelectGift() {
        if (this.mPresenter.getSelectedGift() != null) {
            this.showGiftDecs(this.mPresenter.getSelectedGift());
        }
    }

    private void showAmountPopupWindow(String amount) {
        if (this.mGiftAmountView != null) {
            this.mGiftAmountView.setSelectedItem(amount);
            if (this.mGiftAmountView.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.mGiftAmountView.getParent()).removeView((View)this.mGiftAmountView);
            }
            this.mGiftLayer.addView((View)this.mGiftAmountView);
            this.mIsGiftAmountShow = true;
        }
        this.mIvArrow.startAnimation(this.mAnimRotateUp);
    }

    public void setPresenter(GiftPanelContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    @Override
    public void showConsumeGuide(ConsumeGuideNotifyInfo data) {
        if (this.mConsumeGuidePop == null) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_consume_guide_pop, null);
            BubbleStyle bubbleStyle = (BubbleStyle)view.findViewById(R.id.bfl_root);
            bubbleStyle.setFillColor(-1);
            bubbleStyle.setCornerRadius((float)ResolutionUtils.dip2Px((float)6.0f));
            this.mConsumeGuidePop = new BubblePopupWindow(view, bubbleStyle);
            RecycleImageView imageView = (RecycleImageView)view.findViewById(R.id.rivReward);
            YYTextView contentView = (YYTextView)view.findViewById(R.id.tvContent);
            ImageLoader.loadImage((ImageView)imageView, (String)data.getRewardPhoto());
            contentView.setText((CharSequence)data.getRewardContent());
        }
        this.mIsConsumeGuideShown = true;
        this.mConsumeGuidePop.showArrowTo((View)this.mTvSend, BubbleStyle.ArrowDirection.Down, ResolutionUtils.dip2Px((float)10.4f));
        GiftHiidoReport.consumeGuidePopShowReport();
    }

    @Override
    public int getFrom() {
        return this.mPresenter.getFrom();
    }

    public IGiftPanelOperator getPresenter() {
        return this.mPresenter.getOperator();
    }

    @Override
    public void refreshPropId(String jumpTabType) {
        if (!jumpTabType.isEmpty()) {
            MLog.info((Object)TAG, (String)"refreshPropId jumpToTab %s", (Object[])new Object[]{jumpTabType});
            this.mGiftViewPagelContainer.jumpToTab(jumpTabType);
            if (this.getGiftPanelHelper().getGiftItemPanelList().get(jumpTabType) != null) {
                this.getGiftPanelHelper().getGiftItemPanelList().get(jumpTabType).loadData();
            }
        }
    }

    @Override
    @NotNull
    public String getTittle(String type) {
        return this.mPresenter.getTittle(type);
    }

    @Override
    @NotNull
    public String getRoomId() {
        return this.mRoomId;
    }

    @Override
    public int getRoomMode() {
        if (this.mPresenter != null) {
            return this.mPresenter.getRoomMode();
        }
        return 0;
    }

    @Override
    public boolean isVideo() {
        if (this.mPresenter != null) {
            return this.mPresenter.isVideo();
        }
        return false;
    }

    @Override
    public List<List<GiftPanelItemInfo>> getGiftList(String type) {
        if (this.mPresenter.getCacheGiftItemMap().containsKey(type)) {
            return this.mPresenter.getCacheGiftItemMap().get(type);
        }
        return null;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public GiftPanelItemInfo getH5SelectedGift() {
        return this.mPresenter.getH5SelectedGift();
    }

    @Override
    public void updateGiftItems(String realTabId) {
        this.jumpTabType = realTabId;
        YYTaskExecutor.removeTask((Runnable)this.refreshRunnable);
        if (this.isShowFinish) {
            this.refreshGiftPanel();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)this.refreshRunnable, (long)300L);
        }
    }

    private void refreshGiftPanel() {
        ArrayList<PageEntity> pageEntityList = new ArrayList<PageEntity>();
        if (this.mPresenter.getCacheGiftItemMap().containsKey("0")) {
            pageEntityList.add(this.getGiftPanelHelper().buildGiftPanel(this.mContext, "0", this, this, this));
        }
        for (GiftExpandInfo.GiftPanelTabInfo tabInfo : this.mPresenter.getGiftTabList()) {
            String tabId;
            if (tabInfo == null || "3".equals(tabId = tabInfo.getTabId()) && (null == this.mGiftPanelCallback || null == this.mGiftPanelCallback.getMyFamilyInfo() || FP.empty((CharSequence)this.mGiftPanelCallback.getMyFamilyInfo().getFid())) || TextUtils.isEmpty((CharSequence)tabId) || "0".equals(tabId) || "packet".equals(tabId) || !this.mPresenter.getCacheGiftItemMap().containsKey(tabId)) continue;
            pageEntityList.add(this.getGiftPanelHelper().buildGiftPanel(this.mContext, tabId, this, this, this));
        }
        pageEntityList.add(this.getGiftPanelHelper().buildGiftPanel(this.mContext, "packet", this, this, this));
        boolean tabChange = this.isTabChange(pageEntityList);
        if (tabChange) {
            MLog.info((Object)TAG, (String)"refreshGiftPanel tabChange setPageEntityList", (Object[])new Object[0]);
            this.getGiftPanelHelper().clearCache();
            this.mGiftViewPagelContainer.setPageEntityList(pageEntityList);
        } else {
            for (PageEntity pageEntity : pageEntityList) {
                if (this.getGiftPanelHelper().getGiftItemPanelList().get(pageEntity.getTabType()) == null) continue;
                this.getGiftPanelHelper().getGiftItemPanelList().get(pageEntity.getTabType()).loadData();
            }
        }
        if (!this.jumpTabType.isEmpty()) {
            MLog.info((Object)TAG, (String)"refreshGiftPanel jumpToTab", (Object[])new Object[0]);
            this.mGiftViewPagelContainer.jumpToTab(this.jumpTabType);
        }
        this.refreshSelectGift();
    }

    private boolean isTabChange(List<PageEntity> pageEntityList) {
        boolean tabChange = true;
        if (pageEntityList.size() == this.mGiftViewPagelContainer.getPageEntityList().size()) {
            tabChange = false;
            for (PageEntity pageEntity : pageEntityList) {
                if (this.isContains(pageEntity.getTabType())) continue;
                tabChange = true;
                break;
            }
        }
        return tabChange;
    }

    boolean isContains(String tabType) {
        for (PageEntity cachePage : this.mGiftViewPagelContainer.getPageEntityList()) {
            if (!cachePage.getTabType().equals(tabType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isShowWithoutAnim() {
        return this.mIsShowWithoutAnim;
    }

    @Override
    public void hideLoading() {
        FeatureLog.i((String)"FTGiftPanel_GiftPanel", (String)"hideLoading", (Object[])new Object[0]);
        this.mLslLoading.setVisibility(8);
    }

    @Override
    public void showLoading() {
        FeatureLog.i((String)"FTGiftPanel_GiftPanel", (String)"showLoading", (Object[])new Object[0]);
        this.mLslLoading.setVisibility(0);
    }

    @Override
    public void updateGiftAmountList(GiftPanelItemInfo giftInfo) {
        if (giftInfo != null && this.mGiftAmountView != null) {
            this.mGiftAmountView.setDate(giftInfo.getGiftInfo());
        }
    }

    @Override
    public boolean isShowWithAnim() {
        return this.mIsShowWithAnim;
    }

    @Override
    public boolean isAnimating() {
        return this.mIsAnimating;
    }

    @Override
    public void updateBalance(String balance) {
        this.mTvBalance.setText((CharSequence)balance);
    }

    @Override
    public void onClickBanner(ActBannerGiftInfo info, boolean isBannerFistShow) {
        IYYUriService uriService = (IYYUriService)ServiceManagerProxy.getService(IYYUriService.class);
        if (uriService != null && info != null) {
            uriService.handleUriString(info.getLinkUrl());
            MLog.debug((Object)TAG, (String)"onClickBanner %s", (Object[])new Object[]{isBannerFistShow});
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60129245").put("function_id", "gift _banner_click").put("activity_id", info.getId() + "").put("banner_source", isBannerFistShow ? "0" : "1").put("is_video", this.isVideo() ? "1" : "0").put("room_type", this.mPresenter.getRoomMode() + ""));
        }
    }

    @Override
    public boolean isFirstBannerShow(String tabId) {
        return this.mPresenter.isFirstBannerShow(tabId);
    }

    @Override
    public void onClickGift(GiftPanelItemInfo giftInfo) {
        MLog.info((Object)TAG, (String)"onClickGift %s", (Object[])new Object[]{giftInfo});
        if (giftInfo != null && giftInfo.getType() == 1000) {
            this.hide();
        } else {
            this.mPresenter.onGiftClick(giftInfo);
            this.mPresenter.setSelectedGift(giftInfo);
            if (giftInfo != null) {
                int number = StringUtils.parseInt((String)this.mTvAmount.getText().toString());
                ArrayList<GiftItemInfo.Number> numberList = giftInfo.getNumberLists();
                if (!FP.empty(numberList)) {
                    boolean contain = false;
                    for (GiftItemInfo.Number item : numberList) {
                        if (item == null || number != item.getNumber()) continue;
                        contain = true;
                        MLog.info((Object)TAG, (String)"onClickGift %s, select: %d", (Object[])new Object[]{giftInfo, number});
                        break;
                    }
                    if (!contain) {
                        this.updateGiftAmount("1");
                    }
                }
            }
            this.showGiftDecs(giftInfo);
        }
        this.mPresenter.updateSelect();
    }

    @Override
    public void updateSelectHolder(MyViewHolder holder) {
        if (this.mySelectedHolder != null && this.mySelectedHolder != holder) {
            this.mySelectedHolder.clearSelectedAnimator();
            this.mySelectedHolder.unSelect();
        }
        this.mySelectedHolder = holder;
    }

    private void showGiftDecs(GiftPanelItemInfo giftInfo) {
        if (this.mPresenter != null && this.mPresenter.getGiftPanelActManager().isWeekActGift(giftInfo.getPropsId())) {
            this.getGiftDecsView().setVisibility(8);
            this.getWeekGiftDecsView().showGiftDesc(giftInfo.getGiftInfo());
        } else {
            this.getWeekGiftDecsView().setVisibility(8);
            this.getGiftDecsView().showGiftDesc(giftInfo.getGiftInfo());
        }
    }

    @Override
    public void hidePanel() {
        this.hide();
    }

    @Override
    public void updateGiftAmount(String amount) {
        this.dismissAmountList();
        MLog.info((Object)TAG, (String)"updateGiftAmount %d", (Object[])new Object[]{amount});
        this.mTvAmount.setText((CharSequence)amount);
    }

    @Override
    public Context getDialogContext() {
        return this.mContext;
    }

    @Override
    public void show(String gid, String roomId, int propId, boolean selectPropPacketTab) {
        MLog.info((Object)TAG, (String)"show gid %s, roomId %s, mIsAnimating %b", (Object[])new Object[]{gid, roomId, this.mIsAnimating});
        if (this.mIsAnimating) {
            return;
        }
        this.mRoomId = roomId;
        this.isShowFinish = false;
        if (this.getParent() == null) {
            this.mIsShowWithAnim = true;
            this.mGiftLayer.addView((View)this);
            this.mPanelInSet.start();
        }
        this.mPresenter.start();
    }

    public void dismissAmountList() {
        if (this.mGiftAmountView != null && this.mIsGiftAmountShow) {
            this.mIsGiftAmountShow = false;
            this.mGiftLayer.removeView((View)this.mGiftAmountView);
            this.mIvArrow.startAnimation(this.mAnimRotateDown);
        }
    }

    public boolean isGiftAmountShow() {
        return this.mIsGiftAmountShow;
    }

    @Override
    public void hide() {
        MLog.info((Object)TAG, (String)"hide", (Object[])new Object[0]);
        YYTaskExecutor.removeTask((Runnable)this.refreshRunnable);
        if (this.mySelectedHolder != null) {
            this.mySelectedHolder.clearSelectedAnimator();
        }
        if (this.mIsAnimating) {
            return;
        }
        this.mIsShowWithoutAnim = false;
        this.dismissAmountList();
        if (this.isShowWithAnim()) {
            this.mPanelOutSet.start();
        }
        if (this.mPresenter != null) {
            this.mPresenter.canInitPagersPosition(true);
        }
    }

    private void hideAfterAnim() {
        this.mGiftLayer.removeView((View)this);
        if (this.mPresenter != null) {
            this.mPresenter.onPanelHidden();
        }
    }

    @Override
    public void setActivityEntryData(@Nullable GiftPanelAction data, String roomId) {
        MLog.info((Object)TAG, (String)"setActivityEntryData %s", (Object[])new Object[]{data});
        if (data != null) {
            GiftPanelAction oldData = (GiftPanelAction)this.mActivityEntryView.getData();
            if (oldData == null || oldData.id != data.id) {
                GiftHiidoReport.giftPanelActShow(roomId, data.id, data.linkUrl);
            }
            this.rechargeGuide.setVisibility(8);
            this.mActivityEntryView.setVisibility(0);
            this.mActivityEntryView.setData((ActivityAction)data);
        } else {
            this.mActivityEntryView.setVisibility(8);
        }
        this.updateGiftArrow();
    }

    private void updateGiftArrow() {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.mActivityEntryView.getLayoutParams();
        ConstraintLayout.LayoutParams arrowParams = (ConstraintLayout.LayoutParams)this.giftArrow.getLayoutParams();
        if (!this.isH5BigPage()) {
            params.startToEnd = R.id.tv_recharge_guide;
            params.leftToRight = R.id.tv_recharge_guide;
            arrowParams.leftToRight = R.id.recharge_activity_entry;
            arrowParams.startToEnd = R.id.recharge_activity_entry;
        } else {
            arrowParams.startToEnd = R.id.tv_recharge_guide;
            params.startToEnd = R.id.gift_arrow;
            arrowParams.leftToRight = R.id.tv_recharge_guide;
            params.leftToRight = R.id.gift_arrow;
        }
        this.mActivityEntryView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.giftArrow.setLayoutParams((ViewGroup.LayoutParams)arrowParams);
    }

    @Override
    public void setGifAboveActivityData(@Nullable List<ActivityAction> list, String roomId) {
        MLog.info((Object)TAG, (String)"setGifAboveActivityData %s", (Object[])new Object[]{list});
        if (!FP.empty(list)) {
            this.initActivityViews(list);
            this.mShowGifAboveView = true;
            this.setActivityEntryVisibility();
        } else {
            this.mLlAbovePanelContainer.setVisibility(8);
            this.mShowGifAboveView = false;
        }
    }

    private void initActivityViews(List<ActivityAction> list) {
        if (this.mActivityContainer != null) {
            this.mActivityContainer.removeAllViews();
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            for (ActivityAction action : list) {
                if (StringUtils.equal((String)((String)action.actExtraInfos.get(KEY_STYLE)), (String)STYLE_WEEK_CARD)) {
                    this.reportAbovePanelShow(this.mGiftWeekCardEntranceView == null ? null : this.mGiftWeekCardEntranceView.getData(), action);
                    this.mGiftWeekCardEntranceView = new GiftWeekCardEntranceView(this.getContext());
                    this.mGiftWeekCardEntranceView.setData(action);
                    this.mActivityContainer.addView((View)this.mGiftWeekCardEntranceView, (ViewGroup.LayoutParams)params);
                    this.mGiftWeekCardEntranceView.setAutoOpenCharge(false);
                    this.mGiftWeekCardEntranceView.setOnClickListener(v -> {
                        if (this.mGiftWeekCardEntranceView.getData() != null) {
                            ActionManager.obtain().onAction(this.mGiftWeekCardEntranceView.getData());
                            GiftHiidoReport.giftPanelAboveActClick(this.mRoomId, this.mGiftWeekCardEntranceView.getData().id, this.mGiftWeekCardEntranceView.getData().linkUrl);
                        }
                    });
                    continue;
                }
                this.reportAbovePanelShow(this.mCommonActivityView == null ? null : this.mCommonActivityView.getData(), action);
                this.mCommonActivityView = new ExtendActivityIconView(this.getContext());
                this.mCommonActivityView.setData(action);
                this.mActivityContainer.addView((View)this.mCommonActivityView, (ViewGroup.LayoutParams)params);
                this.mCommonActivityView.setAutoOpenCharge(false);
                this.mCommonActivityView.setOnClickListener(v -> {
                    if (this.mCommonActivityView.getData() != null) {
                        ActionManager.obtain().onAction(this.mCommonActivityView.getData());
                        GiftHiidoReport.giftPanelAboveActClick(this.mRoomId, this.mCommonActivityView.getData().id, this.mCommonActivityView.getData().linkUrl);
                    }
                });
            }
        }
    }

    private void reportAbovePanelShow(ActivityAction oldData, ActivityAction newData) {
        if (newData != null && (oldData == null || oldData.id != newData.id)) {
            GiftHiidoReport.giftPanelAboveActShow(this.mRoomId, newData.id, newData.linkUrl);
        }
    }

    private void setPageShow() {
        IGiftItemPanel giftItemPanel;
        String tabType = this.mGiftViewPagelContainer.getCurrentTabType();
        if (!TextUtils.isEmpty((CharSequence)tabType) && (giftItemPanel = this.getGiftPanelHelper().getGiftItemPanelList().get(tabType)) != null) {
            giftItemPanel.onPageShow();
        }
    }

    @Override
    public void onPacketClick() {
        this.mGiftViewPagelContainer.setLastTab();
    }

    @Override
    public void setGiftDecsCallback(IGiftPanelCallBack.IGiftDecsCallback giftDecsCallback) {
        this.mGiftDecsCallback = giftDecsCallback;
    }

    @Override
    public void onDecsVisibilityChange(int visibility) {
        this.mDescViewVisibility = visibility;
        this.setActivityEntryVisibility();
    }

    private void setActivityEntryVisibility() {
        if (this.mShowGifAboveView) {
            this.mLlAbovePanelContainer.setVisibility(this.mDescViewVisibility == 0 ? 8 : 0);
        }
    }

    @Override
    public GiftItemActExpandInfo getActGiftInfo(GiftPanelItemInfo giftInfo) {
        if (this.mPresenter != null) {
            return this.mPresenter.getGiftPanelActManager().getActGiftInfo(giftInfo.getGiftInfo());
        }
        return null;
    }

    @Override
    public YYPlaceHolderView getPlaceHolderView() {
        return this.placeHolderView;
    }

    @Override
    public void onPageEntitySelected(@NotNull PageEntity pageEntity, int position) {
        IGiftItemPanel giftItemPane = this.getGiftPanelHelper().getGiftItemPanelList().get(pageEntity.getTabType());
        if (giftItemPane != null) {
            if (this.mPresenter != null) {
                this.mPresenter.notifyCurrentTab(pageEntity.getTabType());
            }
            giftItemPane.onPageSelect();
        }
    }

    @Override
    public void onPageEntityUnSelected(@NotNull PageEntity pageEntity, int position) {
        IGiftItemPanel giftItemPane = this.getGiftPanelHelper().getGiftItemPanelList().get(pageEntity.getTabType());
        if (giftItemPane != null) {
            giftItemPane.giftPanelHide();
        }
    }
}

